/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.BorderStyle;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.Repeat;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.framework.RelativeURL;
import com.ibm.xsl.composer.framework.Utilities;
import com.ibm.xsl.composer.properties.parse.ParseException;
import com.ibm.xsl.composer.properties.parse.SPParseBackground;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class BorderPaddingBackgroundProperty {
    private WritingMode wmParent;
    private static final String BORDER_THIN = "0.5pt";
    private static final String BORDER_MEDIUM = "1.0pt";
    private static final String BORDER_THICK = "2pt";
    private static final String NONE = "none";
    private static final String IWM = "illegal writing mode:";
    public String backgroundAttachment = "scroll";
    private boolean inheritBorderAfterStyle = true;
    private boolean inheritBorderBeforeStyle = true;
    private boolean inheritBorderStartStyle = true;
    private boolean inheritBorderBottomStyle = true;
    private boolean inheritBorderTopStyle = true;
    private boolean inheritBorderEndStyle = true;
    private boolean inheritBorderRightStyle = true;
    private boolean inheritBorderLeftStyle = true;
    private boolean drawBackgroundColor = false;
    private boolean drawBorderBeforeColor = false;
    private boolean drawBorderAfterColor = false;
    private boolean drawBorderStartColor = false;
    private boolean drawBorderBottomColor = false;
    private boolean drawBorderTopColor = false;
    private boolean drawBorderEndColor = false;
    private boolean drawBorderRightColor = false;
    private boolean drawBorderLeftColor = false;
    private boolean inheritBackgroundColor = true;
    private boolean inheritBackgroundRepeat = true;
    private boolean inheritBackgroundImage = true;
    private boolean inheritBackgroundPositionHorizontal = true;
    private boolean inheritBackgroundPositionVertical = true;
    private boolean inheritBackgroundAttachment = true;
    private boolean inheritBorderLeftWidth = true;
    private boolean inheritBorderRightWidth = true;
    private boolean inheritBorderTopWidth = true;
    private boolean inheritBorderBottomWidth = true;
    private boolean inheritBorderBeforeColor = true;
    private boolean inheritBorderAfterColor = true;
    private boolean inheritBorderStartColor = true;
    private boolean inheritBorderBottomColor = true;
    private boolean inheritBorderTopColor = true;
    private boolean inheritBorderRightColor = true;
    private boolean inheritBorderLeftColor = true;
    private boolean inheritBorderEndColor = true;
    private CSSColor backgroundColor = new CSSColor();
    private URL backgroundImage = null;
    private Repeat backgroundRepeat = new Repeat();
    private CSSLength backgroundPositionHorizontal = new CSSLength();
    private CSSLength backgroundPositionVertical = new CSSLength();
    private CSSColor borderBeforeColor = new CSSColor();
    public short borderBeforeStyle;
    private boolean inheritBorderBeforeWidth = true;
    private boolean inheritBorderAfterWidth = true;
    private boolean inheritBorderStartWidth = true;
    private boolean inheritBorderEndWidth = true;
    private CSSLength borderBeforeWidth = new CSSLength("1.0pt");
    private CSSLength borderAfterWidth = new CSSLength("1.0pt");
    private CSSLength borderStartWidth = new CSSLength("1.0pt");
    private CSSLength borderEndWidth = new CSSLength("1.0pt");
    public CSSColor borderAfterColor = new CSSColor();
    public short borderAfterStyle = 0;
    private CSSColor borderStartColor = new CSSColor();
    public short borderStartStyle = 0;
    private CSSColor borderEndColor = new CSSColor();
    public short borderEndStyle = 0;
    private CSSColor borderTopColor = new CSSColor();
    public short borderTopStyle = 0;
    public CSSLength borderTopWidth = new CSSLength("1.0pt");
    private CSSColor borderBottomColor = new CSSColor();
    public short borderBottomStyle = 0;
    public CSSLength borderBottomWidth = new CSSLength("1.0pt");
    private CSSColor borderLeftColor = new CSSColor();
    public short borderLeftStyle = 0;
    public CSSLength borderLeftWidth = new CSSLength("1.0pt");
    private CSSColor borderRightColor = new CSSColor();
    public short borderRightStyle = 0;
    public CSSLength borderRightWidth = new CSSLength("1.0pt");
    private boolean inheritPaddingBefore = true;
    private boolean inheritPaddingAfter = true;
    private boolean inheritPaddingStart = true;
    private boolean inheritPaddingEnd = true;
    private boolean inheritPaddingRight = true;
    private boolean inheritPaddingLeft = true;
    private boolean inheritPaddingTop = true;
    private boolean inheritPaddingBottom = true;
    private CSSLength paddingBefore = new CSSLength();
    private CSSLength paddingAfter = new CSSLength();
    private CSSLength paddingStart = new CSSLength();
    private CSSLength paddingEnd = new CSSLength();
    public CSSLength paddingTop = new CSSLength();
    public CSSLength paddingBottom = new CSSLength();
    public CSSLength paddingLeft = new CSSLength();
    public CSSLength paddingRight = new CSSLength();
    private SPParseBackground parseBackground = new SPParseBackground();
    private SPParseBackground parseBackgroundPosition = new SPParseBackground();
    private SPParseBackground parseBorder = new SPParseBackground();
    private SPParseBackground parseBorderTop = new SPParseBackground();
    private SPParseBackground parseBorderBottom = new SPParseBackground();
    private SPParseBackground parseBorderRight = new SPParseBackground();
    private SPParseBackground parseBorderLeft = new SPParseBackground();
    private SPParseBackground parseBorderWidth = new SPParseBackground();
    private SPParseBackground parseBorderStyle = new SPParseBackground();
    private SPParseBackground parseBorderColor = new SPParseBackground();
    private SPParseBackground parseBorderSpacing = new SPParseBackground();
    private SPParseBackground parsePadding = new SPParseBackground();

    public boolean compare(BorderPaddingBackgroundProperty bp) {
        return !(this.inheritBackgroundPositionHorizontal != bp.inheritBackgroundPositionHorizontal || this.inheritBackgroundPositionVertical != bp.inheritBackgroundPositionVertical || this.inheritBackgroundColor != bp.inheritBackgroundColor || this.inheritBackgroundImage != bp.inheritBackgroundImage || this.inheritBackgroundRepeat != bp.inheritBackgroundRepeat || this.inheritBorderBeforeColor != bp.inheritBorderBeforeColor || this.inheritBorderAfterColor != bp.inheritBorderAfterColor || this.inheritBorderTopColor != bp.inheritBorderTopColor || this.inheritBorderBottomColor != bp.inheritBorderBottomColor || this.inheritBorderStartColor != bp.inheritBorderStartColor || this.inheritBorderLeftColor != bp.inheritBorderLeftColor || this.inheritBorderRightColor != bp.inheritBorderRightColor || this.inheritBorderBeforeWidth != bp.inheritBorderBeforeWidth || this.inheritBorderAfterWidth != bp.inheritBorderAfterWidth || this.inheritBorderStartWidth != bp.inheritBorderStartWidth || this.inheritBorderEndWidth != bp.inheritBorderEndWidth || this.inheritPaddingBefore != bp.inheritPaddingBefore || this.inheritPaddingAfter != bp.inheritPaddingAfter || this.inheritPaddingStart != bp.inheritPaddingStart || this.inheritPaddingEnd != bp.inheritPaddingEnd || this.inheritBorderLeftWidth != bp.inheritBorderLeftWidth || this.inheritBorderRightWidth != bp.inheritBorderRightWidth || this.inheritBorderTopWidth != bp.inheritBorderTopWidth || this.inheritBorderBottomWidth != bp.inheritBorderBottomWidth || this.inheritBackgroundAttachment != bp.inheritBackgroundAttachment || this.inheritPaddingRight != bp.inheritPaddingRight || this.inheritPaddingLeft != bp.inheritPaddingLeft || this.inheritPaddingTop != bp.inheritPaddingTop || this.inheritPaddingBottom != bp.inheritPaddingBottom || this.parseBackground.isParseBackgroundInherited() != bp.parseBackground.isParseBackgroundInherited() || this.parseBackgroundPosition.isParseBackgroundPositionInherited() != bp.parseBackgroundPosition.isParseBackgroundPositionInherited() || !this.inheritBackgroundColor && (bp.drawBackgroundColor != this.drawBackgroundColor || !bp.backgroundColor.equals(this.backgroundColor)) || !this.inheritBorderBeforeColor && (bp.drawBorderBeforeColor != this.drawBorderBeforeColor || !this.borderBeforeColor.equals(bp.borderBeforeColor)) || !this.inheritBorderAfterColor && (bp.drawBorderAfterColor != this.drawBorderAfterColor || !this.borderAfterColor.equals(bp.borderAfterColor)) || !this.inheritBorderBottomColor && (bp.drawBorderBottomColor != this.drawBorderBottomColor || !this.borderBottomColor.equals(bp.borderBottomColor)) || !this.inheritBorderStartColor && (bp.drawBorderStartColor != this.drawBorderStartColor || !this.borderStartColor.equals(bp.borderStartColor)) || !this.inheritBorderTopColor && (bp.drawBorderTopColor != this.drawBorderTopColor || !this.borderTopColor.equals(bp.borderTopColor)) || !this.inheritBorderLeftColor && (bp.drawBorderLeftColor != this.drawBorderLeftColor || !this.borderLeftColor.equals(bp.borderLeftColor)) || !this.inheritBorderRightColor && (bp.drawBorderRightColor != this.drawBorderRightColor || !this.borderRightColor.equals(bp.borderRightColor)) || !this.inheritBorderBeforeWidth && !this.borderBeforeWidth.equals(bp.borderBeforeWidth) || !this.inheritBorderAfterWidth && !this.borderAfterWidth.equals(bp.borderAfterWidth) || !this.inheritBorderStartWidth && !this.borderStartWidth.equals(bp.borderStartWidth) || !this.inheritBorderEndWidth && !this.borderEndWidth.equals(bp.borderEndWidth) || !this.inheritPaddingBefore && !this.paddingEnd.equals(bp.paddingEnd) || !this.inheritPaddingAfter && !this.paddingAfter.equals(bp.paddingAfter) || !this.inheritPaddingStart && !this.paddingStart.equals(bp.paddingStart) || !this.inheritPaddingEnd && !this.paddingEnd.equals(bp.paddingEnd) || !this.inheritBackgroundAttachment && !this.backgroundAttachment.equalsIgnoreCase(bp.backgroundAttachment) || !this.inheritBackgroundImage && !this.backgroundImage.equals(bp.backgroundImage) || !this.inheritBackgroundPositionHorizontal && !this.backgroundPositionHorizontal.equals(bp.backgroundPositionHorizontal) || !this.inheritBackgroundPositionVertical && !this.backgroundPositionVertical.equals(bp.backgroundPositionVertical) || !this.inheritBackgroundRepeat && !this.backgroundRepeat.equals(bp.backgroundRepeat) || this.borderAfterStyle != bp.borderAfterStyle || this.borderBeforeStyle != bp.borderBeforeStyle || this.borderBottomStyle != bp.borderBottomStyle || this.borderStartStyle != bp.borderStartStyle || this.borderTopStyle != bp.borderTopStyle || this.borderEndStyle != bp.borderEndStyle || this.borderLeftStyle != bp.borderLeftStyle || this.borderRightStyle != bp.borderRightStyle || !this.borderBottomWidth.equals(bp.borderBottomWidth) || !this.borderLeftWidth.equals(bp.borderLeftWidth) || !this.borderRightWidth.equals(bp.borderRightWidth) || !this.borderTopWidth.equals(bp.borderTopWidth) || !this.inheritPaddingLeft && !this.paddingLeft.equals(bp.paddingLeft) || !this.inheritPaddingRight && !this.paddingRight.equals(bp.paddingRight) || !this.inheritPaddingBottom && !this.paddingBottom.equals(bp.paddingBottom) || !this.inheritPaddingTop && !this.paddingTop.equals(bp.paddingTop) || !this.parseBackground.isParseBackgroundInherited() && !this.parseBackground.equals(bp.parseBackground) || !this.parseBackgroundPosition.isParseBackgroundPositionInherited() && !this.parseBackgroundPosition.equals(bp.parseBackgroundPosition));
    }

    private static boolean decodeWidth(String widthString, CSSLength value) {
        boolean inherited = false;
        if ((widthString = widthString.trim().toLowerCase()).equals("inherit")) {
            inherited = true;
        } else if (widthString.equals("thin")) {
            value.setLength(BORDER_THIN);
        } else if (widthString.equals("medium")) {
            value.setLength(BORDER_MEDIUM);
        } else if (widthString.equals("thick")) {
            value.setLength(BORDER_THICK);
        } else {
            value.setLength(widthString);
        }
        return inherited;
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj instanceof BorderPaddingBackgroundProperty) {
            isEquals = this.compare((BorderPaddingBackgroundProperty)obj);
        }
        return isEquals;
    }

    public String getBackgroundAttachment() {
        return this.backgroundAttachment;
    }

    public String getBackgroundAttachmentAttribute() {
        return this.backgroundAttachment;
    }

    public CSSColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getBackgroundColorAttribute() {
        String result = this.inheritBackgroundColor ? "inherit" : (!this.drawBackgroundColor ? "transparent" : this.backgroundColor.attributeString());
        return result;
    }

    public URL getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getBackgroundImageAttribute() {
        String result = this.inheritBackgroundImage ? "inherit" : (this.backgroundImage == null ? NONE : this.backgroundImage.toExternalForm());
        return result;
    }

    public CSSLength getBackgroundPostionHorizontal() {
        return this.backgroundPositionHorizontal;
    }

    public String getBackgroundPostionHorizontalAttribute() {
        String result = this.inheritBackgroundPositionHorizontal ? "inherit" : this.backgroundPositionHorizontal.getLength();
        return result;
    }

    public CSSLength getBackgroundPostionVertical() {
        return this.backgroundPositionVertical;
    }

    public String getBackgroundPostionVerticalAttribute() {
        String result = this.inheritBackgroundPositionVertical ? "inherit" : this.backgroundPositionVertical.getLength();
        return result;
    }

    public Repeat getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public String getBackgroundRepeatAttribute() {
        String result = this.inheritBackgroundRepeat ? "inherit" : this.backgroundRepeat.getName();
        return result;
    }

    public CSSColor getBorderAfterColor() {
        return this.borderAfterColor;
    }

    public String getBorderAfterColorAttribute() {
        String result = this.inheritBorderAfterColor ? "inherit" : this.borderAfterColor.attributeString();
        return result;
    }

    public short getBorderAfterStyle() {
        return this.borderAfterStyle;
    }

    public String getBorderAfterStyleAttribute() {
        String result = this.inheritBorderAfterStyle ? "inherit" : BorderStyle.getStyleName(this.borderAfterStyle);
        return result;
    }

    public CSSLength getBorderAfterWidth() {
        return this.borderAfterWidth;
    }

    public String getBorderAfterWidthAttribute() {
        String result = this.inheritBorderAfterWidth ? "inherit" : this.borderAfterWidth.getLength();
        return result;
    }

    public CSSColor getBorderBeforeColor() {
        return this.borderBeforeColor;
    }

    public String getBorderBeforeColorAttribute() {
        String result = this.inheritBorderBeforeColor ? "inherit" : this.borderBeforeColor.attributeString();
        return result;
    }

    public short getBorderBeforeStyle() {
        return this.borderBeforeStyle;
    }

    public String getBorderBeforeStyleAttribute() {
        String result = this.inheritBorderBeforeStyle ? "inherit" : BorderStyle.getStyleName(this.borderBeforeStyle);
        return result;
    }

    public CSSLength getBorderBeforeWidth() {
        return this.borderBeforeWidth;
    }

    public String getBorderBeforeWidthAttribute() {
        String result = this.inheritBorderBeforeWidth ? "inherit" : this.borderBeforeWidth.getLength();
        return result;
    }

    public CSSColor getBorderBottomColor() {
        return this.borderBottomColor;
    }

    public String getBorderBottomColorAttribute() {
        String result = this.inheritBorderBottomColor ? "inherit" : this.borderBottomColor.attributeString();
        return result;
    }

    public short getBorderBottomStyle() {
        return this.borderBottomStyle;
    }

    public String getBorderBottomStyleAttribute() {
        String result = this.inheritBorderBottomStyle ? "inherit" : BorderStyle.getStyleName(this.borderBottomStyle);
        return result;
    }

    public CSSLength getBorderBottomWidth() {
        return this.borderBottomWidth;
    }

    public String getBorderBottomWidthAttribute() {
        return this.inheritBorderBottomWidth ? "inherit" : this.borderBottomWidth.getLength();
    }

    public CSSColor getBorderEndColor() {
        return this.borderEndColor;
    }

    public String getBorderEndColorAttribute() {
        String result = this.inheritBorderEndColor ? "inherit" : this.borderEndColor.attributeString();
        return result;
    }

    public short getBorderEndStyle() {
        return this.borderEndStyle;
    }

    public String getBorderEndStyleAttribute() {
        String result = this.inheritBorderEndStyle ? "inherit" : BorderStyle.getStyleName(this.borderEndStyle);
        return result;
    }

    public CSSLength getBorderEndWidth() {
        return this.borderEndWidth;
    }

    public String getBorderEndWidthAttribute() {
        String result = this.inheritBorderEndWidth ? "inherit" : this.borderEndWidth.getLength();
        return result;
    }

    public CSSColor getBorderLeftColor() {
        return this.borderLeftColor;
    }

    public String getBorderLeftColorAttribute() {
        String result = this.inheritBorderLeftColor ? "inherit" : this.borderLeftColor.attributeString();
        return result;
    }

    public short getBorderLeftStyle() {
        return this.borderLeftStyle;
    }

    public String getBorderLeftStyleAttribute() {
        String result = this.inheritBorderLeftStyle ? "inherit" : BorderStyle.getStyleName(this.borderLeftStyle);
        return result;
    }

    public CSSLength getBorderLeftWidth() {
        return this.borderLeftWidth;
    }

    public String getBorderLeftWidthAttribute() {
        return this.inheritBorderLeftWidth ? "inherit" : this.borderLeftWidth.getLength();
    }

    public CSSColor getBorderRightColor() {
        return this.borderRightColor;
    }

    public String getBorderRightColorAttribute() {
        String result = this.inheritBorderRightColor ? "inherit" : this.borderRightColor.attributeString();
        return result;
    }

    public short getBorderRightStyle() {
        return this.borderRightStyle;
    }

    public String getBorderRightStyleAttribute() {
        String result = this.inheritBorderRightStyle ? "inherit" : BorderStyle.getStyleName(this.borderRightStyle);
        return result;
    }

    public CSSLength getBorderRightWidth() {
        return this.borderRightWidth;
    }

    public String getBorderRightWidthAttribute() {
        return this.inheritBorderRightWidth ? "inherit" : this.borderRightWidth.getLength();
    }

    public CSSColor getBorderStartColor() {
        return this.borderStartColor;
    }

    public String getBorderStartColorAttribute() {
        String result = this.inheritBorderStartColor ? "inherit" : this.borderStartColor.attributeString();
        return result;
    }

    public short getBorderStartStyle() {
        return this.borderStartStyle;
    }

    public String getBorderStartStyleAttribute() {
        String result = this.inheritBorderStartStyle ? "inherit" : BorderStyle.getStyleName(this.borderStartStyle);
        return result;
    }

    public CSSLength getBorderStartWidth() {
        return this.borderStartWidth;
    }

    public String getBorderStartWidthAttribute() {
        String result = this.inheritBorderStartWidth ? "inherit" : this.borderStartWidth.getLength();
        return result;
    }

    public CSSColor getBorderTopColor() {
        return this.borderTopColor;
    }

    public String getBorderTopColorAttribute() {
        return this.inheritBorderTopColor ? "inherit" : this.borderTopColor.attributeString();
    }

    public short getBorderTopStyle() {
        return this.borderTopStyle;
    }

    public String getBorderTopStyleAttribute() {
        String result = this.inheritBorderTopStyle ? "inherit" : BorderStyle.getStyleName(this.borderTopStyle);
        return result;
    }

    public CSSLength getBorderTopWidth() {
        return this.borderTopWidth;
    }

    public String getBorderTopWidthAttribute() {
        return this.inheritBorderTopWidth ? "inherit" : this.borderTopWidth.getLength();
    }

    public CSSLength getPaddingAfter() {
        return this.paddingAfter;
    }

    public String getPaddingAfterAttribute() {
        String result = this.inheritPaddingAfter ? "inherit" : this.paddingAfter.getLength();
        return result;
    }

    public CSSLength getPaddingBefore() {
        return this.paddingBefore;
    }

    public String getPaddingBeforeAttribute() {
        String result = this.inheritPaddingBefore ? "inherit" : this.paddingBefore.getLength();
        return result;
    }

    public CSSLength getPaddingBottom() {
        return this.paddingBottom;
    }

    public String getPaddingBottomAttribute() {
        return this.inheritPaddingBottom ? "inherit" : this.paddingBottom.getLength();
    }

    public CSSLength getPaddingEnd() {
        return this.paddingEnd;
    }

    public String getPaddingEndAttribute() {
        String result = this.inheritPaddingEnd ? "inherit" : this.paddingEnd.getLength();
        return result;
    }

    public CSSLength getPaddingLeft() {
        return this.paddingLeft;
    }

    public String getPaddingLeftAttribute() {
        return this.inheritPaddingLeft ? "inherit" : this.paddingLeft.getLength();
    }

    public CSSLength getPaddingRight() {
        return this.paddingRight;
    }

    public String getPaddingRightAttribute() {
        return this.inheritPaddingRight ? "inherit" : this.paddingRight.getLength();
    }

    public CSSLength getPaddingStart() {
        return this.paddingStart;
    }

    public String getPaddingStartAttribute() {
        String result = this.inheritPaddingStart ? "inherit" : this.paddingStart.getLength();
        return result;
    }

    public CSSLength getPaddingTop() {
        return this.paddingTop;
    }

    public String getPaddingTopAttribute() {
        return this.inheritPaddingTop ? "inherit" : this.paddingTop.getLength();
    }

    public int hashCode() {
        return (!this.inheritBackgroundImage ? 0 : this.backgroundImage.hashCode()) + (!this.inheritBackgroundRepeat ? 0 : this.backgroundRepeat.hashCode()) + (!this.inheritBackgroundPositionHorizontal ? 0 : this.backgroundPositionHorizontal.hashCode()) + (!this.inheritBackgroundPositionVertical ? 0 : this.backgroundPositionVertical.hashCode()) + (!this.inheritBackgroundColor && this.drawBackgroundColor ? this.backgroundColor.hashCode() : 0) + (!this.inheritBorderBeforeColor ? 0 : this.borderBeforeColor.hashCode()) + (!this.inheritBorderStartColor ? 0 : this.borderStartColor.hashCode()) + (!this.inheritBorderAfterColor ? 0 : this.borderAfterColor.hashCode()) + (!this.inheritBorderEndColor ? 0 : this.borderEndColor.hashCode()) + (!this.inheritBorderTopColor ? 0 : this.borderTopColor.hashCode()) + (!this.inheritBorderLeftColor ? 0 : this.borderLeftColor.hashCode()) + (!this.inheritBorderBottomColor ? 0 : this.borderBottomColor.hashCode()) + (!this.inheritBorderRightColor ? 0 : this.borderRightColor.hashCode()) + (!this.inheritBorderEndWidth ? 0 : this.borderEndWidth.hashCode()) + (!this.inheritBorderStartWidth ? 0 : this.borderStartWidth.hashCode()) + (!this.inheritBorderBeforeWidth ? 0 : this.borderBeforeWidth.hashCode()) + (!this.inheritBorderAfterWidth ? 0 : this.borderAfterWidth.hashCode()) + (!this.inheritBorderEndStyle ? (short)0 : this.borderEndStyle) + (!this.inheritBorderStartStyle ? (short)0 : this.borderStartStyle) + (!this.inheritBorderBeforeStyle ? (short)0 : this.borderBeforeStyle) + (!this.inheritBorderAfterStyle ? (short)0 : this.borderAfterStyle) + (!this.inheritPaddingBefore ? 0 : this.paddingBefore.hashCode()) + (!this.inheritPaddingAfter ? 0 : this.paddingAfter.hashCode()) + (!this.inheritPaddingStart ? 0 : this.paddingStart.hashCode()) + (!this.inheritPaddingEnd ? 0 : this.paddingEnd.hashCode()) + (!this.inheritBorderLeftWidth ? 0 : this.borderLeftWidth.hashCode()) + (!this.inheritBorderRightWidth ? 0 : this.borderRightWidth.hashCode()) + (!this.inheritBorderTopWidth ? 0 : this.borderTopWidth.hashCode()) + (!this.inheritBorderBottomWidth ? 0 : this.borderBottomWidth.hashCode()) + (!this.inheritBackgroundAttachment ? 0 : this.backgroundAttachment.hashCode()) + (!this.inheritPaddingRight ? 0 : this.paddingRight.hashCode()) + (!this.inheritPaddingLeft ? 0 : this.paddingLeft.hashCode()) + (!this.inheritPaddingBottom ? 0 : this.paddingBottom.hashCode()) + (!this.inheritPaddingTop ? 0 : this.paddingTop.hashCode()) + (!this.parseBackground.isParseBackgroundInherited() ? 0 : this.parseBackground.hashCode()) + (!this.parseBackgroundPosition.isParseBackgroundInherited() ? 0 : this.parseBackgroundPosition.hashCode()) + 1;
    }

    public boolean inherit(BorderPaddingBackgroundProperty bp) {
        boolean altered = false;
        if (this.inheritBackgroundRepeat && !bp.backgroundRepeat.equals(this.backgroundRepeat)) {
            this.backgroundRepeat.copy(bp.backgroundRepeat);
            altered = true;
        }
        if (this.inheritBackgroundImage && !this.objectWithNullEquals(bp.backgroundImage, this.backgroundImage)) {
            this.backgroundImage = bp.backgroundImage;
            altered = true;
        }
        if (this.inheritBackgroundPositionHorizontal && !bp.backgroundPositionHorizontal.equals(this.backgroundPositionHorizontal)) {
            this.backgroundPositionHorizontal.copy(bp.backgroundPositionHorizontal);
            altered = true;
        }
        if (this.inheritBackgroundPositionVertical && !bp.backgroundPositionVertical.equals(this.backgroundPositionVertical)) {
            this.backgroundPositionVertical.copy(bp.backgroundPositionVertical);
            altered = true;
        }
        if (this.inheritBackgroundColor && !bp.backgroundColor.equals(this.backgroundColor)) {
            this.backgroundColor.copy(bp.backgroundColor);
            this.drawBackgroundColor = bp.drawBackgroundColor;
            altered = true;
        }
        if (this.inheritBorderBeforeColor && !bp.borderBeforeColor.equals(this.borderBeforeColor)) {
            this.borderBeforeColor.copy(bp.borderBeforeColor);
            altered = true;
        }
        if (this.inheritBorderAfterColor && !bp.borderAfterColor.equals(this.borderAfterColor)) {
            this.borderAfterColor.copy(bp.borderAfterColor);
            altered = true;
        }
        if (this.inheritBorderStartColor && !bp.borderStartColor.equals(this.borderStartColor)) {
            this.borderStartColor.copy(bp.borderStartColor);
            altered = true;
        }
        if (this.inheritBorderEndColor && !bp.borderEndColor.equals(this.borderEndColor)) {
            this.borderEndColor.copy(bp.borderEndColor);
            altered = true;
        }
        if (this.inheritBorderBottomColor && !bp.borderBottomColor.equals(this.borderBottomColor)) {
            this.borderBottomColor.copy(bp.borderBottomColor);
            altered = true;
        }
        if (this.inheritBorderTopColor && !bp.borderTopColor.equals(this.borderTopColor)) {
            this.borderTopColor.copy(bp.borderTopColor);
            altered = true;
        }
        if (this.inheritBorderLeftColor && !bp.borderLeftColor.equals(this.borderLeftColor)) {
            this.borderLeftColor.copy(bp.borderLeftColor);
            altered = true;
        }
        if (this.inheritBorderRightColor && !bp.borderRightColor.equals(this.borderRightColor)) {
            this.borderRightColor.copy(bp.borderRightColor);
            altered = true;
        }
        if (this.inheritBorderBeforeWidth && !bp.borderBeforeWidth.equals(this.borderBeforeWidth)) {
            this.borderBeforeWidth.copy(bp.borderBeforeWidth);
            altered = true;
        }
        if (this.inheritBorderStartWidth && !bp.borderStartWidth.equals(this.borderStartWidth)) {
            this.borderStartWidth.copy(bp.borderStartWidth);
            altered = true;
        }
        if (this.inheritBorderEndWidth && !bp.borderEndWidth.equals(this.borderEndWidth)) {
            this.borderEndWidth.copy(bp.borderEndWidth);
            altered = true;
        }
        if (this.inheritBorderAfterWidth && !bp.borderAfterWidth.equals(this.borderAfterWidth)) {
            this.borderAfterWidth.copy(bp.borderAfterWidth);
            altered = true;
        }
        if (this.inheritBorderBeforeStyle && bp.borderBeforeStyle != this.borderBeforeStyle) {
            this.borderBeforeStyle = bp.borderBeforeStyle;
            altered = true;
        }
        if (this.inheritBorderStartStyle && bp.borderStartStyle != this.borderStartStyle) {
            this.borderStartStyle = bp.borderStartStyle;
            altered = true;
        }
        if (this.inheritBorderEndStyle && bp.borderEndStyle != this.borderEndStyle) {
            this.borderEndStyle = bp.borderEndStyle;
            altered = true;
        }
        if (this.inheritBorderAfterStyle && bp.borderAfterStyle != this.borderAfterStyle) {
            this.borderAfterStyle = bp.borderAfterStyle;
            altered = true;
        }
        if (this.inheritPaddingBefore && bp.paddingBefore != this.paddingBefore) {
            this.paddingBefore = bp.paddingBefore;
            altered = true;
        }
        if (this.inheritPaddingAfter && bp.paddingAfter != this.paddingAfter) {
            this.paddingAfter = bp.paddingAfter;
            altered = true;
        }
        if (this.inheritPaddingStart && bp.paddingStart != this.paddingStart) {
            this.paddingStart = bp.paddingStart;
            altered = true;
        }
        if (this.inheritPaddingEnd && bp.paddingEnd != this.paddingEnd) {
            this.paddingEnd = bp.paddingEnd;
            altered = true;
        }
        if (this.inheritBorderRightWidth && !bp.borderRightWidth.equals(this.borderRightWidth)) {
            this.borderRightWidth.copy(bp.borderRightWidth);
            altered = true;
        }
        if (this.inheritBorderLeftWidth && !bp.borderLeftWidth.equals(this.borderLeftWidth)) {
            this.borderLeftWidth.copy(bp.borderLeftWidth);
            altered = true;
        }
        if (this.inheritBorderBottomWidth && !bp.borderBottomWidth.equals(this.borderBottomWidth)) {
            this.borderBottomWidth.copy(bp.borderBottomWidth);
            altered = true;
        }
        if (this.inheritBorderTopWidth && !bp.borderTopWidth.equals(this.borderTopWidth)) {
            this.borderTopWidth.copy(bp.borderTopWidth);
            altered = true;
        }
        if (this.inheritPaddingRight && !bp.paddingRight.equals(this.paddingRight)) {
            this.paddingRight = bp.paddingRight;
            altered = true;
        }
        if (this.inheritPaddingLeft && !bp.paddingLeft.equals(this.paddingLeft)) {
            this.paddingLeft = bp.paddingLeft;
            altered = true;
        }
        if (this.inheritPaddingBottom && !bp.paddingBottom.equals(this.paddingBottom)) {
            this.paddingBottom = bp.paddingBottom;
            altered = true;
        }
        if (this.inheritPaddingTop && !bp.paddingTop.equals(this.paddingTop)) {
            this.paddingTop = bp.paddingTop;
            altered = true;
        }
        if (this.parseBackground.isParseBackgroundInherited() && !bp.parseBackground.equals(this.parseBackground)) {
            this.parseBackground.copy(bp.parseBackground.getParseString());
            altered = true;
        }
        if (this.parseBackgroundPosition.isParseBackgroundPositionInherited() && !bp.parseBackgroundPosition.equals(this.parseBackgroundPosition)) {
            this.parseBackgroundPosition.copy(bp.parseBackgroundPosition.getParseString());
            altered = true;
        }
        return altered;
    }

    public boolean isTransparent() {
        return this.drawBackgroundColor ^ true;
    }

    private boolean objectWithNullEquals(Object a, Object b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public void setBackgroundAttachment(String backgroundAttachment) {
        if ((backgroundAttachment = backgroundAttachment.toLowerCase()).equals("inherit")) {
            this.inheritBackgroundAttachment = true;
            this.backgroundAttachment = "";
        } else {
            this.inheritBackgroundAttachment = false;
            this.backgroundAttachment = backgroundAttachment;
        }
    }

    public void setBackgroundColor(String backgroundColor) throws ParseException {
        if ((backgroundColor = backgroundColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBackgroundColor = true;
            this.drawBackgroundColor = true;
        } else if (backgroundColor.equals("transparent")) {
            this.inheritBackgroundColor = false;
            this.drawBackgroundColor = false;
        } else {
            this.backgroundColor.setColor(backgroundColor);
            this.inheritBackgroundColor = false;
            this.drawBackgroundColor = true;
        }
    }

    public void setBackgroundImage(String backgroundImage) throws IOException {
        String tmpBackgroundImage = backgroundImage.trim().toLowerCase();
        if (tmpBackgroundImage.equals("inherit")) {
            this.inheritBackgroundImage = true;
        } else if (tmpBackgroundImage.equals(NONE)) {
            this.inheritBackgroundImage = false;
            this.backgroundImage = null;
        } else {
            String file;
            this.inheritBackgroundImage = false;
            String uri = backgroundImage;
            URL theUri = null;
            try {
                theUri = RelativeURL.getAbsoluteURLForName(uri);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("<" + uri + "> is not a valid URI");
                this.backgroundImage = null;
                return;
            }
            if (theUri.toExternalForm().startsWith("file://") && !Utilities.isExists(file = theUri.toExternalForm().substring(7))) {
                this.backgroundImage = null;
                return;
            }
            this.backgroundImage = theUri;
        }
    }

    public void setBackgroundPositionShorthandProperty(String background) throws ParseException {
        String property = "background-position";
        this.parseBackgroundPosition = new SPParseBackground(this);
        boolean success = this.parseBackgroundPosition.spBackgroundPosition(background);
        this.parseBackgroundPosition.successFail("background-position", success);
    }

    public void setBackgroundPostionHorizontal(String position) {
        if ((position = position.toLowerCase()).equals("inherit")) {
            this.inheritBackgroundPositionHorizontal = true;
        } else if (position.equals("left")) {
            this.inheritBackgroundPositionHorizontal = false;
            this.backgroundPositionHorizontal.setLength("0%");
        } else if (position.equals("center")) {
            this.inheritBackgroundPositionHorizontal = false;
            this.backgroundPositionHorizontal.setLength("50%");
        } else if (position.equals("right")) {
            this.inheritBackgroundPositionHorizontal = false;
            this.backgroundPositionHorizontal.setLength("100%");
        } else {
            this.inheritBackgroundPositionHorizontal = false;
            this.backgroundPositionHorizontal.setLength(position);
        }
    }

    public void setBackgroundPostionVertical(String position) {
        if ((position = position.toLowerCase()).equals("inherit")) {
            this.inheritBackgroundPositionVertical = true;
        } else if (position.equals("top")) {
            this.inheritBackgroundPositionVertical = false;
            this.backgroundPositionVertical.setLength("0%");
        } else if (position.equals("center")) {
            this.inheritBackgroundPositionVertical = false;
            this.backgroundPositionVertical.setLength("50%");
        } else if (position.equals("bottom")) {
            this.inheritBackgroundPositionVertical = false;
            this.backgroundPositionVertical.setLength("100%");
        } else {
            this.inheritBackgroundPositionVertical = false;
            this.backgroundPositionVertical.setLength(position);
        }
    }

    public void setBackgroundRepeat(String backgroundRepeat) {
        if ((backgroundRepeat = backgroundRepeat.trim().toLowerCase()).equals("inherit")) {
            this.inheritBackgroundRepeat = true;
        } else {
            this.backgroundRepeat.setRepeat(backgroundRepeat);
            this.inheritBackgroundRepeat = false;
        }
    }

    public void setBackgroundShorthandProperty(String background) throws ParseException, IOException {
        String property = "background";
        this.parseBackground = new SPParseBackground(this);
        boolean success = this.parseBackground.spBackground(background);
        this.parseBackground.successFail("background", success);
    }

    public void setBorderAfterColor(String borderAfterColor) throws ParseException {
        if ((borderAfterColor = borderAfterColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderAfterColor = true;
        } else {
            this.borderAfterColor.setColor(borderAfterColor);
            this.inheritBorderAfterColor = false;
        }
    }

    public void setBorderAfterStyle(String borderAfterStyle) {
        if ((borderAfterStyle = borderAfterStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderAfterStyle = true;
        } else {
            this.borderAfterStyle = BorderStyle.styleFromString(borderAfterStyle);
            this.inheritBorderAfterStyle = false;
        }
    }

    public void setBorderAfterWidth(String borderAfterWidth) {
        this.inheritBorderAfterWidth = BorderPaddingBackgroundProperty.decodeWidth(borderAfterWidth, this.borderAfterWidth);
    }

    public void setBorderBeforeColor(String borderBeforeColor) throws ParseException {
        if ((borderBeforeColor = borderBeforeColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderBeforeColor = true;
        } else {
            this.borderBeforeColor.setColor(borderBeforeColor);
            this.inheritBorderBeforeColor = false;
        }
    }

    public void setBorderBeforeStyle(String borderBeforeStyle) {
        if ((borderBeforeStyle = borderBeforeStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderBeforeStyle = true;
        } else {
            this.borderBeforeStyle = BorderStyle.styleFromString(borderBeforeStyle);
            this.inheritBorderBeforeStyle = false;
        }
    }

    public void setBorderBeforeWidth(String borderBeforeWidth) {
        this.inheritBorderBeforeWidth = BorderPaddingBackgroundProperty.decodeWidth(borderBeforeWidth, this.borderBeforeWidth);
    }

    public void setBorderBottomColor(String borderBottomColor) throws ParseException {
        if ((borderBottomColor = borderBottomColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderBottomColor = true;
        } else {
            this.borderBottomColor.setColor(borderBottomColor);
            this.inheritBorderBottomColor = false;
        }
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderAfterColor(borderBottomColor);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderEndColor(borderBottomColor);
        }
    }

    public void setBorderBottomShorthandProperty(String border) throws ParseException {
        String property = "border-bottom";
        this.parseBorderBottom = new SPParseBackground(this);
        boolean success = this.parseBorderBottom.spBorderBottom(border);
        this.parseBorderBottom.successFail("border-bottom", success);
    }

    public void setBorderBottomStyle(String borderBottomStyle) {
        if ((borderBottomStyle = borderBottomStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderBottomStyle = true;
        } else {
            this.borderBottomStyle = BorderStyle.styleFromString(borderBottomStyle);
            this.inheritBorderBottomStyle = false;
        }
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderAfterStyle(borderBottomStyle);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderEndStyle(borderBottomStyle);
        } else {
            System.err.println("setBorderBottomStyle: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderBottomWidth(String borderBottomWidth) {
        this.inheritBorderBottomWidth = BorderPaddingBackgroundProperty.decodeWidth(borderBottomWidth, this.borderBottomWidth);
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderAfterWidth(borderBottomWidth);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderEndWidth(borderBottomWidth);
        } else {
            System.err.println("setBorderBottomWidth: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderColorShorthandProperty(String border) throws ParseException {
        String property = "border-color";
        this.parseBorderColor = new SPParseBackground(this);
        boolean success = this.parseBorderColor.spBorderColor(border);
        this.parseBorderColor.successFail("border-color", success);
    }

    public void setBorderEndColor(String borderEndColor) throws ParseException {
        if ((borderEndColor = borderEndColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderEndColor = true;
        } else {
            this.borderEndColor.setColor(borderEndColor);
            this.inheritBorderEndColor = false;
        }
    }

    public void setBorderEndStyle(String borderEndStyle) {
        if ((borderEndStyle = borderEndStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderEndStyle = true;
        } else {
            this.borderEndStyle = BorderStyle.styleFromString(borderEndStyle);
            this.inheritBorderEndStyle = false;
        }
    }

    public void setBorderEndWidth(String borderEndWidth) {
        this.inheritBorderEndWidth = BorderPaddingBackgroundProperty.decodeWidth(borderEndWidth, this.borderEndWidth);
    }

    public void setBorderLeftColor(String borderLeftColor) throws ParseException {
        if ((borderLeftColor = borderLeftColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderLeftColor = true;
        } else {
            this.borderLeftColor.setColor(borderLeftColor);
            this.inheritBorderLeftColor = false;
        }
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setBorderStartColor(borderLeftColor);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderEndColor(borderLeftColor);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderAfterColor(borderLeftColor);
        } else {
            System.err.println("setBorderLeftColor: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderLeftShorthandProperty(String border) throws ParseException {
        String property = "border-left";
        this.parseBorderLeft = new SPParseBackground(this);
        boolean success = this.parseBorderLeft.spBorderLeft(border);
        this.parseBorderLeft.successFail("border-left", success);
    }

    public void setBorderLeftStyle(String borderLeftStyle) {
        if ((borderLeftStyle = borderLeftStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderLeftStyle = true;
        } else {
            this.borderLeftStyle = BorderStyle.styleFromString(borderLeftStyle);
            this.inheritBorderLeftStyle = false;
        }
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setBorderStartStyle(borderLeftStyle);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderEndStyle(borderLeftStyle);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderAfterStyle(borderLeftStyle);
        } else {
            System.err.println("setBorderLeftStyle: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderLeftWidth(String borderLeftWidth) {
        this.inheritBorderLeftWidth = BorderPaddingBackgroundProperty.decodeWidth(borderLeftWidth, this.borderLeftWidth);
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setBorderStartWidth(borderLeftWidth);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderEndWidth(borderLeftWidth);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderAfterWidth(borderLeftWidth);
        } else {
            System.err.println("setBorderLeftWidth: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderRightColor(String borderRightColor) throws ParseException {
        if ((borderRightColor = borderRightColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderRightColor = true;
        } else {
            this.borderRightColor.setColor(borderRightColor);
            this.inheritBorderRightColor = false;
        }
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setBorderEndColor(borderRightColor);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderStartColor(borderRightColor);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderBeforeColor(borderRightColor);
        } else {
            System.err.println("setBorderRightColor: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderRightShorthandProperty(String border) throws ParseException {
        String property = "border-right";
        this.parseBorderRight = new SPParseBackground(this);
        boolean success = this.parseBorderRight.spBorderRight(border);
        this.parseBorderRight.successFail("border-right", success);
    }

    public void setBorderRightStyle(String borderRightStyle) {
        if ((borderRightStyle = borderRightStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderRightStyle = true;
        } else {
            this.borderRightStyle = BorderStyle.styleFromString(borderRightStyle);
            this.inheritBorderRightStyle = false;
        }
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setBorderEndStyle(borderRightStyle);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderStartStyle(borderRightStyle);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderBeforeStyle(borderRightStyle);
        } else {
            System.err.println("setBorderRightStyle: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderRightWidth(String borderRightWidth) {
        this.inheritBorderRightWidth = BorderPaddingBackgroundProperty.decodeWidth(borderRightWidth, this.borderRightWidth);
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setBorderEndWidth(borderRightWidth);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderStartWidth(borderRightWidth);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderBeforeWidth(borderRightWidth);
        } else {
            System.err.println("setBorderRightWidth: illegal writing mode:" + this.wmParent);
        }
    }

    public void setBorderShorthandProperty(String border) throws ParseException {
        String property = "border";
        this.parseBorder = new SPParseBackground(this);
        boolean success = this.parseBorder.spBorder(border);
        this.parseBorder.successFail("border", success);
    }

    public void setBorderSpacingShorthandProperty(String border) throws ParseException {
        String property = "border-spacing";
        this.parseBorderSpacing = new SPParseBackground(this);
        boolean success = this.parseBorderSpacing.spBorderSpacing(border);
        this.parseBorderSpacing.successFail("border-spacing", success);
    }

    public void setBorderStartColor(String borderStartColor) throws ParseException {
        if ((borderStartColor = borderStartColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderStartColor = true;
        } else {
            this.borderStartColor.setColor(borderStartColor);
            this.inheritBorderStartColor = false;
        }
    }

    public void setBorderStartStyle(String borderStartStyle) {
        if ((borderStartStyle = borderStartStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderStartStyle = true;
        } else {
            this.borderStartStyle = BorderStyle.styleFromString(borderStartStyle);
            this.inheritBorderStartStyle = false;
        }
    }

    public void setBorderStartWidth(String borderStartWidth) {
        this.inheritBorderStartWidth = BorderPaddingBackgroundProperty.decodeWidth(borderStartWidth, this.borderStartWidth);
    }

    public void setBorderStyleShorthandProperty(String border) throws ParseException {
        String property = "border-style";
        this.parseBorderStyle = new SPParseBackground(this);
        boolean success = this.parseBorderStyle.spBorderStyle(border);
        this.parseBorderStyle.successFail("border-style", success);
    }

    public void setBorderTopColor(String borderTopColor) throws ParseException {
        if ((borderTopColor = borderTopColor.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderTopColor = true;
        } else {
            this.inheritBorderTopColor = false;
            this.borderTopColor.setColor(borderTopColor);
        }
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderBeforeColor(borderTopColor);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderStartColor(borderTopColor);
        }
    }

    public void setBorderTopShorthandProperty(String border) throws ParseException {
        String property = "border-top";
        this.parseBorderTop = new SPParseBackground(this);
        boolean success = this.parseBorderTop.spBorderTop(border);
        this.parseBorderTop.successFail("border-top", success);
    }

    public void setBorderTopStyle(String borderTopStyle) {
        if ((borderTopStyle = borderTopStyle.trim().toLowerCase()).equals("inherit")) {
            this.inheritBorderTopStyle = true;
        } else {
            this.borderTopStyle = BorderStyle.styleFromString(borderTopStyle);
            this.inheritBorderTopStyle = false;
        }
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderBeforeStyle(borderTopStyle);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderStartStyle(borderTopStyle);
        }
    }

    public void setBorderTopWidth(String borderTopWidth) {
        borderTopWidth = borderTopWidth.trim().toLowerCase();
        this.inheritBorderTopWidth = BorderPaddingBackgroundProperty.decodeWidth(borderTopWidth, this.borderTopWidth);
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setBorderBeforeWidth(borderTopWidth);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setBorderStartWidth(borderTopWidth);
        }
    }

    public void setBorderWidthShorthandProperty(String border) throws ParseException {
        String property = "border-width";
        this.parseBorderWidth = new SPParseBackground(this);
        boolean success = this.parseBorderWidth.spBorderWidth(border);
        this.parseBorderWidth.successFail("border-width", success);
    }

    public void setDefaults() throws ParseException {
        try {
            this.inheritBackgroundAttachment = false;
            this.inheritBackgroundColor = false;
            this.drawBackgroundColor = false;
            this.inheritBackgroundImage = false;
            this.backgroundImage = null;
            this.backgroundRepeat.setRepeat("repeat");
            this.inheritBackgroundRepeat = false;
            this.inheritBackgroundPositionHorizontal = false;
            this.backgroundPositionHorizontal.setLength("0%");
            this.inheritBackgroundPositionVertical = false;
            this.backgroundPositionVertical.setLength("0%");
            this.inheritBorderBeforeColor = false;
            String black = "black";
            this.borderBeforeColor.setColor("black");
            this.inheritBorderBeforeStyle = false;
            this.borderBeforeStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderBeforeWidth = false;
            this.borderBeforeWidth.setLength(BORDER_MEDIUM);
            this.inheritBorderAfterColor = false;
            this.borderAfterColor.setColor("black");
            this.inheritBorderAfterStyle = false;
            this.borderAfterStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderAfterWidth = false;
            this.borderAfterWidth.setLength(BORDER_MEDIUM);
            this.inheritBorderStartColor = false;
            this.borderStartColor.setColor("black");
            this.inheritBorderStartStyle = false;
            this.borderStartStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderStartWidth = false;
            this.borderStartWidth.setLength(BORDER_MEDIUM);
            this.inheritBorderEndColor = false;
            this.borderEndColor.setColor("black");
            this.inheritBorderEndStyle = false;
            this.borderEndStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderEndWidth = false;
            this.borderEndWidth.setLength(BORDER_MEDIUM);
            this.inheritBorderTopColor = false;
            this.borderTopColor.setColor("black");
            this.inheritBorderTopStyle = false;
            this.borderTopStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderTopWidth = false;
            this.borderTopWidth.setLength(BORDER_MEDIUM);
            this.inheritBorderBottomColor = false;
            this.borderBottomColor.setColor("black");
            this.inheritBorderBottomStyle = false;
            this.borderBottomStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderBottomWidth = false;
            this.borderBottomWidth.setLength(BORDER_MEDIUM);
            this.inheritBorderLeftColor = false;
            this.borderLeftColor.setColor("black");
            this.inheritBorderLeftStyle = false;
            this.borderLeftStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderLeftWidth = false;
            this.borderLeftWidth.setLength(BORDER_MEDIUM);
            this.inheritBorderRightColor = false;
            this.borderRightColor.setColor("black");
            this.inheritBorderRightStyle = false;
            this.borderRightStyle = BorderStyle.styleFromString(NONE);
            this.inheritBorderRightWidth = false;
            this.borderRightWidth.setLength(BORDER_MEDIUM);
            this.inheritPaddingBefore = false;
            this.paddingBefore.setLength("0pt");
            this.inheritPaddingAfter = false;
            this.paddingAfter.setLength("0pt");
            this.inheritPaddingStart = false;
            this.paddingStart.setLength("0pt");
            this.inheritPaddingEnd = false;
            this.paddingEnd.setLength("0pt");
            this.inheritPaddingTop = false;
            this.inheritPaddingBottom = false;
            this.inheritPaddingLeft = false;
            this.inheritPaddingRight = false;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setPaddingAfter(String paddingAfter) {
        if ((paddingAfter = paddingAfter.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingAfter = true;
        } else {
            this.paddingAfter.setLength(paddingAfter);
            this.inheritPaddingAfter = false;
        }
    }

    public void setPaddingBefore(String paddingBefore) {
        if ((paddingBefore = paddingBefore.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingBefore = true;
        } else {
            this.paddingBefore.setLength(paddingBefore);
            this.inheritPaddingBefore = false;
        }
    }

    public void setPaddingBottom(String paddingBottom) {
        if ((paddingBottom = paddingBottom.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingBottom = true;
        } else {
            this.inheritPaddingBottom = false;
            this.paddingBottom.setLength(paddingBottom);
        }
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setPaddingAfter(paddingBottom);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setPaddingEnd(paddingBottom);
        }
    }

    public void setPaddingEnd(String paddingEnd) {
        if ((paddingEnd = paddingEnd.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingEnd = true;
        } else {
            this.paddingEnd.setLength(paddingEnd);
            this.inheritPaddingEnd = false;
        }
    }

    public void setPaddingLeft(String paddingLeft) {
        if ((paddingLeft = paddingLeft.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingLeft = true;
        } else {
            this.inheritPaddingLeft = false;
            this.paddingLeft.setLength(paddingLeft);
        }
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setPaddingStart(paddingLeft);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setPaddingEnd(paddingLeft);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setPaddingAfter(paddingLeft);
        }
    }

    public void setPaddingRight(String paddingRight) {
        if ((paddingRight = paddingRight.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingRight = true;
        } else {
            this.inheritPaddingRight = false;
            this.paddingRight.setLength(paddingRight);
        }
        if (this.wmParent.equals(WritingMode.LR_TB)) {
            this.setPaddingEnd(paddingRight);
        } else if (this.wmParent.equals(WritingMode.RL_TB)) {
            this.setPaddingStart(paddingRight);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setPaddingBefore(paddingRight);
        }
    }

    public void setPaddingShorthandProperty(String border) throws ParseException {
        String property = "padding";
        this.parsePadding = new SPParseBackground(this);
        boolean success = this.parsePadding.spPadding(border);
        this.parsePadding.successFail("padding", success);
    }

    public void setPaddingStart(String paddingStart) {
        if ((paddingStart = paddingStart.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingStart = true;
        } else {
            this.paddingStart.setLength(paddingStart);
            this.inheritPaddingStart = false;
        }
    }

    public void setPaddingTop(String paddingTop) {
        if ((paddingTop = paddingTop.trim().toLowerCase()).equals("inherit")) {
            this.inheritPaddingTop = true;
        } else {
            this.inheritPaddingTop = false;
            this.paddingTop.setLength(paddingTop);
        }
        if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
            this.setPaddingBefore(paddingTop);
        } else if (this.wmParent.equals(WritingMode.TB_RL)) {
            this.setPaddingStart(paddingTop);
        }
    }

    public void setParentWritingMode(WritingMode wm) {
        this.wmParent = wm;
    }
}

