/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.FontFamily;
import com.ibm.xsl.composer.csstypes.FontSize;
import com.ibm.xsl.composer.csstypes.FontStretch;
import com.ibm.xsl.composer.csstypes.FontStyle;
import com.ibm.xsl.composer.csstypes.FontVariant;
import com.ibm.xsl.composer.csstypes.FontWeight;
import com.ibm.xsl.composer.java2d.J2DExtendedFont;
import com.ibm.xsl.composer.properties.parse.ParseBase;
import com.ibm.xsl.composer.properties.parse.ParseException;
import com.ibm.xsl.composer.properties.parse.SPParseFont;
import java.util.Vector;

public class FontProperty {
    FontFamily cssFontFamily = new FontFamily();
    FontSize cssFontSize = new FontSize();
    FontStretch cssFontStretch = new FontStretch();
    FontStyle cssFontStyle = new FontStyle();
    FontVariant cssFontVariant = new FontVariant();
    FontWeight cssFontWeight = new FontWeight();
    private SPParseFont parseFont = new SPParseFont();

    public boolean cmpFontProperty(FontProperty fp) {
        return !(this.cssFontStyle.inheritFontStyle != fp.cssFontStyle.inheritFontStyle || this.cssFontFamily.inheritFontFamily != fp.cssFontFamily.inheritFontFamily || this.cssFontVariant.fontVariantValue != fp.cssFontVariant.fontVariantValue || this.cssFontStretch.fontStretchValue != fp.cssFontStretch.fontStretchValue || this.cssFontSize.inheritFontSize != fp.cssFontSize.inheritFontSize || this.cssFontSize.fontSizeAdjustValue != 0 && this.cssFontSize.fontSizeAdjustValue == fp.cssFontSize.fontSizeAdjustValue && this.cssFontSize.fontSizeAdjustValue == 2 && this.cssFontSize.fontSizeAdjust != fp.cssFontSize.fontSizeAdjust && !false || this.cssFontWeight.inheritFontWeight != fp.cssFontWeight.inheritFontWeight || !this.cssFontStyle.inheritFontStyle && !this.cssFontStyle.fontStyle.equals(fp.cssFontStyle.fontStyle) || !this.cssFontFamily.inheritFontFamily && !this.cssFontFamily.fontFamily.equals(fp.cssFontFamily.fontFamily) || this.cssFontStretch.fontStretchValue != fp.cssFontStretch.fontStretchValue || this.cssFontSize.inheritFontSize != 0 && this.cssFontSize.fontSize != fp.cssFontSize.fontSize || !this.cssFontWeight.inheritFontWeight && this.cssFontWeight.fontWeight != fp.cssFontWeight.fontWeight);
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj != null && obj instanceof FontProperty) {
            isEquals = this.cmpFontProperty((FontProperty)obj);
        }
        return isEquals;
    }

    public String getFontFamily() {
        return this.cssFontFamily.fontFamily;
    }

    public CSSLength getFontSize() {
        return this.cssFontSize.getFontSize();
    }

    public int getFontSizeAdjust() {
        return this.cssFontSize.getFontSizeAdjust();
    }

    public String getFontSizeAdjustAttribute() {
        return this.cssFontSize.getFontSizeAdjustAttribute();
    }

    public String getFontStretch() {
        return this.cssFontStretch.getFontStretch();
    }

    public String getFontStretchAttribute() {
        return this.cssFontStretch.getFontStretch();
    }

    public String getFontStyle() {
        return this.cssFontStyle.getFontStyle();
    }

    public String getFontVariant() {
        return this.cssFontVariant.getFontVariant();
    }

    public int getFontWeight() {
        return this.cssFontWeight.getFontWeight();
    }

    public String getFontWeightAttribute() {
        return this.cssFontWeight.getFontWeightAttribute();
    }

    public int hashCode() {
        return (this.cssFontStyle.inheritFontStyle ? this.cssFontStyle.fontStyle.hashCode() : 0) + (this.cssFontFamily.inheritFontFamily ? this.cssFontFamily.fontFamily.hashCode() : 0) + (this.cssFontVariant.fontVariantValue == 0 ? (int)this.cssFontVariant.fontVariantValue : 0) + (this.cssFontSize.inheritFontSize == 0 ? this.cssFontSize.fontSize.hashCode() : 0) + (this.cssFontSize.fontSizeAdjustValue == 0 ? this.cssFontSize.fontSizeAdjust.intValue() : 0) + (this.cssFontStretch.fontStretchValue == 0 ? (int)this.cssFontStretch.fontStretchValue : 0) + (this.cssFontWeight.inheritFontWeight ? (int)this.cssFontWeight.fontWeight : 0);
    }

    public boolean inherit(FontProperty parent) {
        boolean altered = false;
        if (this.cssFontStyle.inheritFontStyle && !this.cssFontStyle.fontStyle.equals(parent.cssFontStyle.fontStyle)) {
            this.cssFontStyle.fontStyle = parent.cssFontStyle.fontStyle;
            altered = true;
        }
        if (this.cssFontFamily.inheritFontFamily && !this.cssFontFamily.fontFamily.equals(parent.cssFontFamily.fontFamily)) {
            this.cssFontFamily.fontFamily = parent.cssFontFamily.fontFamily;
            this.cssFontFamily.fontSet = parent.cssFontFamily.fontSet;
            altered = true;
        }
        if (this.cssFontVariant.fontVariantValue == 0) {
            this.cssFontVariant.fontVariantValue = parent.cssFontVariant.fontVariantValue;
            altered = true;
        }
        if (this.cssFontSize.inheritFontSize == 0 && !this.cssFontSize.fontSize.equals(parent.cssFontSize.fontSize)) {
            this.cssFontSize.fontSize.copy(parent.cssFontSize.fontSize);
            this.cssFontSize.inheritFontSize = 0;
            altered = true;
        } else if (!(this.cssFontSize.inheritFontSize != 2 && this.cssFontSize.inheritFontSize != 3 || this.cssFontSize.fontSize.equals(parent.cssFontSize.fontSize))) {
            this.setAdjustedSize(parent);
            this.cssFontSize.inheritFontSize = 0;
            altered = true;
        }
        if (this.cssFontSize.fontSizeAdjustValue == 0 && this.cssFontSize.fontSizeAdjust != parent.cssFontSize.fontSizeAdjust) {
            this.cssFontSize.fontSizeAdjustValue = parent.cssFontSize.fontSizeAdjustValue;
            this.cssFontSize.fontSizeAdjust = parent.cssFontSize.fontSizeAdjust;
            altered = true;
        }
        if (this.cssFontWeight.inheritFontWeight && this.cssFontWeight.fontWeight != parent.cssFontWeight.fontWeight) {
            this.cssFontWeight.fontWeight = parent.cssFontWeight.fontWeight;
            altered = true;
        }
        if (this.cssFontStretch.fontStretchValue == 0) {
            this.cssFontStretch.fontStretchValue = parent.cssFontStretch.fontStretchValue;
            altered = true;
        } else if (this.cssFontStretch.fontStretchValue == 1) {
            this.cssFontStretch.fontStretchValue = this.narrowerFontStretch(parent.cssFontStretch.fontStretchValue);
            altered = true;
        } else if (this.cssFontStretch.fontStretchValue == 2) {
            this.cssFontStretch.fontStretchValue = this.widerFontStretch(parent.cssFontStretch.fontStretchValue);
            altered = true;
        }
        return altered;
    }

    private short narrowerFontStretch(short parentFontStretchValue) {
        short s;
        if (parentFontStretchValue > 3) {
            short s2 = parentFontStretchValue;
            s = s2;
            parentFontStretchValue = (short)(s2 - 1);
        } else {
            s = 3;
        }
        return s;
    }

    private void setAdjustedSize(FontProperty parentFontSize) {
        CSSLength pFontSize = new CSSLength(parentFontSize.cssFontSize.fontSize);
        if (this.cssFontSize.inheritFontSize == 2) {
            pFontSize.scale(1.2f);
        } else {
            pFontSize.scale(0.8f);
        }
        this.cssFontSize.fontSize.copy(pFontSize);
    }

    public void setAllPropertiesToInherit() {
        this.cssFontFamily.inheritFontFamily = true;
        this.cssFontSize.inheritFontSize = 0;
        this.cssFontStretch.fontStretchValue = 0;
        this.cssFontSize.fontSizeAdjustValue = 0;
        this.cssFontStyle.inheritFontStyle = true;
        this.cssFontVariant.fontVariantValue = 0;
        this.cssFontWeight.inheritFontWeight = true;
    }

    public void setFontFamily(String familyName) {
        this.cssFontFamily.fontFamily = familyName;
        this.cssFontFamily.inheritFontFamily = false;
    }

    public void setFontFamily(Vector fontSet) {
        this.cssFontFamily.fontSet = fontSet;
        this.cssFontFamily.inheritFontFamily = false;
    }

    public void setFontShorthandProperty(String border) {
        boolean success;
        String property = "font";
        this.parseFont = new SPParseFont(this);
        this.parseFont.setStrictness(true);
        try {
            success = this.parseFont.spFont(border);
        }
        catch (ParseException parseException) {
            success = false;
        }
        if (!success) {
            new ParseBase().dontUnderstand("font", border);
        }
    }

    public void setFontSize(int size) {
        this.cssFontSize.setFontSize(size);
    }

    public void setFontSize(String size) throws ParseException {
        this.cssFontSize.setFontSize(size);
    }

    public void setFontSizeAdjust(int size) {
        this.setFontSizeAdjust(Integer.toString(size));
    }

    public void setFontSizeAdjust(String size) {
        this.cssFontSize.setFontSizeAdjust(size);
    }

    public void setFontStretch(String fontStretch) {
        this.cssFontStretch.setFontStretch(fontStretch);
    }

    public void setFontStyle(String style) {
        this.cssFontStyle.setFontStyle(style);
    }

    public void setFontVariant(String variant) {
        this.cssFontVariant.setFontVariant(variant);
    }

    public void setFontWeight(String weight) {
        this.cssFontWeight.setFontWeight(weight);
    }

    public void setFontWeight(short weight) {
        this.cssFontWeight.setFontWeight(weight);
    }

    public void setSystemFontFamily(String systemFontSet) {
        this.cssFontFamily.fontSet.removeAllElements();
        this.cssFontFamily.fontSet.addElement(J2DExtendedFont.getDefaultSystemFont(systemFontSet));
        this.cssFontFamily.inheritFontFamily = false;
    }

    private short widerFontStretch(short parentFontStretchValue) {
        short s;
        if (parentFontStretchValue < 11) {
            short s2 = parentFontStretchValue;
            s = s2;
            parentFontStretchValue = (short)(s2 + 1);
        } else {
            s = 11;
        }
        return s;
    }
}

