/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.BorderStyle;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.LengthRange;

public class LeaderAndRuleProperty {
    private String leaderAlignment = "none";
    private String leaderPattern = "space";
    private String leaderPatternWidth = "use-font-metrics";
    private String ruleStyle = "solid";
    private CSSLength ruleThickness = new CSSLength("1.0pt", 18);
    private boolean inheritLeaderLength = true;
    private LengthRange leaderLength = new LengthRange("0pt", "12.0pt", "100%");

    public boolean cmpLeaderAndRuleProperty(LeaderAndRuleProperty lp) {
        boolean state = false;
        if (this.leaderAlignment.equalsIgnoreCase(lp.leaderAlignment) && this.leaderLength.equals(lp.leaderLength) && this.leaderPattern.equalsIgnoreCase(lp.leaderPattern) && this.leaderPatternWidth.equalsIgnoreCase(lp.leaderPatternWidth) && this.ruleStyle.equalsIgnoreCase(lp.ruleStyle) && this.ruleThickness.equals(lp.ruleThickness)) {
            state = true;
        }
        return state;
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj != null && obj instanceof LeaderAndRuleProperty) {
            isEquals = this.cmpLeaderAndRuleProperty((LeaderAndRuleProperty)obj);
        }
        return isEquals;
    }

    public String getLeaderAlignment() {
        return this.leaderAlignment;
    }

    public String getLeaderLength() {
        String result = this.inheritLeaderLength ? "inherit" : this.leaderLength.getOptimumString();
        return result;
    }

    public CSSLength getLeaderLengthMaximum() {
        return this.leaderLength.getMaximum();
    }

    public CSSLength getLeaderLengthMinimum() {
        return this.leaderLength.getMinimum();
    }

    public CSSLength getLeaderLengthOptimum() {
        return this.leaderLength.getOptimum();
    }

    public String getLeaderPattern() {
        return this.leaderPattern;
    }

    public String getLeaderPatternWidth() {
        return this.leaderPatternWidth;
    }

    public short getRuleStyle() {
        return BorderStyle.styleFromString(this.ruleStyle);
    }

    public CSSLength getRuleThickness() {
        return this.ruleThickness;
    }

    public void setLeaderAlignment(String leaderAlignment) {
        this.leaderAlignment = leaderAlignment;
    }

    public void setLeaderLength(String leaderLengthString) {
        if ((leaderLengthString = leaderLengthString.toLowerCase()).equals("inherit")) {
            this.inheritLeaderLength = true;
        } else {
            this.inheritLeaderLength = false;
            this.leaderLength.setLength(leaderLengthString);
        }
    }

    public void setLeaderLengthMaximum(String leaderLengthString) {
        this.leaderLength.setMaximum(leaderLengthString);
    }

    public void setLeaderLengthMinimum(String leaderLengthString) {
        this.leaderLength.setMinimum(leaderLengthString);
    }

    public void setLeaderLengthOptimum(String leaderLengthString) {
        this.leaderLength.setOptimum(leaderLengthString);
    }

    public void setLeaderPattern(String leaderPattern) {
        this.leaderPattern = leaderPattern;
    }

    public void setLeaderPatternWidth(String leaderPatternWidth) {
        this.leaderPatternWidth = leaderPatternWidth;
    }

    public void setRuleStyle(String ruleStyle) {
        this.ruleStyle = ruleStyle;
    }

    public void setRuleThickness(String ruleThickness) {
        this.ruleThickness.setLength(ruleThickness);
    }
}

