/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.BorderSeparationCDT;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.prim.ShortMap;
import com.ibm.xsl.composer.properties.parse.ParseBase;
import com.ibm.xsl.composer.properties.parse.SPUtility;

public class TableProperty {
    private WritingMode wmParent;
    public static final short BORDER_COLLAPSE_INHERIT = 0;
    public static final short BORDER_COLLAPSE_COLLAPSE = 1;
    public static final short BORDER_COLLAPSE_SEPARATE = 2;
    private static final ShortMap borderCollapseMap = new ShortMap(new String[]{"inherit", "collapse", "separate"});
    public static short borderCollapseValue = 1;
    public boolean inheritBorderCollapse = true;
    public final BorderSeparationCDT borderSeparation = new BorderSeparationCDT();
    public static final short CAPTION_SIDE_INHERIT = 0;
    public static final short CAPTION_SIDE_BEFORE = 1;
    public static final short CAPTION_SIDE_AFTER = 2;
    public static final short CAPTION_SIDE_START = 3;
    public static final short CAPTION_SIDE_END = 4;
    private static final ShortMap captionSideMap = new ShortMap(new String[]{"inherit", "before", "after", "start", "end"});
    public short captionSideValue = 1;
    public boolean inheritCaptionSide = true;
    public int columnNumber = 1;
    public final CSSLength columnWidth = new CSSLength(18);
    public boolean columnWidthIsInitialValue = true;
    public static final short EMPTY_CELLS_INHERIT = 0;
    public static final short EMPTY_CELLS_SHOW = 1;
    public static final short EMPTY_CELLS_HIDE = 2;
    private static final ShortMap emptyCellsMap = new ShortMap(new String[]{"inherit", "show", "hide"});
    public short emptyCellsValue = 1;
    public boolean inheritEmptyCells = true;
    public boolean endsRow = false;
    public int numberColumnsRepeated = 1;
    public int numberColumnsSpanned = 1;
    public int numberRowsSpanned = 1;
    public boolean startsRow = false;
    public static final short TABLE_LAYOUT_INHERIT = 0;
    public static final short TABLE_LAYOUT_AUTO = 1;
    public static final short TABLE_LAYOUT_FIXED = 2;
    private static final ShortMap tableLayoutMap = new ShortMap(new String[]{"inherit", "auto", "fixed"});
    public short tableLayoutValue = 1;
    public boolean inheritTableLayout = true;
    public boolean tableOmitFooterAtBreak = false;
    public boolean tableOmitHeaderAtBreak = false;

    public boolean cmpTableProperty(TableProperty tp) {
        boolean state = false;
        if (borderCollapseValue == borderCollapseValue && this.borderSeparation.equals(tp.borderSeparation) && this.captionSideValue == tp.captionSideValue && this.columnNumber == tp.columnNumber && this.columnWidth.equals(tp.columnWidth) && this.inheritEmptyCells == tp.inheritEmptyCells && this.endsRow == tp.endsRow && this.numberColumnsRepeated == tp.numberColumnsRepeated && this.numberColumnsSpanned == tp.numberColumnsSpanned && this.numberRowsSpanned == tp.numberRowsSpanned && this.startsRow == tp.startsRow && this.tableLayoutValue == tp.tableLayoutValue && this.tableOmitFooterAtBreak == tp.tableOmitFooterAtBreak && this.tableOmitHeaderAtBreak == tp.tableOmitHeaderAtBreak) {
            state = true;
        }
        return state;
    }

    private int convertToInt(String s, String methodId) {
        if (SPUtility.isInteger(s)) {
            int positiveInteger = SPUtility.isPositiveInteger(s) ? Integer.parseInt(s) : -Integer.parseInt(s);
            return positiveInteger >= 1 ? positiveInteger : 1;
        }
        if (SPUtility.isNumber(s)) {
            double positiveNumber = SPUtility.isPositiveNumber(s) ? (double)Float.parseFloat(s) + 0.5 : (double)(-Float.parseFloat(s)) + 0.5;
            return (int)(positiveNumber >= 1.0 ? positiveNumber : 1.0);
        }
        new ParseBase().dontUnderstand(methodId, s);
        return 1;
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj != null && obj instanceof TableProperty) {
            isEquals = this.cmpTableProperty((TableProperty)obj);
        }
        return isEquals;
    }

    public String getBorderCollapse() {
        return borderCollapseMap.getName(borderCollapseValue);
    }

    public String getBorderCollapseAttribute() {
        return this.getBorderCollapse();
    }

    public BorderSeparationCDT getBorderSeparation() {
        return this.borderSeparation;
    }

    public String getBorderSeparationAttribute() {
        return this.borderSeparation.toString();
    }

    public String getCaptionSide() {
        return captionSideMap.getName(this.captionSideValue);
    }

    public String getCaptionSideAttribute() {
        return this.getCaptionSide();
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getColumnNumberAttribute() {
        return String.valueOf(this.columnNumber);
    }

    public CSSLength getColumnWidth() {
        return this.columnWidth;
    }

    public String getColumnWidthAttribute() {
        return this.getColumnWidth().getLength();
    }

    public String getEmptyCells() {
        return emptyCellsMap.getName(this.emptyCellsValue);
    }

    public String getEmptyCellsAttribute() {
        return this.getEmptyCells();
    }

    public boolean getEndsRow() {
        return this.endsRow;
    }

    public String getEndsRowAttribute() {
        return this.endsRow ? "yes" : "no";
    }

    public int getNumberColumnsRepeated() {
        return this.numberColumnsRepeated;
    }

    public String getNumberColumnsRepeatedAttribute() {
        return String.valueOf(this.numberColumnsRepeated);
    }

    public int getNumberColumnsSpanned() {
        return this.numberColumnsSpanned;
    }

    public int getNumberRowsSpanned() {
        return this.numberRowsSpanned;
    }

    public boolean getStartsRow() {
        return this.startsRow;
    }

    public String getStartsRowAttribute() {
        return this.startsRow ? "yes" : "no";
    }

    public String getTableLayout() {
        return tableLayoutMap.getName(this.tableLayoutValue);
    }

    public String getTableLayoutAttribute() {
        return this.getTableLayout();
    }

    public boolean getTableOmitFooterAtBreak() {
        return this.tableOmitFooterAtBreak;
    }

    public String getTableOmitFooterAtBreakAttribute() {
        return this.tableOmitFooterAtBreak ? "yes" : "no";
    }

    public boolean getTableOmitHeaderAtBreak() {
        return this.tableOmitHeaderAtBreak;
    }

    public String getTableOmitHeaderAtBreakAttribute() {
        return this.tableOmitHeaderAtBreak ? "yes" : "no";
    }

    public String getnumberColumnsSpannedAttribute() {
        return String.valueOf(this.numberColumnsSpanned);
    }

    public String getnumberRowsSpannedAttribute() {
        return String.valueOf(this.numberRowsSpanned);
    }

    public boolean inherit(TableProperty parent) {
        boolean altered = false;
        if (this.inheritBorderCollapse) {
            altered = true;
        }
        if (this.borderSeparation.isInherited()) {
            this.borderSeparation.copy(parent.borderSeparation);
            altered = true;
        }
        if (this.inheritCaptionSide) {
            this.captionSideValue = parent.captionSideValue;
            altered = true;
        }
        if (this.inheritEmptyCells) {
            this.emptyCellsValue = parent.emptyCellsValue;
            altered = true;
        }
        if (this.inheritTableLayout) {
            this.tableLayoutValue = parent.tableLayoutValue;
            altered = true;
        }
        return altered;
    }

    public void setBorderCollapse(String borderCollapse) {
        borderCollapse = borderCollapse.trim().toLowerCase();
        try {
            borderCollapseValue = borderCollapseMap.decodeName(borderCollapse);
            this.inheritBorderCollapse = borderCollapseValue == 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new ParseBase().dontUnderstand("border-collapse", borderCollapse);
        }
    }

    public void setBorderSeparation(String borderSeparation) {
        if (!this.borderSeparation.setBorderSeparation(borderSeparation)) {
            new ParseBase().dontUnderstand("border-separation", borderSeparation);
        }
    }

    public void setBorderSeparationBlockProgressionDirection(String borderSeparation) {
        if (!this.borderSeparation.setBorderSeparationBPD(borderSeparation)) {
            new ParseBase().dontUnderstand("border-separation.block-progression-direction", borderSeparation);
        }
    }

    public void setBorderSeparationInlineProgressionDirection(String borderSeparation) {
        if (!this.borderSeparation.setBorderSeparationIPD(borderSeparation)) {
            new ParseBase().dontUnderstand("border-separation.inline-progression-direction", borderSeparation);
        }
    }

    public void setCaptionSide(String captionSide) {
        captionSide = captionSide.trim().toLowerCase();
        try {
            this.captionSideValue = captionSideMap.decodeName(captionSide);
            this.inheritCaptionSide = this.captionSideValue == 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (captionSide.equals("top")) {
                if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
                    this.captionSideValue = 1;
                } else if (this.wmParent.equals(WritingMode.TB_RL)) {
                    this.captionSideValue = (short)3;
                }
            }
            if (captionSide.equals("bottom")) {
                if (this.wmParent.equals(WritingMode.LR_TB) || this.wmParent.equals(WritingMode.RL_TB)) {
                    this.captionSideValue = (short)2;
                } else if (this.wmParent.equals(WritingMode.TB_RL)) {
                    this.captionSideValue = (short)4;
                }
            }
            if (captionSide.equals("right")) {
                if (this.wmParent.equals(WritingMode.LR_TB)) {
                    this.captionSideValue = (short)4;
                } else if (this.wmParent.equals(WritingMode.RL_TB)) {
                    this.captionSideValue = (short)3;
                } else if (this.wmParent.equals(WritingMode.TB_RL)) {
                    this.captionSideValue = 1;
                }
            }
            if (captionSide.equals("left")) {
                if (this.wmParent.equals(WritingMode.LR_TB)) {
                    this.captionSideValue = (short)3;
                } else if (this.wmParent.equals(WritingMode.RL_TB)) {
                    this.captionSideValue = (short)4;
                } else if (this.wmParent.equals(WritingMode.TB_RL)) {
                    this.captionSideValue = (short)2;
                }
            }
            new ParseBase().dontUnderstand("caption-side", captionSide);
        }
    }

    public void setColumnNumber(String columnNumber) {
        this.columnNumber = this.convertToInt(columnNumber, "column-number");
    }

    public void setColumnWidth(String columnWidth) {
        if (CSSLength.isValid(columnWidth = columnWidth.trim(), 18)) {
            this.columnWidth.setLength(columnWidth);
            this.columnWidthIsInitialValue = false;
        } else {
            new ParseBase().dontUnderstand("column-width", columnWidth);
        }
    }

    public void setEmptyCells(String emptyCells) {
        emptyCells = emptyCells.trim().toLowerCase();
        try {
            this.emptyCellsValue = emptyCellsMap.decodeName(emptyCells);
            this.inheritEmptyCells = this.emptyCellsValue == 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new ParseBase().dontUnderstand("empty-cells", emptyCells);
        }
    }

    public void setEndsRow(String endsRow) {
        if ((endsRow = endsRow.trim().toLowerCase()).equals("yes")) {
            this.endsRow = true;
        } else if (endsRow.equals("no")) {
            this.endsRow = false;
        } else {
            new ParseBase().dontUnderstand("ends-row", endsRow);
        }
    }

    public void setNumberColumnsRepeated(String numberColumnsRepeated) {
        this.numberColumnsRepeated = this.convertToInt(numberColumnsRepeated, "number-columns-repeated");
    }

    public void setNumberColumnsSpanned(String numberColumnsSpanned) {
        this.numberColumnsSpanned = this.convertToInt(numberColumnsSpanned, "number-columns-spanned");
    }

    public void setNumberRowsSpanned(String numberRowsSpanned) {
        this.numberRowsSpanned = this.convertToInt(numberRowsSpanned, "number-rows-spanned");
    }

    public void setParentWritingMode(WritingMode wm) {
        this.wmParent = wm;
    }

    public void setStartsRow(String startsRow) {
        if ((startsRow = startsRow.trim().toLowerCase()).equals("yes")) {
            this.startsRow = true;
        } else if (startsRow.equals("no")) {
            this.startsRow = false;
        } else {
            new ParseBase().dontUnderstand("starts-row", startsRow);
        }
    }

    public void setTableLayout(String tableLayout) {
        tableLayout = tableLayout.trim().toLowerCase();
        try {
            this.tableLayoutValue = tableLayoutMap.decodeName(tableLayout);
            this.inheritTableLayout = this.tableLayoutValue == 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new ParseBase().dontUnderstand("table-layout", tableLayout);
        }
    }

    public void setTableOmitFooterAtBreak(String tableOmitFooterAtBreak) {
        if ((tableOmitFooterAtBreak = tableOmitFooterAtBreak.trim().toLowerCase()).equals("yes")) {
            this.tableOmitFooterAtBreak = true;
        } else if (tableOmitFooterAtBreak.equals("no")) {
            this.tableOmitFooterAtBreak = false;
        } else {
            new ParseBase().dontUnderstand("omit-footer-at-break", tableOmitFooterAtBreak);
        }
    }

    public void setTableOmitHeaderAtBreak(String tableOmitHeaderAtBreak) {
        if ((tableOmitHeaderAtBreak = tableOmitHeaderAtBreak.trim().toLowerCase()).equals("yes")) {
            this.tableOmitHeaderAtBreak = true;
        } else if (tableOmitHeaderAtBreak.equals("no")) {
            this.tableOmitHeaderAtBreak = false;
        } else {
            new ParseBase().dontUnderstand("omit-header-at-break", tableOmitHeaderAtBreak);
        }
    }
}

