/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.Orientation;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.prim.ShortMap;
import com.ibm.xsl.composer.properties.parse.ParseBase;

public class WritingModeRelatedProperty {
    private boolean inheritDirection = true;
    public String direction = "lr-tb";
    public static final short FONT_HEIGHT_OVERRIDE_INHERIT = 0;
    public static final short FONT_HEIGHT_OVERRIDE_USEFONTMETRICS = 1;
    public static final short FONT_HEIGHT_OVERRIDE_ISLENGTH = 2;
    private static final ShortMap fontHeightOverrideMap = new ShortMap(new String[]{"inherit", "use-font-metrics"});
    public short fontHeightOverrideBeforeValue = 1;
    public final CSSLength fontHeightOverrideAfterLength = new CSSLength(2);
    public short fontHeightOverrideAfterValue = 1;
    public final CSSLength fontHeightOverrideBeforeLength = new CSSLength(2);
    private boolean inheritGlyphOrientationVertical = true;
    public short glyphOrientationVertical = 0;
    private boolean inheritGlyphOrientationHorizontal = true;
    public short glyphOrientationHorizontal = 0;
    private boolean isAutoGlyphOrientationVertical = true;
    private boolean inheritUnicodeBidi = true;
    public String unicodeBidi = "normal";
    private boolean inheritWritingMode = true;
    private WritingMode writingMode = new WritingMode();

    public boolean cmpWritingModeRelatedProperty(WritingModeRelatedProperty wp) {
        return !(this.inheritWritingMode != wp.inheritWritingMode || this.inheritGlyphOrientationHorizontal != this.inheritGlyphOrientationHorizontal || this.inheritGlyphOrientationVertical != this.inheritGlyphOrientationVertical || this.isAutoGlyphOrientationVertical != wp.isAutoGlyphOrientationVertical || this.inheritUnicodeBidi != wp.inheritUnicodeBidi || this.inheritDirection != wp.inheritDirection || !this.inheritWritingMode && !this.writingMode.equals(wp.writingMode) || this.fontHeightOverrideAfterValue != 0 && (this.fontHeightOverrideAfterValue != wp.fontHeightOverrideAfterValue || !(this.fontHeightOverrideAfterValue != 2 ? true : this.fontHeightOverrideAfterLength.equals(wp.fontHeightOverrideAfterLength))) || this.fontHeightOverrideBeforeValue != 0 && (this.fontHeightOverrideBeforeValue != wp.fontHeightOverrideBeforeValue || !(this.fontHeightOverrideBeforeValue != 2 ? true : this.fontHeightOverrideBeforeLength.equals(wp.fontHeightOverrideBeforeLength))) || !this.inheritGlyphOrientationHorizontal && this.glyphOrientationHorizontal != wp.glyphOrientationHorizontal || !this.inheritGlyphOrientationVertical && !this.isAutoGlyphOrientationVertical && this.glyphOrientationVertical != wp.glyphOrientationVertical || !this.inheritUnicodeBidi && !this.unicodeBidi.equals(wp.unicodeBidi) || !this.inheritDirection && !this.direction.equalsIgnoreCase(wp.direction));
    }

    public boolean compare(Object object) {
        if (!(object instanceof WritingModeRelatedProperty)) {
            return false;
        }
        return this.cmpWritingModeRelatedProperty((WritingModeRelatedProperty)object);
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj instanceof WritingModeRelatedProperty) {
            isEquals = this.cmpWritingModeRelatedProperty((WritingModeRelatedProperty)obj);
        }
        return isEquals;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getDirectionAttributes() {
        return this.inheritDirection ? "inherit" : this.direction;
    }

    public String getFontHeightOverrideAfter() {
        String s = this.fontHeightOverrideAfterValue == 2 ? this.fontHeightOverrideAfterLength.getLength() : fontHeightOverrideMap.getName(this.fontHeightOverrideAfterValue);
        return s;
    }

    public String getFontHeightOverrideAfterAttributes() {
        return this.getFontHeightOverrideAfter();
    }

    public String getFontHeightOverrideBefore() {
        String s = this.fontHeightOverrideBeforeValue == 2 ? this.fontHeightOverrideBeforeLength.getLength() : fontHeightOverrideMap.getName(this.fontHeightOverrideBeforeValue);
        return s;
    }

    public String getFontHeightOverrideBeforeAttributes() {
        return this.getFontHeightOverrideBefore();
    }

    public short getGlyphOrientationHorizontal() {
        return this.glyphOrientationHorizontal;
    }

    public String getGlyphOrientationHorizontalAttribute() {
        String value = this.inheritGlyphOrientationHorizontal ? "inherit" : Orientation.getName(this.glyphOrientationHorizontal);
        return value;
    }

    public short getGlyphOrientationVertical(char ch) {
        short orientation = this.isAutoGlyphOrientationVertical ? (short)0 : this.glyphOrientationVertical;
        return orientation;
    }

    public String getGlyphOrientationVerticalAttribute() {
        String value = this.inheritGlyphOrientationVertical ? "inherit" : Orientation.getName(this.glyphOrientationVertical);
        return value;
    }

    public String getUnicodeBidi() {
        return this.unicodeBidi;
    }

    public String getUnicodeBidiAttribute() {
        return this.inheritUnicodeBidi ? "inherit" : this.unicodeBidi;
    }

    public WritingMode getWritingMode() {
        return this.writingMode;
    }

    public String getWritingModeAttribute() {
        return this.writingMode.getWritingMode();
    }

    public boolean inherit(WritingModeRelatedProperty wp) {
        boolean altered = false;
        if (this.inheritWritingMode && !wp.writingMode.equals(this.writingMode)) {
            this.writingMode.copy(wp.writingMode);
            altered = true;
        }
        if (this.inheritGlyphOrientationHorizontal && this.glyphOrientationHorizontal != wp.glyphOrientationHorizontal) {
            this.glyphOrientationHorizontal = wp.glyphOrientationHorizontal;
            altered = true;
        }
        if (this.inheritGlyphOrientationVertical && this.glyphOrientationVertical != wp.glyphOrientationVertical) {
            this.glyphOrientationVertical = wp.glyphOrientationVertical;
            altered = true;
        }
        if (this.inheritUnicodeBidi && this.unicodeBidi != wp.unicodeBidi) {
            this.unicodeBidi = wp.unicodeBidi;
            altered = true;
        }
        if (this.inheritDirection && this.direction != wp.direction) {
            this.direction = wp.direction;
            altered = true;
        }
        if (this.fontHeightOverrideAfterValue == 0) {
            this.fontHeightOverrideAfterValue = wp.fontHeightOverrideAfterValue;
            this.fontHeightOverrideAfterLength.copy(wp.fontHeightOverrideAfterLength);
            altered = true;
        }
        if (this.fontHeightOverrideBeforeValue == 0) {
            this.fontHeightOverrideBeforeValue = wp.fontHeightOverrideBeforeValue;
            this.fontHeightOverrideBeforeLength.copy(wp.fontHeightOverrideBeforeLength);
            altered = true;
        }
        return altered;
    }

    public void setDefaults() {
        this.inheritDirection = true;
        this.direction = "lr-tb";
        this.setFontHeightOverrideAfterDefault();
        this.setFontHeightOverrideBeforeDefault();
        this.setGlyphOrientationHorizontalDefault();
        this.setGlyphOrientationVerticalDefault();
        this.inheritUnicodeBidi = false;
        this.unicodeBidi = "normal";
        this.setWritingModeDefault();
    }

    public void setDirection(String direction) {
        String value = direction.trim().toLowerCase();
        if (value.equals("inherit")) {
            this.inheritDirection = true;
        } else {
            this.inheritDirection = false;
            this.direction = direction;
        }
    }

    public void setFontHeightOverrideAfter(String fontHeightOverrideAfter) {
        String value = fontHeightOverrideAfter.trim().toLowerCase();
        try {
            this.fontHeightOverrideAfterValue = fontHeightOverrideMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 2)) {
                this.fontHeightOverrideAfterValue = (short)2;
                this.fontHeightOverrideAfterLength.setLength(value);
            }
            new ParseBase().dontUnderstand("font-height-override-after", value);
        }
    }

    public void setFontHeightOverrideAfterDefault() {
        this.fontHeightOverrideAfterValue = 1;
    }

    public void setFontHeightOverrideBefore(String fontHeightOverrideBefore) {
        String value = fontHeightOverrideBefore.trim().toLowerCase();
        try {
            this.fontHeightOverrideBeforeValue = fontHeightOverrideMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 2)) {
                this.fontHeightOverrideBeforeValue = (short)2;
                this.fontHeightOverrideBeforeLength.setLength(value);
            }
            new ParseBase().dontUnderstand("font-height-override-before", value);
        }
    }

    public void setFontHeightOverrideBeforeDefault() {
        this.fontHeightOverrideBeforeValue = 1;
    }

    public void setGlyphOrientationHorizontal(String glyphOrientationHorizontal) {
        String value = glyphOrientationHorizontal.trim().toLowerCase();
        if (value.equals("inherit")) {
            this.inheritGlyphOrientationHorizontal = true;
        } else {
            this.inheritGlyphOrientationHorizontal = false;
            this.glyphOrientationHorizontal = Orientation.decodeAttribute(value);
        }
    }

    public void setGlyphOrientationHorizontalDefault() {
        this.inheritGlyphOrientationHorizontal = true;
        this.glyphOrientationHorizontal = 0;
    }

    public void setGlyphOrientationVertical(String glyphOrientationVertical) {
        String value = glyphOrientationVertical.trim().toLowerCase();
        if (value.equals("inherit")) {
            this.inheritGlyphOrientationVertical = true;
        } else if (value.equals("auto")) {
            this.isAutoGlyphOrientationVertical = true;
        } else {
            this.inheritGlyphOrientationVertical = false;
            this.isAutoGlyphOrientationVertical = false;
            this.glyphOrientationVertical = Orientation.decodeAttribute(value);
        }
    }

    public void setGlyphOrientationVerticalDefault() {
        this.inheritGlyphOrientationVertical = true;
        this.glyphOrientationVertical = 0;
    }

    public void setUnicodeBidi(String unicodeBidi) {
        String value = unicodeBidi.trim().toLowerCase();
        if (value.equals("inherit")) {
            this.inheritUnicodeBidi = true;
        } else {
            this.inheritUnicodeBidi = false;
            this.unicodeBidi = unicodeBidi;
        }
    }

    public void setWritingMode(String writingMode) {
        if ((writingMode = writingMode.trim().toLowerCase()).equals("inherit")) {
            this.inheritWritingMode = true;
        } else {
            this.writingMode.setWritingMode(writingMode);
            this.inheritWritingMode = false;
        }
    }

    public void setWritingModeDefault() {
        this.inheritWritingMode = true;
        this.writingMode.setWritingMode("lr-tb");
    }
}

