/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties.parse;

import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.parse.ParseBase;
import com.ibm.xsl.composer.properties.parse.ParseException;
import com.ibm.xsl.composer.properties.parse.SPUtility;
import com.ibm.xsl.composer.properties.parse.TokenManager;
import java.io.IOException;

public class SPParseBackground
extends ParseBase {
    protected boolean backgroundInherit = false;
    protected boolean backgroundPositionInherit = false;
    protected boolean backgroundImageFound = false;
    protected boolean backgroundRepeatFound = false;
    protected boolean backgroundColorFound = false;
    protected boolean backgroundAttachmentFound = false;
    protected boolean backgroundFound = false;
    protected boolean backgroundPositionFound = false;
    protected boolean borderFound = false;
    protected boolean borderTopFound = false;
    protected boolean borderBottomFound = false;
    protected boolean borderRightFound = false;
    protected boolean borderLeftFound = false;
    protected boolean borderStyleFound = false;
    protected boolean borderWidthFound = false;
    protected boolean borderColorFound = false;
    protected boolean borderSpacingFound = false;
    protected boolean paddingFound = false;
    protected boolean sizeFound = false;
    protected static final String INHERIT = "inherit";
    protected static final String TRANSPARENT = "transparent";
    protected static final String NONE = "none";
    private BorderPaddingBackgroundProperty bpb;
    protected static final int NO_PERCENT_LENGTH = 0;
    protected static final int PERCENT_PERCENT = 1;
    protected static final int LENGTH_LENGTH = 2;
    protected static final int LENGTH_PERCENT = 3;
    protected static final int PERCENT_LENGTH = 4;

    public SPParseBackground() {
        this(null);
    }

    public SPParseBackground(BorderPaddingBackgroundProperty bpb) {
        this.bpb = bpb;
    }

    protected boolean backgroundAttachment(String s) throws ParseException {
        if (SPUtility.isAttachmentToken(s = s.toLowerCase())) {
            if (this.backgroundAttachmentFound) {
                this.parseError("More than one background-attachment element was found:" + s);
            }
            this.backgroundAttachmentFound = true;
            this.bpb.setBackgroundAttachment(s);
            return true;
        }
        return false;
    }

    protected boolean backgroundColor(String s) throws ParseException {
        if ((s = s.toLowerCase()).equals(TRANSPARENT)) {
            if (this.backgroundColorFound) {
                this.parseError("More than one background-color element was found:" + s);
            }
            this.backgroundColorFound = true;
            this.bpb.setBackgroundColor(TRANSPARENT);
            return true;
        }
        if (SPUtility.isColor(s)) {
            if (this.backgroundColorFound) {
                this.parseError("More than one background-color element was found:" + s);
            }
            this.backgroundColorFound = true;
            this.bpb.setBackgroundColor(s);
            return true;
        }
        return false;
    }

    protected boolean backgroundImage(String s) throws ParseException, IOException {
        if (s.toLowerCase().equals(NONE)) {
            if (this.backgroundImageFound) {
                this.parseError("More than one background-image element was found:" + s);
            }
            this.backgroundImageFound = true;
            this.bpb.setBackgroundImage(NONE);
            return true;
        }
        if (SPUtility.isUri(s)) {
            if (this.backgroundImageFound) {
                this.parseError("More than one background-image element was found:" + s);
            }
            this.backgroundImageFound = true;
            this.bpb.setBackgroundImage(s);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean backgroundPosition(String s) {
        block25: {
            block24: {
                isPercent = false;
                isLength = false;
                firstTerm = false;
                tm = new TokenManager(this.stack);
                t1 = "";
                if (CSSLength.isValid(s, 1, false)) {
                    firstTerm = true;
                    isPercent = true;
                    t1 = s;
                } else if (CSSLength.isValid(s, 18, false)) {
                    firstTerm = true;
                    isLength = true;
                    t1 = s;
                }
                if (firstTerm && (s = tm.getNextToken()) == null) {
                    return true;
                }
                secondTerm = false;
                t2 = "";
                lengthPercent = 0;
                if (isPercent && CSSLength.isValid(s, 1, false)) {
                    secondTerm = true;
                    lengthPercent = 1;
                    tm.consumedToken("1");
                    t2 = s;
                } else if (isLength && CSSLength.isValid(s, 18, false)) {
                    secondTerm = true;
                    lengthPercent = 3;
                    tm.consumedToken("2");
                    t2 = s;
                } else if (isPercent && CSSLength.isValid(s, 1)) {
                    secondTerm = true;
                    lengthPercent = 4;
                    tm.consumedToken("3");
                    t2 = s;
                } else if (isLength && CSSLength.isPercent(s)) {
                    secondTerm = true;
                    lengthPercent = 3;
                    tm.consumedToken("4");
                    t2 = s;
                }
                if (!secondTerm) break block24;
                this.backgroundPositionFound = true;
                switch (lengthPercent) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.bpb.setBackgroundPostionHorizontal(t1);
                        this.bpb.setBackgroundPostionVertical(t2);
                        ** GOTO lbl56
                    }
                    default: {
                        if (!secondTerm) break block25;
                    }
                }
            }
            if (firstTerm) {
                this.bpb.setBackgroundPostionHorizontal(t1);
                this.bpb.setBackgroundPostionVertical("50%");
            }
lbl56:
            // 4 sources

            if (!secondTerm) break block25;
            if ((s = tm.getNextToken()) == null) {
                return true;
            }
        }
        thirdTerm = false;
        value = "";
        t3 = "";
        if (SPUtility.isTCBLRFirstToken(s)) {
            thirdTerm = true;
            if (firstTerm || secondTerm) {
                tm.consumedToken("5");
            }
            value = s;
            t3 = s;
        }
        if (thirdTerm && (s = tm.getNextToken()) == null) {
            return true;
        }
        fourthTerm = false;
        t4 = "";
        if (thirdTerm && SPUtility.isTCBLRSecondToken(s)) {
            fourthTerm = true;
            tm.consumedToken("6");
            value = String.valueOf(value) + " " + s;
            t4 = s;
        }
        if (thirdTerm || fourthTerm) {
            v0 = firstTerm == false && this.backgroundPositionFound != false;
            this.backgroundPositionFound = true;
            d = this.decode(value);
            this.bpb.setBackgroundPostionHorizontal(d.x);
            this.bpb.setBackgroundPostionVertical(d.y);
        }
        tm.returnLastTokenIfAny();
        return firstTerm != false || thirdTerm != false;
    }

    protected boolean backgroundRepeat(String s) throws ParseException {
        if (SPUtility.isRepeatToken(s.toLowerCase())) {
            if (this.backgroundRepeatFound) {
                this.parseError("More than one background-repeat element was found:" + s);
            }
            this.backgroundRepeatFound = true;
            this.bpb.setBackgroundRepeat(s);
            return true;
        }
        return false;
    }

    public void copy(String parseString) {
        this.setParseString(parseString);
    }

    private XY decode(String value) {
        XY o = new XY();
        if (value.equals("top left") || value.equals("left top")) {
            o.x = "0%";
            o.y = "0%";
        } else if (value.equals("top") || value.equals("top center") || value.equals("center top")) {
            o.x = "50%";
            o.y = "0%";
        } else if (value.equals("right top") || value.equals("top right")) {
            o.x = "100%";
            o.y = "0%";
        } else if (value.equals("left") || value.equals("left center") || value.equals("center left")) {
            o.x = "0%";
            o.y = "50%";
        } else if (value.equals("center") || value.equals("center center")) {
            o.x = "50%";
            o.y = "50%";
        } else if (value.equals("right") || value.equals("right center") || value.equals("center right")) {
            o.x = "100%";
            o.y = "50%";
        } else if (value.equals("left bottom") || value.equals("bottom left")) {
            o.x = "0%";
            o.y = "100%";
        } else if (value.equals("bottom") || value.equals("bottom center") || value.equals("center bottom")) {
            o.x = "50%";
            o.y = "100%";
        } else if (value.equals("top left") || value.equals("left top")) {
            o.x = "100%";
            o.y = "100%";
        } else {
            o.x = "0%";
            o.y = "0%";
        }
        return o;
    }

    public boolean equals(Object object) {
        if (object instanceof SPParseBackground) {
            SPParseBackground o = (SPParseBackground)object;
            if (o.parseString.equals(this.parseString)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.parseString.hashCode();
    }

    public boolean isParseBackgroundInherited() {
        return this.backgroundInherit;
    }

    public boolean isParseBackgroundPositionInherited() {
        return this.backgroundPositionInherit;
    }

    public String parseColorFunction(String s) {
        int index = s.toLowerCase().indexOf("rgb");
        if (index == -1) {
            return s;
        }
        String remainder = s.substring(index + 3);
        String firstPart = s.substring(0, index);
        int index1 = remainder.indexOf("(");
        if (index1 == -1) {
            return s;
        }
        int index2 = (remainder = remainder.substring(index1 + 1)).indexOf(")");
        if (index2 == -1) {
            return s;
        }
        String lastPart = remainder.substring(index2 + 1);
        String color = remainder.substring(0, index2);
        CSSColor c = new CSSColor();
        try {
            c.setColor("rgb(" + color + ")");
        }
        catch (ParseException parseException) {
            return s;
        }
        return String.valueOf(firstPart) + " " + c.toHexColor() + " " + lastPart;
    }

    protected boolean setAllBorderColors(String s) throws ParseException {
        return this.setBorderColors(s, s, s, s);
    }

    protected boolean setAllBorderPaddings(String s) {
        return this.setBorderPaddings(s, s, s, s);
    }

    protected boolean setAllBorderStyles(String s) {
        return this.setBorderStyles(s, s, s, s);
    }

    protected boolean setAllBorderWidths(String s) {
        return this.setBorderWidths(s, s, s, s);
    }

    protected boolean setBorderColors(String top, String bottom, String right, String left) throws ParseException {
        this.bpb.setBorderTopColor(top);
        this.bpb.setBorderBottomColor(bottom);
        this.bpb.setBorderRightColor(right);
        this.bpb.setBorderLeftColor(left);
        return true;
    }

    protected boolean setBorderPaddings(String top, String bottom, String right, String left) {
        this.bpb.setPaddingTop(top);
        this.bpb.setPaddingBottom(bottom);
        this.bpb.setPaddingRight(right);
        this.bpb.setPaddingLeft(left);
        return true;
    }

    protected boolean setBorderStyles(String top, String bottom, String right, String left) {
        this.bpb.setBorderTopStyle(top);
        this.bpb.setBorderBottomStyle(bottom);
        this.bpb.setBorderRightStyle(right);
        this.bpb.setBorderLeftStyle(left);
        return true;
    }

    protected boolean setBorderWidths(String top, String bottom, String right, String left) {
        this.bpb.setBorderTopWidth(top);
        this.bpb.setBorderBottomWidth(bottom);
        this.bpb.setBorderRightWidth(right);
        this.bpb.setBorderLeftWidth(left);
        return true;
    }

    public boolean spBackground(String parseString) throws ParseException, IOException {
        if (parseString.toLowerCase().lastIndexOf(INHERIT) >= 0) {
            if (parseString.equals(INHERIT)) {
                this.backgroundInherit = true;
                this.backgroundFound = true;
                return true;
            }
            this.backgroundInherit = false;
            this.parseError("illegal attributes:" + parseString);
            return false;
        }
        this.backgroundInherit = false;
        parseString = this.parseColorFunction(parseString);
        this.setParseString(parseString);
        this.scanAndTokenize();
        boolean consumed = true;
        while (!this.stack.empty()) {
            consumed = false;
            String attribute = this.nextToken();
            if (this.backgroundRepeat(attribute.toLowerCase())) {
                consumed = true;
                continue;
            }
            if (this.backgroundAttachment(attribute.toLowerCase())) {
                consumed = true;
                continue;
            }
            if (this.backgroundColor(attribute.toLowerCase())) {
                consumed = true;
                continue;
            }
            if (this.backgroundImage(attribute.toLowerCase())) {
                consumed = true;
                continue;
            }
            if (this.backgroundPosition(attribute.toLowerCase())) {
                consumed = true;
                continue;
            }
            if (consumed) continue;
            this.parseWarning("Token <" + attribute + "> was not understood.");
        }
        return true;
    }

    public boolean spBackgroundPosition(String parseString) throws ParseException {
        if (parseString.toLowerCase().lastIndexOf(INHERIT) >= 0) {
            if (parseString.equals(INHERIT)) {
                if (this.backgroundPositionFound) {
                    this.parseError("More than one background-position element was found:" + parseString);
                }
                this.backgroundPositionInherit = true;
                this.backgroundPositionFound = true;
                return true;
            }
            this.backgroundPositionInherit = false;
            this.parseError("illegal attributes:" + parseString);
            return false;
        }
        this.backgroundPositionInherit = false;
        this.setParseString(parseString);
        this.scanAndTokenize();
        boolean consumed = true;
        while (!this.stack.empty()) {
            consumed = false;
            String attribute = this.nextToken();
            if (this.backgroundPosition(attribute.toLowerCase())) {
                consumed = true;
                this.backgroundPositionFound = true;
                continue;
            }
            if (consumed) continue;
            this.parseWarning("Token <" + attribute + "> was not understood.");
        }
        return true;
    }

    public boolean spBorder(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT)) {
            if (this.borderFound) {
                this.parseError("More than one border element was found:" + s);
            }
            this.borderFound = true;
            this.setAllBorderColors(INHERIT);
            this.setAllBorderWidths(INHERIT);
            this.setAllBorderStyles(INHERIT);
            return true;
        }
        this.setParseString(s);
        this.scanAndTokenize();
        boolean widthFound = false;
        boolean styleFound = false;
        boolean colorFound = false;
        while ((s = this.nextToken()) != null) {
            if (SPUtility.isBorderWidth(s)) {
                widthFound = true;
                this.setAllBorderWidths(s);
                continue;
            }
            if (SPUtility.isBorderStyle(s)) {
                styleFound = true;
                this.setAllBorderStyles(s);
                continue;
            }
            if (SPUtility.isColor(s)) {
                colorFound = true;
                this.setAllBorderColors(s);
                continue;
            }
            String property = "border";
            this.dontUnderstand("border", s);
        }
        if (widthFound || styleFound || colorFound) {
            this.borderFound = true;
            return true;
        }
        return false;
    }

    public boolean spBorderBottom(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT)) {
            if (this.borderBottomFound) {
                this.parseError("More than one border-bottom element was found:" + s);
            }
            this.borderFound = true;
            this.bpb.setBorderBottomColor(INHERIT);
            this.bpb.setBorderBottomWidth(INHERIT);
            this.bpb.setBorderBottomStyle(INHERIT);
            return true;
        }
        this.setParseString(s);
        this.scanAndTokenize();
        boolean widthFound = false;
        boolean styleFound = false;
        boolean colorFound = false;
        while ((s = this.nextToken()) != null) {
            if (SPUtility.isBorderWidth(s)) {
                widthFound = true;
                this.bpb.setBorderBottomWidth(s);
                continue;
            }
            if (SPUtility.isBorderStyle(s)) {
                styleFound = true;
                this.bpb.setBorderBottomStyle(s);
                continue;
            }
            if (SPUtility.isColor(s)) {
                colorFound = true;
                this.bpb.setBorderBottomColor(s);
                continue;
            }
            String property = "border-bottom";
            this.dontUnderstand("border-bottom", s);
        }
        if (widthFound || styleFound || colorFound) {
            this.borderBottomFound = true;
            return true;
        }
        return false;
    }

    public boolean spBorderColor(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT) || s.equals(TRANSPARENT)) {
            this.borderColorFound = true;
            return this.setAllBorderColors(s);
        }
        boolean hasOneColor = false;
        boolean hasTwoColors = false;
        boolean hasThreeColors = false;
        boolean hasFourColors = false;
        String firstToken = "";
        String nextToken = "";
        String nextNextToken = "";
        String nextNextNextToken = "";
        this.setParseString(s);
        this.scanAndTokenize();
        String token = "";
        token = this.nextToken();
        if (token == null || !SPUtility.isColor(token)) {
            return false;
        }
        hasOneColor = true;
        firstToken = token;
        if (hasOneColor && (token = this.nextToken()) != null && SPUtility.isColor(token)) {
            hasTwoColors = true;
            nextToken = token;
        }
        if (hasTwoColors && (token = this.nextToken()) != null && SPUtility.isColor(token)) {
            hasThreeColors = true;
            nextNextToken = token;
        }
        if (hasThreeColors && (token = this.nextToken()) != null && SPUtility.isColor(token)) {
            hasFourColors = true;
            nextNextNextToken = token;
        }
        if (hasFourColors) {
            this.borderColorFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextNextNextToken;
            return this.setBorderColors(top, bottom, right, left);
        }
        if (hasThreeColors) {
            this.borderColorFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderColors(top, bottom, right, left);
        }
        if (hasTwoColors) {
            this.borderColorFound = true;
            String top = firstToken;
            String bottom = firstToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderColors(top, bottom, right, left);
        }
        if (hasOneColor) {
            this.borderColorFound = true;
            return this.setBorderColors(firstToken, firstToken, firstToken, firstToken);
        }
        return false;
    }

    public boolean spBorderLeft(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT)) {
            if (this.borderLeftFound) {
                this.parseError("More than one border-left element was found:" + s);
            }
            this.borderFound = true;
            this.bpb.setBorderLeftColor(INHERIT);
            this.bpb.setBorderLeftWidth(INHERIT);
            this.bpb.setBorderLeftStyle(INHERIT);
            return true;
        }
        this.setParseString(s);
        this.scanAndTokenize();
        boolean widthFound = false;
        boolean styleFound = false;
        boolean colorFound = false;
        while ((s = this.nextToken()) != null) {
            if (SPUtility.isBorderWidth(s)) {
                widthFound = true;
                this.bpb.setBorderLeftWidth(s);
                continue;
            }
            if (SPUtility.isBorderStyle(s)) {
                styleFound = true;
                this.bpb.setBorderLeftStyle(s);
                continue;
            }
            if (SPUtility.isColor(s)) {
                colorFound = true;
                this.bpb.setBorderLeftColor(s);
                continue;
            }
            String property = "border-left";
            this.dontUnderstand("border-left", s);
        }
        if (widthFound || styleFound || colorFound) {
            this.borderLeftFound = true;
            return true;
        }
        return false;
    }

    public boolean spBorderRight(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT)) {
            if (this.borderRightFound) {
                this.parseError("More than one border-right element was found:" + s);
            }
            this.borderFound = true;
            this.bpb.setBorderRightColor(INHERIT);
            this.bpb.setBorderRightWidth(INHERIT);
            this.bpb.setBorderRightStyle(INHERIT);
            return true;
        }
        this.setParseString(s);
        this.scanAndTokenize();
        boolean widthFound = false;
        boolean styleFound = false;
        boolean colorFound = false;
        while ((s = this.nextToken()) != null) {
            if (SPUtility.isBorderWidth(s)) {
                widthFound = true;
                this.bpb.setBorderRightWidth(s);
                continue;
            }
            if (SPUtility.isBorderStyle(s)) {
                styleFound = true;
                this.bpb.setBorderRightStyle(s);
                continue;
            }
            if (SPUtility.isColor(s)) {
                colorFound = true;
                this.bpb.setBorderRightColor(s);
                continue;
            }
            String property = "border-right";
            this.dontUnderstand("border-right", s);
        }
        if (widthFound || styleFound || colorFound) {
            this.borderRightFound = true;
            return true;
        }
        return false;
    }

    public boolean spBorderSpacing(String s) throws ParseException {
        return false;
    }

    public boolean spBorderStyle(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT) || s.equals(TRANSPARENT)) {
            this.borderStyleFound = true;
            return this.setAllBorderStyles(s);
        }
        boolean hasOneStyle = false;
        boolean hasTwoStyles = false;
        boolean hasThreeStyles = false;
        boolean hasFourStyles = false;
        String firstToken = "";
        String nextToken = "";
        String nextNextToken = "";
        String nextNextNextToken = "";
        this.setParseString(s);
        this.scanAndTokenize();
        String token = "";
        token = this.nextToken();
        if (token == null || !SPUtility.isBorderStyle(token)) {
            return false;
        }
        hasOneStyle = true;
        firstToken = token;
        if (hasOneStyle && (token = this.nextToken()) != null && SPUtility.isBorderStyle(token)) {
            hasTwoStyles = true;
            nextToken = token;
        }
        if (hasTwoStyles && (token = this.nextToken()) != null && SPUtility.isBorderStyle(token)) {
            hasThreeStyles = true;
            nextNextToken = token;
        }
        if (hasThreeStyles && (token = this.nextToken()) != null && SPUtility.isBorderStyle(token)) {
            hasFourStyles = true;
            nextNextNextToken = token;
        }
        if (hasFourStyles) {
            this.borderStyleFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextNextNextToken;
            return this.setBorderStyles(top, bottom, right, left);
        }
        if (hasThreeStyles) {
            this.borderStyleFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderStyles(top, bottom, right, left);
        }
        if (hasTwoStyles) {
            this.borderColorFound = true;
            String top = firstToken;
            String bottom = firstToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderStyles(top, bottom, right, left);
        }
        if (hasOneStyle) {
            this.borderColorFound = true;
            return this.setBorderStyles(firstToken, firstToken, firstToken, firstToken);
        }
        return false;
    }

    public boolean spBorderTop(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT)) {
            if (this.borderTopFound) {
                this.parseError("More than one border-top element was found:" + s);
            }
            this.borderFound = true;
            this.bpb.setBorderTopColor(INHERIT);
            this.bpb.setBorderTopWidth(INHERIT);
            this.bpb.setBorderTopStyle(INHERIT);
            return true;
        }
        this.setParseString(s);
        this.scanAndTokenize();
        boolean widthFound = false;
        boolean styleFound = false;
        boolean colorFound = false;
        while ((s = this.nextToken()) != null) {
            if (SPUtility.isBorderWidth(s)) {
                widthFound = true;
                this.bpb.setBorderTopWidth(s);
                continue;
            }
            if (SPUtility.isBorderStyle(s)) {
                styleFound = true;
                this.bpb.setBorderTopStyle(s);
                continue;
            }
            if (SPUtility.isColor(s)) {
                colorFound = true;
                this.bpb.setBorderTopColor(s);
                continue;
            }
            String property = "border-top";
            this.dontUnderstand("border-top", s);
        }
        if (widthFound || styleFound || colorFound) {
            this.borderTopFound = true;
            return true;
        }
        return false;
    }

    public boolean spBorderWidth(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT)) {
            this.borderWidthFound = true;
            return this.setAllBorderWidths(s);
        }
        boolean hasOneWidth = false;
        boolean hasTwoWidths = false;
        boolean hasThreeWidths = false;
        boolean hasFourWidths = false;
        String firstToken = "";
        String nextToken = "";
        String nextNextToken = "";
        String nextNextNextToken = "";
        this.setParseString(s);
        this.scanAndTokenize();
        String token = "";
        token = this.nextToken();
        if (token == null || !SPUtility.isBorderWidth(token)) {
            return false;
        }
        hasOneWidth = true;
        firstToken = token;
        if (hasOneWidth && (token = this.nextToken()) != null && SPUtility.isBorderWidth(token)) {
            hasTwoWidths = true;
            nextToken = token;
        }
        if (hasTwoWidths && (token = this.nextToken()) != null && SPUtility.isBorderWidth(token)) {
            hasThreeWidths = true;
            nextNextToken = token;
        }
        if (hasThreeWidths && (token = this.nextToken()) != null && SPUtility.isBorderWidth(token)) {
            hasFourWidths = true;
            nextNextNextToken = token;
        }
        if (hasFourWidths) {
            this.borderWidthFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextNextNextToken;
            return this.setBorderWidths(top, bottom, right, left);
        }
        if (hasThreeWidths) {
            this.borderWidthFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderWidths(top, bottom, right, left);
        }
        if (hasTwoWidths) {
            this.borderWidthFound = true;
            String top = firstToken;
            String bottom = firstToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderWidths(top, bottom, right, left);
        }
        if (hasOneWidth) {
            this.borderWidthFound = true;
            return this.setBorderWidths(firstToken, firstToken, firstToken, firstToken);
        }
        return false;
    }

    public boolean spPadding(String s) throws ParseException {
        if (s.toLowerCase().equals(INHERIT) || s.equals(TRANSPARENT)) {
            this.paddingFound = true;
            return this.setAllBorderPaddings(s);
        }
        boolean hasOnePadding = false;
        boolean hasTwoPaddings = false;
        boolean hasThreePaddings = false;
        boolean hasFourPaddings = false;
        String firstToken = "";
        String nextToken = "";
        String nextNextToken = "";
        String nextNextNextToken = "";
        this.setParseString(s);
        this.scanAndTokenize();
        String token = "";
        token = this.nextToken();
        if (token == null || !SPUtility.isPaddingWidth(token)) {
            return false;
        }
        hasOnePadding = true;
        firstToken = token;
        if (hasOnePadding && (token = this.nextToken()) != null && SPUtility.isPaddingWidth(token)) {
            hasTwoPaddings = true;
            nextToken = token;
        }
        if (hasTwoPaddings && (token = this.nextToken()) != null && SPUtility.isPaddingWidth(token)) {
            hasThreePaddings = true;
            nextNextToken = token;
        }
        if (hasThreePaddings && (token = this.nextToken()) != null && SPUtility.isPaddingWidth(token)) {
            hasFourPaddings = true;
            nextNextNextToken = token;
        }
        if (hasFourPaddings) {
            this.paddingFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextNextNextToken;
            return this.setBorderPaddings(top, bottom, right, left);
        }
        if (hasThreePaddings) {
            this.paddingFound = true;
            String top = firstToken;
            String bottom = nextNextToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderPaddings(top, bottom, right, left);
        }
        if (hasTwoPaddings) {
            this.paddingFound = true;
            String top = firstToken;
            String bottom = firstToken;
            String right = nextToken;
            String left = nextToken;
            return this.setBorderPaddings(top, bottom, right, left);
        }
        if (hasOnePadding) {
            this.paddingFound = true;
            return this.setBorderPaddings(firstToken, firstToken, firstToken, firstToken);
        }
        return false;
    }

    public boolean spSize(String s) throws ParseException {
        return false;
    }

    private class XY {
        public String x;
        public String y;

        XY() {
        }

        public String toString() {
            return "XY [x:" + this.x + " y:" + this.y + "]";
        }
    }
}

