/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties.parser;

import com.ibm.xsl.composer.properties.parser.EvaluationContext;
import com.ibm.xsl.composer.properties.parser.EvaluationResult;
import java.util.Vector;

public class EvaluationFunction
extends EvaluationResult {
    String functionName;
    Vector arguments = new Vector();

    public EvaluationFunction() {
        super(null, 0);
    }

    public void addArgument(EvaluationResult argument) {
        this.arguments.add(argument);
    }

    public EvaluationResult evaluateFunction(EvaluationContext context) {
        EvaluationResult er2;
        EvaluationResult result = null;
        if (this.functionName.equalsIgnoreCase("debugprint")) {
            System.out.println("Debug Print Invoked with argument count = " + this.arguments.size());
            int i = 0;
            while (i < this.arguments.size()) {
                EvaluationResult er = (EvaluationResult)this.arguments.elementAt(i);
                System.out.println("Arg " + i + " = " + er.toString());
                ++i;
            }
            result = this.arguments.size() > 0 ? (EvaluationResult)this.arguments.elementAt(0) : new EvaluationResult(0.0);
        } else if (this.functionName.equalsIgnoreCase("floor")) {
            this.simpleValidateArguments(1, 1);
            EvaluationResult er = (EvaluationResult)this.arguments.elementAt(0);
            result = new EvaluationResult(Math.floor(er.getAsDouble()));
        } else if (this.functionName.equalsIgnoreCase("ceiling")) {
            this.simpleValidateArguments(1, 1);
            EvaluationResult er = (EvaluationResult)this.arguments.elementAt(0);
            result = new EvaluationResult(Math.ceil(er.getAsDouble()));
        } else if (this.functionName.equalsIgnoreCase("round")) {
            this.simpleValidateArguments(1, 1);
            EvaluationResult er = (EvaluationResult)this.arguments.elementAt(0);
            result = new EvaluationResult(Math.round(er.getAsDouble()));
        } else if (this.functionName.equalsIgnoreCase("min")) {
            this.simpleValidateArguments(2, 1);
            EvaluationResult er1 = (EvaluationResult)this.arguments.elementAt(0);
            er2 = (EvaluationResult)this.arguments.elementAt(1);
            result = new EvaluationResult(Math.min(er1.getAsDouble(), er2.getAsDouble()));
        } else if (this.functionName.equalsIgnoreCase("max")) {
            this.simpleValidateArguments(2, 1);
            EvaluationResult er1 = (EvaluationResult)this.arguments.elementAt(0);
            er2 = (EvaluationResult)this.arguments.elementAt(1);
            result = new EvaluationResult(Math.max(er1.getAsDouble(), er2.getAsDouble()));
        } else if (this.functionName.equalsIgnoreCase("abs")) {
            this.simpleValidateArguments(1, 1);
            EvaluationResult er = (EvaluationResult)this.arguments.elementAt(0);
            result = new EvaluationResult(Math.abs(er.getAsDouble()));
        } else if (this.functionName.equalsIgnoreCase("rgb")) {
            this.simpleValidateArguments(3, 1);
            EvaluationResult er1 = (EvaluationResult)this.arguments.elementAt(0);
            er2 = (EvaluationResult)this.arguments.elementAt(1);
            EvaluationResult er3 = (EvaluationResult)this.arguments.elementAt(2);
            result = new EvaluationResult(er1.getAsRoundedInteger() * 256.0 * 256.0 + er2.getAsRoundedInteger() * 256.0 + er3.getAsRoundedInteger());
        } else if (!(this.functionName.equalsIgnoreCase("icc-color") || this.functionName.equalsIgnoreCase("system-color") || this.functionName.equalsIgnoreCase("system-font") || this.functionName.equalsIgnoreCase("inherited-property-value") || this.functionName.equalsIgnoreCase("label-end") || this.functionName.equalsIgnoreCase("body-start") || this.functionName.equalsIgnoreCase("from-parent") || this.functionName.equalsIgnoreCase("from-nearest-specified-value") || this.functionName.equalsIgnoreCase("from-table-column") || this.functionName.equalsIgnoreCase("proportional-column-width") || this.functionName.equalsIgnoreCase("merge-property-values"))) {
            throw new ArithmeticException("Function " + this.functionName + "() is not defined.");
        }
        if (result == null) {
            double sum = 0.0;
            int i = 0;
            while (i < this.arguments.size()) {
                EvaluationResult er = (EvaluationResult)this.arguments.elementAt(i);
                sum += er.getAsDouble();
                ++i;
            }
            result = new EvaluationResult(sum);
        }
        return result;
    }

    public void setFunctionName(String newFunctionName) {
        this.functionName = newFunctionName;
    }

    void simpleValidateArguments(int count, int type) {
        if (this.arguments.size() != count) {
            String message = count == 1 ? "Function " + this.functionName + "() expects 1 argument." : "Function " + this.functionName + "() expects " + count + " arguments.";
            throw new ArithmeticException(message);
        }
        if (type != 0) {
            int i = 0;
            while (i < this.arguments.size()) {
                EvaluationResult er = (EvaluationResult)this.arguments.elementAt(0);
                if (er.getValueType() != type) {
                    throw new ArithmeticException("Argument " + (i + 1) + " of type " + er.nameForType() + " is of wrong type in function " + this.functionName + "(). Expected type " + this.nameForType(type));
                }
                ++i;
            }
        }
    }
}

