/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.util;

import com.ibm.xsl.composer.util.EventNotifyTarget;
import java.util.Vector;

public class EventNotifySupport {
    Object source;
    private Vector eventListeners;

    public EventNotifySupport() {
        this(null);
    }

    public EventNotifySupport(Object source) {
        this.source = source;
        this.eventListeners = new Vector();
    }

    public synchronized void addListener(EventNotifyTarget listener) {
        if (listener != null) {
            this.eventListeners.addElement(listener);
        }
    }

    public synchronized void clearListeners() {
        this.eventListeners.removeAllElements();
    }

    public static void main(String[] args) {
        EventNotifySupport es = new EventNotifySupport(null);
        EventNotifyTarget l1 = new EventNotifyTarget(){

            public void notify(Object source, Object data) {
                System.out.println("L1 Event source=" + source + " data=" + data);
            }
        };
        es.addListener(l1);
        es.addListener(new EventNotifyTarget(){

            public void notify(Object source, Object data) {
                System.out.println("L2 Event source=" + source + " data=" + data);
            }
        });
        es.notifyListeners(new Integer(100));
        es.notifyListeners("MySource", new Integer(200));
        es.removeListener(l1);
        es.notifyListeners(new Integer(300));
        es.addListener(l1);
        es.addListener(l1);
        es.addListener(null);
        es.notifyListeners(new Integer(400));
        es.removeListener(null);
        es.notifyListeners(new Integer(500));
        es.clearListeners();
        es.notifyListeners(new Integer(600));
    }

    public void notifyListeners(Object eventData) {
        this.notifyListeners(this.source, eventData);
    }

    public void notifyListeners(Object overSource, Object eventData) {
        Vector listenerObjects;
        EventNotifySupport eventNotifySupport = this;
        synchronized (eventNotifySupport) {
            listenerObjects = (Vector)this.eventListeners.clone();
        }
        int i = 0;
        while (i < listenerObjects.size()) {
            EventNotifyTarget eventListener = (EventNotifyTarget)this.eventListeners.elementAt(i);
            eventListener.notify(overSource, eventData);
            ++i;
        }
    }

    public synchronized void removeListener(Object listener) {
        if (listener != null) {
            this.eventListeners.removeElement(listener);
        }
    }
}

