/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pclwriter;

import com.ibm.as400.util.reportwriter.pclwriter.PCLExtendedFont;
import com.ibm.as400.util.reportwriter.pclwriter.PCLFourEdgeBorder;
import com.ibm.as400.util.reportwriter.pclwriter.PCLOutsetInsetBorder;
import com.ibm.as400.util.reportwriter.pclwriter.PCLRidgeGrooveBorder;
import com.ibm.as400.util.reportwriter.pclwriter.PCLVariableWidthDoubleBorder;
import com.ibm.as400.util.reportwriter.processor.ResourceBundleLoader_rw;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.java2d.ImageHolder;
import com.ibm.xsl.composer.java2d.TBRL;
import com.ibm.xsl.composer.prim.Border;
import com.ibm.xsl.composer.properties.FontProperty;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PCLContext
implements Context {
    private static final int CAP_BUTT = 0;
    private static final int CAP_ROUND = 1;
    private static final int CAP_SQUARE = 2;
    private static final int JOIN_MITER = 0;
    private static final int JOIN_ROUND = 1;
    private static final int JOIN_BEVEL = 2;
    static String FONTMAPPING_PROPERTIES = "/com/ibm/as400/util/reportwriter/fonts/PCLFontMapping.properties";
    private Hashtable fontTable;
    private Hashtable fonts;
    private ExtendedFont curFont = null;
    private ExtendedFont lastFontSent = null;
    private int fontsize = 0;
    private int fontIndex = 0;
    private short Orientation = 0;
    private String FontCommand;
    private PCLExtendedFont pclextfont;
    private PrintStream pcl;
    private PageFormat pageFormat;
    private boolean firstPage;
    private boolean SendFont = true;
    private CSSColor curColor = null;
    private CSSColor lastTextColorSent = null;
    private CSSColor lastDrawColorSent = null;
    private String ColorCommand;
    private Properties propertyFile;
    private long hi;
    private long wide;
    private Image img = null;
    private ImageHolder imageHolder = new ImageHolder();
    String antiqueolive = "\u001b(s4168T";
    String arial = "\u001b(s16602T";
    String avantgarde = "\u001b(s24607T";
    String bookman = "\u001b(s24623";
    String cgomega = "\u001b(s4113T";
    String cgtimes = "\u001b(s4101T";
    String clarendoncondensed = "\u001b(s4140T";
    String coronet = "\u001b(s4116T";
    String courier = "\u001b(s4099T";
    String garamond = "\u001b(s4197T";
    String gothictext = "\u001b(s4102T";
    String helvetica = "\u001b(s24580T";
    String helveticanarrow = "\u001b(s24580T";
    String lettergothic = "\u001b(s4102T";
    String marigold = "\u001b(s4297T";
    String newcenturyschlbk = "\u001b(s24703T";
    String palatino = "\u001b(s24591T";
    String prestige = "\u001b(s4104";
    String symbol = "\u001b(s16686T";
    String times = "\u001b(s25093T";
    String timesnewroman = "\u001b(s16901T";
    String univers = "\u001b(s4148T";
    String universcondensed = "\u001b(s4148T";
    String wingdings = "\u001b(s31402T";
    String zapfchancery = "\u001b(s45099T";
    String zapfdingbats = "\u001b(s45101T";
    String Bold = "\u001b(s3B";
    String Normal = "\u001b(s0B";
    String Upright = "\u001b(s0S";
    String Italic = "\u001b(s1S";
    String Condensed = "\u001b(s4S";

    public PCLContext(OutputStream outputStream, PageFormat pageFormat) throws NullPointerException {
        if (outputStream == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage((String)"nulloutstream"));
        }
        if (pageFormat == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage((String)"nullpf"));
        }
        this.firstPage = true;
        this.fontTable = new Hashtable();
        this.fonts = new Hashtable();
        this.pcl = new PrintStream(outputStream);
        this.curColor = new CSSColor(1, 1, 1);
        this.lastTextColorSent = new CSSColor(1, 1, 1);
        this.lastDrawColorSent = new CSSColor(1, 1, 1);
        this.pageFormat = pageFormat;
        this.hi = (long)pageFormat.getImageableHeight();
        this.wide = (long)pageFormat.getImageableWidth();
        this.propertyFile = new Properties();
        this.loadPropertyFile(FONTMAPPING_PROPERTIES, this.propertyFile);
    }

    private final void outStr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '(' || c == ')' || c == '\\') {
                stringBuffer.append(c);
            }
            ++n;
        }
        this.pcl.print(stringBuffer.toString());
    }

    public CSSExtent getPageSize() {
        CSSExtent cSSExtent = new CSSExtent();
        cSSExtent.setExtent((long)this.pageFormat.getImageableWidth(), (long)this.pageFormat.getImageableHeight());
        return cSSExtent;
    }

    public long getUnitsPerPoint() {
        return 1L;
    }

    public long getUnitsPerPixel() {
        return 1L;
    }

    private String getEndCap(int n) {
        switch (n) {
            case 0: {
                return Integer.toString(0);
            }
            case 1: {
                return Integer.toString(1);
            }
        }
        return Integer.toString(2);
    }

    private String getLineJoin(int n) {
        switch (n) {
            case 0: {
                return Integer.toString(0);
            }
            case 1: {
                return Integer.toString(1);
            }
        }
        return Integer.toString(2);
    }

    public void startDocument() {
        this.pcl.print("\u001bE");
        this.pcl.print("\u001b%1B");
        this.pcl.print("IN");
        this.pcl.print("SP1");
        this.pcl.print("\u001b%0A");
    }

    public void endDocument() {
        this.pcl.print("\u001bE");
        this.pcl.flush();
    }

    public void startViewport(CSSPoint cSSPoint, CSSExtent cSSExtent, boolean bl) {
        if (bl) {
            if (!this.firstPage) {
                this.pcl.print("\f");
                this.pcl.flush();
            }
            this.firstPage = false;
        }
    }

    public ExtendedFont getExtendedFont(FontProperty fontProperty) {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        int n = (int)fontProperty.getFontSize().getNormalizedLength(new long[]{this.getUnitsPerPixel(), this.getUnitsPerPoint()});
        int n2 = fontProperty.getFontWeight();
        string3 = n2 < 400 ? "light" : (n2 >= 400 && n2 <= 600 ? "normal" : "bold");
        string4 = "normal";
        string5 = "normal";
        String string12 = new Integer(n).toString();
        String string13 = new Integer(n2).toString();
        Vector<String> vector = new Vector<String>();
        vector.addElement(fontProperty.getFontFamily());
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            string2 = (String)enumeration.nextElement();
            string2 = string2.toLowerCase().trim();
            string = "";
            object2 = new StringTokenizer(string2, " ");
            while (((StringTokenizer)object2).hasMoreElements()) {
                string = string + ((StringTokenizer)object2).nextToken();
            }
            if (string.equals("serif") || string.equals("sans-serif") || string.equals("cursive") || string.equals("fantasy") || string.equals("monospace")) {
                string = this.propertyFile.getProperty(string);
            } else if (string.equals("caption") || string.equals("icon") || string.equals("menu") || string.equals("message-box") || string.equals("small-caption") || string.equals("status-bar")) {
                string = this.propertyFile.getProperty(string);
            }
            String string14 = this.propertyFile.getProperty(string);
            if (string14 == null) break;
            object = new StringTokenizer(string14, ",");
            while (((StringTokenizer)object).hasMoreElements() && !bl) {
                string10 = ((StringTokenizer)object).nextToken();
                string6 = this.propertyFile.getProperty(string10 + ".style");
                if (!string6.equals(fontProperty.getFontStyle()) || !(string7 = this.propertyFile.getProperty(string10 + ".weight")).equals(string3)) continue;
                string8 = this.propertyFile.getProperty(string10 + ".variant");
                String string15 = fontProperty.getFontVariant();
                if (!string8.equals(string5) || !(string9 = this.propertyFile.getProperty(string10 + ".stretch")).equals(string4)) continue;
                bl = true;
            }
        }
        if (!bl) {
            string2 = fontProperty.getFontStyle();
            string2 = string2.equals("italic") || string2.equals("oblique") ? "italic" : "normal";
            string = new String();
            string = string3.equals("bold") ? "bold" : "normal";
            object2 = new String();
            object2 = string2.equals("normal") && string.equals("bold") ? "default.bold.normal" : (string2.equals("italic") && string.equals("normal") ? "default.normal.italic" : (string2.equals("italic") && string.equals("bold") ? "default.bold.italic" : "default.normal.normal"));
            object = this.propertyFile.getProperty((String)object2);
            string11 = this.propertyFile.getProperty((String)object + ".filename");
        } else {
            string11 = this.propertyFile.getProperty(string10 + ".filename");
        }
        String string16 = new String(string11 + "." + string12);
        PCLExtendedFont pCLExtendedFont = (PCLExtendedFont)this.fontTable.get(string16);
        if (pCLExtendedFont == null) {
            this.pclextfont = new PCLExtendedFont(string11, this.propertyFile.getProperty(string10 + ".fontname"), string6, string7, string8, string9, n, this.fonts);
            this.fontTable.put(string16, this.pclextfont);
        } else {
            this.pclextfont = pCLExtendedFont;
        }
        return this.pclextfont;
    }

    public void setFont(ExtendedFont extendedFont) {
        if (this.curFont != extendedFont) {
            this.curFont = extendedFont;
        }
    }

    private final void outFont() {
        boolean bl = false;
        String string = null;
        if (this.lastFontSent != this.curFont || this.SendFont) {
            this.SendFont = false;
            this.lastFontSent = this.curFont;
            PCLExtendedFont pCLExtendedFont = (PCLExtendedFont)this.curFont;
            this.FontCommand = "\u001b(8U";
            if (pCLExtendedFont.getFamilyName().equals("Antique Olive")) {
                string = this.antiqueolive;
            } else if (pCLExtendedFont.getFamilyName().equals("Arial")) {
                string = this.arial;
            } else if (pCLExtendedFont.getFamilyName().equals("AvantGarde")) {
                string = this.avantgarde;
            } else if (pCLExtendedFont.getFamilyName().equals("Bookman")) {
                string = this.bookman;
            } else if (pCLExtendedFont.getFamilyName().equals("CG Omega")) {
                string = this.cgomega;
            } else if (pCLExtendedFont.getFamilyName().equals("CG Times")) {
                string = this.cgtimes;
            } else if (pCLExtendedFont.getFamilyName().equals("Clarendon Condensed")) {
                string = this.clarendoncondensed;
                bl = true;
            } else if (pCLExtendedFont.getFamilyName().equals("Coronet")) {
                string = this.coronet;
            } else if (pCLExtendedFont.getFamilyName().equals("Courier")) {
                string = this.courier;
            } else if (pCLExtendedFont.getFamilyName().equals("Garamond")) {
                string = this.garamond;
            } else if (pCLExtendedFont.getFamilyName().equals("Gothic Text")) {
                string = this.gothictext;
            } else if (pCLExtendedFont.getFamilyName().equals("Helvetica")) {
                string = this.helvetica;
            } else if (pCLExtendedFont.getFamilyName().equals("Helvetica-Narrow")) {
                string = this.helveticanarrow;
                bl = true;
            } else if (pCLExtendedFont.getFamilyName().equals("Letter Gothic")) {
                string = this.lettergothic;
            } else if (pCLExtendedFont.getFamilyName().equals("Marigold")) {
                string = this.marigold;
            } else if (pCLExtendedFont.getFamilyName().equals("NewCenturySchlbk")) {
                string = this.newcenturyschlbk;
            } else if (pCLExtendedFont.getFamilyName().equals("Palatino")) {
                string = this.palatino;
            } else if (pCLExtendedFont.getFamilyName().equals("Prestige")) {
                string = this.prestige;
            } else if (pCLExtendedFont.getFamilyName().equals("Symbol")) {
                string = this.symbol;
                this.FontCommand = "\u001b(19U";
            } else if (pCLExtendedFont.getFamilyName().equals("Times")) {
                string = this.times;
            } else if (pCLExtendedFont.getFamilyName().equals("Times New Roman")) {
                string = this.timesnewroman;
            } else if (pCLExtendedFont.getFamilyName().equals("Univers")) {
                string = this.univers;
            } else if (pCLExtendedFont.getFamilyName().equals("Univers Condensed")) {
                string = this.universcondensed;
                bl = true;
            } else if (pCLExtendedFont.getFamilyName().equals("Wingdings")) {
                string = this.wingdings;
                this.FontCommand = "\u001b(579L";
            } else {
                string = pCLExtendedFont.getFamilyName().equals("ZapfChancery") ? this.zapfchancery : (pCLExtendedFont.getFamilyName().equals("ZapfDingbats") ? this.zapfdingbats : this.timesnewroman);
            }
            this.FontCommand = pCLExtendedFont.getIsFixedPitch() ? this.FontCommand + "\u001b(s0P" : this.FontCommand + "\u001b(s1P";
            this.fontsize = (int)this.curFont.getSize();
            this.FontCommand = this.FontCommand + "\u001b(s" + this.fontsize + "V";
            this.FontCommand = bl ? this.FontCommand + this.Condensed : (this.curFont.getStyle() == "Italic" ? this.FontCommand + this.Italic : this.FontCommand + this.Upright);
            this.FontCommand = this.curFont.getStyle() == "Bold" ? this.FontCommand + this.Bold : this.FontCommand + this.Normal;
            this.FontCommand = this.FontCommand + string;
            this.pcl.print(this.FontCommand);
        }
    }

    public void setTextColor(CSSColor cSSColor) {
        if (!this.curColor.equals((Object)cSSColor)) {
            this.curColor = cSSColor;
        }
    }

    private void outColor() {
        if (!this.lastTextColorSent.equals((Object)this.curColor)) {
            this.lastTextColorSent = this.curColor;
            this.ColorCommand = "\u001b*v" + this.curColor.red + "a" + this.curColor.green + "b" + this.curColor.blue + "c1I" + "\u001b*v1S";
            this.pcl.print(this.ColorCommand);
        }
    }

    public void drawGlyph(char c, CSSPoint cSSPoint) {
        if (c == 'y') {
            // empty if block
        }
        this.outFont();
        this.outColor();
        this.pcl.print("\u001b&a");
        this.pcl.print(cSSPoint.x * 10L);
        this.pcl.print("H");
        this.pcl.print("\u001b&a");
        this.pcl.print(cSSPoint.y * 10L);
        this.pcl.print("V");
        this.pcl.print(c);
    }

    public void drawOrientatedGlyph(char c, CSSPoint cSSPoint, short s) {
        if (s == 90 || s == -270) {
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.x * 10L);
            this.pcl.print("H");
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.y * 10L);
            this.pcl.print("V");
            this.pcl.print("\u001b&a90P");
        } else if (s == 180 || s == -180) {
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.x * 10L);
            this.pcl.print("H");
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.y * 10L);
            this.pcl.print("V");
            this.pcl.print("\u001b&a180P");
        } else if (s == -90 || s == 270) {
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.x * 10L);
            this.pcl.print("H");
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.y * 10L);
            this.pcl.print("V");
            this.pcl.print("\u001b&a270P");
        }
        this.outFont();
        this.outColor();
        this.pcl.print(c);
        this.pcl.print("\u001b&a0P");
    }

    public void drawString(String string, CSSPoint cSSPoint) {
        this.outFont();
        this.pcl.print("\u001b&a");
        this.pcl.print(cSSPoint.x);
        this.pcl.print("C");
        this.pcl.print("\u001b&a");
        this.pcl.print(cSSPoint.x);
        this.pcl.print("R");
        this.outStr(string);
    }

    public void drawRule(CSSPoint cSSPoint, CSSPoint cSSPoint2, Border border) {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        this.pcl.print("\u001b%1B");
        this.pcl.print("PC1," + border.color.red + "," + border.color.green + "," + border.color.blue + "PC0,255,255,255");
        double d = 0.35 * (double)border.width;
        if (border.style == 3) {
            this.pcl.print("LT2;");
            this.pcl.print("LA1,1,2,1;");
        } else if (border.style == 2) {
            cSSPoint.x += border.width / 2L;
            cSSPoint2.x -= border.width / 2L;
            this.pcl.print("LA1,4,2,4;");
            this.pcl.print("UL1,0,100");
            this.pcl.print("LT1," + 2.0 * d + ",1;");
        } else if (border.style == 4) {
            this.pcl.print("LT;");
            this.pcl.print("LA1,1,2,1;");
        } else {
            System.err.println(ResourceBundleLoader_rw.getMessage((String)"styleerr") + border.style);
            return;
        }
        this.pcl.print("PW" + 0.35 * (double)border.width + ";");
        this.pcl.print("PU;");
        this.pcl.print("PA");
        this.pcl.print((double)cSSPoint.x * 14.1111 + "," + (double)(this.hi - cSSPoint.y) * 14.1111);
        this.pcl.print(";PD");
        this.pcl.print((double)cSSPoint2.x * 14.1111 + "," + (double)(this.hi - cSSPoint2.y) * 14.1111 + ";");
        this.pcl.print("PW;");
        this.pcl.print("\u001b%0A");
        this.SendFont = true;
    }

    private void drawBorder(long l, long l2, long l3, long l4, CSSColor cSSColor, boolean bl) {
        String string = this.getEndCap(0);
        String string2 = this.getLineJoin(0);
        this.pcl.print("\u001b%1B");
        this.pcl.print("TR0");
        this.pcl.print("PC1," + cSSColor.red + "," + cSSColor.green + "," + cSSColor.blue + "PC0,255,255,255");
        this.pcl.print("PU;");
        this.pcl.print("PA");
        this.pcl.print((double)l * 14.1111 + "," + (double)l2 * 14.1111);
        if (bl) {
            this.pcl.print(";RR");
        } else {
            this.pcl.print(";ER");
        }
        this.pcl.print((double)l3 * 14.1111 + "," + (double)l4 * 14.1111 + ";");
        this.pcl.print("\u001b%0A");
        this.SendFont = true;
    }

    public void drawBorder(Border border, Border border2, Border border3, Border border4, CSSPoint cSSPoint, CSSExtent cSSExtent) {
        double d;
        long l;
        long l2;
        long l3;
        long l4;
        PCLFourEdgeBorder pCLFourEdgeBorder = null;
        PCLOutsetInsetBorder pCLOutsetInsetBorder = null;
        PCLRidgeGrooveBorder pCLRidgeGrooveBorder = null;
        TBRL tBRL = new TBRL();
        if (null != border.color && 0L != border.width) {
            this.pcl.print("\u001b%1B");
            l4 = cSSPoint.x;
            l3 = this.hi - cSSPoint.y - border.width / 2L;
            l2 = cSSPoint.x + cSSExtent.width;
            l = this.hi - cSSPoint.y - border.width / 2L;
            if (0 != border.style && 1 != border.style) {
                this.pcl.print("PC1," + border.color.red + "," + border.color.green + "," + border.color.blue + "PC0,255,255,255");
                if (border.style == 4 || border.style == 3 || border.style == 2) {
                    d = 0.35 * (double)border.width;
                    if (border.style == 3) {
                        this.pcl.print("LT2;");
                        this.pcl.print("LA1,1,2,1;");
                    } else if (border.style == 2) {
                        l4 += border.width / 2L;
                        l2 -= border.width / 2L;
                        this.pcl.print("LA1,4,2,4;");
                        this.pcl.print("UL8,33,66");
                        this.pcl.print("LT8," + 3.0 * d + ",1;");
                    } else {
                        this.pcl.print("LT;");
                        this.pcl.print("LA1,1,2,1;");
                    }
                    this.pcl.print("PW" + 0.35 * (double)border.width + ";");
                    this.pcl.print("PU;");
                    this.pcl.print("PA");
                    this.pcl.print((double)l4 * 14.1111 + "," + (double)l3 * 14.1111);
                    this.pcl.print(";PD");
                    this.pcl.print((double)l2 * 14.1111 + "," + (double)l * 14.1111 + ";");
                    tBRL.setTop((int)border.width, (int)border.style);
                    this.pcl.print("PW;");
                } else if (border.style == 5) {
                    if (pCLFourEdgeBorder == null) {
                        pCLFourEdgeBorder = new PCLVariableWidthDoubleBorder();
                    }
                    pCLFourEdgeBorder.setTopEdge(border.color, (int)border.width);
                } else if (border.style == 7 || border.style == 6) {
                    if (pCLRidgeGrooveBorder == null) {
                        pCLRidgeGrooveBorder = new PCLRidgeGrooveBorder();
                    }
                    int n = border.style == 6 ? 2 : 1;
                    pCLRidgeGrooveBorder.setTopEdge(border.color, (int)border.width, n);
                    tBRL.setTop((int)border.width, (int)border.style);
                } else if (border.style == 9 || border.style == 8) {
                    if (pCLOutsetInsetBorder == null) {
                        pCLOutsetInsetBorder = new PCLOutsetInsetBorder();
                    }
                    int n = border.style == 9 ? 1 : 2;
                    pCLOutsetInsetBorder.setTopEdge(border.color, (int)border.width, n);
                    tBRL.setTop((int)border.width, (int)border.style);
                }
            }
            this.pcl.print("\u001b%0A");
            this.SendFont = true;
        }
        if (null != border3.color && 0L != border3.width) {
            this.pcl.print("\u001b%1B");
            l4 = cSSPoint.x;
            l3 = this.hi - cSSPoint.y - cSSExtent.height + border3.width / 2L;
            l2 = cSSPoint.x + cSSExtent.width;
            l = this.hi - cSSPoint.y - cSSExtent.height + border3.width / 2L;
            if (0 != border3.style && 1 != border3.style) {
                this.pcl.print("PC1," + border3.color.red + "," + border3.color.green + "," + border3.color.blue + "PC0,255,255,255");
                if (border3.style == 4 || border3.style == 3 || border3.style == 2) {
                    d = 0.35 * (double)border3.width;
                    if (border3.style == 3) {
                        this.pcl.print("LT2;");
                        this.pcl.print("LA1,1,2,1;");
                    } else if (border3.style == 2) {
                        l4 += border3.width / 2L;
                        l2 -= border3.width / 2L;
                        this.pcl.print("LA1,4,2,4;");
                        this.pcl.print("UL8,33,66");
                        this.pcl.print("LT8," + 3.0 * d + ",1;");
                    } else {
                        this.pcl.print("LT;");
                        this.pcl.print("LA1,1,2,1;");
                    }
                    this.pcl.print("PW" + 0.35 * (double)border3.width + ";");
                    this.pcl.print("PU;");
                    this.pcl.print("PA");
                    this.pcl.print((double)l4 * 14.1111 + "," + (double)l3 * 14.1111);
                    this.pcl.print(";PD");
                    this.pcl.print((double)l2 * 14.1111 + "," + (double)l * 14.1111 + ";");
                    tBRL.setBottom((int)border3.width, (int)border3.style);
                    this.pcl.print("PW;");
                } else if (border3.style == 5) {
                    if (pCLFourEdgeBorder == null) {
                        pCLFourEdgeBorder = new PCLVariableWidthDoubleBorder();
                    }
                    pCLFourEdgeBorder.setBottomEdge(border3.color, (int)border3.width);
                } else if (border3.style == 7 || border3.style == 6) {
                    if (pCLRidgeGrooveBorder == null) {
                        pCLRidgeGrooveBorder = new PCLRidgeGrooveBorder();
                    }
                    int n = border3.style == 6 ? 2 : 1;
                    pCLRidgeGrooveBorder.setBottomEdge(border3.color, (int)border3.width, n);
                    tBRL.setBottom((int)border3.width, (int)border3.style);
                } else if (border3.style == 9 || border3.style == 8) {
                    if (pCLOutsetInsetBorder == null) {
                        pCLOutsetInsetBorder = new PCLOutsetInsetBorder();
                    }
                    int n = border3.style == 9 ? 1 : 2;
                    pCLOutsetInsetBorder.setBottomEdge(border3.color, (int)border3.width, n);
                    tBRL.setBottom((int)border3.width, (int)border3.style);
                }
            }
            this.pcl.print("\u001b%0A");
            this.SendFont = true;
        }
        if (null != border4.color && 0L != border4.width) {
            this.pcl.print("\u001b%1B");
            l4 = cSSPoint.x + cSSExtent.width - border4.width / 2L;
            l3 = this.hi - cSSPoint.y;
            l2 = cSSPoint.x + cSSExtent.width - border4.width / 2L;
            l = this.hi - cSSPoint.y - cSSExtent.height;
            if (0 != border4.style && 1 != border4.style) {
                this.pcl.print("PC1," + border4.color.red + "," + border4.color.green + "," + border4.color.blue + "PC0,255,255,255");
                if (border4.style == 4 || border4.style == 3 || border4.style == 2) {
                    d = 0.35 * (double)border4.width;
                    if (border4.style == 3) {
                        this.pcl.print("LT2;");
                        this.pcl.print("LA1,1,2,1;");
                    } else if (border4.style == 2) {
                        l3 -= border4.width / 2L;
                        l += border4.width / 2L;
                        this.pcl.print("LA1,4,2,4;");
                        this.pcl.print("UL8,33,66");
                        this.pcl.print("LT8," + 3.0 * d + ",1;");
                    } else {
                        this.pcl.print("LT;");
                        this.pcl.print("LA1,1,2,1;");
                    }
                    this.pcl.print("PW" + 0.35 * (double)border4.width + ";");
                    this.pcl.print("PU;");
                    this.pcl.print("PA");
                    this.pcl.print((double)l4 * 14.1111 + "," + (double)l3 * 14.1111);
                    this.pcl.print(";PD");
                    this.pcl.print((double)l2 * 14.1111 + "," + (double)l * 14.1111 + ";");
                    tBRL.setRight((int)border4.width, (int)border4.style);
                    this.pcl.print("PW;");
                } else if (border4.style == 5) {
                    if (pCLFourEdgeBorder == null) {
                        pCLFourEdgeBorder = new PCLVariableWidthDoubleBorder();
                    }
                    pCLFourEdgeBorder.setRightEdge(border4.color, (int)border4.width);
                } else if (border4.style == 7 || border4.style == 6) {
                    if (pCLRidgeGrooveBorder == null) {
                        pCLRidgeGrooveBorder = new PCLRidgeGrooveBorder();
                    }
                    int n = border4.style == 6 ? 2 : 1;
                    pCLRidgeGrooveBorder.setRightEdge(border4.color, (int)border4.width, n);
                    tBRL.setRight((int)border4.width, (int)border4.style);
                } else if (border4.style == 9 || border4.style == 8) {
                    if (pCLOutsetInsetBorder == null) {
                        pCLOutsetInsetBorder = new PCLOutsetInsetBorder();
                    }
                    int n = border4.style == 9 ? 1 : 2;
                    pCLOutsetInsetBorder.setRightEdge(border4.color, (int)border4.width, n);
                    tBRL.setRight((int)border4.width, (int)border4.style);
                }
            }
            this.pcl.print("\u001b%0A");
            this.SendFont = true;
        }
        if (null != border2.color && 0L != border2.width) {
            this.pcl.print("\u001b%1B");
            l4 = cSSPoint.x + border2.width / 2L;
            l3 = this.hi - cSSPoint.y - cSSExtent.height;
            l2 = cSSPoint.x + border2.width / 2L;
            l = this.hi - cSSPoint.y;
            if (0 != border2.style && 1 != border2.style) {
                this.pcl.print("PC1," + border2.color.red + "," + border2.color.green + "," + border2.color.blue + "PC0,255,255,255");
                if (border2.style == 4 || border2.style == 3 || border2.style == 2) {
                    d = 0.35 * (double)border2.width;
                    if (border2.style == 3) {
                        this.pcl.print("LT2;");
                        this.pcl.print("LA1,1,2,1;");
                    } else if (border2.style == 2) {
                        l3 += border2.width / 2L;
                        l -= border2.width / 2L;
                        this.pcl.print("LA1,4,2,4;");
                        this.pcl.print("UL8,33,66");
                        this.pcl.print("LT8," + 3.0 * d + ",1;");
                    } else {
                        this.pcl.print("LT;");
                        this.pcl.print("LA1,1,2,1;");
                    }
                    this.pcl.print("PW" + 0.35 * (double)border2.width + ";");
                    this.pcl.print("PU;");
                    this.pcl.print("PA");
                    this.pcl.print((double)l4 * 14.1111 + "," + (double)l3 * 14.1111);
                    this.pcl.print(";PD");
                    this.pcl.print((double)l2 * 14.1111 + "," + (double)l * 14.1111 + ";");
                    tBRL.setLeft((int)border2.width, (int)border2.style);
                    this.pcl.print("PW;");
                } else if (border2.style == 5) {
                    if (pCLFourEdgeBorder == null) {
                        pCLFourEdgeBorder = new PCLVariableWidthDoubleBorder();
                    }
                    pCLFourEdgeBorder.setLeftEdge(border2.color, (int)border2.width);
                } else if (border2.style == 7 || border2.style == 6) {
                    if (pCLRidgeGrooveBorder == null) {
                        pCLRidgeGrooveBorder = new PCLRidgeGrooveBorder();
                    }
                    int n = border2.style == 6 ? 2 : 1;
                    pCLRidgeGrooveBorder.setLeftEdge(border2.color, (int)border2.width, n);
                    tBRL.setLeft((int)border2.width, (int)border2.style);
                } else if (border2.style == 9 || border2.style == 8) {
                    if (pCLOutsetInsetBorder == null) {
                        pCLOutsetInsetBorder = new PCLOutsetInsetBorder();
                    }
                    int n = border2.style == 9 ? 1 : 2;
                    pCLOutsetInsetBorder.setLeftEdge(border2.color, (int)border2.width, n);
                    tBRL.setLeft((int)border2.width, (int)border2.style);
                }
            }
            this.pcl.print("\u001b%0A");
            this.SendFont = true;
        }
        if (pCLFourEdgeBorder != null) {
            this.pcl.print("\u001b%1B");
            pCLFourEdgeBorder.setDependancies(tBRL);
            ((PCLVariableWidthDoubleBorder)pCLFourEdgeBorder).paintBorder(this.pcl, (int)cSSPoint.x, (int)cSSPoint.y, (int)cSSExtent.width, (int)cSSExtent.height, this.hi);
            this.pcl.print("\u001b%0A");
            this.SendFont = true;
        }
        if (pCLRidgeGrooveBorder != null) {
            this.pcl.print("\u001b%1B");
            pCLRidgeGrooveBorder.paintBorder(this.pcl, (int)cSSPoint.x, (int)cSSPoint.y, (int)cSSExtent.width, (int)cSSExtent.height, this.hi);
            this.pcl.print("\u001b%0A");
            this.SendFont = true;
        }
        if (pCLOutsetInsetBorder != null) {
            this.pcl.print("\u001b%1B");
            pCLOutsetInsetBorder.paintBorder(this.pcl, (int)cSSPoint.x, (int)cSSPoint.y, (int)cSSExtent.width, (int)cSSExtent.height, this.hi);
            this.pcl.print("\u001b%0A");
            this.SendFont = true;
        }
    }

    public void fillBackground(CSSPoint cSSPoint, CSSExtent cSSExtent, CSSColor cSSColor) {
        this.drawBorder(cSSPoint.x, this.hi - cSSPoint.y - cSSExtent.height, cSSExtent.width, cSSExtent.height, cSSColor, true);
    }

    public void fillBackground(CSSPoint cSSPoint, CSSExtent cSSExtent, String string, CSSPoint cSSPoint2, int n) {
        Image image = null;
        image = this.imageHolder.getImage(string);
        if (image == null) {
            System.err.println(ResourceBundleLoader_rw.getMessage((String)"nullimage") + string);
            return;
        }
        Dimension dimension = this.imageHolder.getDimension(string);
        switch (n) {
            case 0: {
                int n2 = (int)cSSPoint.x + (int)cSSPoint2.x;
                int n3 = (int)cSSPoint.y + (int)cSSPoint2.y;
                CSSPoint cSSPoint3 = new CSSPoint((long)n2, (long)n3);
                CSSExtent cSSExtent2 = new CSSExtent((long)dimension.width, (long)dimension.height);
                if ((long)dimension.height > cSSExtent.height - (long)n3) {
                    cSSExtent2.setHeight((long)((int)cSSExtent.height - n3));
                }
                if ((long)dimension.width > cSSExtent.width - (long)n2) {
                    cSSExtent2.setWidth((long)((int)cSSExtent.width - n2));
                }
                this.drawGraphic(string, cSSPoint3, cSSExtent2);
                break;
            }
            case 1: {
                Dimension dimension2 = this.getStartOffset(cSSPoint2, dimension);
                int n4 = 0;
                while ((long)n4 < cSSExtent.height) {
                    int n5 = 0;
                    while ((long)n5 < cSSExtent.width) {
                        int n6 = (int)cSSPoint.x + (int)cSSPoint2.x + dimension2.width + n5;
                        int n7 = (int)cSSPoint.y + (int)cSSPoint2.y + dimension2.height + n4;
                        CSSPoint cSSPoint4 = new CSSPoint((long)n6, (long)n7);
                        CSSExtent cSSExtent3 = new CSSExtent((long)dimension.width, (long)dimension.height);
                        if ((long)dimension.height > cSSExtent.height - (long)n4) {
                            cSSExtent3.setHeight((long)((int)cSSExtent.height - n4));
                        }
                        if ((long)dimension.width > cSSExtent.width - (long)n5) {
                            cSSExtent3.setWidth((long)((int)cSSExtent.width - n5));
                        }
                        this.drawGraphic(string, cSSPoint4, cSSExtent3);
                        n5 += dimension.width;
                    }
                    n4 += dimension.height;
                }
                break;
            }
            case 2: {
                this.pcl.print("\u001b%0A");
                Dimension dimension3 = this.getStartOffset(cSSPoint2, dimension);
                int n8 = (int)cSSPoint.y + (int)cSSPoint2.y;
                int n9 = 0;
                while ((long)n9 < cSSExtent.width) {
                    int n10 = (int)cSSPoint.x + (int)cSSPoint2.x + dimension3.width + n9;
                    CSSPoint cSSPoint5 = new CSSPoint((long)n10, (long)n8);
                    CSSExtent cSSExtent4 = new CSSExtent((long)dimension.width, (long)dimension.height);
                    if ((long)dimension.height > cSSExtent.height + cSSPoint.y - (long)n8) {
                        cSSExtent4.setHeight((long)((int)cSSExtent.height - n8));
                    }
                    if ((long)dimension.width > cSSExtent.width - (long)n10) {
                        if (n9 == 0) {
                            cSSExtent4.setWidth((long)((int)cSSExtent.width));
                        } else {
                            cSSExtent4.setWidth((long)((int)cSSExtent.width - n10));
                        }
                    }
                    this.drawGraphic(string, cSSPoint5, cSSExtent4);
                    n9 += dimension.width;
                }
                break;
            }
            case 3: {
                Dimension dimension4 = this.getStartOffset(cSSPoint2, dimension);
                int n11 = (int)cSSPoint.x + (int)cSSPoint2.x;
                int n12 = 0;
                while ((long)n12 < cSSExtent.height) {
                    int n13 = (int)cSSPoint.y + (int)cSSPoint2.y + dimension4.height + n12;
                    CSSPoint cSSPoint6 = new CSSPoint((long)n11, (long)n13);
                    CSSExtent cSSExtent5 = new CSSExtent((long)dimension.width, (long)dimension.height);
                    if ((long)dimension.height > cSSExtent.height + cSSPoint.y - (long)n13) {
                        if (n12 == 0) {
                            cSSExtent5.setHeight((long)((int)cSSExtent.height));
                        } else {
                            cSSExtent5.setHeight((long)((int)cSSExtent.height - n13));
                        }
                    }
                    if ((long)dimension.width > cSSExtent.width - (long)n11) {
                        cSSExtent5.setWidth((long)((int)cSSExtent.width - n11));
                    }
                    this.drawGraphic(string, cSSPoint6, cSSExtent5);
                    n12 += dimension.height;
                }
                break;
            }
            default: {
                System.err.println(ResourceBundleLoader_rw.getMessage((String)"repeatnotvalid") + (short)n);
            }
        }
    }

    private Dimension getStartOffset(CSSPoint cSSPoint, Dimension dimension) {
        int n = 0;
        int n2 = 0;
        if (cSSPoint.x != 0L) {
            n2 = (int)(-((long)dimension.width - cSSPoint.x % (long)dimension.width));
        }
        if (cSSPoint.y != 0L) {
            n = (int)(-((long)dimension.height - cSSPoint.y % (long)dimension.height));
        }
        return new Dimension(n2, n);
    }

    public void notifyGraphic(URL uRL) {
        this.imageHolder.insertURI(uRL);
    }

    public void drawGraphic(String string, CSSPoint cSSPoint, CSSExtent cSSExtent) {
        Image image = this.imageHolder.getImage(string);
        if (null != image) {
            this.ColorCommand = "\u001b*v0a0b0c1I\u001b*v1S";
            this.pcl.print(this.ColorCommand);
            this.pcl.print("\u001b*r" + cSSExtent.height + "T");
            this.pcl.print("\u001b*r" + cSSExtent.width + "S");
            this.pcl.print("\u001b*v6W");
            byte[] byArray = new byte[]{0, 3, 0, 8, 8, 8};
            this.pcl.write(byArray, 0, 6);
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.x * 10L);
            this.pcl.print("H");
            this.pcl.print("\u001b&a");
            this.pcl.print(cSSPoint.y * 10L);
            this.pcl.print("V");
            this.pcl.print("\u001b*r1A");
            try {
                this.sendImage(image);
            }
            catch (Exception exception) {
                String string2 = exception.getMessage();
                System.err.println(string2);
                return;
            }
            this.pcl.print("\u001b*rC");
        }
    }

    private void sendImage(Image image) throws IOException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        ByteArrayOutputStream byteArrayOutputStream3 = null;
        String string = null;
        boolean bl = false;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        byteArrayOutputStream3 = new ByteArrayOutputStream();
        int n9 = image.getHeight(null);
        int n10 = image.getWidth(null);
        int[] nArray = new int[n10 * n9];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n10, n9, nArray, 0, n10);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedException(ResourceBundleLoader_rw.getMessage((String)"grabpixelerr"));
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException(ResourceBundleLoader_rw.getMessage((String)"fetcherr"));
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        int n11 = 0;
        while (n11 < n9) {
            int n12 = 0;
            while (n12 < n10) {
                int n13 = nArray[n11 * n10 + n12];
                Integer n14 = new Integer(colorModel.getRed(n13));
                byte by = n14.byteValue();
                Integer n15 = new Integer(colorModel.getGreen(n13));
                byte by2 = n15.byteValue();
                Integer n16 = new Integer(colorModel.getBlue(n13));
                byte by3 = n16.byteValue();
                if (n11 > 0) {
                    if (!bl) {
                        bl = true;
                    }
                    if (nArray[n11 * n10 + n12] == nArray[(n11 - 1) * n10 + n12]) {
                        if (n5 > 0 || n12 + 1 == n10) {
                            if (n <= 31) {
                                n2 = (n5 - 1) * 32 + n;
                                byteArrayOutputStream.write(n2);
                                byteArrayOutputStream3.writeTo(byteArrayOutputStream);
                                byteArrayOutputStream3.reset();
                                n5 = 0;
                                n = 0;
                                n7 = 0;
                            } else if (n > 31 && n <= 286) {
                                n2 = (n5 - 1) * 32 + 31;
                                n3 = n - 31;
                                byteArrayOutputStream.write(n2);
                                byteArrayOutputStream.write(n3);
                                byteArrayOutputStream3.writeTo(byteArrayOutputStream);
                                byteArrayOutputStream3.reset();
                                n5 = 0;
                                n = 0;
                                n7 = 0;
                            } else if (n > 286 && n <= 541) {
                                n2 = (n5 - 1) * 32 + 31;
                                n3 = 255;
                                n4 = n - 286;
                                byteArrayOutputStream.write(n2);
                                byteArrayOutputStream.write(n3);
                                byteArrayOutputStream.write(n4);
                                byteArrayOutputStream3.writeTo(byteArrayOutputStream);
                                byteArrayOutputStream3.reset();
                                n5 = 0;
                                n = 0;
                                n7 = 0;
                            }
                        }
                        n = (n7 + 1) * 3;
                        ++n7;
                    } else {
                        if ((n5 += 3) > 8) {
                            n6 = n5 % 8;
                            n5 = 8;
                        } else {
                            n6 = 0;
                        }
                        if (n6 == 0) {
                            byteArrayOutputStream3.write(by);
                            byteArrayOutputStream3.write(by2);
                            byteArrayOutputStream3.write(by3);
                        } else if (n6 == 1) {
                            byteArrayOutputStream3.write(by);
                            byteArrayOutputStream3.write(by2);
                        } else if (n6 == 2) {
                            byteArrayOutputStream3.write(by);
                        }
                        if (n5 == 8 || n12 + 1 == n10) {
                            if (n <= 31) {
                                n2 = (n5 - 1) * 32 + n;
                                byteArrayOutputStream.write(n2);
                                byteArrayOutputStream3.writeTo(byteArrayOutputStream);
                                byteArrayOutputStream3.reset();
                                n5 = 0;
                                n = 0;
                                n7 = 0;
                            } else if (n > 31 && n <= 286) {
                                n2 = (n5 - 1) * 32 + 31;
                                n3 = n - 31;
                                byteArrayOutputStream.write(n2);
                                byteArrayOutputStream.write(n3);
                                byteArrayOutputStream3.writeTo(byteArrayOutputStream);
                                byteArrayOutputStream3.reset();
                                n5 = 0;
                                n = 0;
                                n7 = 0;
                            } else if (n > 286 && n <= 541) {
                                n2 = (n5 - 1) * 32 + 31;
                                n3 = 255;
                                n4 = n - 286;
                                byteArrayOutputStream.write(n2);
                                byteArrayOutputStream.write(n3);
                                byteArrayOutputStream.write(n4);
                                byteArrayOutputStream3.writeTo(byteArrayOutputStream);
                                byteArrayOutputStream3.reset();
                                n5 = 0;
                                n = 0;
                                n7 = 0;
                            }
                            if (n6 == 2) {
                                byteArrayOutputStream3.write(by2);
                                byteArrayOutputStream3.write(by3);
                                n5 = 2;
                            } else if (n6 == 1) {
                                byteArrayOutputStream3.write(by3);
                                n5 = 1;
                            }
                        }
                    }
                } else {
                    byteArrayOutputStream.write(by);
                    byteArrayOutputStream.write(by2);
                    byteArrayOutputStream.write(by3);
                }
                ++n12;
            }
            string2 = byteArrayOutputStream.toString();
            if (n11 > 0 && 0 == string2.compareTo(string)) {
                this.pcl.print("\u001b*b3M");
                this.pcl.print("\u001b*b0W");
                byteArrayOutputStream.reset();
            } else {
                if (bl) {
                    this.pcl.print("\u001b*b3M\u001b*b" + byteArrayOutputStream.size() + "W" + byteArrayOutputStream);
                } else {
                    this.pcl.print("\u001b*b" + n10 * 3 + "W" + byteArrayOutputStream);
                }
                string = byteArrayOutputStream.toString();
                byteArrayOutputStream.writeTo(byteArrayOutputStream2);
                byteArrayOutputStream.reset();
            }
            ++n11;
        }
    }

    public CSSExtent getGraphicDimension(String string) {
        Dimension dimension = this.imageHolder.getDimension(string);
        return new CSSExtent((long)dimension.width, (long)dimension.height);
    }

    private void loadPropertyFile(String string, Properties properties) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

