/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pclwriter;

import com.ibm.as400.util.reportwriter.pclwriter.PCLFourEdgeBorder;
import com.ibm.xsl.composer.csstypes.CSSColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;

public class PCLOutsetInsetBorder
extends PCLFourEdgeBorder {
    public static final int NO_STYLE = 0;
    public static final int OUTSET = 1;
    public static final int INSET = 2;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;
    protected int topStyle = 0;
    protected int bottomStyle = 0;
    protected int rightStyle = 0;
    protected int leftStyle = 0;

    public PCLOutsetInsetBorder() {
        this.borderWidth = 2;
    }

    public PCLOutsetInsetBorder(int n, int n2) {
        this(n);
        this.borderWidth = n2;
    }

    public PCLOutsetInsetBorder(int n) {
        this.bevelType = n;
        this.borderWidth = 2;
    }

    public PCLOutsetInsetBorder(int n, Color color, Color color2) {
        this(n, color.brighter(), color, color2, color2.brighter());
    }

    public PCLOutsetInsetBorder(int n, Color color, Color color2, Color color3, Color color4) {
        this(n);
        this.highlightOuter = color;
        this.highlightInner = color2;
        this.shadowOuter = color3;
        this.shadowInner = color4;
    }

    public void paintBorder(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
    }

    public void paintBorder(PrintStream printStream, int n, int n2, int n3, int n4, long l) {
        printStream.print("LT;");
        printStream.print("LA1,1,2,1;");
        if (this.topEdge && this.topStyle == 1 && this.topWidth > 0) {
            this.paintTopOutset(printStream, n, n2, l, n3, n4);
        }
        if (this.bottomEdge && this.bottomStyle == 1 && this.bottomWidth > 0) {
            this.paintBottomOutset(printStream, n, n2, l, n3, n4);
        }
        if (this.rightEdge && this.rightStyle == 1 && this.rightWidth > 0) {
            this.paintRightOutset(printStream, n, n2, l, n3, n4);
        }
        if (this.leftEdge && this.leftStyle == 1 && this.leftWidth > 0) {
            this.paintLeftOutset(printStream, n, n2, l, n3, n4);
        }
        if (this.topEdge && this.topStyle == 2 && this.topWidth > 0) {
            this.paintTopInset(printStream, n, n2, l, n3, n4);
        }
        if (this.bottomEdge && this.bottomStyle == 2 && this.bottomWidth > 0) {
            this.paintBottomInset(printStream, n, n2, l, n3, n4);
        }
        if (this.rightEdge && this.rightStyle == 2 && this.rightWidth > 0) {
            this.paintRightInset(printStream, n, n2, l, n3, n4);
        }
        if (this.leftEdge && this.leftStyle == 2 && this.leftWidth > 0) {
            this.paintLeftInset(printStream, n, n2, l, n3, n4);
        }
    }

    public Color getHighlightOuterColor(Color color) {
        return color.brighter().brighter();
    }

    public Color getHighlightInnerColor(Color color) {
        return color.brighter();
    }

    public Color getShadowInnerColor(Color color) {
        return color.darker();
    }

    public Color getShadowOuterColor(Color color) {
        return color.darker().darker();
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintTopInset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getShadowInnerColor(this.topColor);
        Color color2 = this.getShadowOuterColor(this.topColor);
        this.drawTop(printStream, color, color2, n, n2, l, this.topWidth, n3, n4);
    }

    protected void paintBottomInset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getHighlightOuterColor(this.bottomColor);
        Color color2 = this.getHighlightInnerColor(this.bottomColor);
        this.drawBottom(printStream, color, color2, n, n2, l, this.bottomWidth, n3, n4);
    }

    protected void paintRightInset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getHighlightOuterColor(this.rightColor);
        Color color2 = this.getHighlightInnerColor(this.rightColor);
        this.drawRight(printStream, color, color2, n, n2, l, this.rightWidth, n3, n4);
    }

    protected void paintLeftInset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getShadowInnerColor(this.leftColor);
        Color color2 = this.getShadowOuterColor(this.leftColor);
        this.drawLeft(printStream, color, color2, n, n2, l, this.leftWidth, n3, n4);
    }

    protected void paintTopOutset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getHighlightOuterColor(this.topColor);
        Color color2 = this.getHighlightInnerColor(this.topColor);
        this.drawTop(printStream, color, color2, n, n2, l, this.topWidth, n3, n4);
    }

    protected void paintBottomOutset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getShadowOuterColor(this.bottomColor);
        Color color2 = this.getShadowInnerColor(this.bottomColor);
        this.drawBottom(printStream, color, color2, n, n2, l, this.bottomWidth, n3, n4);
    }

    protected void paintRightOutset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getShadowOuterColor(this.rightColor);
        Color color2 = this.getShadowInnerColor(this.rightColor);
        this.drawRight(printStream, color, color2, n, n2, l, this.rightWidth, n3, n4);
    }

    protected void paintLeftOutset(PrintStream printStream, int n, int n2, long l, int n3, int n4) {
        Color color = this.getHighlightOuterColor(this.leftColor);
        Color color2 = this.getHighlightInnerColor(this.leftColor);
        this.drawLeft(printStream, color, color2, n, n2, l, this.leftWidth, n3, n4);
    }

    protected void drawTop(PrintStream printStream, Color color, Color color2, int n, int n2, long l, int n3, int n4, int n5) {
        this.sendColor(printStream, color);
        int n6 = n3 / 2;
        long l2 = n;
        long l3 = l - (long)n2;
        long l4 = n + n4 - 1;
        long l5 = l - (long)n2;
        int n7 = 0;
        while (n7 <= n6) {
            this.sendLine(printStream, l2 + (long)n7, l3 - (long)n7, l4 - (long)n7, l5 - (long)n7);
            ++n7;
        }
        this.sendColor(printStream, color2);
        while (n7 < n3) {
            this.sendLine(printStream, l2 + (long)n7, l3 - (long)n7, l4 - (long)n7, l5 - (long)n7);
            ++n7;
        }
    }

    protected void drawBottom(PrintStream printStream, Color color, Color color2, int n, int n2, long l, int n3, int n4, int n5) {
        this.sendColor(printStream, color);
        int n6 = n3 / 2;
        long l2 = n;
        long l3 = l - (long)n2 - (long)n5 + 1L;
        long l4 = n + n4 - 1;
        long l5 = l - (long)n2 - (long)n5 + 1L;
        int n7 = 0;
        while (n7 <= n6) {
            this.sendLine(printStream, l2 + (long)n7, l3 + (long)n7, l4 - (long)n7, l5 + (long)n7);
            ++n7;
        }
        this.sendColor(printStream, color2);
        while (n7 < n3) {
            this.sendLine(printStream, l2 + (long)n7, l3 + (long)n7, l4 - (long)n7, l5 + (long)n7);
            ++n7;
        }
    }

    protected void drawRight(PrintStream printStream, Color color, Color color2, int n, int n2, long l, int n3, int n4, int n5) {
        this.sendColor(printStream, color);
        int n6 = n3 / 2;
        long l2 = n + n4 - 1;
        long l3 = l - (long)n2;
        long l4 = n + n4 - 1;
        long l5 = l - (long)n2 - (long)n5 + 1L;
        int n7 = 0;
        while (n7 <= n6) {
            this.sendLine(printStream, l2 - (long)n7, l3 - (long)n7, l4 - (long)n7, l5 + (long)n7);
            ++n7;
        }
        this.sendColor(printStream, color2);
        while (n7 < n3) {
            this.sendLine(printStream, l2 - (long)n7, l3 - (long)n7, l4 - (long)n7, l5 + (long)n7);
            ++n7;
        }
    }

    protected void drawLeft(PrintStream printStream, Color color, Color color2, int n, int n2, long l, int n3, int n4, int n5) {
        this.sendColor(printStream, color);
        int n6 = n3 / 2;
        long l2 = n;
        long l3 = l - (long)n2 - (long)n5 + 1L;
        long l4 = n;
        long l5 = l - (long)n2;
        int n7 = 0;
        while (n7 <= n6) {
            this.sendLine(printStream, l2 + (long)n7, l3 + (long)n7, l4 + (long)n7, l5 - (long)n7);
            ++n7;
        }
        this.sendColor(printStream, color2);
        while (n7 < n3) {
            this.sendLine(printStream, l2 + (long)n7, l3 + (long)n7, l4 + (long)n7, l5 - (long)n7);
            ++n7;
        }
    }

    public void setTopEdge(CSSColor cSSColor, int n, int n2) {
        super.setTopEdge(cSSColor, n);
        this.topStyle = n2;
    }

    public void setBottomEdge(CSSColor cSSColor, int n, int n2) {
        super.setBottomEdge(cSSColor, n);
        this.bottomStyle = n2;
    }

    public void setRightEdge(CSSColor cSSColor, int n, int n2) {
        super.setRightEdge(cSSColor, n);
        this.rightStyle = n2;
    }

    public void setLeftEdge(CSSColor cSSColor, int n, int n2) {
        super.setLeftEdge(cSSColor, n);
        this.leftStyle = n2;
    }

    private void sendColor(PrintStream printStream, Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        printStream.print("PC1," + n + "," + n2 + "," + n3 + "PC0,255,255,255");
    }

    private void sendLine(PrintStream printStream, long l, long l2, long l3, long l4) {
        printStream.print("PU");
        printStream.print("PA");
        printStream.print((double)l * 14.1111 + "," + (double)l2 * 14.1111);
        printStream.print(";PD");
        printStream.print((double)l3 * 14.1111 + "," + (double)l4 * 14.1111 + ";");
    }
}

