/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pdfwriter;

import com.ibm.as400.util.reportwriter.pdfwriter.PDFContentStream;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFDocument;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFExtendedFont;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFont;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFourEdgeBorder;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFOutsetInsetBorder;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFResource;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFRidgeGrooveBorder;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFVariableWidthDoubleBorder;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFXObject;
import com.ibm.as400.util.reportwriter.pdfwriter.TBRL;
import com.ibm.as400.util.reportwriter.processor.ResourceBundleLoader_rw;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.java2d.ImageHolder;
import com.ibm.xsl.composer.prim.Border;
import com.ibm.xsl.composer.properties.FontProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PDFContext
implements Context {
    private static final int CAP_BUTT = 0;
    private static final int CAP_ROUND = 1;
    private static final int CAP_SQUARE = 2;
    private static final int JOIN_MITER = 0;
    private static final int JOIN_ROUND = 1;
    private static final int JOIN_BEVEL = 2;
    private static final String SOLID_LINE = "[] 0";
    static String FONTMAPPING_PROPERTIES = "/com/ibm/as400/util/reportwriter/fonts/PDFFontMapping.properties";
    private PDFDocument pdfdoc;
    private Hashtable fontTable;
    private Hashtable fonts;
    private PDFResource pdfResources;
    private PDFExtendedFont currentextfont;
    private PDFFont currentpdffont = null;
    private FontProperty currentFont;
    private PDFExtendedFont pdfextfont;
    private OutputStream outstream;
    private PageFormat pageFormat;
    private CSSColor currentColor;
    private PDFContentStream currentStream;
    private double translateY;
    private long hi;
    private boolean firstPage;
    private Properties propertyFile;
    private Image img = null;
    private URL imgsrc = null;
    private Enumeration enum = null;
    private ImageHolder imageHolder = new ImageHolder();

    public PDFContext(OutputStream outputStream, PageFormat pageFormat) throws NullPointerException {
        if (outputStream == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage((String)"nulloutstream"));
        }
        if (pageFormat == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage((String)"nullpf"));
        }
        this.firstPage = true;
        this.fontTable = new Hashtable();
        this.fonts = new Hashtable();
        this.outstream = outputStream;
        this.pageFormat = pageFormat;
        this.currentColor = new CSSColor(1, 1, 1);
        Paper paper = pageFormat.getPaper();
        this.hi = (long)(pageFormat.getHeight() - pageFormat.getImageableY());
        this.propertyFile = new Properties();
        this.loadPropertyFile(FONTMAPPING_PROPERTIES, this.propertyFile);
    }

    public CSSExtent getPageSize() {
        CSSExtent cSSExtent = new CSSExtent();
        cSSExtent.setExtent((long)this.pageFormat.getImageableWidth(), (long)this.pageFormat.getImageableHeight());
        return cSSExtent;
    }

    public long getUnitsPerPoint() {
        return 1L;
    }

    public long getUnitsPerPixel() {
        return 1L;
    }

    private String getEndCap(int n) {
        switch (n) {
            case 0: {
                return Integer.toString(0);
            }
            case 1: {
                return Integer.toString(1);
            }
        }
        return Integer.toString(2);
    }

    private String getLineJoin(int n) {
        switch (n) {
            case 0: {
                return Integer.toString(0);
            }
            case 1: {
                return Integer.toString(1);
            }
        }
        return Integer.toString(2);
    }

    private double round(double d, int n) {
        double d2 = 1.0;
        while (n-- > 0) {
            d2 *= 10.0;
        }
        return (double)Math.round(d * d2) / d2;
    }

    private void setPDFFillColor(CSSColor cSSColor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append(this.round((double)cSSColor.red / 255.0, 3) + " " + this.round((double)cSSColor.green / 255.0, 3) + " " + this.round((double)cSSColor.blue / 255.0, 3) + " rg\r\n");
        try {
            this.currentStream.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setPDFStrokeColor(CSSColor cSSColor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append(this.round((double)cSSColor.red / 255.0, 3) + " " + this.round((double)cSSColor.green / 255.0, 3) + " " + this.round((double)cSSColor.blue / 255.0, 3) + " RG\r\n");
        try {
            this.currentStream.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setPDFStrokeColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append(this.round((double)color.getRed() / 255.0, 3) + " " + this.round((double)color.getGreen() / 255.0, 3) + " " + this.round((double)color.getBlue() / 255.0, 3) + " RG\r\n");
        try {
            this.currentStream.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startDocument() {
        this.pdfdoc = new PDFDocument(this.outstream);
    }

    public void endDocument() {
        this.pdfdoc.endPage();
        this.pdfdoc.endDocument();
        this.pdfdoc.write();
        this.imageHolder.stop();
    }

    public void startViewport(CSSPoint cSSPoint, CSSExtent cSSExtent, boolean bl) {
        if (bl) {
            if (!this.firstPage) {
                this.pdfdoc.endPage();
            }
            this.currentStream = this.pdfdoc.startPage((int)cSSExtent.getWidth(), (int)cSSExtent.getHeight());
            if (!this.firstPage) {
                this.currentpdffont = null;
                if (this.currentextfont != null) {
                    PDFExtendedFont pDFExtendedFont = this.currentextfont;
                    this.setFont(pDFExtendedFont);
                }
            }
            this.firstPage = false;
        }
    }

    public ExtendedFont getExtendedFont(FontProperty fontProperty) {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        int n = (int)fontProperty.getFontSize().getNormalizedLength(new long[]{this.getUnitsPerPixel(), this.getUnitsPerPoint()});
        int n2 = fontProperty.getFontWeight();
        string3 = n2 < 400 ? "light" : (n2 >= 400 && n2 <= 600 ? "normal" : "bold");
        string4 = "normal";
        string5 = "normal";
        String string12 = new Integer(n).toString();
        String string13 = new Integer(n2).toString();
        Vector<String> vector = new Vector<String>();
        vector.addElement(fontProperty.getFontFamily());
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            string2 = (String)enumeration.nextElement();
            string2 = string2.toLowerCase().trim();
            string = "";
            object2 = new StringTokenizer(string2, " ");
            while (((StringTokenizer)object2).hasMoreElements()) {
                string = string + ((StringTokenizer)object2).nextToken();
            }
            if (string.equals("serif") || string.equals("sans-serif") || string.equals("cursive") || string.equals("fantasy") || string.equals("monospace")) {
                string = this.propertyFile.getProperty(string);
            } else if (string.equals("caption") || string.equals("icon") || string.equals("menu") || string.equals("message-box") || string.equals("small-caption") || string.equals("status-bar")) {
                string = this.propertyFile.getProperty(string);
            }
            String string14 = this.propertyFile.getProperty(string);
            if (string14 == null) break;
            object = new StringTokenizer(string14, ",");
            while (((StringTokenizer)object).hasMoreElements() && !bl) {
                string10 = ((StringTokenizer)object).nextToken();
                string6 = this.propertyFile.getProperty(string10 + ".style");
                if (!string6.equals(fontProperty.getFontStyle()) || !(string7 = this.propertyFile.getProperty(string10 + ".weight")).equals(string3)) continue;
                string8 = this.propertyFile.getProperty(string10 + ".variant");
                String string15 = fontProperty.getFontVariant();
                if (!string8.equals(string5) || !(string9 = this.propertyFile.getProperty(string10 + ".stretch")).equals(string4)) continue;
                bl = true;
            }
        }
        if (!bl) {
            string2 = fontProperty.getFontStyle();
            string2 = string2.equals("italic") || string2.equals("oblique") ? "italic" : "normal";
            string = new String();
            string = string3.equals("bold") ? "bold" : "normal";
            object2 = new String();
            object2 = string2.equals("normal") && string.equals("bold") ? "default.bold.normal" : (string2.equals("italic") && string.equals("normal") ? "default.normal.italic" : (string2.equals("italic") && string.equals("bold") ? "default.bold.italic" : "default.normal.normal"));
            object = this.propertyFile.getProperty((String)object2);
            string11 = this.propertyFile.getProperty((String)object + ".filename");
        } else {
            string11 = this.propertyFile.getProperty(string10 + ".filename");
        }
        String string16 = new String(string11 + "." + string12);
        PDFExtendedFont pDFExtendedFont = (PDFExtendedFont)this.fontTable.get(string16);
        if (pDFExtendedFont == null) {
            this.pdfextfont = new PDFExtendedFont(string11, this.propertyFile.getProperty(string10 + ".fontname"), string6, string7, string8, string9, n, this.fonts);
            this.fontTable.put(string16, this.pdfextfont);
        } else {
            this.pdfextfont = pDFExtendedFont;
        }
        return this.pdfextfont;
    }

    public void setFont(ExtendedFont extendedFont) {
        this.currentextfont = (PDFExtendedFont)extendedFont;
        PDFFont pDFFont = this.pdfdoc.addFont(this.currentextfont);
        if (this.currentpdffont != pDFFont) {
            try {
                this.currentStream.write("/" + pDFFont.getName() + " " + extendedFont.getSize() + " Tf\r\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentpdffont = pDFFont;
        }
    }

    public void setTextColor(CSSColor cSSColor) {
        this.currentColor = cSSColor;
        this.setPDFFillColor(this.currentColor);
    }

    public void drawGlyph(char c, CSSPoint cSSPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append("1 0 0 1 " + cSSPoint.x + " " + (this.hi - cSSPoint.y) + " Tm (");
        if (c > '\u007f') {
            stringBuffer = stringBuffer.append("\\");
            stringBuffer = stringBuffer.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '(': {
                    stringBuffer = stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer = stringBuffer.append("\\)");
                    break;
                }
                case '\\': {
                    stringBuffer = stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer = stringBuffer.append(c);
                }
            }
        }
        stringBuffer = stringBuffer.append(") Tj\r\n");
        try {
            this.pdfdoc.startTextMode();
            this.currentStream.write(stringBuffer.toString());
            this.pdfdoc.endTextMode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void drawOrientatedGlyph(char c, CSSPoint cSSPoint, short s) {
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        this.saveGraphicState();
        if (s == 90) {
            d = 1.5707963267948966;
        } else if (s == 180) {
            d = Math.PI;
        } else if (s == 270) {
            d = -1.5707963267948966;
        }
        int n = (int)Math.cos(d);
        int n2 = (int)Math.sin(d);
        stringBuffer = stringBuffer.append(n + " " + n2 + " " + -1 * n2 + " " + n + " " + cSSPoint.x + " " + (this.hi - cSSPoint.y) + " Tm (");
        if (c > '\u007f') {
            stringBuffer = stringBuffer.append("\\");
            stringBuffer = stringBuffer.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '(': {
                    stringBuffer = stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer = stringBuffer.append("\\)");
                    break;
                }
                case '\\': {
                    stringBuffer = stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer = stringBuffer.append(c);
                }
            }
        }
        stringBuffer = stringBuffer.append(") Tj\r\n");
        try {
            this.pdfdoc.startTextMode();
            this.currentStream.write(stringBuffer.toString());
            this.pdfdoc.endTextMode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.restoreGraphicState();
    }

    public void drawString(String string, CSSPoint cSSPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append("1 0 0 1 " + cSSPoint.x + " " + (this.hi - cSSPoint.y) + " Tm (");
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u007f') {
                stringBuffer = stringBuffer.append("\\");
                stringBuffer = stringBuffer.append(Integer.toOctalString(c));
            } else {
                switch (c) {
                    case '(': {
                        stringBuffer = stringBuffer.append("\\(");
                        break;
                    }
                    case ')': {
                        stringBuffer = stringBuffer.append("\\)");
                        break;
                    }
                    case '\\': {
                        stringBuffer = stringBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        stringBuffer = stringBuffer.append(c);
                    }
                }
            }
            ++n2;
        }
        stringBuffer = stringBuffer.append(") Tj\r\n");
        try {
            this.pdfdoc.startTextMode();
            this.currentStream.write(stringBuffer.toString());
            this.pdfdoc.endTextMode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void drawRule(CSSPoint cSSPoint, CSSPoint cSSPoint2, Border border) {
        long l;
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        this.saveGraphicState();
        CSSColor cSSColor = new CSSColor((int)border.color.red, (int)border.color.green, (int)border.color.blue);
        this.setPDFStrokeColor(cSSColor);
        if (border.style == 4) {
            string = this.getEndCap(0);
            string2 = this.getLineJoin(0);
            string3 = SOLID_LINE;
        } else if (border.style == 3) {
            string = this.getEndCap(0);
            string2 = this.getLineJoin(0);
            l = border.width;
            long l2 = border.width;
            long l3 = border.width;
            string3 = "[ " + l + " " + l2 + " ] " + l3;
        } else if (border.style == 2) {
            string = this.getEndCap(1);
            string2 = this.getLineJoin(1);
            l = 0L;
            long l4 = 2L * border.width;
            long l5 = border.width;
            string3 = "[ " + l + " " + l4 + " ] " + l5;
        } else {
            System.err.println(ResourceBundleLoader_rw.getMessage((String)"styleerr") + border.style);
            return;
        }
        int n = (int)(border.width / this.getUnitsPerPixel());
        try {
            this.currentStream.write(string + " J " + string2 + " j\r\n" + " " + string3 + " d " + cSSPoint.x + " " + (this.hi - cSSPoint.y) + " m " + cSSPoint2.x + " " + (this.hi - cSSPoint2.y) + " l " + n + " w S\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void drawSDDBorderEdge(Border border, long l, long l2, long l3, long l4, CSSPoint cSSPoint, CSSExtent cSSExtent) {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        CSSColor cSSColor = new CSSColor((int)border.color.red, (int)border.color.green, (int)border.color.blue);
        this.setPDFStrokeColor(cSSColor);
        if (border.style == 4) {
            string = this.getEndCap(0);
            string2 = this.getLineJoin(0);
            string3 = SOLID_LINE;
        } else if (border.style == 3) {
            string = this.getEndCap(0);
            string2 = this.getLineJoin(0);
            long l5 = border.width;
            long l6 = border.width;
            long l7 = border.width;
            string3 = "[ " + l5 + " " + l6 + " ] " + l7;
        } else if (border.style == 2) {
            string = this.getEndCap(1);
            string2 = this.getLineJoin(1);
            long l8 = 0L;
            long l9 = 2L * border.width;
            long l10 = border.width;
            string3 = "[ " + l8 + " " + l9 + " ] " + l10;
        } else {
            return;
        }
        try {
            this.currentStream.write(string + " J " + string2 + " j\r\n" + " " + string3 + " d " + l + " " + l2 + " m " + l3 + " " + l4 + " l " + border.width + " w S\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void drawBorder(Border border, Border border2, Border border3, Border border4, CSSPoint cSSPoint, CSSExtent cSSExtent) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        PDFFourEdgeBorder pDFFourEdgeBorder = null;
        PDFOutsetInsetBorder pDFOutsetInsetBorder = null;
        PDFRidgeGrooveBorder pDFRidgeGrooveBorder = null;
        TBRL tBRL = new TBRL();
        CSSPoint cSSPoint2 = new CSSPoint(cSSPoint.x, cSSPoint.y);
        cSSPoint2.x /= this.getUnitsPerPixel();
        cSSPoint2.y /= this.getUnitsPerPixel();
        CSSExtent cSSExtent2 = new CSSExtent(cSSExtent.width, cSSExtent.height);
        cSSExtent2.width /= this.getUnitsPerPixel();
        cSSExtent2.height /= this.getUnitsPerPixel();
        Border border5 = new Border(border.color, border.width, (int)border.style);
        border5.width /= this.getUnitsPerPixel();
        Border border6 = new Border(border2.color, border2.width, (int)border2.style);
        border6.width /= this.getUnitsPerPixel();
        Border border7 = new Border(border3.color, border3.width, (int)border3.style);
        border7.width /= this.getUnitsPerPixel();
        Border border8 = new Border(border4.color, border4.width, (int)border4.style);
        border8.width /= this.getUnitsPerPixel();
        cSSPoint.x += border2.width;
        if (0 != border5.style && 1 != border5.style && null != border5.color && 0L != border5.width) {
            if (border5.style == 4 || border5.style == 3 || border5.style == 2) {
                l5 = cSSPoint2.x;
                l4 = cSSPoint2.x + cSSExtent2.width;
                l3 = this.hi - cSSPoint2.y - border5.width / 2L;
                this.saveGraphicState();
                if (border5.style == 2) {
                    l2 = l4 - l5;
                    l = border5.width;
                    try {
                        this.currentStream.write(l5 + " " + (l3 - border5.width / 2L) + " " + l2 + " " + l + " " + "re W n\r\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.drawSDDBorderEdge(border5, l5, l3, l4, l3, cSSPoint2, cSSExtent2);
                this.restoreGraphicState();
                tBRL.setTop((int)border5.width, border5.style);
            } else if (border5.style == 5) {
                if (pDFFourEdgeBorder == null) {
                    pDFFourEdgeBorder = new PDFVariableWidthDoubleBorder();
                }
                pDFFourEdgeBorder.setTopEdge(border5.color, (int)border5.width);
            } else if (border5.style == 7 || border5.style == 6) {
                if (pDFRidgeGrooveBorder == null) {
                    pDFRidgeGrooveBorder = new PDFRidgeGrooveBorder();
                }
                int n = border5.style == 6 ? 2 : 1;
                pDFRidgeGrooveBorder.setTopEdge(border5.color, (int)border5.width, n);
                tBRL.setTop((int)border5.width, border5.style);
            } else if (border5.style == 9 || border5.style == 8) {
                if (pDFOutsetInsetBorder == null) {
                    pDFOutsetInsetBorder = new PDFOutsetInsetBorder();
                }
                int n = border5.style == 9 ? 1 : 2;
                pDFOutsetInsetBorder.setTopEdge(border5.color, (int)border5.width, n);
                tBRL.setTop((int)border5.width, border5.style);
            }
        }
        if (0 != border7.style && 1 != border7.style && null != border7.color && 0L != border7.width) {
            if (border7.style == 4 || border7.style == 3 || border7.style == 2) {
                l5 = cSSPoint2.x + cSSExtent2.width;
                l4 = cSSPoint2.x;
                l3 = this.hi - cSSPoint2.y - cSSExtent2.height + (border7.width + 1L) / 2L;
                this.saveGraphicState();
                if (border7.style == 2) {
                    l2 = l4 - l5;
                    l = border7.width;
                    try {
                        this.currentStream.write(l5 + " " + (l3 - border7.width / 2L) + " " + l2 + " " + l + " " + "re W n\r\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.drawSDDBorderEdge(border7, l5, l3, l4, l3, cSSPoint2, cSSExtent2);
                this.restoreGraphicState();
                tBRL.setBottom((int)border7.width, border7.style);
            } else if (border7.style == 5) {
                if (pDFFourEdgeBorder == null) {
                    pDFFourEdgeBorder = new PDFVariableWidthDoubleBorder();
                }
                pDFFourEdgeBorder.setBottomEdge(border7.color, (int)border7.width);
            } else if (border7.style == 7 || border7.style == 6) {
                if (pDFRidgeGrooveBorder == null) {
                    pDFRidgeGrooveBorder = new PDFRidgeGrooveBorder();
                }
                int n = border7.style == 6 ? 2 : 1;
                pDFRidgeGrooveBorder.setBottomEdge(border7.color, (int)border7.width, n);
                tBRL.setBottom((int)border7.width, border7.style);
            } else if (border7.style == 9 || border7.style == 8) {
                if (pDFOutsetInsetBorder == null) {
                    pDFOutsetInsetBorder = new PDFOutsetInsetBorder();
                }
                int n = border7.style == 9 ? 1 : 2;
                pDFOutsetInsetBorder.setBottomEdge(border7.color, (int)border7.width, n);
                tBRL.setBottom((int)border7.width, border7.style);
            }
        }
        if (0 != border8.style && 1 != border8.style && null != border8.color && 0L != border8.width) {
            if (border8.style == 4 || border8.style == 3 || border8.style == 2) {
                long l6 = cSSPoint2.x + cSSExtent2.width - border8.width / 2L;
                l4 = this.hi - cSSPoint2.y;
                l3 = this.hi - cSSPoint2.y - cSSExtent2.height;
                this.saveGraphicState();
                if (border8.style == 2) {
                    l2 = l3 - l4;
                    l = border8.width;
                    try {
                        this.currentStream.write(l6 - border8.width / 2L + " " + l4 + " " + l + " " + l2 + " " + "re W n\r\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.drawSDDBorderEdge(border8, l6, l4, l6, l3, cSSPoint2, cSSExtent2);
                this.restoreGraphicState();
                tBRL.setRight((int)border8.width, border8.style);
            } else if (border8.style == 5) {
                if (pDFFourEdgeBorder == null) {
                    pDFFourEdgeBorder = new PDFVariableWidthDoubleBorder();
                }
                pDFFourEdgeBorder.setRightEdge(border8.color, (int)border8.width);
            } else if (border8.style == 7 || border8.style == 6) {
                if (pDFRidgeGrooveBorder == null) {
                    pDFRidgeGrooveBorder = new PDFRidgeGrooveBorder();
                }
                int n = border8.style == 6 ? 2 : 1;
                pDFRidgeGrooveBorder.setRightEdge(border8.color, (int)border8.width, n);
                tBRL.setRight((int)border8.width, border8.style);
            } else if (border8.style == 9 || border8.style == 8) {
                if (pDFOutsetInsetBorder == null) {
                    pDFOutsetInsetBorder = new PDFOutsetInsetBorder();
                }
                int n = border8.style == 9 ? 1 : 2;
                pDFOutsetInsetBorder.setRightEdge(border8.color, (int)border8.width, n);
                tBRL.setRight((int)border8.width, border8.style);
            }
        }
        if (0 != border6.style && 1 != border6.style && null != border6.color && 0L != border6.width) {
            if (border6.style == 4 || border6.style == 3 || border6.style == 2) {
                long l7 = cSSPoint2.x + border6.width / 2L;
                l4 = this.hi - cSSPoint2.y - cSSExtent2.height;
                l3 = this.hi - cSSPoint2.y;
                this.saveGraphicState();
                if (border6.style == 2) {
                    l2 = l3 - l4;
                    l = border6.width;
                    try {
                        this.currentStream.write(l7 - border6.width / 2L + " " + l4 + " " + l + " " + l2 + " " + "re W n\r\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.drawSDDBorderEdge(border6, l7, l4, l7, l3, cSSPoint2, cSSExtent2);
                this.restoreGraphicState();
                tBRL.setLeft((int)border6.width, border6.style);
            } else if (border6.style == 5) {
                if (pDFFourEdgeBorder == null) {
                    pDFFourEdgeBorder = new PDFVariableWidthDoubleBorder();
                }
                pDFFourEdgeBorder.setLeftEdge(border6.color, (int)border6.width);
            } else if (border6.style == 7 || border6.style == 6) {
                if (pDFRidgeGrooveBorder == null) {
                    pDFRidgeGrooveBorder = new PDFRidgeGrooveBorder();
                }
                int n = border6.style == 6 ? 2 : 1;
                pDFRidgeGrooveBorder.setLeftEdge(border6.color, (int)border6.width, n);
                tBRL.setLeft((int)border6.width, border6.style);
            } else if (border6.style == 9 || border6.style == 8) {
                if (pDFOutsetInsetBorder == null) {
                    pDFOutsetInsetBorder = new PDFOutsetInsetBorder();
                }
                int n = border6.style == 9 ? 1 : 2;
                pDFOutsetInsetBorder.setLeftEdge(border6.color, (int)border6.width, n);
                tBRL.setLeft((int)border6.width, border6.style);
            }
        }
        if (pDFFourEdgeBorder != null) {
            pDFFourEdgeBorder.setDependancies(tBRL);
            ((PDFVariableWidthDoubleBorder)pDFFourEdgeBorder).paintBorder(this, (int)cSSPoint2.x, (int)cSSPoint2.y, (int)cSSExtent2.width, (int)cSSExtent2.height);
        }
        if (pDFRidgeGrooveBorder != null) {
            pDFRidgeGrooveBorder.paintBorder(this, (int)cSSPoint2.x, (int)cSSPoint2.y, (int)cSSExtent2.width, (int)cSSExtent2.height);
        }
        if (pDFOutsetInsetBorder != null) {
            pDFOutsetInsetBorder.paintBorder(this, (int)cSSPoint2.x, (int)cSSPoint2.y, (int)cSSExtent2.width, (int)cSSExtent2.height);
        }
    }

    public void fillBackground(CSSPoint cSSPoint, CSSExtent cSSExtent, CSSColor cSSColor) {
        try {
            this.currentStream.write(this.round((double)cSSColor.red / 255.0, 3) + " " + this.round((double)cSSColor.green / 255.0, 3) + " " + this.round((double)cSSColor.blue / 255.0, 3) + " rg\r\n" + cSSPoint.x + " " + (this.hi - cSSPoint.y - cSSExtent.height) + " " + cSSExtent.width + " " + cSSExtent.height + " re f\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void fillBackground(CSSPoint cSSPoint, CSSExtent cSSExtent, String string, CSSPoint cSSPoint2, int n) {
        Image image = null;
        PDFXObject pDFXObject = null;
        image = this.imageHolder.getImage(string);
        if (image == null) {
            System.err.println(ResourceBundleLoader_rw.getMessage((String)"nullimage") + string);
            return;
        }
        pDFXObject = this.pdfdoc.addImage(image, string);
        Dimension dimension = this.imageHolder.getDimension(string);
        try {
            this.currentStream.write("q\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.currentStream.write(cSSPoint.x + " " + (this.hi - cSSPoint.y - cSSExtent.height) + " " + cSSExtent.width + " " + cSSExtent.height + " " + "re W n\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        switch (n) {
            case 0: {
                int n2 = (int)cSSPoint.x + (int)cSSPoint2.x;
                int n3 = (int)cSSPoint.y + (int)cSSPoint2.y;
                try {
                    this.currentStream.write("q\r\n" + image.getWidth(null) + " 0 0 " + image.getHeight(null) + " " + n2 + " " + (this.hi - (long)n3 - (long)image.getHeight(null)) + " cm\r\n" + "/" + pDFXObject.getName() + " Do \r\n" + "Q\r\n");
                }
                catch (IOException iOException) {}
                break;
            }
            case 1: {
                Dimension dimension2 = this.getStartOffset(cSSPoint2, dimension);
                int n4 = 0;
                while ((long)n4 < cSSExtent.height + (long)(2 * dimension.height)) {
                    int n5 = 0;
                    while ((long)n5 < cSSExtent.width + (long)(2 * dimension.width)) {
                        int n6 = (int)cSSPoint.x + (int)cSSPoint2.x + dimension2.width + n5;
                        int n7 = (int)cSSPoint.y + (int)cSSPoint2.y + dimension2.height + n4;
                        try {
                            this.currentStream.write("q\r\n" + image.getWidth(null) + " 0 0 " + image.getHeight(null) + " " + n6 + " " + (this.hi - (long)n7 - (long)image.getHeight(null)) + " cm\r\n" + "/" + pDFXObject.getName() + " Do \r\n" + "Q\r\n");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        n5 += dimension.width;
                    }
                    n4 += dimension.height;
                }
                break;
            }
            case 2: {
                Dimension dimension3 = this.getStartOffset(cSSPoint2, dimension);
                int n8 = (int)cSSPoint.y + (int)cSSPoint2.y;
                int n9 = 0;
                while ((long)n9 < cSSExtent.width + (long)(2 * dimension.width)) {
                    int n10 = (int)cSSPoint.x + (int)cSSPoint2.x + dimension3.width + n9;
                    try {
                        this.currentStream.write("q\r\n" + image.getWidth(null) + " 0 0 " + image.getHeight(null) + " " + n10 + " " + (this.hi - (long)n8 - (long)image.getHeight(null)) + " cm\r\n" + "/" + pDFXObject.getName() + " Do \r\n" + "Q\r\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    n9 += dimension.width;
                }
                break;
            }
            case 3: {
                Dimension dimension4 = this.getStartOffset(cSSPoint2, dimension);
                int n11 = (int)cSSPoint.x + (int)cSSPoint2.x;
                int n12 = 0;
                while ((long)n12 < cSSExtent.height + (long)(2 * dimension.height)) {
                    int n13 = (int)cSSPoint.y + (int)cSSPoint2.y + dimension4.height + n12;
                    try {
                        this.currentStream.write("q\r\n" + image.getWidth(null) + " 0 0 " + image.getHeight(null) + " " + n11 + " " + (this.hi - (long)n13 - (long)image.getHeight(null)) + " cm\r\n" + "/" + pDFXObject.getName() + " Do \r\n" + "Q\r\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    n12 += dimension.height;
                }
                break;
            }
            default: {
                System.err.println(ResourceBundleLoader_rw.getMessage((String)"repeatnotvalid") + (short)n);
            }
        }
        try {
            this.currentStream.write("Q\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Dimension getStartOffset(CSSPoint cSSPoint, Dimension dimension) {
        int n = 0;
        int n2 = 0;
        if (cSSPoint.x != 0L) {
            n2 = (int)(-((long)dimension.width - cSSPoint.x % (long)dimension.width));
        }
        if (cSSPoint.y != 0L) {
            n = (int)(-((long)dimension.height - cSSPoint.y % (long)dimension.height));
        }
        return new Dimension(n2, n);
    }

    public void notifyGraphic(URL uRL) {
        this.imageHolder.insertURI(uRL);
    }

    public void drawGraphic(String string, CSSPoint cSSPoint, CSSExtent cSSExtent) {
        PDFXObject pDFXObject = null;
        Image image = this.imageHolder.getImage(string);
        if (null != image) {
            pDFXObject = this.pdfdoc.addImage(image, string);
            try {
                try {
                    this.currentStream.write("q\r\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentStream.write(cSSExtent.width + " 0 0 " + cSSExtent.height + " " + cSSPoint.x + " " + (this.hi - cSSPoint.y - (long)image.getHeight(null)) + " cm\r\n" + "/" + pDFXObject.getName() + " Do \r\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.currentStream.write("Q\r\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public CSSExtent getGraphicDimension(String string) {
        Dimension dimension = this.imageHolder.getDimension(string);
        return new CSSExtent((long)dimension.width, (long)dimension.height);
    }

    private void loadPropertyFile(String string, Properties properties) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void saveGraphicState() {
        try {
            this.currentStream.write("q\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void restoreGraphicState() {
        try {
            this.currentStream.write("Q\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setXform(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.currentStream.write(n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + n6 + " cm\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void drawLine(int n, int n2, int n3, int n4, int n5) {
        try {
            this.currentStream.write(n + " " + (this.hi - (long)n2) + " " + "m" + " " + n3 + " " + (this.hi - (long)n4) + " " + "l" + " " + n5 + " w S\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void drawRectangle(int n, int n2, int n3, int n4, int n5) {
        try {
            this.currentStream.write(n5 + " " + "w" + " " + (n + n5 / 2) + " " + (this.hi - (long)n2 - (long)n4 + (long)(n5 / 2)) + " " + n3 + " " + (n4 - n5) + " " + "re S\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

