/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pdfwriter;

import com.ibm.as400.util.reportwriter.fonts.AFMChar;
import com.ibm.as400.util.reportwriter.fonts.AFMFont;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.framework.ExtendedFont;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class PDFExtendedFont
implements ExtendedFont {
    private AFMFont font;
    private String fontname;
    private String style;
    private int weight;
    private String variance;
    private int size;
    private int characters;
    private int[] depths;
    private int[] heights;
    private int[] widths;
    private double ascent;
    private double descent;
    private String ascentmetric;
    private String descentmetric;
    private double height;
    private double leading;
    private String capheightmetric;
    private String italicanglemetric;
    private Vector fontbbox = new Vector();
    private static char[] glyph = new char[1];

    public PDFExtendedFont(String string, String string2, String string3, String string4, String string5, String string6, int n, Hashtable hashtable) {
        this.weight = string4 == "light" ? 300 : (string4 == "normal" ? 400 : 700);
        this.variance = string5;
        this.size = n;
        this.fontname = string2;
        this.style = string3;
        this.font = (AFMFont)hashtable.get(string);
        if (this.font == null) {
            try {
                this.font = new AFMFont(string);
                hashtable.put(string, this.font);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ascent = this.font.getAscent();
        this.ascentmetric = this.font.getAscentMetric();
        this.descent = this.font.getDescent();
        this.descentmetric = this.font.getDescentMetric();
        this.fontbbox = this.font.getFontBBoxMetric();
        this.height = this.font.getMaxHeight();
        this.fontname = this.font.getFontName();
        this.capheightmetric = this.font.getCapHeightMetric();
        this.italicanglemetric = this.font.getItalicAngleMetric_0();
    }

    public long getAscent() {
        return (long)(this.stringToDouble((String)this.fontbbox.elementAt(3)) / 1000.0 * (double)this.size);
    }

    protected String getAscentMetric() {
        return this.ascentmetric;
    }

    public long getDescent() {
        return (long)(this.stringToDouble((String)this.fontbbox.elementAt(1)) / 1000.0 * (double)this.size * -1.0);
    }

    protected String getDescentMetric() {
        return this.descentmetric;
    }

    public long getHeight() {
        return (long)(this.height * (double)this.size);
    }

    protected Vector getFontBBoxMetric() {
        return this.fontbbox;
    }

    protected String getCapHeightMetric() {
        return this.capheightmetric;
    }

    protected String getItalicAngleMetric() {
        return this.italicanglemetric;
    }

    public long getCharacterHeight(char c) {
        AFMChar aFMChar = this.font.getAFMCharacter(c);
        double d = this.stringToDouble(aFMChar.getury());
        if (d < 0.0) {
            return 0L;
        }
        return (long)(d / 1000.0 * (double)this.size);
    }

    public long getCharacterDepth(char c) {
        AFMChar aFMChar = this.font.getAFMCharacter(c);
        double d = this.stringToDouble(aFMChar.getlly());
        if (d > 0.0) {
            return 0L;
        }
        return (long)(d / 1000.0 * (double)this.size * -1.0);
    }

    public long getCharacterVerticalThickness(char c) {
        AFMChar aFMChar = this.font.getAFMCharacter(c);
        double d = this.stringToDouble(aFMChar.getlly());
        double d2 = this.stringToDouble(aFMChar.getury());
        return (long)((d2 - d) / 1000.0 * (double)this.size);
    }

    public long getCharacterWidth(char c) {
        return (long)(this.font.getCharacterWidth(c) * (double)this.size);
    }

    protected String getCharacterWidthMetric(char c) {
        return this.font.getCharacterWidthMetric(c);
    }

    public CSSExtent getTextExtent(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 == string.length()) {
            char c = string.charAt(n2);
            int n3 = (int)this.getCharacterWidth(c);
            n += n3;
            ++n2;
        }
        return new CSSExtent((long)n * (long)this.size, this.getHeight() * (long)this.size);
    }

    public long getLeading() {
        return (long)(1.1 * this.height * (double)this.size);
    }

    public String getFaceName() {
        return this.fontname;
    }

    public String getStyle() {
        return this.style;
    }

    public long getWeight() {
        return this.weight;
    }

    public String getVariance() {
        return this.variance;
    }

    public long getSize() {
        return this.size;
    }

    private double stringToDouble(String string) {
        return Double.valueOf(string);
    }
}

