/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pdfwriter;

import com.ibm.as400.util.reportwriter.pdfwriter.PDFContext;
import com.ibm.as400.util.reportwriter.pdfwriter.PDFFourEdgeBorder;
import com.ibm.xsl.composer.csstypes.CSSColor;
import java.awt.Color;

public class PDFOutsetInsetBorder
extends PDFFourEdgeBorder {
    public static final int NO_STYLE = 0;
    public static final int OUTSET = 1;
    public static final int INSET = 2;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;
    protected int topStyle = 0;
    protected int bottomStyle = 0;
    protected int rightStyle = 0;
    protected int leftStyle = 0;
    protected int lineWidth = 1;
    private PDFContext pdfcontext;

    public PDFOutsetInsetBorder() {
        this.borderWidth = 2;
    }

    public PDFOutsetInsetBorder(int n, int n2) {
        this(n);
        this.borderWidth = n2;
    }

    public PDFOutsetInsetBorder(int n) {
        this.bevelType = n;
        this.borderWidth = 2;
    }

    public PDFOutsetInsetBorder(int n, Color color, Color color2) {
        this(n, color.brighter(), color, color2, color2.brighter());
    }

    public PDFOutsetInsetBorder(int n, Color color, Color color2, Color color3, Color color4) {
        this(n);
        this.highlightOuter = color;
        this.highlightInner = color2;
        this.shadowOuter = color3;
        this.shadowInner = color4;
    }

    public void paintBorder(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        this.pdfcontext = pDFContext;
        this.pdfcontext.saveGraphicState();
        if (this.topEdge && this.topStyle == 1 && this.topWidth > 0) {
            this.paintTopOutset(this.pdfcontext, n, n2, n3, n4);
        }
        if (this.bottomEdge && this.bottomStyle == 1 && this.bottomWidth > 0) {
            this.paintBottomOutset(this.pdfcontext, n, n2, n3, n4);
        }
        if (this.rightEdge && this.rightStyle == 1 && this.rightWidth > 0) {
            this.paintRightOutset(this.pdfcontext, n, n2, n3, n4);
        }
        if (this.leftEdge && this.leftStyle == 1 && this.leftWidth > 0) {
            this.paintLeftOutset(this.pdfcontext, n, n2, n3, n4);
        }
        if (this.topEdge && this.topStyle == 2 && this.topWidth > 0) {
            this.paintTopInset(this.pdfcontext, n, n2, n3, n4);
        }
        if (this.bottomEdge && this.bottomStyle == 2 && this.bottomWidth > 0) {
            this.paintBottomInset(this.pdfcontext, n, n2, n3, n4);
        }
        if (this.rightEdge && this.rightStyle == 2 && this.rightWidth > 0) {
            this.paintRightInset(this.pdfcontext, n, n2, n3, n4);
        }
        if (this.leftEdge && this.leftStyle == 2 && this.leftWidth > 0) {
            this.paintLeftInset(this.pdfcontext, n, n2, n3, n4);
        }
        this.pdfcontext.restoreGraphicState();
    }

    public Color getHighlightOuterColor(Color color) {
        return color.brighter().brighter();
    }

    public Color getHighlightInnerColor(Color color) {
        return color.brighter();
    }

    public Color getShadowInnerColor(Color color) {
        return color.darker();
    }

    public Color getShadowOuterColor(Color color) {
        return color.darker().darker();
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintTopInset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getShadowInnerColor(this.topColor);
        Color color2 = this.getShadowOuterColor(this.topColor);
        this.drawTop(pDFContext, color, color2, this.topWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void paintBottomInset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getHighlightOuterColor(this.bottomColor);
        Color color2 = this.getHighlightInnerColor(this.bottomColor);
        this.drawBottom(pDFContext, color, color2, this.bottomWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void paintRightInset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getHighlightOuterColor(this.rightColor);
        Color color2 = this.getHighlightInnerColor(this.rightColor);
        this.drawRight(pDFContext, color, color2, this.rightWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void paintLeftInset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getShadowInnerColor(this.leftColor);
        Color color2 = this.getShadowOuterColor(this.leftColor);
        this.drawLeft(pDFContext, color, color2, this.leftWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void paintTopOutset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getHighlightOuterColor(this.topColor);
        Color color2 = this.getHighlightInnerColor(this.topColor);
        this.drawTop(pDFContext, color, color2, this.topWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void paintBottomOutset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getShadowOuterColor(this.bottomColor);
        Color color2 = this.getShadowInnerColor(this.bottomColor);
        this.drawBottom(pDFContext, color, color2, this.bottomWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void paintRightOutset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getShadowOuterColor(this.rightColor);
        Color color2 = this.getShadowInnerColor(this.rightColor);
        this.drawRight(pDFContext, color, color2, this.rightWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void paintLeftOutset(PDFContext pDFContext, int n, int n2, int n3, int n4) {
        pDFContext.saveGraphicState();
        pDFContext.setXform(1, 0, 0, 1, n, -n2);
        Color color = this.getHighlightOuterColor(this.leftColor);
        Color color2 = this.getHighlightInnerColor(this.leftColor);
        this.drawLeft(pDFContext, color, color2, this.leftWidth, n3, n4);
        pDFContext.restoreGraphicState();
    }

    protected void drawTop(PDFContext pDFContext, Color color, Color color2, int n, int n2, int n3) {
        pDFContext.setPDFStrokeColor(color);
        int n4 = n / 2;
        int n5 = 0;
        while (n5 <= n4) {
            pDFContext.drawLine(n5, n5, n2 - 1 - n5, n5, this.lineWidth);
            ++n5;
        }
        pDFContext.setPDFStrokeColor(color2);
        while (n5 < n) {
            pDFContext.drawLine(n5, n5, n2 - 1 - n5, n5, this.lineWidth);
            ++n5;
        }
    }

    protected void drawBottom(PDFContext pDFContext, Color color, Color color2, int n, int n2, int n3) {
        pDFContext.setPDFStrokeColor(color);
        int n4 = n / 2;
        int n5 = 0;
        while (n5 <= n4) {
            pDFContext.drawLine(n5, n3 - 1 - n5, n2 - 1 - n5, n3 - 1 - n5, this.lineWidth);
            ++n5;
        }
        pDFContext.setPDFStrokeColor(color2);
        while (n5 < n) {
            pDFContext.drawLine(n5, n3 - 1 - n5, n2 - 1 - n5, n3 - 1 - n5, this.lineWidth);
            ++n5;
        }
    }

    protected void drawRight(PDFContext pDFContext, Color color, Color color2, int n, int n2, int n3) {
        pDFContext.setPDFStrokeColor(color);
        int n4 = n / 2;
        int n5 = 0;
        while (n5 <= n4) {
            pDFContext.drawLine(n2 - 1 - n5, n5, n2 - 1 - n5, n3 - 1 - n5, this.lineWidth);
            ++n5;
        }
        pDFContext.setPDFStrokeColor(color2);
        while (n5 < n) {
            pDFContext.drawLine(n2 - 1 - n5, n5, n2 - 1 - n5, n3 - 1 - n5, this.lineWidth);
            ++n5;
        }
    }

    protected void drawLeft(PDFContext pDFContext, Color color, Color color2, int n, int n2, int n3) {
        pDFContext.setPDFStrokeColor(color);
        int n4 = n / 2;
        int n5 = 0;
        while (n5 <= n4) {
            pDFContext.drawLine(n5, n5, n5, n3 - 1 - n5, this.lineWidth);
            ++n5;
        }
        pDFContext.setPDFStrokeColor(color2);
        while (n5 < n) {
            pDFContext.drawLine(n5, n5, n5, n3 - 1 - n5, this.lineWidth);
            ++n5;
        }
    }

    public void setTopEdge(CSSColor cSSColor, int n, int n2) {
        super.setTopEdge(cSSColor, n);
        this.topStyle = n2;
    }

    public void setBottomEdge(CSSColor cSSColor, int n, int n2) {
        super.setBottomEdge(cSSColor, n);
        this.bottomStyle = n2;
    }

    public void setRightEdge(CSSColor cSSColor, int n, int n2) {
        super.setRightEdge(cSSColor, n);
        this.rightStyle = n2;
    }

    public void setLeftEdge(CSSColor cSSColor, int n, int n2) {
        super.setLeftEdge(cSSColor, n);
        this.leftStyle = n2;
    }
}

