/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.pdfwriter;

import com.ibm.as400.util.reportwriter.pdfwriter.PDFObject;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PDFXObject
extends PDFObject {
    private String name_;
    private int height_;
    private ByteArrayOutputStream imageData_ = new ByteArrayOutputStream();
    private int width_;

    public PDFXObject(int n, Image image) throws IOException {
        super(n);
        this.name_ = "Im" + n;
        this.height_ = image.getHeight(null);
        this.width_ = image.getWidth(null);
        int[] nArray = new int[this.width_ * this.height_];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width_, this.height_, nArray, 0, this.width_);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        int n2 = 0;
        while (n2 < this.height_) {
            int n3 = 0;
            while (n3 < this.width_) {
                int n4 = nArray[n2 * this.width_ + n3];
                String string = Integer.toHexString(colorModel.getRed(n4));
                String string2 = Integer.toHexString(colorModel.getGreen(n4));
                String string3 = Integer.toHexString(colorModel.getBlue(n4));
                if (string.length() == 1) {
                    string = "0" + string;
                }
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                String string4 = string + string2 + string3;
                this.imageData_.write(string4.getBytes());
                ++n3;
            }
            ++n2;
        }
    }

    public String getName() {
        return this.name_;
    }

    public String toPDF() {
        String string = new String();
        string = this.getNumber() + " 0 obj\r\n<<\r\n/Type /XObject\r\n" + "/Subtype /Image\r\n" + "/Name /" + this.name_ + "\r\n" + "/Width " + this.width_ + "\r\n" + "/Height " + this.height_ + "\r\n" + "/BitsPerComponent 8\r\n" + "/ColorSpace /DeviceRGB\r\n" + "/Filter [/ASCIIHexDecode]\r\n" + "/Length " + (this.imageData_.size() + 2 + 1) + "\r\n>>\r\nstream\r\n" + this.imageData_.toString() + "> \r\nendstream\r\nendobj\r\n";
        this.setByteCount(string.length());
        return string;
    }
}

