/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLSAXErrorHandler;
import com.ibm.as400.ui.tools.CompileManager;
import com.ibm.as400.ui.tools.DataBeanParser;
import com.ibm.as400.ui.tools.GUIConstants;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.RC2XML;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class DataBeanGenerator
implements DocumentHandler {
    private String m_PDMLPackage = null;
    private String m_lastDataClass = "";
    private String m_directory = null;
    private Hashtable m_dataBeans = new Hashtable();
    private PrintWriter m_output = null;
    private static final String m_indent = "    ";
    private boolean m_bElementTrace = false;
    private DataBeanParser m_parser = null;
    private Vector m_newInitializers = new Vector();
    private boolean m_bOldSchool = false;
    private Stack m_stack = null;
    private String m_chars = "";
    private DataClass m_bean = null;
    private Attribute m_attr = null;
    private String m_element = null;

    public DataBeanGenerator(String string) throws FileNotFoundException, IOException, ParseException, MissingResourceException {
        this(string, null);
    }

    public DataBeanGenerator(String string, Locale locale) throws FileNotFoundException, IOException, ParseException, MissingResourceException {
        this.parseXML(string.replace('\\', '/'), locale);
        Enumeration enumeration = this.m_dataBeans.elements();
        while (enumeration.hasMoreElements()) {
            DataClass dataClass = (DataClass)enumeration.nextElement();
            if (!this.isGenerationRequired(dataClass)) continue;
            this.writeDataClass(dataClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void parseXML(String var1_1, Locale var2_2) throws FileNotFoundException, IOException, ParseException, MissingResourceException {
        var3_3 = null;
        var4_4 = SystemResourceFinder.getPDMLHeader();
        if (var1_1.toLowerCase().endsWith(".pdml") || var1_1.toLowerCase().endsWith(".pdmlsrc")) {
            try {
                var3_3 = new BufferedInputStream(new FileInputStream(var1_1));
                var5_5 = var1_1.lastIndexOf(47);
                if (var5_5 <= -1) ** GOTO lbl20
                this.m_directory = var1_1.substring(0, var5_5);
            }
            catch (FileNotFoundException var5_6) {
                var6_8 = new Object[]{var1_1};
                var7_10 = MessageFormat.format(GUIFactory.getString("IDS_PDML_NOT_FOUND"), var6_8);
                if (var3_3 != null) {
                    var3_3.close();
                }
                if (var4_4 != null) {
                    var4_4.close();
                }
                throw new FileNotFoundException(var7_10);
            }
        } else {
            var3_3 = SystemResourceFinder.getPDMLDocument((String)var1_1, (Locale)var2_2);
            var1_1 = var1_1 + SystemResourceFinder.getLastDocumentLocale() + ".pdml";
        }
lbl20:
        // 3 sources

        var5_7 = new XMLSAXErrorHandler(var1_1, SystemResourceFinder.getHeaderLineCount());
        var6_9 = XMLPanelDefinition.getParser((Object)this, (XMLSAXErrorHandler)var5_7);
        var7_11 = new SequenceInputStream(var4_4, var3_3);
        try {
            var8_12 = new InputSource(var7_11);
            XMLPanelDefinition.introspectMethod((Object)var6_9, (String)"parse", (Object[])new Object[]{var8_12}, (Class[])new Class[]{var8_12.getClass()});
            var10_13 = null;
            ** if (var7_11 == null) goto lbl-1000
        }
        catch (Throwable var9_15) {
            var10_14 = null;
            if (var7_11 != null) {
                var7_11.close();
            }
            throw var9_15;
        }
lbl-1000:
        // 1 sources

        {
            var7_11.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        var8_12 = var5_7.getException();
        if (var8_12 != null) {
            throw var8_12;
        }
    }

    private String getPackageAttribute(AttributeList attributeList) {
        int n = 0;
        while (n < attributeList.getLength()) {
            String string = attributeList.getName(n);
            String string2 = attributeList.getValue(n).trim();
            if (string.equalsIgnoreCase("PACKAGE")) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    private String getAttributeValue(AttributeList attributeList, String string) {
        int n = 0;
        while (n < attributeList.getLength()) {
            String string2 = attributeList.getName(n);
            String string3 = attributeList.getValue(n).trim();
            if (string2.equalsIgnoreCase(string)) {
                return string3;
            }
            ++n;
        }
        return null;
    }

    public void startDocument() {
        this.m_stack = new Stack();
    }

    public void endDocument() {
        this.m_stack = null;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (string.equalsIgnoreCase("PDML")) {
            this.m_PDMLPackage = this.getPackageAttribute(attributeList);
        } else if (string.equalsIgnoreCase("DATACLASS")) {
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("ATTRIBUTE")) {
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("INTEGER") || string.equalsIgnoreCase("SHORT") || string.equalsIgnoreCase("LONG") || string.equals("FLOAT") || string.equalsIgnoreCase("STRING") || string.equalsIgnoreCase("PERCENT")) {
            if (this.m_attr != null) {
                this.m_attr.m_format = string;
            }
        } else if (string.equalsIgnoreCase("DATE") || string.equalsIgnoreCase("TIME")) {
            if (this.m_attr != null) {
                this.m_attr.m_format = string;
            }
            this.m_bean.m_hasDate = true;
        } else if (string.equalsIgnoreCase("COLUMN")) {
            String string2 = this.getAttributeValue(attributeList, "TREECOLUMN");
            this.m_element = string2.equalsIgnoreCase("YES") ? "TREECOLUMN" : string;
        } else if (string.equalsIgnoreCase("RADIOBUTTON") || string.equalsIgnoreCase("CHECKBOX") || string.equalsIgnoreCase("TEXTFIELD") || string.equalsIgnoreCase("TEXTAREA") || string.equalsIgnoreCase("LABEL") || string.equalsIgnoreCase("SPINNER") || string.equalsIgnoreCase("BUTTONGROUP") || string.equalsIgnoreCase("SLIDER") || string.equalsIgnoreCase("COMBOBOX") || string.equalsIgnoreCase("LIST") || string.equalsIgnoreCase("TREE")) {
            this.m_element = string;
        }
    }

    public void endElement(String string) {
        if (!this.m_chars.equals("")) {
            this.writeChars();
            this.m_chars = "";
        }
        if (!this.m_stack.isEmpty()) {
            this.m_stack.pop();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.m_chars = this.m_chars + new String(cArray, n, n2).trim();
    }

    private void writeChars() {
        if (this.m_stack.isEmpty()) {
            return;
        }
        if (!(this.m_stack.peek() instanceof String)) {
            System.out.println("STRING expected on the stack");
            return;
        }
        String string = (String)this.m_stack.peek();
        if (string.equalsIgnoreCase("DATACLASS")) {
            String string2 = this.m_chars;
            int n = string2.lastIndexOf(64);
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            if (!this.m_dataBeans.containsKey(string2)) {
                this.m_bean = new DataClass(string2);
                this.m_dataBeans.put(string2, this.m_bean);
            } else {
                this.m_bean = (DataClass)this.m_dataBeans.get(string2);
            }
        } else if (string.equalsIgnoreCase("ATTRIBUTE")) {
            String string3 = this.m_chars.trim();
            this.m_attr = new Attribute(string3, this.getAttributeComponentType(this.m_element));
            if (this.m_attr.m_type != -1 && !this.m_bean.m_attributes.contains(this.m_attr)) {
                this.m_bean.m_attributes.addElement(this.m_attr);
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    private int getAttributeComponentType(String string) {
        return GUIConstants.getTypeInt(string);
    }

    private void trace(String string) {
        if (this.m_bElementTrace) {
            System.out.println(string);
        }
    }

    private void writeDataClass(DataClass dataClass) throws IOException {
        int n;
        Object object;
        String string = null;
        String string2 = null;
        int n2 = dataClass.m_name.lastIndexOf(46);
        if (n2 > -1) {
            string = dataClass.m_name.substring(n2 + 1);
            string2 = dataClass.m_name.substring(0, n2);
            string2 = string2.replace('.', '/');
        } else {
            string = dataClass.m_name;
        }
        Object[] objectArray = new Object[]{string};
        String string3 = MessageFormat.format(GUIFactory.getString("IDS_GENERATING_DATACLASS"), objectArray);
        System.out.println(string3);
        File file = null;
        if (this.m_directory != null && (this.m_PDMLPackage == null || this.m_PDMLPackage.length() == 0)) {
            file = new File(this.m_directory, string + ".java");
        } else if (this.m_PDMLPackage != null && this.m_PDMLPackage.length() > 0) {
            object = this.m_PDMLPackage;
            n = this.m_directory.indexOf((String)(object = ((String)object).replace('.', '/')));
            if (n > -1) {
                String string4 = this.m_directory.substring(0, n);
                string4 = string4 + string2;
                file = new File(string4, string + ".java");
            } else {
                file = this.m_directory != null ? new File(this.m_directory, string + ".java") : new File(string + ".java");
            }
        } else {
            file = this.m_directory != null ? new File(this.m_directory, string + ".java") : new File(string + ".java");
        }
        if (file.exists()) {
            object = new File(file.getPath() + ".backup");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            file.renameTo((File)object);
        }
        this.m_output = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        if (this.m_output == null) {
            return;
        }
        if (this.m_parser == null) {
            if (n2 > -1) {
                this.m_output.println("package " + dataClass.m_name.substring(0, n2) + ";");
                this.m_output.println();
            }
            this.m_output.println("import com.ibm.as400.ui.framework.java.*;");
            if (dataClass.m_hasDate) {
                this.m_output.println("import java.util.*;");
            }
            this.m_output.println();
            this.m_output.println("public class " + string + " extends Object");
            this.m_output.println("    implements DataBean");
            this.m_output.println("{");
            int n3 = dataClass.m_attributes.size();
            n = 0;
            while (n < n3) {
                this.writeAttributeVariables((Attribute)dataClass.m_attributes.elementAt(n));
                ++n;
            }
            this.m_output.println();
            int n4 = 0;
            while (n4 < n3) {
                this.writeAttributeMethods((Attribute)dataClass.m_attributes.elementAt(n4));
                ++n4;
            }
            this.m_output.println(this.getIndent(1) + "public Capabilities getCapabilities()");
            this.m_output.println(this.getIndent(1) + "{");
            this.m_output.println(this.getIndent(2) + "return null;");
            this.m_output.println(this.getIndent(1) + "}");
            this.m_output.println();
            this.m_output.println(this.getIndent(1) + "public void verifyChanges()");
            this.m_output.println(this.getIndent(1) + "{");
            this.m_output.println(this.getIndent(1) + "}");
            this.m_output.println();
            this.m_output.println(this.getIndent(1) + "public void save()");
            this.m_output.println(this.getIndent(1) + "{");
            this.m_output.println(this.getIndent(1) + "}");
            this.m_output.println();
            this.m_output.println(this.getIndent(1) + "public void load()");
            this.m_output.println(this.getIndent(1) + "{");
            int n5 = 0;
            while (n5 < n3) {
                this.writeAttributeInitializers((Attribute)dataClass.m_attributes.elementAt(n5));
                ++n5;
            }
            this.m_output.println(this.getIndent(1) + "}");
            this.m_output.println("}");
        } else {
            this.writeVector(this.m_parser.getHeaders());
            if (!this.m_parser.hasImport()) {
                this.m_output.println("import com.ibm.as400.ui.framework.java.*;");
                this.m_output.println();
            }
            if (!this.m_parser.hasDateImport()) {
                this.m_output.println("import java.util.*;");
                this.m_output.println();
            }
            this.m_output.println("public class " + this.m_parser.getClassName() + " extends " + this.m_parser.getBaseClassName());
            this.m_output.print("    implements ");
            object = this.m_parser.getInterfaces();
            n = ((Vector)object).size();
            int n6 = 0;
            while (n6 < n) {
                this.m_output.print(((Vector)object).elementAt(n6));
                if (n6 < n - 1) {
                    this.m_output.print(", ");
                } else {
                    this.m_output.println();
                }
                ++n6;
            }
            this.m_output.println("{");
            n = dataClass.m_attributes.size();
            int n7 = 0;
            while (n7 < n) {
                this.writeAttributeVariables((Attribute)dataClass.m_attributes.elementAt(n7));
                ++n7;
            }
            this.writeVector(this.m_parser.getBody());
            int n8 = 0;
            while (n8 < n) {
                this.writeAttributeMethods((Attribute)dataClass.m_attributes.elementAt(n8));
                ++n8;
            }
            if (!this.m_parser.hasCapabilities()) {
                this.m_output.println(this.getIndent(1) + "public Capabilities getCapabilities()");
                this.m_output.println(this.getIndent(1) + "{");
                this.m_output.println(this.getIndent(2) + "return null;");
                this.m_output.println(this.getIndent(1) + "}");
                this.m_output.println();
            }
            if (!this.m_parser.hasVerify()) {
                this.m_output.println(this.getIndent(1) + "public void verifyChanges()");
                this.m_output.println(this.getIndent(1) + "{");
                this.m_output.println(this.getIndent(1) + "}");
                this.m_output.println();
            }
            if (!this.m_parser.hasSave()) {
                this.m_output.println(this.getIndent(1) + "public void save()");
                this.m_output.println(this.getIndent(1) + "{");
                this.m_output.println(this.getIndent(1) + "}");
                this.m_output.println();
            }
            this.m_output.println(this.getIndent(1) + "public void load()");
            this.m_output.println(this.getIndent(1) + "{");
            int n9 = 0;
            while (n9 < n) {
                this.writeAttributeInitializers((Attribute)dataClass.m_attributes.elementAt(n9));
                ++n9;
            }
            this.writeVector(this.m_parser.getLoadMethod());
            this.m_output.println(this.getIndent(1) + "}");
            this.m_output.println("}");
            this.writeVector(this.m_parser.getTrailers());
        }
        this.m_output.close();
        CompileManager compileManager = new CompileManager();
        compileManager.doCompile(file.getPath());
    }

    private boolean isGenerationRequired(DataClass dataClass) throws IOException {
        boolean bl = true;
        String string = null;
        int n = dataClass.m_name.lastIndexOf(46);
        string = n > -1 ? dataClass.m_name.substring(n + 1) : dataClass.m_name;
        File file = null;
        file = this.m_directory != null ? new File(this.m_directory, string + ".java") : new File(string + ".java");
        try {
            this.m_parser = new DataBeanParser(file);
            bl = this.markNewAttributes(dataClass.m_attributes);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_parser = null;
        }
        return bl;
    }

    private void writeVector(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_output.println(vector.elementAt(n2));
            ++n2;
        }
    }

    private String[] getDeclarations(Attribute attribute) {
        String[] stringArray = null;
        switch (attribute.m_type) {
            default: {
                break;
            }
            case 101: 
            case 102: {
                stringArray = new String[]{"private boolean m_b" + attribute.m_name};
                break;
            }
            case 4: 
            case 5: {
                stringArray = new String[1];
                if (attribute.m_format == null || attribute.m_format.equalsIgnoreCase("STRING")) {
                    stringArray[0] = "private String m_s" + attribute.m_name;
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("INTEGER")) {
                    stringArray[0] = "private int m_i" + attribute.m_name;
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("LONG")) {
                    stringArray[0] = "private long m_l" + attribute.m_name;
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("SHORT")) {
                    stringArray[0] = "private short m_sh" + attribute.m_name;
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("FLOAT")) {
                    stringArray[0] = "private double m_d" + attribute.m_name;
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("DATE") || attribute.m_format.equalsIgnoreCase("TIME")) {
                    stringArray[0] = "private Calendar m_c" + attribute.m_name;
                    break;
                }
                stringArray[0] = "private Object m_o" + attribute.m_name;
                break;
            }
            case 2: {
                stringArray = new String[]{"private String m_s" + attribute.m_name};
                break;
            }
            case 106: {
                stringArray = new String[1];
                if (this.m_bOldSchool) {
                    stringArray[0] = "private Object m_o" + attribute.m_name;
                    break;
                }
                if (attribute.m_format != null && (attribute.m_format.equalsIgnoreCase("DATE") || attribute.m_format.equalsIgnoreCase("TIME"))) {
                    stringArray[0] = "private Calendar m_c" + attribute.m_name;
                    break;
                }
                stringArray[0] = "private int m_i" + attribute.m_name;
                break;
            }
            case 112: {
                stringArray = new String[]{"private String m_s" + attribute.m_name};
                break;
            }
            case 109: {
                stringArray = new String[]{"private int m_i" + attribute.m_name};
                break;
            }
            case 8: {
                stringArray = new String[]{"private Object m_o" + attribute.m_name, "private ChoiceDescriptor[] m_cd" + attribute.m_name};
                break;
            }
            case 9: 
            case 113: {
                stringArray = new String[]{"private String[] m_s" + attribute.m_name, "private ItemDescriptor[] m_id" + attribute.m_name};
                break;
            }
            case 104: {
                stringArray = new String[]{"private String m_s" + attribute.m_name, "private NodeDescriptor[] m_nd" + attribute.m_name};
                break;
            }
            case 117: {
                stringArray = new String[]{"private String[] m_s" + attribute.m_name, "private NodeDescriptor[] m_nd" + attribute.m_name, "private String m_s" + attribute.m_name + "TreeParent"};
            }
        }
        return stringArray;
    }

    private String[] getInitializers(Attribute attribute) {
        String[] stringArray = null;
        switch (attribute.m_type) {
            default: {
                break;
            }
            case 101: 
            case 102: {
                stringArray = new String[]{"m_b" + attribute.m_name + " = false;"};
                break;
            }
            case 4: 
            case 5: {
                stringArray = new String[1];
                if (attribute.m_format == null || attribute.m_format.equalsIgnoreCase("STRING")) {
                    stringArray[0] = "m_s" + attribute.m_name + " = \"\";";
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("INTEGER")) {
                    stringArray[0] = "m_i" + attribute.m_name + " = 0;";
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("LONG")) {
                    stringArray[0] = "m_l" + attribute.m_name + " = 0;";
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("SHORT")) {
                    stringArray[0] = "m_sh" + attribute.m_name + " = 0;";
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("FLOAT")) {
                    stringArray[0] = "m_d" + attribute.m_name + " = 0.0;";
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("DATE") || attribute.m_format.equalsIgnoreCase("TIME")) {
                    stringArray[0] = "m_c" + attribute.m_name + " = Calendar.getInstance();";
                    break;
                }
                stringArray[0] = "m_o" + attribute.m_name + " = null;";
                break;
            }
            case 2: {
                stringArray = new String[]{"m_s" + attribute.m_name + " = \"\";"};
                break;
            }
            case 106: {
                stringArray = new String[1];
                if (this.m_bOldSchool) {
                    stringArray[0] = "m_o" + attribute.m_name + " = null;";
                    break;
                }
                if (attribute.m_format != null && (attribute.m_format.equalsIgnoreCase("DATE") || attribute.m_format.equalsIgnoreCase("TIME"))) {
                    stringArray[0] = "m_c" + attribute.m_name + " = Calendar.getInstance();";
                    break;
                }
                stringArray[0] = "m_i" + attribute.m_name + " = 0;";
                break;
            }
            case 112: {
                stringArray = new String[]{"m_s" + attribute.m_name + " = \"\";"};
                break;
            }
            case 109: {
                stringArray = new String[]{"m_i" + attribute.m_name + " = 0;"};
                break;
            }
            case 8: {
                stringArray = new String[]{"m_o" + attribute.m_name + " = null;", "m_cd" + attribute.m_name + " = new ChoiceDescriptor[0];"};
                break;
            }
            case 9: 
            case 113: {
                stringArray = new String[]{"m_s" + attribute.m_name + " = new String[0];", "m_id" + attribute.m_name + " = new ItemDescriptor[0];"};
                break;
            }
            case 104: {
                stringArray = new String[]{"m_s" + attribute.m_name + " = \"\";", "m_nd" + attribute.m_name + " = new NodeDescriptor[0];"};
                break;
            }
            case 117: {
                stringArray = new String[]{"m_s" + attribute.m_name + " = new String[0];", "m_nd" + attribute.m_name + " = new NodeDescriptor[0];", "m_s" + attribute.m_name + "TreeParent = null;"};
            }
        }
        return stringArray;
    }

    private String[] getMethods(Attribute attribute) {
        String[] stringArray = null;
        switch (attribute.m_type) {
            default: {
                break;
            }
            case 101: 
            case 102: {
                stringArray = new String[]{"public boolean is" + attribute.m_name + "()", "return m_b" + attribute.m_name + ";", "public void set" + attribute.m_name + "(boolean b)", "m_b" + attribute.m_name + " = b;"};
                break;
            }
            case 4: 
            case 5: {
                stringArray = new String[4];
                if (attribute.m_format == null || attribute.m_format.equalsIgnoreCase("STRING")) {
                    stringArray = new String[]{"public String get" + attribute.m_name + "()", "return m_s" + attribute.m_name + ";", "public void set" + attribute.m_name + "(String s)", "m_s" + attribute.m_name + " = s;"};
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("INTEGER")) {
                    stringArray = new String[]{"public int get" + attribute.m_name + "()", "return m_i" + attribute.m_name + ";", "public void set" + attribute.m_name + "(int i)", "m_i" + attribute.m_name + " = i;"};
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("LONG")) {
                    stringArray = new String[]{"public long get" + attribute.m_name + "()", "return m_l" + attribute.m_name + ";", "public void set" + attribute.m_name + "(long l)", "m_l" + attribute.m_name + " = l;"};
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("SHORT")) {
                    stringArray = new String[]{"public short get" + attribute.m_name + "()", "return m_sh" + attribute.m_name + ";", "public void set" + attribute.m_name + "(short sh)", "m_sh" + attribute.m_name + " = sh;"};
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("FLOAT")) {
                    stringArray = new String[]{"public double get" + attribute.m_name + "()", "return m_d" + attribute.m_name + ";", "public void set" + attribute.m_name + "(double d)", "m_d" + attribute.m_name + " = d;"};
                    break;
                }
                if (attribute.m_format.equalsIgnoreCase("DATE") || attribute.m_format.equalsIgnoreCase("TIME")) {
                    stringArray = new String[]{"public Calendar get" + attribute.m_name + "()", "return m_c" + attribute.m_name + ";", "public void set" + attribute.m_name + "(Calendar c)", "m_c" + attribute.m_name + " = c;"};
                    break;
                }
                stringArray = new String[]{"public Object get" + attribute.m_name + "()", "return m_o" + attribute.m_name + ";", "public void set" + attribute.m_name + "(Object o)", "m_o" + attribute.m_name + " = o;"};
                break;
            }
            case 2: {
                stringArray = new String[]{"public String get" + attribute.m_name + "()", "return m_s" + attribute.m_name + ";"};
                break;
            }
            case 106: {
                stringArray = new String[4];
                if (this.m_bOldSchool) {
                    stringArray[0] = "public Object get" + attribute.m_name + "()";
                    stringArray[1] = "return m_o" + attribute.m_name + ";";
                    stringArray[2] = "public void set" + attribute.m_name + "(Object o)";
                    stringArray[3] = "m_o" + attribute.m_name + " = o;";
                    break;
                }
                if (attribute.m_format != null && (attribute.m_format.equalsIgnoreCase("DATE") || attribute.m_format.equalsIgnoreCase("TIME"))) {
                    stringArray[0] = "public Calendar get" + attribute.m_name + "()";
                    stringArray[1] = "return m_c" + attribute.m_name + ";";
                    stringArray[2] = "public void set" + attribute.m_name + "(Calendar c)";
                    stringArray[3] = "m_c" + attribute.m_name + " = c;";
                    break;
                }
                stringArray[0] = "public int get" + attribute.m_name + "()";
                stringArray[1] = "return m_i" + attribute.m_name + ";";
                stringArray[2] = "public void set" + attribute.m_name + "(int i)";
                stringArray[3] = "m_i" + attribute.m_name + " = i;";
                break;
            }
            case 112: {
                stringArray = new String[]{"public String get" + attribute.m_name + "()", "return m_s" + attribute.m_name + ";", "public void set" + attribute.m_name + "(String s)", "m_s" + attribute.m_name + " = s;"};
                break;
            }
            case 109: {
                stringArray = new String[]{"public int get" + attribute.m_name + "()", "return m_i" + attribute.m_name + ";", "public void set" + attribute.m_name + "(int i)", "m_i" + attribute.m_name + " = i;"};
                break;
            }
            case 8: {
                stringArray = new String[]{"public Object get" + attribute.m_name + "()", "return m_o" + attribute.m_name + ";", "public void set" + attribute.m_name + "(Object o)", "m_o" + attribute.m_name + " = o;", "public ChoiceDescriptor[] get" + attribute.m_name + "Choices()", "return m_cd" + attribute.m_name + ";"};
                break;
            }
            case 9: 
            case 113: {
                stringArray = new String[]{"public ItemDescriptor[] get" + attribute.m_name + "List()", "return m_id" + attribute.m_name + ";", "public void set" + attribute.m_name + "List(ItemDescriptor[] items)", "m_id" + attribute.m_name + " = items;", "public String[] get" + attribute.m_name + "Selection()", "return m_s" + attribute.m_name + ";", "public void set" + attribute.m_name + "Selection(String[] select)", "m_s" + attribute.m_name + " = select;"};
                break;
            }
            case 104: {
                stringArray = new String[]{"public NodeDescriptor[] get" + attribute.m_name + "Children()", "return m_nd" + attribute.m_name + ";", "public void set" + attribute.m_name + "TreeParent(String name)", "m_s" + attribute.m_name + " = name;"};
                break;
            }
            case 117: {
                stringArray = new String[]{"public NodeDescriptor[] get" + attribute.m_name + "Children()", "return m_nd" + attribute.m_name + ";", "public void set" + attribute.m_name + "TreeParent(String name)", "m_s" + attribute.m_name + "TreeParent = name;", "public String[] get" + attribute.m_name + "Selection()", "return m_s" + attribute.m_name + ";", "public void set" + attribute.m_name + "Selection(String[] select)", "m_s" + attribute.m_name + " = select;"};
            }
        }
        return stringArray;
    }

    private void writeAttributeVariables(Attribute attribute) {
        String[] stringArray = this.getDeclarations(attribute);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.m_parser == null) {
                    this.m_output.println(this.getIndent(1) + stringArray[n] + ";");
                } else if (attribute.m_new && !this.m_parser.hasMemberVariable(stringArray[n])) {
                    this.m_output.println(this.getIndent(1) + stringArray[n] + ";");
                    this.m_newInitializers.addElement(stringArray[n].substring(stringArray[n].lastIndexOf(32) + 1));
                }
                ++n;
            }
        }
    }

    private void writeAttributeInitializers(Attribute attribute) {
        String[] stringArray = this.getInitializers(attribute);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string;
                int n2;
                if (this.m_parser == null) {
                    this.m_output.println(this.getIndent(2) + stringArray[n]);
                } else if (attribute.m_new && (n2 = this.m_newInitializers.indexOf(string = stringArray[n].substring(0, stringArray[n].indexOf(32)))) > -1) {
                    this.m_output.println(this.getIndent(2) + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void writeAttributeMethods(Attribute attribute) {
        String[] stringArray = this.getMethods(attribute);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.m_parser == null || attribute.m_new && !this.m_parser.hasGetSetMethod(stringArray[n])) {
                    this.m_output.println(this.getIndent(1) + stringArray[n]);
                    this.m_output.println(this.getIndent(1) + "{");
                    this.m_output.println(this.getIndent(2) + stringArray[n + 1]);
                    this.m_output.println(this.getIndent(1) + "}");
                    this.m_output.println();
                }
                n += 2;
            }
        }
    }

    private boolean markNewAttributes(Vector vector) {
        if (this.m_parser == null || vector == null) {
            return false;
        }
        boolean bl = false;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = (Attribute)vector.elementAt(n2);
            String[] stringArray = this.getMethods(attribute);
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (n3 % 2 == 0 && !this.m_parser.hasGetSetMethod(stringArray[n3])) {
                    attribute.m_new = true;
                    bl = true;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    private String getIndent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + m_indent;
            ++n2;
        }
        return string;
    }

    private static void dumpSyntax() {
        int n = 0;
        while (n <= 2) {
            System.out.println(GUIFactory.getString("IDS_DATABEAN_GENERATOR_SYNTAX_" + n));
            ++n;
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 3) {
            DataBeanGenerator.dumpSyntax();
        } else if (stringArray.length == 1 && stringArray[0].equals("-l")) {
            DataBeanGenerator.dumpSyntax();
        } else if (stringArray.length == 3 && !stringArray[1].equals("-l")) {
            DataBeanGenerator.dumpSyntax();
        }
        try {
            if (stringArray.length == 1) {
                DataBeanGenerator dataBeanGenerator = new DataBeanGenerator(stringArray[0]);
            } else {
                DataBeanGenerator dataBeanGenerator = new DataBeanGenerator(stringArray[0], RC2XML.generateLocale(stringArray[2]));
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class Attribute {
        public String m_name;
        public int m_type;
        public boolean m_new;
        public String m_format;

        public Attribute(String string, int n) {
            this.m_name = string;
            this.m_type = n;
            this.m_new = false;
            this.m_format = null;
        }

        public boolean equals(Object object) {
            if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                if (this.m_name.equals(attribute.m_name)) {
                    return true;
                }
            }
            return false;
        }
    }

    class DataClass {
        public String m_name;
        public Vector m_attributes;
        public boolean m_hasDate;

        public DataClass(String string) {
            this.m_name = string;
            this.m_attributes = new Vector();
            this.m_hasDate = false;
        }
    }
}

