/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DataBeanParser {
    private BufferedReader m_input = null;
    private String m_baseClass = "Object";
    private String m_className = null;
    private Vector m_interfaces = new Vector();
    private Vector m_headers = new Vector();
    private Vector m_trailers = new Vector();
    private Vector m_body = new Vector();
    private Vector m_getSetMethods = new Vector();
    private Vector m_getMethods = new Vector();
    private Vector m_memberVariables = new Vector();
    private Vector m_load = new Vector();
    private boolean m_bImport = false;
    private boolean m_bDateImport = false;
    private boolean m_bSave = false;
    private boolean m_bVerify = false;
    private boolean m_bCapabilities = false;

    public DataBeanParser(String string) throws FileNotFoundException, IOException {
        this(new File(string));
    }

    public DataBeanParser(File file) throws FileNotFoundException, IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        this.m_input = new BufferedReader(new FileReader(file));
        this.processDocument();
        this.m_input.close();
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getBaseClassName() {
        return this.m_baseClass;
    }

    public Vector getInterfaces() {
        return this.m_interfaces;
    }

    public Vector getHeaders() {
        return this.m_headers;
    }

    public Vector getTrailers() {
        return this.m_trailers;
    }

    public Vector getBody() {
        return this.m_body;
    }

    public Vector getLoadMethod() {
        return this.m_load;
    }

    public boolean hasGetSetMethod(String string) {
        if (string == null) {
            return false;
        }
        int n = this.m_getSetMethods.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.m_getSetMethods.elementAt(n2);
            int n3 = string2.indexOf(" set");
            if (n3 > -1) {
                string2 = string2.substring(0, string2.lastIndexOf(40));
            }
            if (string.startsWith(string2)) {
                return true;
            }
            ++n2;
        }
        return this.hasGetMethod(string);
    }

    public boolean hasGetMethod(String string) {
        if (string == null) {
            return false;
        }
        int n = this.m_getMethods.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.m_getMethods.elementAt(n2);
            if (string.indexOf(string2 = string2.substring(string2.lastIndexOf("get"))) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasMemberVariable(String string) {
        if (string == null) {
            return false;
        }
        int n = this.m_memberVariables.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.m_memberVariables.elementAt(n2);
            if (string.trim().equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasImport() {
        return this.m_bImport;
    }

    public boolean hasDateImport() {
        return this.m_bDateImport;
    }

    public boolean hasSave() {
        return this.m_bSave;
    }

    public boolean hasVerify() {
        return this.m_bVerify;
    }

    public boolean hasCapabilities() {
        return this.m_bCapabilities;
    }

    private void processDocument() throws IOException {
        boolean bl = true;
        String string = null;
        while ((string = this.m_input.readLine()) != null) {
            String string2 = string.trim();
            if (string2.startsWith("public class ")) {
                Object object;
                while (!string2.endsWith("{")) {
                    object = this.m_input.readLine();
                    if (object == null) break;
                    string2 = ((String)object).trim();
                    string = string + " " + (String)object;
                }
                this.m_interfaces.addElement("DataBean");
                object = new StringTokenizer(string);
                block2: while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    if (string3.equals("class") && ((StringTokenizer)object).hasMoreTokens()) {
                        this.m_className = ((StringTokenizer)object).nextToken();
                        continue;
                    }
                    if (string3.equals("extends") && ((StringTokenizer)object).hasMoreTokens()) {
                        this.m_baseClass = ((StringTokenizer)object).nextToken();
                        continue;
                    }
                    if (!string3.equals("implements")) continue;
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string3 = ((StringTokenizer)object).nextToken();
                        if (string3.equals("{")) continue block2;
                        if (string3.endsWith(",") || string3.endsWith("{")) {
                            string3 = string3.substring(0, string3.lastIndexOf(","));
                        }
                        if (string3.equals("DataBean") || string3.equals("com.ibm.as400.ui.framework.java.DataBean")) continue;
                        this.m_interfaces.addElement(string3);
                    }
                }
                this.processClass();
                bl = false;
            } else if (bl) {
                this.m_headers.addElement(string);
                if (string.startsWith("import com.ibm.as400.ui.framework.java.*;")) {
                    this.m_bImport = true;
                }
                if (string.startsWith("import java.util.*;")) {
                    this.m_bDateImport = true;
                }
            } else {
                this.m_trailers.addElement(string);
            }
            if (string != null) continue;
        }
    }

    private void processClass() throws IOException {
        int n = 1;
        String string = null;
        while ((string = this.m_input.readLine()) != null) {
            if (string.indexOf(123) > -1) {
                ++n;
            }
            if (string.indexOf(125) > -1) {
                --n;
            }
            String string2 = string.trim();
            if (n == 0) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = null;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string4;
                String string5;
                String string6 = stringTokenizer.nextToken();
                if (string6.equals("//") || string6.equals("/*")) break;
                if (string6.equals("public") && stringTokenizer.hasMoreTokens()) {
                    String string7;
                    int n3;
                    string5 = stringTokenizer.nextToken();
                    if (string5.equals("static") || !stringTokenizer.hasMoreTokens() || (n3 = (string4 = stringTokenizer.nextToken()).indexOf("(")) <= -1 || string.indexOf(",") != -1) continue;
                    string3 = string6 + " " + string5 + " " + string4.substring(0, n3) + "(";
                    n3 = string.indexOf("(");
                    if (n3 + 1 < (n2 = string.indexOf(")")) && (string7 = string.substring(n3 + 1, n2).trim()).length() > 0) {
                        string3 = string3 + string7;
                    }
                    string3 = string3 + ")";
                    this.m_getSetMethods.addElement(string3);
                    if (string4.startsWith("get") && string3.endsWith("()")) {
                        this.m_getMethods.addElement(string3.substring(string3.indexOf("get")));
                    }
                    if (string3.equals("public void load()")) {
                        while (!string2.endsWith("{")) {
                            string = string + " " + this.m_input.readLine();
                            string2 = string.trim();
                        }
                        this.m_load = this.saveMethodBody();
                        bl = true;
                        continue;
                    }
                    if (string3.equals("public void save()")) {
                        this.m_bSave = true;
                        continue;
                    }
                    if (string3.equals("public void verifyChanges()")) {
                        this.m_bVerify = true;
                        continue;
                    }
                    if (!string3.equals("public Capabilities getCapabilities()")) continue;
                    this.m_bCapabilities = true;
                    continue;
                }
                if (!string6.equals("private") || !stringTokenizer.hasMoreTokens() || (string5 = stringTokenizer.nextToken()).equals("static") || !stringTokenizer.hasMoreTokens() || !(string4 = stringTokenizer.nextToken()).startsWith("m_") || string4.length() <= 2) continue;
                String string8 = string6 + " " + string5 + " ";
                n2 = string4.indexOf(59);
                if (n2 > -1) {
                    string4 = string4.substring(0, n2);
                }
                if ((n2 = string4.indexOf(61)) > -1) {
                    string4 = string4.substring(0, n2);
                }
                string8 = string8 + string4;
                this.m_memberVariables.addElement(string8);
            }
            if (!bl) {
                this.m_body.addElement(string);
            }
            if (string != null) continue;
        }
    }

    private Vector saveMethodBody() throws IOException {
        int n = 1;
        Vector<String> vector = new Vector<String>();
        String string = null;
        while ((string = this.m_input.readLine()) != null) {
            if (string.indexOf(123) > -1) {
                ++n;
            }
            if (string.indexOf(125) > -1) {
                --n;
            }
            String string2 = string.trim();
            if (n == 0) break;
            vector.addElement(string);
            if (string != null) continue;
        }
        return vector;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

