/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLSAXErrorHandler;
import com.ibm.as400.ui.tools.CompileManager;
import com.ibm.as400.ui.tools.EventHandlerParser;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIConstants;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.RC2XML;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class EventHandlerGenerator
implements ContentHandler {
    private String m_directory = null;
    private Hashtable m_handlers = new Hashtable();
    private PrintWriter m_output = null;
    private static final String m_indent = "    ";
    private boolean m_bElementTrace = false;
    private EventHandlerParser m_parser = null;
    private Stack m_stack = null;
    private String m_chars = null;
    private boolean m_isMenuItem = false;
    private boolean m_newSignatures = GUIBuilder.isMSYSMode();

    public EventHandlerGenerator(String string) throws FileNotFoundException, IOException, ParseException, MissingResourceException {
        this(string, null);
    }

    public EventHandlerGenerator(String string, Locale locale) throws FileNotFoundException, IOException, ParseException, MissingResourceException {
        this.parseXML(string.replace('\\', '/'), locale);
        Enumeration enumeration = this.m_handlers.elements();
        while (enumeration.hasMoreElements()) {
            EventHandlerClass eventHandlerClass = (EventHandlerClass)enumeration.nextElement();
            if (!this.isGenerationRequired(eventHandlerClass)) continue;
            this.writeEventHandlers(eventHandlerClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void parseXML(String var1_1, Locale var2_2) throws FileNotFoundException, IOException, ParseException, MissingResourceException {
        var3_3 = SystemResourceFinder.getPDMLHeader();
        var4_4 = null;
        if (var1_1.toLowerCase().endsWith(".pdml") || var1_1.toLowerCase().endsWith(".pdmlsrc")) {
            try {
                var4_4 = new BufferedInputStream(new FileInputStream(var1_1));
                var5_5 = var1_1.lastIndexOf(47);
                if (var5_5 <= -1) ** GOTO lbl20
                this.m_directory = var1_1.substring(0, var5_5);
            }
            catch (FileNotFoundException var5_6) {
                var6_8 = new Object[]{var1_1};
                var7_10 = MessageFormat.format(GUIFactory.getString("IDS_PDML_NOT_FOUND"), var6_8);
                if (var4_4 != null) {
                    var4_4.close();
                }
                if (var3_3 != null) {
                    var3_3.close();
                }
                throw new FileNotFoundException(var7_10);
            }
        } else {
            var4_4 = SystemResourceFinder.getPDMLDocument((String)var1_1, (Locale)var2_2);
            var1_1 = var1_1 + SystemResourceFinder.getLastDocumentLocale() + ".pdml";
        }
lbl20:
        // 3 sources

        var5_7 = new XMLSAXErrorHandler(var1_1, SystemResourceFinder.getHeaderLineCount());
        var6_9 = XMLPanelDefinition.getParser((Object)this, (XMLSAXErrorHandler)var5_7);
        var7_11 = new SequenceInputStream(var3_3, var4_4);
        try {
            var8_12 /* !! */  = new InputSource(var7_11);
            XMLPanelDefinition.introspectMethod((Object)var6_9, (String)"parse", (Object[])new Object[]{var8_12 /* !! */ }, (Class[])new Class[]{var8_12 /* !! */ .getClass()});
            var10_13 = null;
            ** if (var7_11 == null) goto lbl-1000
        }
        catch (Throwable var9_15) {
            var10_14 = null;
            if (var7_11 != null) {
                var7_11.close();
            }
            throw var9_15;
        }
lbl-1000:
        // 1 sources

        {
            var7_11.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        var8_12 /* !! */  = var5_7.getException();
        if (var8_12 /* !! */  != null) {
            throw var8_12 /* !! */ ;
        }
    }

    public void startDocument() {
        this.m_stack = new Stack();
    }

    public void endDocument() {
        this.m_stack = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equalsIgnoreCase("MENUITEM")) {
            this.m_isMenuItem = true;
        } else if (string3.equalsIgnoreCase("ACTION") || string3.equalsIgnoreCase("ACTIVATE") || string3.equalsIgnoreCase("ADJUST") || string3.equalsIgnoreCase("DOUBLECLICK")) {
            this.m_stack.push(string3);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (!this.m_chars.equals("")) {
            this.writeChars();
            this.m_chars = "";
        }
        if (!this.m_stack.isEmpty()) {
            this.m_stack.pop();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.m_chars = this.m_chars + new String(cArray, n, n2).trim();
    }

    private void writeChars() {
        if (this.m_stack.isEmpty()) {
            return;
        }
        if (!(this.m_stack.peek() instanceof String)) {
            System.out.println("STRING expected on the stack");
            return;
        }
        String string = (String)this.m_stack.peek();
        if (string.equalsIgnoreCase("ACTION") || string.equalsIgnoreCase("ACTIVATE") || string.equalsIgnoreCase("ADJUST") || string.equalsIgnoreCase("DOUBLECLICK")) {
            EventHandlerClass eventHandlerClass;
            String string2 = this.m_chars;
            if (!(this.m_handlers.containsKey(string2) || string2.equals("COMMIT") || string2.equals("CANCEL") || string2.equals("HELP") || string2.equals("CONTEXTHELP") || string2.equals(GUIFactory.getString("IDS_DEFAULT_MENU_ACTION_CLASS")))) {
                this.m_handlers.put(string2, new EventHandlerClass(string2));
            }
            if ((eventHandlerClass = (EventHandlerClass)this.m_handlers.get(string2)) != null && !eventHandlerClass.m_menuaction) {
                if (string.equalsIgnoreCase("ACTION")) {
                    if (this.m_isMenuItem) {
                        eventHandlerClass.m_menuaction = true;
                        eventHandlerClass.m_action = false;
                        eventHandlerClass.m_doubleclick = false;
                        eventHandlerClass.m_adjust = false;
                        eventHandlerClass.m_activate = false;
                    } else {
                        eventHandlerClass.m_action = true;
                    }
                    this.m_isMenuItem = false;
                } else if (string.equalsIgnoreCase("ACTIVATE")) {
                    eventHandlerClass.m_activate = true;
                } else if (string.equalsIgnoreCase("ADJUST")) {
                    eventHandlerClass.m_adjust = true;
                } else if (string.equalsIgnoreCase("DOUBLECLICK")) {
                    eventHandlerClass.m_doubleclick = true;
                }
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    private int getAttributeComponentType(String string) {
        return GUIConstants.getTypeInt(string);
    }

    private void trace(String string) {
        if (this.m_bElementTrace) {
            System.out.println(string);
        }
    }

    private void writeEventHandlers(EventHandlerClass eventHandlerClass) throws IOException {
        int n;
        String[] stringArray;
        String string = eventHandlerClass.m_name;
        String string2 = null;
        int n2 = string.lastIndexOf(46);
        string2 = n2 > -1 ? string.substring(n2 + 1) : string;
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(GUIFactory.getString("IDS_GENERATING_EVENTHANDLER"), objectArray);
        System.out.println(string3);
        File file = null;
        file = this.m_directory != null ? new File(this.m_directory, string2 + ".java") : new File(string2 + ".java");
        if (file.exists()) {
            stringArray = new File(file.getPath() + ".backup");
            if (stringArray.exists()) {
                stringArray.delete();
            }
            file.renameTo((File)stringArray);
        }
        this.m_output = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        if (this.m_output == null) {
            return;
        }
        stringArray = this.getInterfaces(eventHandlerClass);
        if (this.m_parser == null) {
            if (n2 > -1) {
                this.m_output.println("package " + string.substring(0, n2) + ";");
                this.m_output.println();
            }
            if (this.m_newSignatures && (eventHandlerClass.m_action || eventHandlerClass.m_activate)) {
                this.m_output.println("import com.ibm.ui.framework.*;");
            } else {
                this.m_output.println("import com.ibm.as400.ui.framework.java.*;");
                this.m_output.println("import java.awt.*;");
                this.m_output.println("import java.awt.event.*;");
                this.m_output.println("import javax.swing.*;");
                this.m_output.println("import javax.swing.event.*;");
            }
            this.m_output.println();
            if (eventHandlerClass.m_menuaction) {
                this.m_output.println("public class " + string2 + " extends ActionHandler");
                this.m_output.println("    implements " + eventHandlerClass.getInterfaces());
                this.m_output.println("{");
                this.m_output.println(this.getIndent(1) + "public " + string2 + "(MenuManager mm)");
                this.m_output.println(this.getIndent(1) + "{");
                this.m_output.println(this.getIndent(2) + "super(mm);");
                this.m_output.println(this.getIndent(1) + "}");
            } else if (this.m_newSignatures && (eventHandlerClass.m_action || eventHandlerClass.m_activate)) {
                this.m_output.println("public class " + string2);
                this.m_output.println("    implements " + eventHandlerClass.getInterfaces());
                this.m_output.println("{");
            } else {
                this.m_output.println("public class " + string2 + " extends EventHandler");
                this.m_output.println("    implements " + eventHandlerClass.getInterfaces());
                this.m_output.println("{");
                this.m_output.println(this.getIndent(1) + "public " + string2 + "(PanelManager pm)");
                this.m_output.println(this.getIndent(1) + "{");
                this.m_output.println(this.getIndent(2) + "super(pm);");
                this.m_output.println(this.getIndent(1) + "}");
            }
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.m_output.println(this.getIndent(1) + stringArray[n] + "e)");
                    this.m_output.println(this.getIndent(1) + "{");
                    this.m_output.println(this.getIndent(2) + "System.out.println(e);");
                    this.m_output.println(this.getIndent(1) + "}");
                }
                ++n;
            }
            this.m_output.println("}");
        } else {
            String string4;
            this.writeVector(this.m_parser.getHeaders());
            n = 5;
            String string5 = "import com.ibm.as400.ui.framework.java.*;";
            if (this.m_newSignatures && (eventHandlerClass.m_action || eventHandlerClass.m_activate)) {
                string5 = "import com.ibm.ui.framework.*;";
                n = 1;
            }
            String[] stringArray2 = new String[]{string5, "import java.awt.*;", "import java.awt.event.*;", "import javax.swing.*;", "import javax.swing.event.*;"};
            int n3 = 0;
            while (n3 < n) {
                if (!this.m_parser.hasImport(stringArray2[n3])) {
                    this.m_output.println(stringArray2[n3]);
                    this.m_output.println();
                }
                ++n3;
            }
            String string6 = string4 = eventHandlerClass.m_menuaction ? "ActionHandler" : "EventHandler";
            if (this.m_newSignatures && (eventHandlerClass.m_action || eventHandlerClass.m_activate)) {
                this.m_output.println("public class " + this.m_parser.getClassName());
            } else {
                this.m_output.println("public class " + this.m_parser.getClassName() + " extends " + string4);
            }
            Vector vector = this.m_parser.getInterfaces();
            if (vector.size() > 0) {
                this.m_output.print("    implements ");
                int n4 = 0;
                while (n4 < stringArray.length) {
                    if (stringArray[n4] != null) {
                        String string7 = null;
                        switch (n4) {
                            default: {
                                break;
                            }
                            case 0: {
                                if (eventHandlerClass.m_menuaction) break;
                                if (this.m_newSignatures) {
                                    string7 = "TaskActionListener";
                                    break;
                                }
                                string7 = "ActionListener";
                                break;
                            }
                            case 1: {
                                string7 = "DoubleClickListener";
                                break;
                            }
                            case 2: {
                                string7 = "ChangeListener";
                                break;
                            }
                            case 3: {
                                string7 = "ItemListener";
                            }
                        }
                        if (string7 != null && !vector.contains(string7)) {
                            vector.addElement(string7);
                        }
                    }
                    ++n4;
                }
                int n5 = vector.size();
                int n6 = 0;
                while (n6 < n5) {
                    this.m_output.print(vector.elementAt(n6));
                    if (n6 < n5 - 1) {
                        this.m_output.print(", ");
                    } else {
                        this.m_output.println();
                    }
                    ++n6;
                }
            }
            this.m_output.println("{");
            String string8 = "public " + this.m_parser.getClassName() + "(" + string4;
            String string9 = this.m_parser.getInterfaceMethodDeclaration(string8);
            if (string9 != null) {
                this.m_output.println(this.getIndent(1) + string9);
                this.m_output.println(this.getIndent(1) + "{");
                this.writeVector(this.m_parser.getInterfaceMethodBody(string9));
                this.m_output.println(this.getIndent(1) + "}");
            } else if (eventHandlerClass.m_menuaction) {
                this.m_output.println(this.getIndent(1) + "public " + this.m_parser.getClassName() + "(MenuManager mm)");
                this.m_output.println(this.getIndent(1) + "{");
                this.m_output.println(this.getIndent(2) + "super(mm);");
                this.m_output.println(this.getIndent(1) + "}");
            } else if (!this.m_newSignatures || !eventHandlerClass.m_action && !eventHandlerClass.m_activate) {
                this.m_output.println(this.getIndent(1) + "public " + this.m_parser.getClassName() + "(PanelManager pm)");
                this.m_output.println(this.getIndent(1) + "{");
                this.m_output.println(this.getIndent(2) + "super(pm);");
                this.m_output.println(this.getIndent(1) + "}");
            }
            this.writeVector(this.m_parser.getBody());
            Enumeration enumeration = this.m_parser.getInterfaceMethodDeclarations();
            while (enumeration.hasMoreElements()) {
                string9 = (String)enumeration.nextElement();
                if (string9.startsWith(string8)) continue;
                this.m_output.println(this.getIndent(1) + string9);
                this.m_output.println(this.getIndent(1) + "{");
                this.writeVector(this.m_parser.getInterfaceMethodBody(string9));
                this.m_output.println(this.getIndent(1) + "}");
            }
            int n7 = 0;
            while (n7 < stringArray.length) {
                if (stringArray[n7] != null && (string9 = this.m_parser.getInterfaceMethodDeclaration(stringArray[n7])) == null) {
                    this.m_output.println(this.getIndent(1) + stringArray[n7] + "e)");
                    this.m_output.println(this.getIndent(1) + "{");
                    this.m_output.println(this.getIndent(2) + "System.out.println(e);");
                    this.m_output.println(this.getIndent(1) + "}");
                }
                ++n7;
            }
            this.m_output.println("}");
            this.writeVector(this.m_parser.getTrailers());
        }
        this.m_output.close();
        CompileManager compileManager = new CompileManager();
        compileManager.doCompile(file.getPath());
    }

    private String[] getInterfaces(EventHandlerClass eventHandlerClass) {
        String[] stringArray = new String[4];
        if (eventHandlerClass.m_menuaction || eventHandlerClass.m_action || eventHandlerClass.m_activate) {
            stringArray[0] = this.m_newSignatures && !eventHandlerClass.m_menuaction ? "public void actionPerformed(TaskActionEvent " : "public void actionPerformed(ActionEvent ";
        }
        if (eventHandlerClass.m_doubleclick) {
            stringArray[1] = "public void itemDoubleClicked(DoubleClickEvent ";
        }
        if (eventHandlerClass.m_adjust) {
            stringArray[2] = "public void stateChanged(ChangeEvent ";
        }
        if (eventHandlerClass.m_menuaction) {
            stringArray[3] = "public void itemStateChanged(ItemEvent ";
        }
        return stringArray;
    }

    private boolean isGenerationRequired(EventHandlerClass eventHandlerClass) throws IOException {
        boolean bl = false;
        String string = eventHandlerClass.m_name;
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n > -1 ? string.substring(n + 1) : string;
        File file = null;
        file = this.m_directory != null ? new File(this.m_directory, string2 + ".java") : new File(string2 + ".java");
        try {
            this.m_parser = new EventHandlerParser(file);
            String[] stringArray = this.getInterfaces(eventHandlerClass);
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3;
                if (stringArray[n2] != null && (string3 = this.m_parser.getInterfaceMethodDeclaration(stringArray[n2])) == null) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_parser = null;
            bl = true;
        }
        return bl;
    }

    private void writeVector(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_output.println(vector.elementAt(n2));
            ++n2;
        }
    }

    private String getIndent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + m_indent;
            ++n2;
        }
        return string;
    }

    private static void dumpSyntax() {
        int n = 0;
        while (n <= 2) {
            System.out.println(GUIFactory.getString("IDS_EVENTHANDLER_GENERATOR_SYNTAX_" + n));
            ++n;
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 3) {
            EventHandlerGenerator.dumpSyntax();
        } else if (stringArray.length == 1 && stringArray[0].equals("-l")) {
            EventHandlerGenerator.dumpSyntax();
        } else if (stringArray.length == 3 && !stringArray[1].equals("-l")) {
            EventHandlerGenerator.dumpSyntax();
        }
        try {
            if (stringArray.length == 1) {
                EventHandlerGenerator eventHandlerGenerator = new EventHandlerGenerator(stringArray[0]);
            } else {
                EventHandlerGenerator eventHandlerGenerator = new EventHandlerGenerator(stringArray[0], RC2XML.generateLocale(stringArray[2]));
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class EventHandlerClass {
        public String m_name;
        public boolean m_menuaction = false;
        public boolean m_doubleclick = false;
        public boolean m_action = false;
        public boolean m_adjust = false;
        public boolean m_activate = false;

        public EventHandlerClass(String string) {
            this.m_name = string;
        }

        public String getInterfaces() {
            String string = "";
            if (this.m_action || this.m_activate) {
                string = EventHandlerGenerator.this.m_newSignatures ? string + "TaskActionListener" : string + "ActionListener";
            }
            if (this.m_doubleclick) {
                if (!string.equals("")) {
                    string = string + ", ";
                }
                string = string + "DoubleClickListener";
            }
            if (this.m_adjust) {
                if (!string.equals("")) {
                    string = string + ", ";
                }
                string = string + "ChangeListener";
            }
            if (this.m_menuaction) {
                if (!string.equals("")) {
                    string = string + ", ";
                }
                string = string + "ItemListener";
            }
            return string;
        }

        public boolean equals(Object object) {
            if (object instanceof EventHandlerClass) {
                EventHandlerClass eventHandlerClass = (EventHandlerClass)object;
                return eventHandlerClass.m_name.equals(this.m_name);
            }
            if (object instanceof String) {
                String string = (String)object;
                return string.equals(this.m_name);
            }
            return false;
        }
    }
}

