/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.MessageLog;
import com.ibm.as400.ui.tools.ToolsResourceLoader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public class HelpDocParser {
    public static boolean m_Trace = false;
    public static ToolsResourceLoader resourceLoader = new ToolsResourceLoader();
    String m_lineBuffer = null;
    int m_currentLine = 0;
    String m_tagBuffer;
    String m_contentBuffer;
    BufferedReader m_in;

    public HelpDocParser(BufferedReader bufferedReader) {
        this.m_in = bufferedReader;
    }

    private int fillBuffer(String string) {
        try {
            String string2 = this.m_in.readLine();
            while (string2 != null) {
                this.m_lineBuffer = this.m_lineBuffer + "\r\n" + string2;
                ++this.m_currentLine;
                if (-1 < string2.indexOf(string)) {
                    return this.m_lineBuffer.indexOf(string);
                }
                string2 = this.m_in.readLine();
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        return -1;
    }

    public String nextTag() throws IOException {
        this.m_contentBuffer = "";
        if (this.m_lineBuffer == null) {
            this.m_lineBuffer = this.m_in.readLine();
        }
        if (this.m_lineBuffer == null) {
            return null;
        }
        boolean bl = false;
        while (!bl) {
            int n = -1;
            int n2 = this.m_lineBuffer.indexOf("<!--");
            if (n2 < 0) {
                n2 = this.fillBuffer("<!--");
            }
            if (n2 >= 0) {
                n = this.m_lineBuffer.indexOf("-->", n2);
                if (n < 0) {
                    n = this.fillBuffer("-->");
                }
                if (n < 0) {
                    n = this.m_lineBuffer.length() - 3;
                    bl = true;
                }
            } else {
                this.m_contentBuffer = this.m_lineBuffer;
                this.m_tagBuffer = "";
                return null;
            }
            this.m_contentBuffer = this.m_contentBuffer + this.m_lineBuffer.substring(0, n2);
            this.m_tagBuffer = this.m_lineBuffer.substring(n2, n + 3);
            this.m_lineBuffer = this.m_lineBuffer.substring(n + 3);
            StringTokenizer stringTokenizer = new StringTokenizer(this.m_tagBuffer, " :=-");
            stringTokenizer.nextToken();
            String string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("HELPDOC")) {
                if (stringTokenizer.nextToken().equalsIgnoreCase("SEGMENTBEGIN")) {
                    int n3 = this.m_lineBuffer.indexOf("</a>");
                    int n4 = this.m_lineBuffer.indexOf("</A>");
                    int n5 = 0;
                    while (n3 < 0 && n4 < 0 && n5 > -1) {
                        n5 = this.fillBuffer(">");
                        n3 = this.m_lineBuffer.indexOf("</a>");
                        n4 = this.m_lineBuffer.indexOf("</A>");
                    }
                    if (n3 >= 0 && n4 >= 0) {
                        n3 = n3 < n4 ? n3 : n4;
                    } else {
                        int n6 = n3 = n3 > n4 ? n3 : n4;
                    }
                    if (n3 < 0) {
                        Object[] objectArray = new Object[]{this.m_lineBuffer};
                        MessageLog.traceErr((Object)MessageFormat.format(resourceLoader.getString("IDHDP_MISSING_ANCHOR_TAIL"), objectArray));
                        this.m_contentBuffer = this.m_contentBuffer + this.m_lineBuffer;
                        return null;
                    }
                    this.m_tagBuffer = this.m_tagBuffer + this.m_lineBuffer.substring(0, n3 + 4);
                    this.m_lineBuffer = this.m_lineBuffer.substring(n3 + 4);
                }
                return this.m_tagBuffer;
            }
            this.m_contentBuffer = this.m_contentBuffer + this.m_tagBuffer;
        }
        return null;
    }

    public String currentTag() {
        return this.m_tagBuffer;
    }

    public String previousContent() {
        return this.m_contentBuffer;
    }

    public int currentLine() {
        return this.m_currentLine;
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        if (stringArray.length > 0 && (string = stringArray[0]) != null) {
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
                return;
            }
            HelpDocParser helpDocParser = new HelpDocParser(bufferedReader);
            boolean bl = false;
            while (!bl) {
                String string2 = helpDocParser.nextTag();
                String string3 = helpDocParser.previousContent();
                System.out.println("Content: " + string3);
                System.out.println("Token:   " + string2);
                if (string2 != null) continue;
                bl = true;
            }
        }
    }

    private void debug(String string) {
        if (m_Trace) {
            System.out.println("HelpDocParser: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        resourceLoader.setResourceName("com.ibm.as400.ui.tools.HelpGenMRI");
        try {
            MessageLog.setLogFileName((String)("Service" + System.getProperty("file.separator") + "OpNav.Java.Service.log"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

