/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuBarBorder;
import com.ibm.as400.ui.tools.MenuEditor;
import com.ibm.as400.ui.tools.MenuItemLinkDialog;
import com.ibm.as400.ui.tools.MenuItemProperties;
import com.ibm.as400.ui.tools.MenuItemRenderer;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MenuSeparatorProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class MenuBuilder
extends BuilderFrame {
    JPanel m_mainToolBar;
    JPanel m_editToolBar;
    JPanel m_moveToolBar;
    JPanel m_helpToolBar;
    AbstractButton m_menu;
    JLayeredPane m_canvas;
    JScrollPane m_scroll;
    JPopupMenu m_contextMenu;
    ActionListener m_actionListener;
    MutableProperties m_emptyParent;
    MutableProperties m_selection;
    MutableProperties m_hover;
    static final int HOVER_ABOVE = 0;
    static final int HOVER_BELOW = 1;
    static final int HOVER_SUBMENU = 2;
    int m_hoverDirection = 0;
    Hashtable m_submenus;
    PDMLNodeListener m_pdmlNodeListener = new MenuPDMLNodeListener();
    TreeModelListener m_treeModelListener;

    MenuBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, MenuProperties menuProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, menuProperties);
        menuProperties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.m_treeModelListener = new MenuTreeModelListener();
        menuProperties.addTreeModelListener(this.m_treeModelListener);
        this.m_selection = menuProperties;
        this.addKeyListener(new MenuBuilderKeyListener());
        MenuActionListener menuActionListener = new MenuActionListener();
        this.m_actionListener = menuActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Insert MenuItem", null, null, "Add.gif", "IDTT_INSERT_MENUITEM", true, menuActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Insert ItemLink", null, null, "InsertItemLink.gif", "IDTT_INSERT_ITEMLINK", true, menuActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Insert Separator", null, null, "InsertSeparator.gif", "IDTT_INSERT_SEPARATOR", true, menuActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove", null, null, "Remove.gif", "IDTT_REMOVE_MENUITEM", true, menuActionListener));
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 5, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Undo", null, null, "Undo.gif", "IDTT_EDIT_UNDO", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Redo", null, null, "Redo.gif", "IDTT_EDIT_REDO", false, menuActionListener));
        this.m_moveToolBar = new DividerPanel(2);
        this.m_moveToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Up", null, null, "MoveUp.gif", "IDTT_MOVE_UP", true, menuActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Down", null, null, "MoveDown.gif", "IDTT_MOVE_DOWN", true, menuActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, menuActionListener));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, menuActionListener));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_mainToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_moveToolBar);
        jPanel.add(this.m_helpToolBar);
        jPanel.setBorder(new MenuBarBorder(((Component)this).getBackground().darker(), ((Component)this).getBackground().brighter()));
        this.m_menu = new JMenuItemMB();
        this.m_menu.addMouseListener(new MenuCanvasMouseAdapter());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new DefaultMenuLayout(jPanel2, 0));
        jPanel2.setBorder(new BasicBorders.MenuBarBorder(((Component)this).getBackground().darker(), ((Component)this).getBackground().brighter()));
        jPanel2.add(this.m_menu);
        MenuBuilder.resetMenu(this.m_menu, this.getProperties());
        this.m_canvas = new JDesktopPane();
        this.m_canvas.setLayout(null);
        this.m_canvas.setBackground(UIManager.getColor("Desktop.background"));
        this.m_canvas.setBorder(new EmptyBorder(0, 0, 100, 100));
        this.m_scroll = new JScrollPane(this.m_canvas);
        this.m_scroll.setBorder(null);
        this.m_canvas.addMouseListener(new MenuCanvasMouseAdapter());
        this.m_submenus = new Hashtable();
        this.createMenuEditor(menuProperties);
        MenuEditor menuEditor = (MenuEditor)this.m_submenus.get(menuProperties);
        menuEditor.setVisible(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        this.updateTitleBar(null);
        ((Frame)this).setIconImage(GUIFactory.getImage("Menu.gif", true).getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel3, "North");
        this.getContentPane().add((Component)this.m_scroll, "Center");
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 250;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.validateScrollPane();
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_MENU_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_actionListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_MENU_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_actionListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_MENU_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_actionListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_MENU_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_actionListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_MENU_PROPERTIES", null, true, this.m_actionListener));
    }

    JPopupMenu getContextMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.canDelete());
        return this.m_contextMenu;
    }

    String getHelpName() {
        return "MenuBuilder";
    }

    void createMenuEditor(MutableProperties mutableProperties) {
        MenuEditor menuEditor = new MenuEditor(this, mutableProperties);
        this.m_submenus.put(mutableProperties, menuEditor);
        menuEditor.setSize(menuEditor.getPreferredSize());
        menuEditor.setVisible(false);
        if (mutableProperties.equals(this.getProperties())) {
            menuEditor.setLocation(0, 0);
        } else {
            menuEditor.setLocation(this.getMenuLocation(mutableProperties));
        }
        int n = this.getProperties().getDepth() - mutableProperties.getDepth();
        this.m_canvas.add((Component)menuEditor, new Integer(n));
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            if (!mutableProperties2.getProperty("Menu Item Type").equals("submenu")) continue;
            this.createMenuEditor(mutableProperties2);
        }
    }

    void removeMenuEditor(MutableProperties mutableProperties) {
        MenuEditor menuEditor = (MenuEditor)this.m_submenus.get(mutableProperties);
        if (menuEditor != null) {
            this.m_canvas.remove(menuEditor);
            this.m_submenus.remove(mutableProperties);
        }
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            if (!mutableProperties2.getProperty("Menu Item Type").equals("submenu")) continue;
            this.removeMenuEditor(mutableProperties2);
        }
    }

    void refresh(MutableProperties mutableProperties) {
        MenuEditor menuEditor = (MenuEditor)this.m_submenus.get(mutableProperties);
        if (menuEditor != null) {
            menuEditor.setSize(menuEditor.getPreferredSize());
            menuEditor.setLocation(this.getMenuLocation(mutableProperties));
            menuEditor.repaint();
        }
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            this.refresh(mutableProperties2);
        }
    }

    void scrollItemToVisible(MutableProperties mutableProperties) {
        Rectangle rectangle;
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        if (mutableProperties2 == null) {
            return;
        }
        MenuEditor menuEditor = (MenuEditor)this.m_submenus.get(mutableProperties2);
        if (menuEditor != null && (rectangle = menuEditor.getItemBounds(mutableProperties)) != null) {
            Point point = menuEditor.getLocation();
            rectangle.x += point.x;
            rectangle.y += point.y;
            int n = 20;
            if (rectangle.x >= n) {
                rectangle.x -= n;
            }
            if (rectangle.y >= n) {
                rectangle.y -= n;
            }
            rectangle.width += n * 2;
            rectangle.height += n * 2;
            this.m_canvas.scrollRectToVisible(rectangle);
        }
    }

    void validateScrollPane() {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Enumeration enumeration = this.m_submenus.elements();
        while (enumeration.hasMoreElements()) {
            MenuEditor menuEditor = (MenuEditor)enumeration.nextElement();
            rectangle = rectangle.union(menuEditor.getBounds());
        }
        Dimension dimension = new Dimension(rectangle.width + 50, rectangle.height + 50);
        this.m_canvas.setSize(dimension);
        this.m_canvas.setPreferredSize(dimension);
        this.m_scroll.getViewport().setViewSize(dimension);
        this.m_scroll.getViewport().invalidate();
        this.m_scroll.validate();
    }

    Point getMenuLocation(MutableProperties mutableProperties) {
        TreeNode[] treeNodeArray = mutableProperties.getPath();
        int n = treeNodeArray.length - 2;
        if (treeNodeArray.length <= 1) {
            return new Point(0, 0);
        }
        MutableProperties mutableProperties2 = (MutableProperties)treeNodeArray[n];
        MenuEditor menuEditor = (MenuEditor)this.m_submenus.get(mutableProperties2);
        Point point = new Point(0, 0);
        if (menuEditor != null) {
            Rectangle rectangle = menuEditor.getItemBounds(mutableProperties);
            Point point2 = menuEditor.getLocation();
            point.x += point2.x + rectangle.x + rectangle.width;
            point.y += point2.y + rectangle.y;
        }
        return point;
    }

    static void resetMenu(AbstractButton abstractButton, MutableProperties mutableProperties) {
        Object object;
        MenuBuilder.setMenuText(abstractButton, (String)mutableProperties.getProperty("Title"));
        String string = (String)mutableProperties.getProperty("Icon");
        if (string != null && !string.equals("")) {
            object = (String)mutableProperties.getProperty("* H Position");
            String string2 = (String)mutableProperties.getProperty("* V Position");
            if (object == null) {
                object = "left";
            }
            if (string2 == null) {
                string2 = "center";
            }
            ImageIcon imageIcon = null;
            imageIcon = GUIFactory.getUserImage(string);
            if (imageIcon == null) {
                imageIcon = GUIFactory.getImage("Bitmap.gif", true);
            }
            imageIcon.setImageObserver(abstractButton);
            int n = 4;
            int n2 = 0;
            if (((String)object).equals("right")) {
                n = 2;
            } else if (((String)object).equals("center")) {
                n = 0;
            }
            if (string2.equals("top")) {
                n2 = 1;
            } else if (string2.equals("bottom")) {
                n2 = 3;
            }
            if (n == 0) {
                if (n2 == 1) {
                    n2 = 3;
                } else if (n2 == 3) {
                    n2 = 1;
                }
            }
            abstractButton.setHorizontalTextPosition(n);
            abstractButton.setVerticalTextPosition(n2);
            abstractButton.setIcon(imageIcon);
        } else {
            abstractButton.setIcon(null);
        }
        if (abstractButton instanceof MenuItemRenderer) {
            object = (MenuItemRenderer)((Object)abstractButton);
            object.setAccelerator(((MenuItemProperties)mutableProperties).getAccelerator());
        }
    }

    static void setMenuText(Component component, String string) {
        String[] stringArray = new String[]{string};
        char c = MenuBuilder.checkMnemonic(stringArray);
        AbstractButton abstractButton = (AbstractButton)component;
        abstractButton.setText(stringArray[0]);
        abstractButton.setMnemonic(c);
    }

    static char checkMnemonic(String[] stringArray) {
        String string = "";
        int n = stringArray[0].indexOf(37);
        char c = '\u0000';
        while (n != -1 && n < stringArray[0].length() - 1) {
            if (stringArray[0].charAt(n + 1) != '%') {
                c = stringArray[0].charAt(n + 1);
                stringArray[0] = string = string + stringArray[0].substring(0, n) + stringArray[0].substring(n + 1);
                string = "";
                break;
            }
            if (n + 1 >= stringArray[0].length()) break;
            string = string + stringArray[0].substring(0, n + 1);
            stringArray[0] = stringArray[0].substring(n + 2);
            n = stringArray[0].indexOf(37);
        }
        if (!string.equals("")) {
            stringArray[0] = string + stringArray[0];
        }
        return c;
    }

    public void stopEditing() {
    }

    boolean canLink() {
        Enumeration enumeration = this.getPDMLDocument().linkableMenuNames(this.getProperties());
        return enumeration.hasMoreElements();
    }

    public boolean canCut() {
        return !this.m_selection.equals(this.getProperties());
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canPaste() {
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        if (transferable != null && transferable instanceof MutableProperties) {
            MutableProperties mutableProperties = (MutableProperties)transferable;
            int n = mutableProperties.getType();
            if (n == 56) {
                String string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, false);
                String string2 = (String)this.getProperties().getProperty("Name");
                String string3 = (String)mutableProperties.getProperty("Link Resource");
                String string4 = (String)mutableProperties.getProperty("Link Menu");
                return string.equals(string3) && !string2.equals(string4);
            }
            return n == 52 || n == 51 || n == 53;
        }
        return false;
    }

    public boolean canDelete() {
        return !this.m_selection.equals(this.getProperties());
    }

    boolean canMoveUp() {
        MutableProperties mutableProperties;
        if (!this.m_selection.equals(this.getProperties()) && (mutableProperties = (MutableProperties)this.m_selection.getParent()) != null) {
            int n = mutableProperties.getIndex(this.m_selection);
            return n > 0;
        }
        return false;
    }

    boolean canMoveDown() {
        MutableProperties mutableProperties;
        if (!this.m_selection.equals(this.getProperties()) && (mutableProperties = (MutableProperties)this.m_selection.getParent()) != null) {
            int n;
            int n2 = mutableProperties.getIndex(this.m_selection);
            return n2 < (n = mutableProperties.getChildCount()) - 1;
        }
        return false;
    }

    public void setSelectedProperties(MutableProperties mutableProperties) {
        MutableProperties mutableProperties2;
        if (mutableProperties == null) {
            mutableProperties = this.getProperties();
        }
        if (!mutableProperties.equals(mutableProperties2 = this.m_selection)) {
            this.m_selection = mutableProperties;
            this.m_menu.repaint();
            this.fireSelectionChangedEvent();
            this.repaint();
        }
        MenuEditor menuEditor = null;
        menuEditor = (MenuEditor)this.m_submenus.get(this.m_selection);
        Enumeration enumeration = this.m_submenus.elements();
        while (enumeration.hasMoreElements()) {
            menuEditor = (MenuEditor)enumeration.nextElement();
            menuEditor.setVisible(false);
        }
        TreeNode[] treeNodeArray = this.m_selection.getPath();
        int n = 0;
        while (n < treeNodeArray.length) {
            MutableProperties mutableProperties3 = (MutableProperties)treeNodeArray[n];
            menuEditor = (MenuEditor)this.m_submenus.get(mutableProperties3);
            if (menuEditor != null) {
                menuEditor.setVisible(true);
            }
            ++n;
        }
        this.scrollItemToVisible(this.m_selection);
    }

    public MutableProperties getSelectedProperties() {
        return this.m_selection;
    }

    void setHoverProperties(MutableProperties mutableProperties, int n) {
        this.m_hoverDirection = n;
        this.m_hover = mutableProperties;
        MenuEditor menuEditor = null;
        if (mutableProperties != null) {
            menuEditor = (MenuEditor)this.m_submenus.get(mutableProperties);
        } else {
            mutableProperties = this.getProperties();
        }
        Enumeration enumeration = this.m_submenus.elements();
        while (enumeration.hasMoreElements()) {
            menuEditor = (MenuEditor)enumeration.nextElement();
            menuEditor.setVisible(false);
        }
        if (mutableProperties != null) {
            TreeNode[] treeNodeArray = mutableProperties.getPath();
            MutableProperties mutableProperties2 = this.getSelectedProperties();
            if (mutableProperties2.equals(this.getProperties())) {
                mutableProperties2 = null;
            }
            int n2 = 0;
            while (n2 < treeNodeArray.length) {
                MutableProperties mutableProperties3 = (MutableProperties)treeNodeArray[n2];
                menuEditor = (MenuEditor)this.m_submenus.get(mutableProperties3);
                if (menuEditor != null) {
                    if (mutableProperties2 != null && mutableProperties2.equals(mutableProperties3)) {
                        menuEditor.setVisible(false);
                    } else {
                        menuEditor.setVisible(true);
                    }
                }
                ++n2;
            }
            this.scrollItemToVisible(mutableProperties);
        }
    }

    MutableProperties getHoverProperties() {
        return this.m_hover;
    }

    int getHoverDirection() {
        return this.m_hoverDirection;
    }

    MenuEditor getItemEditor(MutableProperties mutableProperties) {
        Enumeration enumeration = this.m_submenus.elements();
        while (enumeration.hasMoreElements()) {
            MenuEditor menuEditor = (MenuEditor)enumeration.nextElement();
            if (!menuEditor.containsItem(mutableProperties)) continue;
            return menuEditor;
        }
        return null;
    }

    MenuEditor getMenuAtPoint(Point point) {
        Enumeration enumeration = this.m_submenus.elements();
        while (enumeration.hasMoreElements()) {
            MenuEditor menuEditor = (MenuEditor)enumeration.nextElement();
            if (!menuEditor.isVisible() || !menuEditor.getBounds().contains(point)) continue;
            return menuEditor;
        }
        return null;
    }

    void processMouseDrag(Point point) {
        MenuEditor menuEditor = this.getMenuAtPoint(point);
        if (menuEditor != null && menuEditor.isVisible()) {
            Rectangle rectangle = menuEditor.getBounds();
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            MutableProperties mutableProperties = menuEditor.getItemAtPoint(point);
            if (mutableProperties != null) {
                boolean bl;
                rectangle = menuEditor.getItemBounds(mutableProperties);
                point.x -= rectangle.x;
                point.y -= rectangle.y;
                boolean bl2 = bl = point.y < rectangle.height / 2;
                if (bl) {
                    this.setHoverProperties(mutableProperties, 0);
                } else {
                    this.setHoverProperties(mutableProperties, 1);
                }
            } else if (menuEditor.getComponentCount() == 1) {
                mutableProperties = menuEditor.getProperties();
                this.setHoverProperties(mutableProperties, 2);
            }
        }
        this.repaint();
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getSelectedProperties();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.doRemove();
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
        this.getBuilder().updateBuilder();
    }

    public void paste() {
        Object object;
        MutableProperties mutableProperties;
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties2 = (MutableProperties)transferable;
        if (mutableProperties2.getType() == 51) {
            Enumeration<TreeNode> enumeration;
            mutableProperties = mutableProperties2;
            mutableProperties2 = new MenuItemProperties();
            try {
                mutableProperties2.setProperty("Menu Item Type", "submenu");
                enumeration = mutableProperties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)((Object)enumeration.nextElement());
                    if (((String)object).equals("Name")) {
                        mutableProperties2.setProperty("Name", ((MenuProperties)this.getProperties()).generateUniqueName((String)mutableProperties.getProperty("Name")));
                        continue;
                    }
                    if (!mutableProperties2.hasProperty((String)object)) continue;
                    mutableProperties2.setProperty((String)object, mutableProperties.getProperty((String)object));
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            mutableProperties2.setPDMLDocument(this.getPDMLDocument());
            enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                object = (MutableProperties)enumeration.nextElement();
                mutableProperties2.add(((MutableProperties)object).cloneNode(this.getPDMLDocument(), (MenuProperties)this.getProperties()));
            }
        } else {
            mutableProperties2 = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), (MenuProperties)this.getProperties());
            mutableProperties2.setPDMLDocument(this.getPDMLDocument());
        }
        mutableProperties = this.getSelectedProperties();
        if (mutableProperties.equals(this.getProperties())) {
            mutableProperties.insert(mutableProperties2, 0);
        } else {
            object = (MutableProperties)mutableProperties.getParent();
            int n = ((DefaultMutableTreeNode)object).getIndex(mutableProperties);
            ((MutableProperties)object).insert(mutableProperties2, n + 1);
        }
        this.setSelectedProperties(mutableProperties2);
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit(false);
        this.doRemove();
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getNextSibling();
            if (mutableProperties2 == null && (mutableProperties2 = (MutableProperties)mutableProperties.getPreviousSibling()) == null && (mutableProperties2 = (MutableProperties)mutableProperties.getParent()) == null) {
                mutableProperties2 = this.getProperties();
            }
            mutableProperties.removeFromParent();
            if (mutableProperties2 != null) {
                this.setSelectedProperties(mutableProperties2);
            }
        }
    }

    void moveUp() {
        if (!this.canMoveUp()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        this.getPDMLDocument().beginEdit(true);
        mutableProperties.removeFromParent();
        mutableProperties2.insert(mutableProperties, n - 1);
        this.getPDMLDocument().endEdit();
    }

    void moveDown() {
        if (!this.canMoveDown()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        this.getPDMLDocument().beginEdit(true);
        mutableProperties.removeFromParent();
        mutableProperties2.insert(mutableProperties, n + 1);
        this.getPDMLDocument().endEdit();
    }

    public void updateBuilder() {
        this.m_mainToolBar.getComponent(1).setEnabled(this.canLink());
        this.m_mainToolBar.getComponent(3).setEnabled(this.canDelete());
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.getPDMLDocument();
        this.m_editToolBar.getComponent(3).setEnabled(xMLGUIBuilderDefinition.getUndoManager().canUndo());
        this.m_editToolBar.getComponent(4).setEnabled(xMLGUIBuilderDefinition.getUndoManager().canRedo());
        this.m_moveToolBar.getComponent(0).setEnabled(this.canMoveUp());
        this.m_moveToolBar.getComponent(1).setEnabled(this.canMoveDown());
        this.m_helpToolBar.getComponent(0).setEnabled(this.getProperties().getChildCount() > 0);
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        String string2 = (String)this.getProperties().getProperty("Name");
        string2 = string2 + " (" + string + ")";
        this.setTitle(string2);
    }

    ActionListener getContextMenuListener() {
        return this.m_actionListener;
    }

    void setEmptyParent(MutableProperties mutableProperties) {
        this.m_emptyParent = mutableProperties;
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class MenuBuilderKeyListener
    extends KeyAdapter {
        MenuBuilderKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            MutableProperties mutableProperties = MenuBuilder.this.getSelectedProperties();
            if (mutableProperties == null) {
                return;
            }
            MutableProperties mutableProperties2 = null;
            boolean bl = mutableProperties.equals(MenuBuilder.this.getProperties());
            switch (keyEvent.getKeyCode()) {
                default: {
                    return;
                }
                case 38: {
                    if (bl || (mutableProperties2 = (MutableProperties)mutableProperties.getPreviousSibling()) != null || (mutableProperties2 = (MutableProperties)mutableProperties.getParent()).equals(MenuBuilder.this.getProperties())) break;
                    mutableProperties2 = null;
                    break;
                }
                case 40: {
                    if (bl) {
                        if (mutableProperties.getChildCount() <= 0) break;
                        mutableProperties2 = (MutableProperties)mutableProperties.getFirstChild();
                        break;
                    }
                    mutableProperties2 = (MutableProperties)mutableProperties.getNextSibling();
                    break;
                }
                case 37: {
                    if (bl || !(mutableProperties2 = (MutableProperties)mutableProperties.getParent()).equals(MenuBuilder.this.getProperties())) break;
                    mutableProperties2 = null;
                    break;
                }
                case 39: {
                    if (bl || mutableProperties.getChildCount() <= 0) break;
                    mutableProperties2 = (MutableProperties)mutableProperties.getFirstChild();
                }
            }
            if (mutableProperties2 != null) {
                MenuBuilder.this.setSelectedProperties(mutableProperties2);
            }
        }
    }

    class JMenuItemMB
    extends AbstractButton {
        JMenuItem myMenuItem = new JMenuItem();

        JMenuItemMB() {
            this.setModel(new DefaultButtonModel());
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            if (string == null || string.equals("")) {
                string = " ";
            }
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(c);
            }
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(n);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getMinimumSize();
            }
            return super.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            if (MenuBuilder.this.getSelectedProperties().equals(MenuBuilder.this.getProperties())) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
                graphics.setColor(color);
            }
        }
    }

    class MenuCanvasMouseAdapter
    extends MouseAdapter {
        MenuCanvasMouseAdapter() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = MenuBuilder.this.getContextMenu();
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuBuilder.this.setSelectedProperties(null);
            if (mouseEvent.isPopupTrigger() && mouseEvent.getSource().equals(MenuBuilder.this.m_menu)) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getSource().equals(MenuBuilder.this.m_menu)) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource().equals(MenuBuilder.this.m_menu)) {
                MenuBuilder.this.getBuilder().doEditProperty("Title");
            }
        }
    }

    class MenuTreeModelListener
    implements TreeModelListener {
        MenuTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            int n = 0;
            while (n < objectArray.length) {
                MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                MenuEditor menuEditor = MenuBuilder.this.getItemEditor(mutableProperties);
                if (menuEditor != null) {
                    menuEditor.refresh(mutableProperties);
                    menuEditor.repaint();
                    String string = (String)mutableProperties.getProperty("Menu Item Type");
                    if (string.equals("submenu")) {
                        if (!MenuBuilder.this.m_submenus.containsKey(mutableProperties)) {
                            MenuBuilder.this.createMenuEditor(mutableProperties);
                        }
                    } else {
                        menuEditor = (MenuEditor)MenuBuilder.this.m_submenus.get(mutableProperties);
                        if (menuEditor != null) {
                            MenuBuilder.this.m_canvas.remove(menuEditor);
                            MenuBuilder.this.m_submenus.remove(mutableProperties);
                        }
                    }
                    MenuBuilder.this.setSelectedProperties(mutableProperties);
                }
                ++n;
            }
            MenuBuilder.this.refresh(MenuBuilder.this.getProperties());
            MenuBuilder.this.validateScrollPane();
            MenuBuilder.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            MenuEditor menuEditor = (MenuEditor)MenuBuilder.this.m_submenus.get(mutableProperties);
            if (menuEditor != null) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n];
                    menuEditor.insertItem(mutableProperties2, nArray[n]);
                    menuEditor.repaint();
                    if (mutableProperties2.getProperty("Menu Item Type").equals("submenu")) {
                        MenuBuilder.this.createMenuEditor(mutableProperties2);
                    }
                    MenuBuilder.this.setSelectedProperties(mutableProperties2);
                    ++n;
                }
                MenuBuilder.this.refresh(MenuBuilder.this.getProperties());
                MenuBuilder.this.validateScrollPane();
                MenuBuilder.this.repaint();
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            MenuEditor menuEditor = (MenuEditor)MenuBuilder.this.m_submenus.get(mutableProperties);
            if (menuEditor != null) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n];
                    menuEditor.removeItem(mutableProperties2);
                    menuEditor.repaint();
                    if (mutableProperties2.getProperty("Menu Item Type").equals("submenu")) {
                        MenuBuilder.this.removeMenuEditor(mutableProperties2);
                    }
                    ++n;
                }
                MenuBuilder.this.setSelectedProperties(mutableProperties);
                MenuBuilder.this.refresh(MenuBuilder.this.getProperties());
                MenuBuilder.this.validateScrollPane();
                MenuBuilder.this.repaint();
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class MenuActionListener
    implements ActionListener {
        MenuActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("Insert")) {
                string = string.substring(7);
                MutableProperties mutableProperties = null;
                MutableProperties mutableProperties2 = MenuBuilder.this.getSelectedProperties();
                MutableProperties mutableProperties3 = (MutableProperties)mutableProperties2.getParent();
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition = MenuBuilder.this.getPDMLDocument();
                if (string.equals("ItemLink")) {
                    mutableProperties = MenuBuilder.this.getSelectedProperties();
                    if (!mutableProperties.equals(MenuBuilder.this.getProperties())) {
                        mutableProperties = mutableProperties3;
                    }
                    MenuItemLinkDialog menuItemLinkDialog = new MenuItemLinkDialog(MenuBuilder.this, mutableProperties, GUIFactory.getString("IDS_ITEMLINK_DIALOG_NEW_TITLEBAR"));
                    menuItemLinkDialog.show();
                    mutableProperties = menuItemLinkDialog.getItemLinkProperties();
                } else if (string.equals("Separator")) {
                    mutableProperties = new MenuSeparatorProperties();
                } else {
                    mutableProperties = new MenuItemProperties();
                    try {
                        mutableProperties.setProperty("Name", ((MenuProperties)MenuBuilder.this.getProperties()).generateName(52));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    try {
                        mutableProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_MENUITEM"));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (mutableProperties != null) {
                    xMLGUIBuilderDefinition.beginEdit();
                    mutableProperties.setPDMLDocument(xMLGUIBuilderDefinition);
                    if (mutableProperties.getType() == 56) {
                        mutableProperties.initTargets();
                    }
                    if (mutableProperties2.equals(MenuBuilder.this.getProperties())) {
                        mutableProperties2.insert(mutableProperties, 0);
                    } else {
                        int n = mutableProperties3.getIndex(mutableProperties2);
                        mutableProperties3.insert(mutableProperties, n + 1);
                    }
                    MenuBuilder.this.getPDMLDocument().endEdit();
                    MenuBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.equals("Remove")) {
                MenuBuilder.this.delete();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    MenuBuilder.this.cut();
                } else if (string.equals("Copy")) {
                    MenuBuilder.this.copy();
                } else if (string.equals("Paste")) {
                    MenuBuilder.this.paste();
                } else if (string.equals("Delete")) {
                    MenuBuilder.this.delete();
                } else if (string.equals("Undo")) {
                    MenuBuilder.this.getBuilder().doUndo();
                } else if (string.equals("Redo")) {
                    MenuBuilder.this.getBuilder().doRedo();
                }
            } else if (string.startsWith("Type")) {
                string = string.substring(5).toLowerCase();
                MutableProperties mutableProperties = MenuBuilder.this.getSelectedProperties();
                String string2 = (String)mutableProperties.getProperty("Menu Item Type");
                if (!string2.equals(string)) {
                    MenuBuilder.this.getPDMLDocument().beginEdit();
                    try {
                        mutableProperties.setProperty("Menu Item Type", string);
                        MenuBuilder.this.getPDMLDocument().endEdit();
                        MenuBuilder.this.getBuilder().updateBuilder();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        JOptionPane.showMessageDialog(MenuBuilder.this, propertyVetoException.getMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        MenuBuilder.this.getPDMLDocument().abortEdit();
                    }
                }
            } else if (string.startsWith("New")) {
                Object object;
                string = string.substring(4).toLowerCase();
                MenuBuilder.this.getPDMLDocument().beginEdit();
                Object object2 = null;
                if (string.equalsIgnoreCase("ItemLink")) {
                    object2 = MenuBuilder.this.getSelectedProperties();
                    object = (MutableProperties)((DefaultMutableTreeNode)object2).getParent();
                    if (!object2.equals(MenuBuilder.this.getProperties())) {
                        object2 = object;
                    }
                    MenuItemLinkDialog menuItemLinkDialog = new MenuItemLinkDialog(MenuBuilder.this, (MutableProperties)object2, GUIFactory.getString("IDS_ITEMLINK_DIALOG_NEW_TITLEBAR"));
                    menuItemLinkDialog.show();
                    object2 = menuItemLinkDialog.getItemLinkProperties();
                } else if (string.equalsIgnoreCase("Separator")) {
                    object2 = new MenuSeparatorProperties();
                } else {
                    object2 = new MenuItemProperties();
                    try {
                        ((MutableProperties)object2).setProperty("Name", ((MenuProperties)MenuBuilder.this.getProperties()).generateName(52));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    object = GUIFactory.getString("IDS_DEFAULT_LABEL_MENUITEM");
                    if (string.equals("submenu")) {
                        object = GUIFactory.getString("IDS_DEFAULT_LABEL_MENU");
                    }
                    try {
                        ((MutableProperties)object2).setProperty("Title", object);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    try {
                        ((MutableProperties)object2).setProperty("Menu Item Type", string);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    ((MutableProperties)object2).setPDMLDocument(MenuBuilder.this.getPDMLDocument());
                    if (((MutableProperties)object2).getType() == 56) {
                        ((MutableProperties)object2).initTargets();
                    }
                    if ((object = MenuBuilder.this.m_emptyParent) == null) {
                        object = MenuBuilder.this.getProperties();
                    }
                    ((MutableProperties)object).add((MutableProperties)object2);
                    MenuBuilder.this.m_emptyParent = null;
                    MenuBuilder.this.getPDMLDocument().endEdit();
                    MenuBuilder.this.getBuilder().updateBuilder();
                    MenuBuilder.this.setHoverProperties(null, 0);
                    MenuBuilder.this.setSelectedProperties((MutableProperties)object2);
                }
            } else if (string.startsWith("Move")) {
                if ((string = string.substring(5)).equals("Up")) {
                    MenuBuilder.this.moveUp();
                    MenuBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Down")) {
                    MenuBuilder.this.moveDown();
                    MenuBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.equals("Show Properties")) {
                MenuBuilder.this.getBuilder().doShowProperties();
            } else if (string.equals("Preview")) {
                MenuBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                MenuBuilder.this.getBuilder().doPreview(MenuBuilder.this.getProperties());
                MenuBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Help")) {
                MenuBuilder.this.displayHelp();
            }
        }
    }

    class MenuPDMLNodeListener
    implements PDMLNodeListener {
        MenuPDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            MenuBuilder.this.updateTitleBar(null);
            MenuBuilder.resetMenu(MenuBuilder.this.m_menu, MenuBuilder.this.getProperties());
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }
}

