/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuContainerTable;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PropertyTableModel;
import com.ibm.as400.ui.tools.PulldownProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class MenuContainerBuilder
extends BuilderFrame {
    JPanel m_mainToolBar;
    JPanel m_moveToolBar;
    JPanel m_editToolBar;
    JPanel m_helpToolBar;
    JTable m_table;
    PropertyTableModel m_tableModel;
    MenuTableModelListener m_modelListener;
    JPopupMenu m_contextMenu;
    ActionListener m_menuListener;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener = new MenuTreeModelListener();
    static /* synthetic */ Class class$java$lang$Object;

    MenuContainerBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, MutableProperties mutableProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, mutableProperties);
        mutableProperties.addTreeModelListener(this.m_treeModelListener);
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        this.m_pdmlNodeListener = new MenuPDMLNodeListener();
        mutableProperties2.addPDMLNodeListener(this.m_pdmlNodeListener);
        MenuActionListener menuActionListener = new MenuActionListener();
        this.m_menuListener = menuActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Add", null, null, "Add.gif", "IDTT_ADD_PULLDOWN", true, menuActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove", null, null, "Remove.gif", "IDTT_REMOVE_PULLDOWN", true, menuActionListener));
        this.m_moveToolBar = new DividerPanel(2);
        this.m_moveToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Up", null, null, "MoveUp.gif", "IDTT_MOVE_UP", true, menuActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Down", null, null, "MoveDown.gif", "IDTT_MOVE_DOWN", true, menuActionListener));
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, menuActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, menuActionListener));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, menuActionListener));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_mainToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_moveToolBar);
        jPanel.add(this.m_helpToolBar);
        Object[] objectArray = new Object[]{GUIFactory.getString("IDP_RESOURCE"), GUIFactory.getString("IDP_NAME")};
        this.m_tableModel = new PropertyTableModel(mutableProperties.getType());
        this.m_tableModel.setColumnIdentifiers(objectArray);
        this.m_table = new MenuContainerTable(gUIBuilder, this.m_tableModel, mutableProperties);
        this.m_table.setOpaque(true);
        this.m_table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MenuContainerBuilder.class$("java.lang.Object")) : class$java$lang$Object, new MenuCellRenderer());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getSelectionModel().setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(new MenuSelectionListener());
        this.m_table.addMouseListener(new MenuMouseListener());
        this.m_table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MenuContainerBuilder.this.stopEditing();
            }
        });
        this.m_modelListener = new MenuTableModelListener();
        this.m_tableModel.addTableModelListener(this.m_modelListener);
        String string = null;
        switch (mutableProperties.getType()) {
            case 55: {
                string = "ToolBar.gif";
                break;
            }
            case 50: {
                string = "MenuBar.gif";
            }
        }
        if (string != null) {
            ((Frame)this).setIconImage(GUIFactory.getImage(string, true).getImage());
        }
        this.updateTitleBar(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)new JScrollPane(this.m_table), "Center");
        int n = 0;
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties3 = (MutableProperties)enumeration.nextElement();
            this.insertProperties(mutableProperties3, n, false);
            ++n;
        }
        Dimension dimension = new Dimension(400, 250);
        ((Component)this).setSize(dimension);
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_MENU_EDIT_CUT", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_MENU_EDIT_COPY", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_MENU_EDIT_PASTE", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_MENU_EDIT_DELETE", null, false, this.m_menuListener));
    }

    JPopupMenu getContextMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.canDelete());
        return this.m_contextMenu;
    }

    String getHelpName() {
        return this.getProperties().getType() == 55 ? "ToolBarBuilder" : "MenuBarBuilder";
    }

    public void stopEditing() {
        if (this.m_table.isEditing()) {
            ((DefaultCellEditor)this.m_table.getCellEditor()).stopCellEditing();
        }
    }

    boolean canAddPulldown() {
        return true;
    }

    boolean canAddNewPulldown() {
        return this.getBuilder().arePulldownsAvailable();
    }

    public boolean canCut() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canCopy() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canPaste() {
        boolean bl = this.canAddPulldown();
        if (bl) {
            bl = false;
            Transferable transferable = this.getBuilder().getClipboard().getContents(this);
            if (transferable != null && transferable instanceof MutableProperties) {
                MutableProperties mutableProperties = (MutableProperties)transferable;
                int n = mutableProperties.getType();
                return n == 54;
            }
        }
        return bl;
    }

    public boolean canDelete() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getTableSelection();
        this.doRemove();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.getPDMLDocument().endEdit();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getTableSelection();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
    }

    public void paste() {
        MutableProperties mutableProperties;
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties2 = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), null);
        mutableProperties2.setPDMLDocument(this.getPDMLDocument());
        if (mutableProperties2.getProperty("Resource").equals(this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
            mutableProperties = this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)mutableProperties2.getProperty("ID"));
            try {
                mutableProperties2.setProperty("File Target", this.getPDMLDocument().getPDMLRoot());
                if (mutableProperties != null) {
                    mutableProperties2.setProperty("Target", mutableProperties);
                } else {
                    mutableProperties2.setProperty("Target", "");
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if ((mutableProperties = this.getTableSelection()) == null) {
            this.getProperties().add(mutableProperties2);
        } else {
            this.getProperties().insert(mutableProperties2, this.getProperties().getIndex(mutableProperties) + 1);
        }
        this.getPDMLDocument().endEdit();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        this.doRemove();
        this.getPDMLDocument().endEdit();
    }

    public MutableProperties getSelectedProperties() {
        return this.getProperties();
    }

    MutableProperties getTableSelection() {
        int n = this.getSelectedRow();
        if (n > -1) {
            return (MutableProperties)this.m_tableModel.getValueAt(n, 0);
        }
        return null;
    }

    PulldownProperties getPulldownAtIndex(int n) {
        return (PulldownProperties)this.getProperties().getChildAt(n);
    }

    void insertProperties(MutableProperties mutableProperties, int n, boolean bl) {
        Object[] objectArray = new Object[]{mutableProperties, mutableProperties};
        this.m_tableModel.insertRow(n, objectArray);
        if (bl) {
            this.m_table.setRowSelectionInterval(n, n);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(n, 0, true));
        }
    }

    void removeProperties(MutableProperties mutableProperties, int n) {
        this.m_tableModel.removeRow(n);
    }

    void doAdd() {
        MutableProperties mutableProperties;
        PulldownProperties pulldownProperties = this.getBuilder().getFirstAvailablePulldown(this.getProperties());
        pulldownProperties.setPDMLDocument(this.getPDMLDocument());
        if (pulldownProperties.getProperty("Resource").equals(this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
            mutableProperties = this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)pulldownProperties.getProperty("ID"));
            try {
                pulldownProperties.setProperty("File Target", this.getPDMLDocument().getPDMLRoot());
                if (mutableProperties != null) {
                    pulldownProperties.setProperty("Target", mutableProperties);
                } else {
                    pulldownProperties.setProperty("Target", "");
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if ((mutableProperties = this.getTableSelection()) == null) {
            this.getProperties().add(pulldownProperties);
        } else {
            this.getProperties().insert(pulldownProperties, this.getProperties().getIndex(mutableProperties) + 1);
        }
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            int n = this.getSelectedRow();
            mutableProperties.removeFromParent();
            int n2 = this.m_table.getRowCount();
            if (n2 > 0) {
                if (n >= n2) {
                    n = n2 - 1;
                }
                this.m_table.setRowSelectionInterval(n, n);
            }
        }
    }

    void doMoveUp() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
            int n = mutableProperties2.getIndex(mutableProperties);
            mutableProperties.removeFromParent();
            mutableProperties2.insert(mutableProperties, n - 1);
        }
    }

    void doMoveDown() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
            int n = mutableProperties2.getIndex(mutableProperties);
            mutableProperties.removeFromParent();
            mutableProperties2.insert(mutableProperties, n + 1);
        }
    }

    public void updateBuilder() {
        boolean bl;
        boolean bl2;
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        boolean bl3 = bl2 = n > -1 && n2 > 0;
        boolean bl4 = bl2 ? n > 0 : (bl = false);
        boolean bl5 = bl2 ? n < n2 - 1 : false;
        boolean bl6 = n2 > 0;
        this.m_mainToolBar.getComponent(0).setEnabled(this.canAddNewPulldown());
        this.m_mainToolBar.getComponent(1).setEnabled(bl2);
        this.m_moveToolBar.getComponent(0).setEnabled(bl);
        this.m_moveToolBar.getComponent(1).setEnabled(bl5);
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        this.m_helpToolBar.getComponent(0).setEnabled(bl6);
    }

    int getSelectedRow() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        MutableProperties mutableProperties = (MutableProperties)this.getProperties().getParent();
        String string2 = this.getProperties().getType() == 55 ? "IDS_TOOLBAR_EDITOR_TITLEBAR" : "IDS_MENUBAR_EDITOR_TITLEBAR";
        String string3 = GUIFactory.getString(string2);
        string3 = string3 + " (" + (String)mutableProperties.getProperty("Name") + ": " + string + ")";
        this.setTitle(string3);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MenuMouseListener
    extends MouseAdapter {
        MenuMouseListener() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            int n = MenuContainerBuilder.this.m_table.rowAtPoint(mouseEvent.getPoint());
            int n2 = MenuContainerBuilder.this.m_table.columnAtPoint(mouseEvent.getPoint());
            if (n != -1 && n == MenuContainerBuilder.this.getSelectedRow() && n2 > -1) {
                JPopupMenu jPopupMenu = MenuContainerBuilder.this.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }
    }

    class MenuTableModelListener
    implements TableModelListener {
        MenuTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                MenuContainerBuilder.this.m_tableModel.removeTableModelListener(MenuContainerBuilder.this.m_modelListener);
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                if (n == 0) {
                    Object object = MenuContainerBuilder.this.m_tableModel.getValueAt(n2, 0);
                    if (object instanceof XMLGUIBuilderDefinition) {
                        int n3 = MenuContainerBuilder.this.getProperties().getType();
                        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)object;
                        PulldownProperties pulldownProperties = MenuContainerBuilder.this.getBuilder().getFirstAvailablePulldown(xMLGUIBuilderDefinition.getPDMLRoot());
                        PulldownProperties pulldownProperties2 = MenuContainerBuilder.this.getPulldownAtIndex(n2);
                        if (!pulldownProperties.getProperty("Resource").equals(pulldownProperties2.getProperty("Resource"))) {
                            MenuContainerBuilder.this.getPDMLDocument().beginEdit();
                            try {
                                pulldownProperties2.setProperty("Resource", pulldownProperties.getProperty("Resource"));
                                pulldownProperties2.setProperty("ID", pulldownProperties.getProperty("ID"));
                                pulldownProperties2.setProperty("Type", pulldownProperties.getProperty("Type"));
                                if (xMLGUIBuilderDefinition.equals(MenuContainerBuilder.this.getPDMLDocument())) {
                                    pulldownProperties2.setProperty("File Target", MenuContainerBuilder.this.getPDMLDocument().getPDMLRoot());
                                    MutableProperties mutableProperties = xMLGUIBuilderDefinition.getPDMLRoot().getNodeNamed((String)pulldownProperties.getProperty("ID"));
                                    if (mutableProperties != null) {
                                        pulldownProperties2.setProperty("Target", mutableProperties);
                                    } else {
                                        pulldownProperties2.setProperty("Target", "");
                                    }
                                }
                                pulldownProperties2.setProperty("File Target", "");
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                            MenuContainerBuilder.this.getPDMLDocument().endEdit();
                        }
                        MenuContainerBuilder.this.m_tableModel.setValueAt(pulldownProperties2, n2, 0);
                        MenuContainerBuilder.this.m_tableModel.setValueAt(pulldownProperties2, n2, 1);
                    } else {
                        object = MenuContainerBuilder.this.m_tableModel.getValueAt(n2, 1);
                        MenuContainerBuilder.this.m_tableModel.setValueAt(object, n2, 0);
                    }
                } else if (n == 1) {
                    PulldownProperties pulldownProperties = (PulldownProperties)MenuContainerBuilder.this.m_tableModel.getValueAt(n2, n);
                    PulldownProperties pulldownProperties3 = MenuContainerBuilder.this.getPulldownAtIndex(n2);
                    if (!pulldownProperties3.getProperty("ID").equals(pulldownProperties.getProperty("ID"))) {
                        MenuContainerBuilder.this.getPDMLDocument().beginEdit();
                        try {
                            pulldownProperties3.setProperty("Resource", pulldownProperties.getProperty("Resource"));
                            pulldownProperties3.setProperty("ID", pulldownProperties.getProperty("ID"));
                            pulldownProperties3.setProperty("Type", pulldownProperties.getProperty("Type"));
                            if (pulldownProperties.getProperty("Resource").equals(MenuContainerBuilder.this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
                                MutableProperties mutableProperties = MenuContainerBuilder.this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)pulldownProperties.getProperty("ID"));
                                if (mutableProperties != null) {
                                    pulldownProperties3.setProperty("Target", mutableProperties);
                                } else {
                                    pulldownProperties3.setProperty("Target", "");
                                }
                            }
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        MenuContainerBuilder.this.getPDMLDocument().endEdit();
                    }
                    MenuContainerBuilder.this.m_tableModel.setValueAt(pulldownProperties3, n2, 1);
                }
                MenuContainerBuilder.this.m_tableModel.addTableModelListener(MenuContainerBuilder.this.m_modelListener);
            }
        }
    }

    class MenuTreeModelListener
    implements TreeModelListener {
        MenuTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            MenuContainerBuilder.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(MenuContainerBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    MenuContainerBuilder.this.insertProperties(mutableProperties, nArray[n], true);
                    ++n;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(MenuContainerBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    MenuContainerBuilder.this.removeProperties(mutableProperties, nArray[n]);
                    ++n;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class MenuPDMLNodeListener
    implements PDMLNodeListener {
        MenuPDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            MenuContainerBuilder.this.updateTitleBar(null);
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class MenuCellRenderer
    extends DefaultTableCellRenderer {
        MenuCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            }
            if (object != null) {
                this.setValue(object);
                this.setIcon(null);
                PulldownProperties pulldownProperties = (PulldownProperties)object;
                if (n2 == 0) {
                    this.setText((String)pulldownProperties.getProperty("Resource"));
                } else if (n2 == 1) {
                    this.setText((String)pulldownProperties.getProperty("ID"));
                    this.setIcon(GUIFactory.getImage("Menu.gif", true));
                }
            }
            return this;
        }
    }

    class MenuSelectionListener
    implements ListSelectionListener {
        MenuSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MenuContainerBuilder.this.fireSelectionChangedEvent();
        }
    }

    class MenuActionListener
    implements ActionListener {
        MenuActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuContainerBuilder.this.stopEditing();
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                MenuContainerBuilder.this.getPDMLDocument().beginEdit();
                MenuContainerBuilder.this.doAdd();
                MenuContainerBuilder.this.getPDMLDocument().endEdit();
                MenuContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Remove")) {
                MenuContainerBuilder.this.getPDMLDocument().beginEdit();
                MenuContainerBuilder.this.doRemove();
                MenuContainerBuilder.this.getPDMLDocument().endEdit();
                MenuContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Up")) {
                MenuContainerBuilder.this.getPDMLDocument().beginEdit(true);
                MenuContainerBuilder.this.doMoveUp();
                MenuContainerBuilder.this.getPDMLDocument().endEdit();
                MenuContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Move Down")) {
                MenuContainerBuilder.this.getPDMLDocument().beginEdit(true);
                MenuContainerBuilder.this.doMoveDown();
                MenuContainerBuilder.this.getPDMLDocument().endEdit();
                MenuContainerBuilder.this.getBuilder().updateBuilder();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    MenuContainerBuilder.this.cut();
                    MenuContainerBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Copy")) {
                    MenuContainerBuilder.this.copy();
                    MenuContainerBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Paste")) {
                    MenuContainerBuilder.this.paste();
                    MenuContainerBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Delete")) {
                    MenuContainerBuilder.this.delete();
                    MenuContainerBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.equals("Preview")) {
                MenuContainerBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                MutableProperties mutableProperties = MenuContainerBuilder.this.getProperties();
                mutableProperties = (MutableProperties)mutableProperties.getParent();
                MenuContainerBuilder.this.getBuilder().doPreview(mutableProperties);
                MenuContainerBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Help")) {
                MenuContainerBuilder.this.displayHelp();
            }
        }
    }
}

