/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PulldownProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class MenuContainerTable
extends JTable {
    GUIBuilder m_builder;
    MutableProperties m_parentProperties;

    public MenuContainerTable(GUIBuilder gUIBuilder, TableModel tableModel, MutableProperties mutableProperties) {
        super(tableModel);
        this.m_builder = gUIBuilder;
        this.m_parentProperties = mutableProperties;
    }

    public TableCellEditor getCustomCellEditor(int n, int n2) {
        int n3 = this.m_parentProperties.getType();
        if (n2 == 0) {
            PulldownProperties pulldownProperties = (PulldownProperties)this.getModel().getValueAt(n, n2);
            String string = (String)pulldownProperties.getProperty("Resource");
            MenuCellEditor menuCellEditor = new MenuCellEditor(true);
            Vector vector = this.m_builder.getAvailablePulldownResources(this.m_parentProperties);
            boolean bl = false;
            if (vector != null) {
                int n4 = vector.size();
                int n5 = 0;
                while (n5 < n4) {
                    XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)vector.elementAt(n5);
                    if (xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false).equals(string)) {
                        menuCellEditor.addItem(pulldownProperties);
                        bl = true;
                    } else {
                        menuCellEditor.addItem(xMLGUIBuilderDefinition);
                    }
                    ++n5;
                }
            }
            if (!bl) {
                menuCellEditor.insertItemAt(pulldownProperties, 0);
            }
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(menuCellEditor);
            defaultCellEditor.setClickCountToStart(2);
            return defaultCellEditor;
        }
        if (n2 == 1) {
            PulldownProperties pulldownProperties = (PulldownProperties)this.getModel().getValueAt(n, n2);
            String string = (String)pulldownProperties.getProperty("Resource");
            String string2 = (String)pulldownProperties.getProperty("ID");
            MenuCellEditor menuCellEditor = new MenuCellEditor(false);
            Vector vector = this.m_builder.getAvailablePulldowns(string, this.m_parentProperties);
            boolean bl = false;
            if (vector != null) {
                int n6 = vector.size();
                int n7 = 0;
                while (n7 < n6) {
                    PulldownProperties pulldownProperties2 = (PulldownProperties)vector.elementAt(n7);
                    if (pulldownProperties2.getProperty("ID").equals(string2)) {
                        menuCellEditor.addItem(pulldownProperties);
                        bl = true;
                    } else {
                        menuCellEditor.addItem(pulldownProperties2);
                    }
                    ++n7;
                }
            }
            if (!bl) {
                menuCellEditor.insertItemAt(pulldownProperties, 0);
            }
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(menuCellEditor);
            defaultCellEditor.setClickCountToStart(2);
            return defaultCellEditor;
        }
        return null;
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        TableColumn tableColumn;
        boolean bl;
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this.isEditing() && this.cellEditor != null && !(bl = this.cellEditor.stopCellEditing())) {
            return false;
        }
        TableCellEditor tableCellEditor = this.getCustomCellEditor(n, n2);
        if (tableCellEditor == null && (tableCellEditor = (tableColumn = this.getColumnModel().getColumn(n2)).getCellEditor()) == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2));
        }
        if (tableCellEditor != null) {
            this.editorComp = this.prepareEditor(tableCellEditor, n, n2);
            if (tableCellEditor.isCellEditable(eventObject)) {
                this.editorComp.setBounds(this.getCellRect(n, n2, false));
                this.add(this.editorComp);
                this.editorComp.validate();
                boolean bl2 = tableCellEditor.shouldSelectCell(eventObject);
                this.setCellEditor(tableCellEditor);
                this.setEditingRow(n);
                this.setEditingColumn(n2);
                tableCellEditor.addCellEditorListener(this);
                this.repaint();
                return true;
            }
        }
        return false;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class MenuCellEditorRenderer
    extends DefaultListCellRenderer {
        boolean m_isResource = false;

        MenuCellEditorRenderer(boolean bl) {
            this.m_isResource = bl;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof XMLGUIBuilderDefinition) {
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)object;
                String string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
                jLabel.setText(string);
            } else if (object instanceof PulldownProperties) {
                PulldownProperties pulldownProperties = (PulldownProperties)object;
                if (this.m_isResource) {
                    jLabel.setText((String)pulldownProperties.getProperty("Resource"));
                } else {
                    jLabel.setText((String)pulldownProperties.getProperty("ID"));
                    jLabel.setIcon(GUIFactory.getImage("Menu.gif", true));
                }
            }
            return jLabel;
        }
    }

    class MenuCellEditor
    extends JComboBox {
        MenuCellEditor(boolean bl) {
            this.setBorder(new LineBorder(Color.black));
            this.setEditable(false);
            this.setRenderer(new MenuCellEditorRenderer(bl));
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ MenuCellEditor this$1;
                {
                    this.this$1 = menuCellEditor;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27 && MenuCellEditor.access$000(this.this$1).isEditing()) {
                        ((DefaultCellEditor)MenuCellEditor.access$000(this.this$1).getCellEditor()).cancelCellEditing();
                    } else if (keyEvent.getKeyCode() == 10 && MenuCellEditor.access$000(this.this$1).isEditing()) {
                        ((DefaultCellEditor)MenuCellEditor.access$000(this.this$1).getCellEditor()).stopCellEditing();
                    }
                }
            });
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isManagingFocus() {
            return true;
        }

        static /* synthetic */ MenuContainerTable access$000(MenuCellEditor menuCellEditor) {
            return menuCellEditor.MenuContainerTable.this;
        }
    }
}

