/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.FixedDefaultTreeModel;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuItemLinkProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

class MenuItemLinkDialog
extends JDialog {
    BuilderFrame m_parent;
    GUIBuilder m_builder;
    MutableProperties m_properties;
    MenuItemLinkProperties m_linkProperties;
    JComboBox m_comboResource;
    JComboBox m_comboContainer;
    JButton m_okButton;
    JTree m_tree;
    int m_lastSelectedIndex = 0;
    int m_lastSelectedTypeIndex = 0;
    ActionListener m_comboActionListener;
    String m_resourceName;
    String m_containerName;
    String m_itemName;

    MenuItemLinkDialog(BuilderFrame builderFrame, MutableProperties mutableProperties, String string) {
        super(builderFrame, string, true);
        this.m_parent = builderFrame;
        this.m_builder = builderFrame.getBuilder();
        this.m_properties = mutableProperties;
        this.m_linkProperties = null;
        if (mutableProperties != null) {
            this.m_resourceName = (String)mutableProperties.getProperty("Link Resource");
            this.m_containerName = (String)mutableProperties.getProperty("Link Menu");
            this.m_itemName = (String)mutableProperties.getProperty("Link Item");
        } else {
            this.m_resourceName = null;
            this.m_containerName = null;
            this.m_itemName = null;
        }
        this.m_comboResource = new JComboBox();
        this.m_comboResource.setRenderer(new LinkResourceRenderer());
        this.m_comboContainer = new JComboBox();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(GUIFactory.getString("IDS_ITEMLINK_DIALOG_RESOURCE"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jLabel = new JLabel(GUIFactory.getString("IDS_ITEMLINK_DIALOG_CONTAINER"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel(GUIFactory.getString("IDS_ITEMLINK_DIALOG_ITEMS"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_comboResource, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.m_comboContainer, gridBagConstraints);
        jPanel.add(this.m_comboContainer);
        Dimension dimension = new Dimension(80, 25);
        LinkActionListener linkActionListener = new LinkActionListener();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 5, 0));
        this.m_okButton = GUIFactory.createButton("OK", null, "IDS_OK", null, null, false, linkActionListener);
        jPanel2.add(this.m_okButton);
        JButton jButton = GUIFactory.createButton("Cancel", null, "IDS_CANCEL", null, null, true, linkActionListener);
        jPanel2.add(jButton);
        JButton jButton2 = GUIFactory.createButton("Help", null, "IDS_HELP", null, null, true, linkActionListener);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "East");
        Dimension dimension2 = this.m_okButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton2.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        this.m_okButton.setPreferredSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.m_tree = new JTree();
        this.initResource();
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new LinkTreeRenderer());
        this.m_tree.addTreeSelectionListener(new LinkTreeSelectionListener());
        this.m_tree.addMouseListener(new LinkMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.m_tree);
        jScrollPane.setBorder(new BevelBorder(1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel4.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        jPanel5.add((Component)jPanel3, "South");
        jPanel5.add((Component)jPanel4, "Center");
        jPanel5.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add((Component)jPanel5, "Center");
        dimension2 = this.getPreferredSize();
        if (dimension2.width < 400) {
            dimension2.width = 400;
        }
        dimension2.height = 300;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point();
        point.x = (dimension3.width - dimension2.width) / 2;
        point.y = (dimension3.height - dimension2.height) / 2;
        ((Component)this).setBounds(point.x, point.y, dimension2.width, dimension2.height);
        this.setDefaultCloseOperation(2);
        this.m_comboActionListener = new LinkComboActionListener();
        this.m_comboResource.addActionListener(this.m_comboActionListener);
        this.m_comboContainer.addActionListener(this.m_comboActionListener);
        this.addKeyListener(new LinkKeyListener());
    }

    void initResource() {
        Vector vector = this.m_builder.getAvailablePulldownResources(null);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_comboResource.addItem(vector.elementAt(n2));
            ++n2;
        }
        this.m_comboResource.setSelectedItem(this.m_parent.getProperties().getPDMLDocument());
        this.refreshContainers();
    }

    void refreshContainers() {
        if (this.m_comboContainer.getItemCount() > 0) {
            this.m_comboContainer.removeAllItems();
        }
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)this.m_comboResource.getSelectedItem();
        Enumeration enumeration = xMLGUIBuilderDefinition.linkableMenuNames(this.m_parent.getProperties());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.m_comboContainer.addItem(string);
        }
        this.refreshItems();
    }

    void refreshItems() {
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)this.m_comboResource.getSelectedItem();
        String string = (String)this.m_comboContainer.getSelectedItem();
        MutableProperties mutableProperties = xMLGUIBuilderDefinition.getPDMLRoot().getNodeNamed(string);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(mutableProperties);
        FixedDefaultTreeModel fixedDefaultTreeModel = new FixedDefaultTreeModel(defaultMutableTreeNode);
        this.addNodes(defaultMutableTreeNode, mutableProperties);
        this.m_tree.setModel(fixedDefaultTreeModel);
    }

    void addNodes(DefaultMutableTreeNode defaultMutableTreeNode, MutableProperties mutableProperties) {
        if (mutableProperties == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(mutableProperties2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.addNodes(defaultMutableTreeNode2, mutableProperties2);
        }
    }

    void doUpdate() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            EventListener eventListener;
            String string;
            String string2;
            String string3;
            MutableProperties mutableProperties = (MutableProperties)defaultMutableTreeNode.getUserObject();
            if (mutableProperties.getType() == 56) {
                string3 = (String)mutableProperties.getProperty("Link Resource");
                string2 = (String)mutableProperties.getProperty("Link Menu");
                string = (String)mutableProperties.getProperty("Link Item");
            } else {
                eventListener = (XMLGUIBuilderDefinition)this.m_comboResource.getSelectedItem();
                string3 = ((XMLGUIBuilderDefinition)eventListener).getPDMLRoot().getResourceName(true, false);
                string2 = (String)this.m_comboContainer.getSelectedItem();
                string = (String)mutableProperties.getProperty("Name");
            }
            eventListener = new MenuItemLinkProperties();
            try {
                ((MutableProperties)eventListener).setProperty("Link Resource", string3);
                ((MutableProperties)eventListener).setProperty("Link Menu", string2);
                ((MutableProperties)eventListener).setProperty("Link Item", string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.m_linkProperties = eventListener;
        }
    }

    MenuItemLinkProperties getItemLinkProperties() {
        return this.m_linkProperties;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class LinkKeyListener
    extends KeyAdapter {
        LinkKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 112) {
                MenuItemLinkDialog.this.m_builder.displayHelp("ImportMenuItemDialog", MenuItemLinkDialog.this);
            }
        }
    }

    class LinkResourceRenderer
    extends DefaultListCellRenderer {
        LinkResourceRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)object;
            String string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
            jLabel.setText(string);
            return jLabel;
        }
    }

    class LinkTreeRenderer
    extends DefaultTreeCellRenderer {
        LinkTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            MutableProperties mutableProperties = (MutableProperties)defaultMutableTreeNode.getUserObject();
            String string = "";
            if (mutableProperties != null) {
                string = (String)mutableProperties.getProperty("Name");
            }
            if (string == null) {
                string = mutableProperties.getType() == 56 ? (String)mutableProperties.getProperty("Link Menu") + "." + (String)mutableProperties.getProperty("Link Item") : GUIFactory.getString("IDS_MENUITEM_SEPARATOR");
            }
            jLabel.setText(string);
            jLabel.setIcon(null);
            return jLabel;
        }
    }

    class LinkTreeSelectionListener
    implements TreeSelectionListener {
        LinkTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            boolean bl;
            boolean bl2 = bl = MenuItemLinkDialog.this.m_tree.getSelectionPath() != null;
            if (bl) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)MenuItemLinkDialog.this.m_tree.getLastSelectedPathComponent();
                MutableProperties mutableProperties = (MutableProperties)defaultMutableTreeNode.getUserObject();
                if (mutableProperties.getType() == 56) {
                    String string;
                    String string2 = MenuItemLinkDialog.this.m_properties.getPDMLDocument().getPDMLRoot().getResourceName(true, false);
                    if (string2.equals(string = (String)mutableProperties.getProperty("Link Resource"))) {
                        String string3;
                        String string4 = (String)MenuItemLinkDialog.this.m_properties.getProperty("Name");
                        bl = !string4.equals(string3 = (String)mutableProperties.getProperty("Link Menu"));
                    }
                } else if (mutableProperties.getType() == 53) {
                    bl = false;
                }
            }
            MenuItemLinkDialog.this.m_okButton.setEnabled(bl);
        }
    }

    class LinkMouseListener
    extends MouseAdapter {
        LinkMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() != 2 || (n = MenuItemLinkDialog.this.m_tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY())) > -1) {
                // empty if block
            }
        }
    }

    class LinkActionListener
    implements ActionListener {
        LinkActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                MenuItemLinkDialog.this.doUpdate();
                MenuItemLinkDialog.this.dispose();
            } else if (string.equals("Cancel")) {
                MenuItemLinkDialog.this.dispose();
            } else if (string.equals("Help")) {
                MenuItemLinkDialog.this.m_builder.displayHelp("ImportMenuItemDialog", MenuItemLinkDialog.this);
            }
        }
    }

    class LinkComboActionListener
    implements ActionListener {
        LinkComboActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuItemLinkDialog.this.m_comboResource.removeActionListener(MenuItemLinkDialog.this.m_comboActionListener);
            MenuItemLinkDialog.this.m_comboContainer.removeActionListener(MenuItemLinkDialog.this.m_comboActionListener);
            if (actionEvent.getSource().equals(MenuItemLinkDialog.this.m_comboResource)) {
                MenuItemLinkDialog.this.refreshContainers();
            } else {
                MenuItemLinkDialog.this.refreshItems();
            }
            MenuItemLinkDialog.this.m_comboResource.addActionListener(MenuItemLinkDialog.this.m_comboActionListener);
            MenuItemLinkDialog.this.m_comboContainer.addActionListener(MenuItemLinkDialog.this.m_comboActionListener);
        }
    }
}

