/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.ButtonGroupProperties;
import com.ibm.as400.ui.tools.ButtonProperties;
import com.ibm.as400.ui.tools.CheckBoxProperties;
import com.ibm.as400.ui.tools.ColumnProperties;
import com.ibm.as400.ui.tools.ComboBoxProperties;
import com.ibm.as400.ui.tools.ComponentInfo;
import com.ibm.as400.ui.tools.ComponentProperties;
import com.ibm.as400.ui.tools.CustomProperties;
import com.ibm.as400.ui.tools.DeckPaneProperties;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.GroupBoxProperties;
import com.ibm.as400.ui.tools.ImageProperties;
import com.ibm.as400.ui.tools.LabelProperties;
import com.ibm.as400.ui.tools.ListProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PanelBuilder;
import com.ibm.as400.ui.tools.PanelProperties;
import com.ibm.as400.ui.tools.ProgressBarProperties;
import com.ibm.as400.ui.tools.RadioButtonProperties;
import com.ibm.as400.ui.tools.SelectionEvent;
import com.ibm.as400.ui.tools.SelectionListener;
import com.ibm.as400.ui.tools.SliderProperties;
import com.ibm.as400.ui.tools.SpinnerProperties;
import com.ibm.as400.ui.tools.SplitPaneProperties;
import com.ibm.as400.ui.tools.TabbedPaneProperties;
import com.ibm.as400.ui.tools.TableProperties;
import com.ibm.as400.ui.tools.TextProperties;
import com.ibm.as400.ui.tools.TreeProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class PanelEditor
extends JPanel {
    PanelBuilder m_panelBuilder;
    PanelProperties m_properties;
    PanelMenuToolBorder m_border;
    JPopupMenu m_contextMenu;
    Point m_contextMenuLocation;
    JScrollPane m_scroll;
    JLayeredPane m_canvas;
    Hashtable m_components;
    Vector m_trackers;
    MutableProperties m_resizeProperties;
    Rectangle m_resizeOriginalRect;
    int m_resizeType = 0;
    Rectangle m_moveRect;
    Point m_ptMoveOrigin = null;
    Point m_ptMoveDestination = null;
    Point m_ptOrigin = null;
    Point m_ptDestination = null;
    int m_dragCount = 0;
    int m_dragThreshold = 3;
    boolean m_lassoSelect = false;
    PanelMenuListener m_menuListener;
    Font m_tabFont;
    boolean m_bPaintGrid = false;
    boolean m_bPaintMargins = false;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener;

    PanelEditor(PanelBuilder panelBuilder, PanelProperties panelProperties) {
        Font font = this.getFont();
        this.m_tabFont = new Font(font.getName(), 1, font.getSize());
        this.m_trackers = new Vector(5, 5);
        this.m_panelBuilder = panelBuilder;
        this.m_panelBuilder.addSelectionListener(new PanelSelectionListener());
        this.m_properties = panelProperties;
        this.m_treeModelListener = new PanelEditorTreeModelListener();
        this.m_properties.addTreeModelListener(this.m_treeModelListener);
        this.m_pdmlNodeListener = new PanelEditorPDMLNodeListener();
        this.m_properties.addPDMLNodeListener(this.m_pdmlNodeListener);
        PanelMouseListener panelMouseListener = new PanelMouseListener();
        this.m_canvas = new PanelEditorCanvas();
        this.m_canvas.setBackground(UIManager.getColor("Panel.background"));
        this.m_canvas.setLayout(null);
        this.m_canvas.addMouseListener(panelMouseListener);
        this.m_canvas.addMouseMotionListener(panelMouseListener);
        Dimension dimension = (Dimension)panelProperties.getProperty("Size");
        this.m_canvas.setSize(dimension);
        this.m_canvas.setPreferredSize(dimension);
        PanelDesktopMouseListener panelDesktopMouseListener = new PanelDesktopMouseListener();
        this.addMouseListener(panelDesktopMouseListener);
        this.addMouseMotionListener(panelDesktopMouseListener);
        this.setBackground(Color.white);
        this.m_border = new PanelMenuToolBorder();
        this.setBorder(this.m_border);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.m_canvas);
        this.m_menuListener = new PanelMenuListener();
        this.m_contextMenu = new JPopupMenu();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_PANEL_EDIT_CUT", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_PANEL_EDIT_COPY", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_PANEL_EDIT_PASTE", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_PANEL_EDIT_DELETE", null, false, this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_PANEL_PROPERTIES", null, true, this.m_menuListener));
        this.m_components = new Hashtable();
        Enumeration<TreeNode> enumeration = panelProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            this.createComponentInfo(mutableProperties);
        }
    }

    ActionListener getContextMenuListener() {
        return this.m_menuListener;
    }

    void clearContextMenuLocation() {
        this.m_contextMenuLocation = null;
    }

    JPopupMenu getContextMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelBuilder.canDelete());
        return this.m_contextMenu;
    }

    ComponentInfo getComponentInfo(MutableProperties mutableProperties) {
        return (ComponentInfo)this.m_components.get(mutableProperties);
    }

    void createComponentInfo(MutableProperties mutableProperties) {
        int n = mutableProperties.getType();
        if (n == 50) {
            this.m_border.setMenuBar(mutableProperties);
            this.m_panelBuilder.revalidateScroll();
            return;
        }
        if (n == 55) {
            this.m_border.setToolBar(mutableProperties);
            this.m_panelBuilder.revalidateScroll();
            return;
        }
        if (n == 112) {
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
                this.createComponentInfo(mutableProperties2);
            }
        } else {
            ComponentInfo componentInfo = new ComponentInfo(this, mutableProperties);
            this.m_components.put(mutableProperties, componentInfo);
            int n2 = mutableProperties.getType() == 3 ? -1 : 0;
            this.m_canvas.add((Component)componentInfo, new Integer(n2));
        }
    }

    void removeComponentInfo(MutableProperties mutableProperties) {
        ComponentInfo componentInfo = (ComponentInfo)this.m_components.get(mutableProperties);
        if (componentInfo != null) {
            this.m_components.remove(mutableProperties);
            this.m_canvas.remove(componentInfo);
        } else if (mutableProperties.getType() == 112) {
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
                this.removeComponentInfo(mutableProperties2);
            }
        } else if (mutableProperties.getType() == 55) {
            this.m_border.setToolBar(null);
            this.m_panelBuilder.revalidateScroll();
        } else if (mutableProperties.getType() == 50) {
            this.m_border.setMenuBar(null);
            this.m_panelBuilder.revalidateScroll();
        }
    }

    void refresh() {
    }

    Dimension getDefaultComponentSize(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            default: {
                break;
            }
            case 2: {
                n2 = 90;
                n3 = 20;
                break;
            }
            case 6: {
                n2 = 80;
                n3 = 25;
                break;
            }
            case 4: 
            case 8: 
            case 101: 
            case 102: 
            case 106: 
            case 108: {
                n2 = 90;
                n3 = 20;
                break;
            }
            case 109: {
                n2 = 90;
                n3 = 25;
                break;
            }
            case 5: 
            case 9: 
            case 60: 
            case 61: 
            case 62: 
            case 103: 
            case 104: 
            case 110: 
            case 111: {
                n2 = 90;
                n3 = 70;
                break;
            }
            case 3: {
                n2 = 140;
                n3 = 70;
            }
        }
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        rectangle = this.m_panelBuilder.getProperties().getPDMLDocument().scaleRect(rectangle);
        return rectangle.getSize();
    }

    MutableProperties createNewComponentProperties(int n, Rectangle rectangle) {
        ComponentProperties componentProperties = null;
        switch (n) {
            default: {
                break;
            }
            case 2: {
                componentProperties = new LabelProperties();
                break;
            }
            case 101: {
                componentProperties = new RadioButtonProperties();
                break;
            }
            case 102: {
                componentProperties = new CheckBoxProperties();
                break;
            }
            case 8: {
                componentProperties = new ComboBoxProperties();
                break;
            }
            case 6: {
                componentProperties = new ButtonProperties();
                break;
            }
            case 106: {
                componentProperties = new SpinnerProperties();
                break;
            }
            case 4: 
            case 5: {
                componentProperties = new TextProperties();
                break;
            }
            case 109: {
                componentProperties = new SliderProperties();
                break;
            }
            case 108: {
                componentProperties = new ProgressBarProperties();
                break;
            }
            case 60: {
                componentProperties = new DeckPaneProperties();
                ((MutableProperties)componentProperties).setPropertyVisible("Bounds", true);
                break;
            }
            case 61: {
                componentProperties = new SplitPaneProperties();
                ((MutableProperties)componentProperties).setPropertyVisible("Bounds", true);
                break;
            }
            case 62: {
                componentProperties = new TabbedPaneProperties();
                ((MutableProperties)componentProperties).setPropertyVisible("Bounds", true);
                break;
            }
            case 111: {
                componentProperties = new CustomProperties();
                break;
            }
            case 110: {
                componentProperties = new ImageProperties();
                break;
            }
            case 9: {
                componentProperties = new ListProperties();
                break;
            }
            case 103: {
                componentProperties = new TableProperties();
                ColumnProperties columnProperties = new ColumnProperties();
                try {
                    columnProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_COLUMN") + "1");
                    columnProperties.setProperty("Primary", new Boolean(true));
                    columnProperties.setProperty("Width", new Integer(75));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                componentProperties.add(columnProperties);
                break;
            }
            case 104: {
                componentProperties = new TreeProperties();
                break;
            }
            case 3: {
                componentProperties = new GroupBoxProperties();
            }
        }
        if (componentProperties != null) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_panelBuilder.getPDMLDocument();
            try {
                componentProperties.setProperty("Name", this.m_properties.generateName(n));
                componentProperties.setProperty("Bounds", rectangle);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            componentProperties.setPDMLDocument(xMLGUIBuilderDefinition);
        }
        return componentProperties;
    }

    void showContextMenu(Point point, JPopupMenu jPopupMenu) {
        this.m_contextMenuLocation = point;
        jPopupMenu.show(this.m_canvas, point.x, point.y);
    }

    boolean canMoveSelected() {
        Enumeration enumeration;
        if (this.m_panelBuilder.getTool() == -1 && (enumeration = this.m_panelBuilder.getSelection()).hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            int n = mutableProperties.getType();
            return n != 1 && n != 50 && n != 55 && n != 112;
        }
        return false;
    }

    void moveSelected(int n, int n2) {
        if (!this.canMoveSelected()) {
            return;
        }
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_panelBuilder.getPDMLDocument();
        xMLGUIBuilderDefinition.beginEdit();
        try {
            Enumeration enumeration = this.m_panelBuilder.getSelection();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
                Rectangle rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                rectangle = new Rectangle(rectangle.x + n, rectangle.y + n2, rectangle.width, rectangle.height);
                mutableProperties.setProperty("Bounds", rectangle);
            }
            xMLGUIBuilderDefinition.endEdit();
        }
        catch (PropertyVetoException propertyVetoException) {
            xMLGUIBuilderDefinition.abortEdit();
        }
        this.m_panelBuilder.getBuilder().updateBuilder();
    }

    Rectangle getCanvasBounds() {
        Rectangle rectangle = this.m_canvas.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this.m_bPaintMargins) {
            Insets insets = this.m_panelBuilder.getBuilder().getPanelMargins();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
        return rectangle;
    }

    Point convertGridPoint(Point point) {
        int n;
        Point point2 = new Point(point.x, point.y);
        Insets insets = this.m_panelBuilder.getBuilder().getPanelMargins();
        int n2 = this.m_bPaintMargins ? insets.top : 0;
        int n3 = this.m_bPaintMargins ? insets.bottom : 0;
        int n4 = this.m_bPaintMargins ? insets.left : 0;
        int n5 = n = this.m_bPaintMargins ? insets.right : 0;
        if (this.m_resizeProperties != null && this.m_resizeProperties.getType() == 1) {
            if (this.m_bPaintGrid) {
                Dimension dimension = this.m_panelBuilder.getBuilder().getPanelGrid();
                int n6 = dimension.width;
                int n7 = dimension.height;
                point2.x = (point.x - n4 - n) / n6 * n6 + n4 + n;
                point2.y = (point.y - n2 - n3) / n7 * n7 + n2 + n3;
            }
        } else {
            Cloneable cloneable;
            if (this.m_bPaintGrid) {
                cloneable = this.m_panelBuilder.getBuilder().getPanelGrid();
                int n8 = cloneable.width;
                int n9 = cloneable.height;
                point2.x = (point.x - n4) / n8 * n8 + n4;
                point2.y = (point.y - n2) / n9 * n9 + n2;
            }
            if (this.m_bPaintMargins) {
                cloneable = this.getCanvasBounds();
                if (point2.x > ((Rectangle)cloneable).x + ((Rectangle)cloneable).width) {
                    point2.x = ((Rectangle)cloneable).y + ((Rectangle)cloneable).width;
                }
                if (point2.x < ((Rectangle)cloneable).x) {
                    point2.x = ((Rectangle)cloneable).x;
                }
                if (point2.y > ((Rectangle)cloneable).y + ((Rectangle)cloneable).height) {
                    point2.y = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height;
                }
                if (point2.y < ((Rectangle)cloneable).y) {
                    point2.y = ((Rectangle)cloneable).y;
                }
            }
        }
        return point2;
    }

    void componentMouseClicked(MouseEvent mouseEvent, ComponentInfo componentInfo) {
        if (this.m_panelBuilder.getTool() == -1 && mouseEvent.getClickCount() == 2) {
            MutableProperties mutableProperties = this.m_panelBuilder.getSelectedProperties();
            int n = mutableProperties.getType();
            if (n == 50 || n == 55 || n == 103 || n == 104 || n == 9 || n == 8 || n == 60 || n == 61 || n == 62) {
                this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(3));
                this.m_panelBuilder.getBuilder().showEditor(mutableProperties);
                this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(0));
            } else if (n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 102 || n == 101 || n == 110) {
                this.m_panelBuilder.getBuilder().doEditProperty("Title");
            }
        }
    }

    void componentMouseMoved(MouseEvent mouseEvent, ComponentInfo componentInfo) {
        int n = this.m_panelBuilder.getTool();
        Point point = mouseEvent.getPoint();
        Point point2 = componentInfo.getLocation();
        point.x += point2.x;
        point.y += point2.y;
        if (n == -1) {
            Cursor cursor = this.findResizeCursor(point);
            if (cursor == Cursor.getDefaultCursor() && this.m_panelBuilder.isSelected(componentInfo.getProperties())) {
                cursor = Cursor.getPredefinedCursor(13);
            }
            componentInfo.setCursor(cursor);
        } else if (n == 112) {
            Cursor cursor = Cursor.getDefaultCursor();
            int n2 = componentInfo.getProperties().getType();
            if (n2 == 101 || n2 == 102) {
                cursor = Cursor.getPredefinedCursor(12);
            }
            componentInfo.setCursor(cursor);
        } else if (n == 90 || n == 98) {
            int n3 = componentInfo.getProperties().getType();
            if (n == 90) {
                if (n3 == 103 && (this.m_panelBuilder.m_selectedEditType.equals("DISABLE") || this.m_panelBuilder.m_selectedEditType.equals("ENABLE"))) {
                    componentInfo.setCursor(Cursor.getPredefinedCursor(0));
                } else if (n3 == 60 || n3 == 61 || n3 == 62) {
                    componentInfo.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    componentInfo.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else {
                componentInfo.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else {
            point = this.convertGridPoint(point);
            this.m_trackers.removeAllElements();
            Dimension dimension = this.getDefaultComponentSize(this.m_panelBuilder.getTool());
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            Rectangle rectangle2 = this.getCanvasBounds();
            if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
            }
            if (rectangle.x < rectangle2.x) {
                rectangle.x = rectangle2.x;
            }
            if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
            }
            if (rectangle.y < rectangle2.y) {
                rectangle.y = rectangle2.y;
            }
            componentInfo.setCursor(Cursor.getPredefinedCursor(1));
            this.m_trackers.addElement(rectangle);
            this.m_panelBuilder.getStatusBar().setStatusBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.repaint();
        }
    }

    void componentMouseDragged(MouseEvent mouseEvent, ComponentInfo componentInfo) {
        Point point = mouseEvent.getPoint();
        Point point2 = componentInfo.getLocation();
        point.x += point2.x;
        point.y += point2.y;
        if (this.m_resizeProperties != null) {
            this.editorMouseDragged(point, mouseEvent);
        } else {
            Cloneable cloneable;
            int n;
            int n2;
            if (this.m_ptOrigin == null || this.m_ptDestination == null) {
                return;
            }
            ++this.m_dragCount;
            if (this.m_dragCount <= this.m_dragThreshold) {
                return;
            }
            Rectangle rectangle = null;
            Rectangle rectangle2 = this.getCanvasBounds();
            if (this.m_panelBuilder.getTool() == -1) {
                this.m_ptDestination = point;
                n2 = this.m_ptDestination.x - this.m_ptOrigin.x;
                n = this.m_ptDestination.y - this.m_ptOrigin.y;
                Point point3 = new Point(this.m_ptMoveOrigin.x + n2, this.m_ptMoveOrigin.y + n);
                this.m_ptMoveDestination = this.convertGridPoint(point3);
                n2 = this.m_ptMoveDestination.x - this.m_ptMoveOrigin.x;
                n = this.m_ptMoveDestination.y - this.m_ptMoveOrigin.y;
                if (this.m_moveRect.x + this.m_moveRect.width + n2 > rectangle2.x + rectangle2.width) {
                    n2 = rectangle2.x + rectangle2.width - this.m_moveRect.x - this.m_moveRect.width;
                }
                if (this.m_moveRect.x + n2 < rectangle2.x) {
                    n2 = rectangle2.x - this.m_moveRect.x;
                }
                if (this.m_moveRect.y + this.m_moveRect.height + n > rectangle2.y + rectangle2.height) {
                    n = rectangle2.y + rectangle2.height - this.m_moveRect.y - this.m_moveRect.height;
                }
                if (this.m_moveRect.y + n < rectangle2.y) {
                    n = rectangle2.y - this.m_moveRect.y;
                }
                this.m_trackers.removeAllElements();
                Enumeration enumeration = this.m_panelBuilder.getSelection();
                while (enumeration.hasMoreElements()) {
                    cloneable = (MutableProperties)enumeration.nextElement();
                    Rectangle rectangle3 = (Rectangle)((MutableProperties)cloneable).getProperty("Bounds");
                    rectangle = this.getMoveRectangle(rectangle3, n2, n);
                    this.m_trackers.addElement(rectangle);
                }
            } else {
                this.m_ptDestination = this.convertGridPoint(point);
                n2 = this.m_ptDestination.x - this.m_ptOrigin.x;
                n = this.m_ptDestination.y - this.m_ptOrigin.y;
                this.m_trackers.removeAllElements();
                rectangle = this.getResizeRectangle(5, n2, n);
                this.m_trackers.addElement(rectangle);
            }
            if (rectangle != null) {
                int n3;
                this.m_panelBuilder.getStatusBar().setStatusBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Dimension dimension = this.m_canvas.getSize();
                n = this.m_ptDestination.x;
                if (n > dimension.width) {
                    n = dimension.width;
                }
                if (n < 0) {
                    n = 0;
                }
                if ((n3 = this.m_ptDestination.y) > dimension.height) {
                    n3 = dimension.height;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                cloneable = new Rectangle(n, n3, 50, 50);
                this.scrollRectToVisible((Rectangle)cloneable);
            }
            this.repaint();
        }
    }

    void componentMousePressed(MouseEvent mouseEvent, ComponentInfo componentInfo) {
        componentInfo.requestFocus();
        Point point = mouseEvent.getPoint();
        Point point2 = componentInfo.getLocation();
        point.x += point2.x;
        point.y += point2.y;
        int n = this.m_panelBuilder.getTool();
        if (n == -1) {
            Cursor cursor = this.findResizeCursor(point);
            if (cursor == Cursor.getDefaultCursor()) {
                if (this.m_ptOrigin != null || this.m_ptDestination != null) {
                    this.m_ptOrigin = null;
                    this.m_ptDestination = null;
                    this.m_dragCount = 0;
                    this.m_trackers.removeAllElements();
                    this.m_moveRect = null;
                    this.m_resizeOriginalRect = null;
                    this.repaint();
                    this.m_panelBuilder.updateBuilder();
                    return;
                }
                MutableProperties mutableProperties = componentInfo.getProperties();
                if (this.m_panelBuilder.isSelected(this.m_properties)) {
                    this.m_panelBuilder.removeSelectedProperties(this.m_properties);
                }
                if (mouseEvent.isControlDown()) {
                    if (this.m_panelBuilder.isSelected(mutableProperties)) {
                        this.m_panelBuilder.removeSelectedProperties(mutableProperties);
                    } else {
                        this.m_panelBuilder.addSelectedProperties(mutableProperties);
                    }
                } else if (this.m_panelBuilder.isSelected(mutableProperties)) {
                    this.m_panelBuilder.addSelectedProperties(mutableProperties);
                } else {
                    this.m_panelBuilder.setSelectedProperties(mutableProperties);
                }
                if (mouseEvent.isPopupTrigger()) {
                    this.showContextMenu(point, componentInfo.getContextMenu());
                } else if (this.m_panelBuilder.isSelected(mutableProperties)) {
                    cursor = Cursor.getPredefinedCursor(13);
                    componentInfo.setCursor(cursor);
                    Rectangle rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                    this.m_ptMoveOrigin = new Point(rectangle.x, rectangle.y);
                    this.m_ptMoveDestination = new Point(rectangle.x, rectangle.y);
                    this.m_ptOrigin = point;
                    this.m_ptDestination = point;
                    this.m_dragCount = 0;
                    this.m_moveRect = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    Enumeration enumeration = this.m_panelBuilder.getSelection();
                    while (enumeration.hasMoreElements()) {
                        mutableProperties = (MutableProperties)enumeration.nextElement();
                        rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                        this.m_moveRect = this.m_moveRect.union(rectangle);
                    }
                }
            } else {
                componentInfo.setCursor(cursor);
                this.editorMousePressed(point, mouseEvent);
            }
        } else if (n == 112 || n == 90) {
            int n2 = componentInfo.getProperties().getType();
            if (n2 == 101 || n2 == 102) {
                this.m_panelBuilder.toggleModeSelectedProperties(componentInfo.getProperties());
            } else if (n == 90 && (n2 != 103 || !this.m_panelBuilder.m_selectedEditType.equals("DISABLE") && !this.m_panelBuilder.m_selectedEditType.equals("ENABLE")) && n2 != 60 && n2 != 61 && n2 != 62) {
                this.m_panelBuilder.toggleModeSelectedProperties(componentInfo.getProperties());
            }
            this.repaint();
        } else if (n == 98) {
            if (!mouseEvent.isControlDown()) {
                this.m_panelBuilder.reorderModeSelectedProperties(componentInfo.getProperties());
            }
            this.m_panelBuilder.setTabSelection(componentInfo.getProperties());
            this.repaint();
        } else {
            if (this.m_ptOrigin != null || this.m_ptDestination != null) {
                this.m_ptOrigin = null;
                this.m_ptDestination = null;
                this.m_dragCount = 0;
                this.m_trackers.removeAllElements();
                this.m_moveRect = null;
                this.m_resizeOriginalRect = null;
                this.repaint();
                this.m_panelBuilder.updateBuilder();
                return;
            }
            this.m_ptOrigin = point = this.convertGridPoint(point);
            this.m_ptDestination = point;
            this.m_dragCount = 0;
            this.m_resizeOriginalRect = new Rectangle(point.x, point.y, 0, 0);
        }
    }

    void componentMouseReleased(MouseEvent mouseEvent, ComponentInfo componentInfo) {
        Point point = mouseEvent.getPoint();
        Point point2 = componentInfo.getLocation();
        point.x += point2.x;
        point.y += point2.y;
        if (this.m_resizeProperties != null) {
            this.editorMouseReleased(point, mouseEvent);
        } else {
            if (this.m_ptOrigin == null || this.m_ptDestination == null) {
                return;
            }
            int n = this.m_panelBuilder.getTool();
            if (n == -1) {
                if (mouseEvent.isPopupTrigger() && this.m_dragCount <= this.m_dragThreshold) {
                    this.showContextMenu(point, componentInfo.getContextMenu());
                } else if (this.m_dragCount > this.m_dragThreshold) {
                    this.m_ptDestination = point;
                    int n2 = this.m_ptDestination.x - this.m_ptOrigin.x;
                    int n3 = this.m_ptDestination.y - this.m_ptOrigin.y;
                    Point point3 = new Point(this.m_ptMoveOrigin.x + n2, this.m_ptMoveOrigin.y + n3);
                    this.m_ptMoveDestination = this.convertGridPoint(point3);
                    n2 = this.m_ptMoveDestination.x - this.m_ptMoveOrigin.x;
                    n3 = this.m_ptMoveDestination.y - this.m_ptMoveOrigin.y;
                    Rectangle rectangle = this.getCanvasBounds();
                    if (this.m_moveRect.x + this.m_moveRect.width + n2 > rectangle.x + rectangle.width) {
                        n2 = rectangle.x + rectangle.width - this.m_moveRect.x - this.m_moveRect.width;
                    }
                    if (this.m_moveRect.x + n2 < rectangle.x) {
                        n2 = rectangle.x - this.m_moveRect.x;
                    }
                    if (this.m_moveRect.y + this.m_moveRect.height + n3 > rectangle.y + rectangle.height) {
                        n3 = rectangle.y + rectangle.height - this.m_moveRect.y - this.m_moveRect.height;
                    }
                    if (this.m_moveRect.y + n3 < rectangle.y) {
                        n3 = rectangle.y - this.m_moveRect.y;
                    }
                    if (n2 != 0 || n3 != 0) {
                        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_panelBuilder.getPDMLDocument();
                        xMLGUIBuilderDefinition.beginEdit();
                        try {
                            Enumeration enumeration = this.m_panelBuilder.getSelection();
                            while (enumeration.hasMoreElements()) {
                                MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
                                Rectangle rectangle2 = (Rectangle)mutableProperties.getProperty("Bounds");
                                rectangle2 = this.getMoveRectangle(rectangle2, n2, n3);
                                mutableProperties.setProperty("Bounds", rectangle2);
                            }
                            xMLGUIBuilderDefinition.endEdit();
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            xMLGUIBuilderDefinition.abortEdit();
                        }
                        this.m_panelBuilder.getBuilder().updateBuilder();
                    }
                }
            } else if (n != 112 && n != 90 && n != 98) {
                Rectangle rectangle;
                if (this.m_dragCount > this.m_dragThreshold) {
                    this.m_ptDestination = this.convertGridPoint(point);
                    int n4 = this.m_ptDestination.x - this.m_ptOrigin.x;
                    int n5 = this.m_ptDestination.y - this.m_ptOrigin.y;
                    rectangle = this.getResizeRectangle(5, n4, n5);
                } else {
                    Dimension dimension = this.getDefaultComponentSize(this.m_panelBuilder.getTool());
                    rectangle = new Rectangle(this.m_ptOrigin.x, this.m_ptOrigin.y, dimension.width, dimension.height);
                    Rectangle rectangle3 = this.getCanvasBounds();
                    if (rectangle.x + rectangle.width > rectangle3.x + rectangle3.width) {
                        rectangle.x = rectangle3.x + rectangle3.width - rectangle.width;
                    }
                    if (rectangle.x < rectangle3.x) {
                        rectangle.x = rectangle3.x;
                    }
                    if (rectangle.y + rectangle.height > rectangle3.y + rectangle3.height) {
                        rectangle.y = rectangle3.y + rectangle3.height - rectangle.height;
                    }
                    if (rectangle.y < rectangle3.y) {
                        rectangle.y = rectangle3.y;
                    }
                }
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_panelBuilder.getPDMLDocument();
                xMLGUIBuilderDefinition.beginEdit();
                MutableProperties mutableProperties = this.createNewComponentProperties(this.m_panelBuilder.getTool(), rectangle);
                this.m_panelBuilder.getProperties().add(mutableProperties);
                if (mutableProperties.getType() == 103) {
                    ColumnProperties columnProperties = (ColumnProperties)mutableProperties.getChildAt(2);
                    try {
                        String string = ((TableProperties)mutableProperties).generateName(113);
                        columnProperties.setProperty("Name", string);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        System.out.println(propertyVetoException);
                    }
                }
                xMLGUIBuilderDefinition.endEdit();
                this.m_panelBuilder.setSelectedProperties(mutableProperties);
                this.m_panelBuilder.stopEditing();
                this.m_panelBuilder.getBuilder().updateBuilder();
            }
            this.m_ptOrigin = null;
            this.m_ptDestination = null;
            this.m_dragCount = 0;
            this.m_moveRect = null;
            this.m_resizeOriginalRect = null;
            this.m_trackers.removeAllElements();
            this.repaint();
            Cursor cursor = this.findResizeCursor(point);
            if (cursor == Cursor.getDefaultCursor() && this.m_panelBuilder.isSelected(componentInfo.getProperties())) {
                cursor = Cursor.getPredefinedCursor(13);
            }
            componentInfo.setCursor(cursor);
        }
    }

    void setPaintGrid(boolean bl) {
        this.m_bPaintGrid = bl;
        this.repaint();
    }

    boolean isGridEnabled() {
        return this.m_bPaintGrid;
    }

    void setPaintMargins(boolean bl) {
        this.m_bPaintMargins = bl;
        this.repaint();
    }

    boolean isMarginsEnabled() {
        return this.m_bPaintMargins;
    }

    public void paint(Graphics graphics) {
        int n;
        Rectangle rectangle;
        MutableProperties mutableProperties;
        super.paint(graphics);
        Rectangle rectangle2 = this.m_canvas.getBounds();
        Color color = graphics.getColor();
        Enumeration enumeration = this.m_panelBuilder.getSelection();
        while (enumeration.hasMoreElements()) {
            mutableProperties = (MutableProperties)enumeration.nextElement();
            int n2 = mutableProperties.getType();
            if (n2 == 112 || n2 == 50 || n2 == 55) continue;
            if (!enumeration.hasMoreElements()) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.black);
            }
            rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
            }
            graphics.drawRect(rectangle2.x + rectangle.x - 1, rectangle2.y + rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
            graphics.drawRect(rectangle2.x + rectangle.x - 2, rectangle2.y + rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
            Rectangle[] rectangleArray = this.getSelectionHandles(mutableProperties);
            if (rectangleArray == null) continue;
            n = 0;
            while (n < rectangleArray.length) {
                rectangle = rectangleArray[n];
                if (rectangle != null) {
                    graphics.fillRect(rectangle2.x + rectangle.x, rectangle2.y + rectangle.y, rectangle.width, rectangle.height);
                }
                ++n;
            }
        }
        n = this.m_panelBuilder.getTool();
        if (n == 112 || n == 90) {
            graphics.setColor(Color.blue);
            Enumeration enumeration2 = this.m_panelBuilder.getModeSelection();
            while (enumeration2.hasMoreElements()) {
                mutableProperties = (MutableProperties)enumeration2.nextElement();
                rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                graphics.drawRect(rectangle2.x + rectangle.x - 1, rectangle2.y + rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                graphics.drawRect(rectangle2.x + rectangle.x - 2, rectangle2.y + rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
            }
        } else if (n == 98) {
            Font font = graphics.getFont();
            graphics.setFont(this.m_tabFont);
            graphics.setColor(Color.blue);
            mutableProperties = this.m_panelBuilder.getTabSelection();
            if (mutableProperties != null) {
                rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                graphics.drawRect(rectangle2.x + rectangle.x - 1, rectangle2.y + rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                graphics.drawRect(rectangle2.x + rectangle.x - 2, rectangle2.y + rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = fontMetrics.stringWidth("888");
            int n4 = fontMetrics.getHeight() + fontMetrics.getMaxDescent();
            int n5 = 1;
            Enumeration enumeration3 = this.m_panelBuilder.getModeSelection();
            while (enumeration3.hasMoreElements()) {
                mutableProperties = (MutableProperties)enumeration3.nextElement();
                if (mutableProperties.getType() == 112 || mutableProperties.getType() == 50 || mutableProperties.getType() == 55) continue;
                graphics.setColor(Color.blue);
                rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                int n6 = rectangle2.x + rectangle.x - 4;
                int n7 = rectangle2.y + rectangle.y - 4;
                graphics.fillRect(n6, n7, n3, n4);
                graphics.setColor(Color.white);
                graphics.drawString("" + n5, n6 += 3, n7 += fontMetrics.getHeight() - 1);
                ++n5;
            }
            graphics.setFont(font);
        } else {
            if (this.m_lassoSelect) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.magenta);
            }
            int n8 = this.m_trackers.size();
            int n9 = 0;
            while (n9 < n8) {
                rectangle = (Rectangle)this.m_trackers.elementAt(n9);
                if (this.m_lassoSelect) {
                    BasicGraphicsUtils.drawDashedRect(graphics, rectangle2.x + rectangle.x - 1, rectangle2.y + rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                } else {
                    graphics.drawRect(rectangle2.x + rectangle.x - 1, rectangle2.y + rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                }
                ++n9;
            }
        }
        graphics.setColor(color);
    }

    Rectangle[] getSelectionHandles(MutableProperties mutableProperties) {
        boolean bl;
        Rectangle rectangle = null;
        boolean bl2 = bl = mutableProperties.getType() == 1;
        if (bl) {
            rectangle = this.m_canvas.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
        } else {
            rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
        }
        Rectangle[] rectangleArray = null;
        if (rectangle != null) {
            int n = 6;
            int n2 = 8;
            rectangleArray = new Rectangle[n2];
            int n3 = 0;
            while (n3 < n2) {
                if (!bl) {
                    rectangleArray[n3] = new Rectangle();
                    rectangleArray[n3].setSize(n, n);
                } else if (n3 == 4 || n3 == 6 || n3 == 7) {
                    rectangleArray[n3] = new Rectangle();
                    rectangleArray[n3].setSize(n, n);
                } else {
                    rectangleArray[n3] = null;
                }
                ++n3;
            }
            if (rectangleArray[0] != null) {
                rectangleArray[0].setLocation(rectangle.x - n, rectangle.y - n);
            }
            if (rectangleArray[1] != null) {
                rectangleArray[1].setLocation(rectangle.x + (rectangle.width - n) / 2, rectangle.y - n);
            }
            if (rectangleArray[2] != null) {
                rectangleArray[2].setLocation(rectangle.x + rectangle.width, rectangle.y - n);
            }
            if (rectangleArray[3] != null) {
                rectangleArray[3].setLocation(rectangle.x - n, rectangle.y + (rectangle.height - n) / 2);
            }
            if (rectangleArray[4] != null) {
                rectangleArray[4].setLocation(rectangle.x + rectangle.width, rectangle.y + (rectangle.height - n) / 2);
            }
            if (rectangleArray[5] != null) {
                rectangleArray[5].setLocation(rectangle.x - n, rectangle.y + rectangle.height);
            }
            if (rectangleArray[6] != null) {
                rectangleArray[6].setLocation(rectangle.x + (rectangle.width - n) / 2, rectangle.y + rectangle.height);
            }
            if (rectangleArray[7] != null) {
                rectangleArray[7].setLocation(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
        }
        return rectangleArray;
    }

    Cursor findResizeCursor(Point point) {
        Enumeration enumeration = this.m_panelBuilder.getSelection();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            Rectangle[] rectangleArray = this.getSelectionHandles(mutableProperties);
            if (rectangleArray == null) continue;
            int n = 0;
            while (n < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n];
                if (rectangle != null && rectangle.contains(point)) {
                    this.m_resizeProperties = mutableProperties;
                    switch (n) {
                        case 0: {
                            return Cursor.getPredefinedCursor(6);
                        }
                        case 1: {
                            return Cursor.getPredefinedCursor(8);
                        }
                        case 2: {
                            return Cursor.getPredefinedCursor(7);
                        }
                        case 3: {
                            return Cursor.getPredefinedCursor(10);
                        }
                        case 4: {
                            return Cursor.getPredefinedCursor(11);
                        }
                        case 5: {
                            return Cursor.getPredefinedCursor(4);
                        }
                        case 6: {
                            return Cursor.getPredefinedCursor(9);
                        }
                        case 7: {
                            return Cursor.getPredefinedCursor(5);
                        }
                    }
                }
                ++n;
            }
        }
        this.m_resizeProperties = null;
        return Cursor.getPredefinedCursor(0);
    }

    void editorMouseEntered(Point point, MouseEvent mouseEvent) {
    }

    void editorMouseExited(Point point, MouseEvent mouseEvent) {
        int n = this.m_panelBuilder.getTool();
        if (n != 112 && n != 90 && n != -1) {
            this.m_trackers.removeAllElements();
            this.m_panelBuilder.getStatusBar().setStatusBounds(0, 0, 0, 0);
            this.repaint();
        }
    }

    void editorMouseMoved(Point point, MouseEvent mouseEvent) {
        int n = this.m_panelBuilder.getTool();
        Component component = mouseEvent.getComponent();
        if (n == -1) {
            component.setCursor(this.findResizeCursor(point));
        } else if (n == 112 || n == 90 || n == 98) {
            component.setCursor(Cursor.getDefaultCursor());
        } else {
            point = this.convertGridPoint(point);
            this.m_trackers.removeAllElements();
            Dimension dimension = this.getDefaultComponentSize(this.m_panelBuilder.getTool());
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            Rectangle rectangle2 = this.getCanvasBounds();
            if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
            }
            if (rectangle.x < rectangle2.x) {
                rectangle.x = rectangle2.x;
            }
            if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
            }
            if (rectangle.y < rectangle2.y) {
                rectangle.y = rectangle2.y;
            }
            component.setCursor(Cursor.getPredefinedCursor(1));
            this.m_trackers.addElement(rectangle);
            this.m_panelBuilder.getStatusBar().setStatusBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.repaint();
        }
    }

    void editorMouseDragged(Point point, MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.m_ptOrigin == null || this.m_ptDestination == null) {
            return;
        }
        ++this.m_dragCount;
        if (this.m_dragCount <= this.m_dragThreshold) {
            return;
        }
        Rectangle rectangle = null;
        if (this.m_lassoSelect) {
            this.m_ptDestination = point;
            rectangle = this.getLassoRectangle();
        } else {
            this.m_ptDestination = this.convertGridPoint(point);
            int n3 = this.m_ptDestination.x - this.m_ptOrigin.x;
            n2 = this.m_ptDestination.y - this.m_ptOrigin.y;
            rectangle = this.m_panelBuilder.getTool() == -1 ? this.getResizeRectangle(this.m_resizeType, n3, n2) : this.getResizeRectangle(5, n3, n2);
        }
        this.m_trackers.removeAllElements();
        this.m_trackers.addElement(rectangle);
        this.m_panelBuilder.getStatusBar().setStatusBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Dimension dimension = this.m_canvas.getSize();
        n2 = this.m_ptDestination.x;
        if (n2 > dimension.width) {
            n2 = dimension.width;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.m_ptDestination.y) > dimension.height) {
            n = dimension.height;
        }
        if (n < 0) {
            n = 0;
        }
        Rectangle rectangle2 = new Rectangle(n2, n, 50, 50);
        this.scrollRectToVisible(rectangle2);
        this.repaint();
    }

    void editorMousePressed(Point point, MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Cursor cursor = this.findResizeCursor(point);
        if (this.m_ptOrigin != null || this.m_ptDestination != null) {
            component.setCursor(cursor);
            this.m_ptOrigin = null;
            this.m_ptDestination = null;
            this.m_dragCount = 0;
            this.m_moveRect = null;
            this.m_resizeOriginalRect = null;
            this.m_lassoSelect = false;
            this.m_trackers.removeAllElements();
            this.repaint();
            this.m_panelBuilder.updateBuilder();
            return;
        }
        int n = this.m_panelBuilder.getTool();
        if (n == -1) {
            Cloneable cloneable;
            component.setCursor(cursor);
            this.m_resizeType = cursor.getType();
            if (this.m_resizeType == 0) {
                if (mouseEvent.isPopupTrigger()) {
                    this.m_panelBuilder.setSelectedProperties(this.m_properties);
                    this.showContextMenu(point, this.getContextMenu());
                } else {
                    this.m_ptOrigin = point;
                    this.m_ptDestination = point;
                    this.m_lassoSelect = true;
                    if (mouseEvent.isControlDown()) {
                        MutableProperties mutableProperties;
                        int n2;
                        if (this.m_panelBuilder.getSelectedCount() == 1 && ((n2 = (mutableProperties = this.m_panelBuilder.getSelectedProperties()).getType()) == 1 || n2 == 112 || n2 == 50 || n2 == 55)) {
                            this.m_panelBuilder.clearSelectedProperties();
                        }
                    } else {
                        this.m_panelBuilder.clearSelectedProperties();
                    }
                }
                return;
            }
            this.m_panelBuilder.addSelectedProperties(this.m_resizeProperties);
            this.m_resizeOriginalRect = (Rectangle)this.m_resizeProperties.getProperty("Bounds");
            if (this.m_resizeOriginalRect == null) {
                cloneable = this.m_canvas.getSize();
                this.m_resizeOriginalRect = new Rectangle(0, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
            }
            if (this.m_resizeProperties.getType() == 1) {
                Object object;
                this.m_moveRect = new Rectangle(0, 0, 0, 0);
                Rectangle rectangle = null;
                Enumeration<TreeNode> enumeration = this.m_resizeProperties.children();
                while (enumeration.hasMoreElements()) {
                    cloneable = (MutableProperties)enumeration.nextElement();
                    rectangle = (Rectangle)((MutableProperties)cloneable).getProperty("Bounds");
                    if (rectangle != null) {
                        this.m_moveRect = this.m_moveRect.union(rectangle);
                    }
                    if (((MutableProperties)cloneable).getType() != 112) continue;
                    object = ((DefaultMutableTreeNode)cloneable).children();
                    while (object.hasMoreElements()) {
                        MutableProperties mutableProperties = (MutableProperties)object.nextElement();
                        rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                        if (rectangle == null) continue;
                        this.m_moveRect = this.m_moveRect.union(rectangle);
                    }
                }
                if (this.m_bPaintMargins) {
                    object = this.m_panelBuilder.getBuilder().getPanelMargins();
                    if (this.m_moveRect != null) {
                        this.m_moveRect.width += ((Insets)object).right;
                        this.m_moveRect.height += ((Insets)object).bottom;
                    }
                }
            }
            switch (this.m_resizeType) {
                case 6: {
                    point.x = this.m_resizeOriginalRect.x;
                    point.y = this.m_resizeOriginalRect.y;
                    break;
                }
                case 7: {
                    point.x = this.m_resizeOriginalRect.x + this.m_resizeOriginalRect.width;
                    point.y = this.m_resizeOriginalRect.y;
                    break;
                }
                case 5: {
                    point.x = this.m_resizeOriginalRect.x + this.m_resizeOriginalRect.width;
                    point.y = this.m_resizeOriginalRect.y + this.m_resizeOriginalRect.height;
                    break;
                }
                case 4: {
                    point.x = this.m_resizeOriginalRect.x;
                    point.y = this.m_resizeOriginalRect.y + this.m_resizeOriginalRect.height;
                    break;
                }
                case 8: {
                    point.x = this.m_resizeOriginalRect.x + this.m_resizeOriginalRect.width / 2;
                    point.y = this.m_resizeOriginalRect.y;
                    break;
                }
                case 9: {
                    point.x = this.m_resizeOriginalRect.x + this.m_resizeOriginalRect.width / 2;
                    point.y = this.m_resizeOriginalRect.y + this.m_resizeOriginalRect.height;
                    break;
                }
                case 11: {
                    point.x = this.m_resizeOriginalRect.x + this.m_resizeOriginalRect.width;
                    point.y = this.m_resizeOriginalRect.y + this.m_resizeOriginalRect.height / 2;
                    break;
                }
                case 10: {
                    point.x = this.m_resizeOriginalRect.x;
                    point.y = this.m_resizeOriginalRect.y + this.m_resizeOriginalRect.height / 2;
                }
            }
        } else if (n == 112 || n == 90 || n == 98) {
            this.m_panelBuilder.stopEditing();
            this.m_panelBuilder.getBuilder().updateBuilder();
        } else {
            point = this.convertGridPoint(point);
            this.m_resizeOriginalRect = new Rectangle(point.x, point.y, 0, 0);
        }
        this.m_ptOrigin = point;
        this.m_ptDestination = point;
        this.m_dragCount = 0;
    }

    void editorMouseReleased(Point point, MouseEvent mouseEvent) {
        Serializable serializable;
        if (mouseEvent.isPopupTrigger() && this.m_dragCount <= this.m_dragThreshold && this.m_ptOrigin != null) {
            this.m_panelBuilder.setSelectedProperties(this.m_properties);
            this.showContextMenu(point, this.getContextMenu());
        }
        if (this.m_ptOrigin == null || this.m_ptDestination == null) {
            return;
        }
        int n = this.m_panelBuilder.getTool();
        if (this.m_lassoSelect) {
            this.m_ptDestination = point;
            serializable = this.getLassoRectangle();
            Enumeration<TreeNode> enumeration = this.m_properties.children();
            while (enumeration.hasMoreElements()) {
                Rectangle rectangle;
                MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
                int n2 = mutableProperties.getType();
                if (n2 == 112) {
                    Enumeration<TreeNode> enumeration2 = mutableProperties.children();
                    while (enumeration2.hasMoreElements()) {
                        mutableProperties = (MutableProperties)enumeration2.nextElement();
                        rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                        if (!rectangle.intersection((Rectangle)serializable).equals(rectangle)) continue;
                        this.m_panelBuilder.addSelectedProperties(mutableProperties);
                    }
                    continue;
                }
                if (n2 == 50 || n2 == 55 || !(rectangle = (Rectangle)mutableProperties.getProperty("Bounds")).intersection((Rectangle)serializable).equals(rectangle)) continue;
                this.m_panelBuilder.addSelectedProperties(mutableProperties);
            }
            if (this.m_panelBuilder.getSelectedCount() == 0) {
                this.m_panelBuilder.setSelectedProperties(this.m_properties);
            }
        } else if (n == -1) {
            if (this.m_dragCount > this.m_dragThreshold) {
                Serializable serializable2;
                if (this.m_resizeProperties == null) {
                    return;
                }
                this.m_ptDestination = this.convertGridPoint(point);
                int n3 = this.m_ptDestination.x - this.m_ptOrigin.x;
                int n4 = this.m_ptDestination.y - this.m_ptOrigin.y;
                Rectangle rectangle = this.getResizeRectangle(this.m_resizeType, n3, n4);
                Rectangle rectangle2 = (Rectangle)this.m_resizeProperties.getProperty("Bounds");
                if (rectangle2 == null) {
                    serializable2 = this.m_canvas.getSize();
                    rectangle2 = new Rectangle(0, 0, ((Dimension)serializable2).width, ((Dimension)serializable2).height);
                }
                if (!rectangle.equals(rectangle2)) {
                    serializable2 = this.m_panelBuilder.getPDMLDocument();
                    ((XMLGUIBuilderDefinition)serializable2).beginEdit();
                    try {
                        if (this.m_resizeProperties.getType() == 1) {
                            this.m_resizeProperties.setProperty("Size", rectangle.getSize());
                        } else {
                            this.m_resizeProperties.setProperty("Bounds", rectangle);
                        }
                        ((XMLGUIBuilderDefinition)serializable2).endEdit();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        ((XMLGUIBuilderDefinition)serializable2).abortEdit();
                    }
                    this.m_panelBuilder.getBuilder().updateBuilder();
                }
            }
        } else if (n != 112 && n != 90 && n != 98) {
            Rectangle rectangle;
            if (this.m_dragCount > this.m_dragThreshold) {
                this.m_ptDestination = this.convertGridPoint(point);
                int n5 = this.m_ptDestination.x - this.m_ptOrigin.x;
                int n6 = this.m_ptDestination.y - this.m_ptOrigin.y;
                rectangle = this.getResizeRectangle(5, n5, n6);
            } else {
                Dimension dimension = this.getDefaultComponentSize(this.m_panelBuilder.getTool());
                rectangle = new Rectangle(this.m_ptOrigin.x, this.m_ptOrigin.y, dimension.width, dimension.height);
                Rectangle rectangle3 = this.getCanvasBounds();
                if (rectangle.x + rectangle.width > rectangle3.x + rectangle3.width) {
                    rectangle.x = rectangle3.x + rectangle3.width - rectangle.width;
                }
                if (rectangle.x < rectangle3.x) {
                    rectangle.x = rectangle3.x;
                }
                if (rectangle.y + rectangle.height > rectangle3.y + rectangle3.height) {
                    rectangle.y = rectangle3.y + rectangle3.height - rectangle.height;
                }
                if (rectangle.y < rectangle3.y) {
                    rectangle.y = rectangle3.y;
                }
            }
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_panelBuilder.getPDMLDocument();
            xMLGUIBuilderDefinition.beginEdit();
            MutableProperties mutableProperties = this.createNewComponentProperties(this.m_panelBuilder.getTool(), rectangle);
            this.m_panelBuilder.getProperties().add(mutableProperties);
            if (mutableProperties.getType() == 103) {
                ColumnProperties columnProperties = (ColumnProperties)mutableProperties.getChildAt(2);
                try {
                    String string = ((TableProperties)mutableProperties).generateName(113);
                    columnProperties.setProperty("Name", string);
                }
                catch (PropertyVetoException propertyVetoException) {
                    System.out.println(propertyVetoException);
                }
            }
            xMLGUIBuilderDefinition.endEdit();
            this.m_panelBuilder.setSelectedProperties(mutableProperties);
            this.m_panelBuilder.stopEditing();
            this.m_panelBuilder.getBuilder().updateBuilder();
        }
        this.m_ptOrigin = null;
        this.m_ptDestination = null;
        this.m_dragCount = 0;
        this.m_moveRect = null;
        this.m_resizeOriginalRect = null;
        this.m_trackers.removeAllElements();
        this.m_lassoSelect = false;
        serializable = mouseEvent.getComponent();
        Cursor cursor = this.findResizeCursor(point);
        ((Component)serializable).setCursor(cursor);
        this.repaint();
    }

    Rectangle getLassoRectangle() {
        Rectangle rectangle = new Rectangle();
        int n = this.m_ptOrigin.x;
        int n2 = this.m_ptOrigin.y;
        int n3 = this.m_ptDestination.x;
        int n4 = this.m_ptDestination.y;
        if (n < n3) {
            rectangle.x = n;
            rectangle.width = n3 - n;
        } else {
            rectangle.x = n3;
            rectangle.width = n - n3;
        }
        if (n2 < n4) {
            rectangle.y = n2;
            rectangle.height = n4 - n2;
        } else {
            rectangle.y = n4;
            rectangle.height = n2 - n4;
        }
        return rectangle;
    }

    Rectangle getMoveRectangle(Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = rectangle.x + n;
        rectangle2.y = rectangle.y + n2;
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
        return rectangle2;
    }

    Rectangle getResizeRectangle(int n, int n2, int n3) {
        if (this.m_resizeOriginalRect == null) {
            return null;
        }
        boolean bl = false;
        if (this.m_resizeProperties != null) {
            bl = this.m_resizeProperties.getType() == 1;
        }
        Rectangle rectangle = this.m_resizeOriginalRect;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (n == 11 || n == 7 || n == 5) {
            if (rectangle2.width + n2 >= 0) {
                rectangle2.width += n2;
            } else {
                rectangle2.x += rectangle2.width + n2;
                rectangle2.width = bl ? (rectangle2.width += n2) : Math.abs(rectangle2.width + n2);
            }
        } else if (n == 10 || n == 6 || n == 4) {
            if (n2 < rectangle2.width) {
                rectangle2.x += n2;
                rectangle2.width -= n2;
            } else {
                rectangle2.x += rectangle2.width;
                rectangle2.width = n2 - rectangle2.width;
            }
        }
        if (n == 9 || n == 5 || n == 4) {
            if (rectangle2.height + n3 >= 0) {
                rectangle2.height += n3;
            } else {
                rectangle2.y += rectangle2.height + n3;
                rectangle2.height = bl ? (rectangle2.height += n3) : Math.abs(rectangle2.height + n3);
            }
        } else if (n == 8 || n == 7 || n == 6) {
            if (n3 < rectangle2.height) {
                rectangle2.y += n3;
                rectangle2.height -= n3;
            } else {
                rectangle2.y += rectangle2.height;
                rectangle2.height = n3 - rectangle2.height;
            }
        }
        if (bl) {
            if (this.m_moveRect != null) {
                if (rectangle2.width < this.m_moveRect.width) {
                    rectangle2.width = this.m_moveRect.width;
                }
                if (rectangle2.height < this.m_moveRect.height) {
                    rectangle2.height = this.m_moveRect.height;
                }
            }
            if (rectangle2.width < 0) {
                rectangle2.width = 0;
            }
            if (rectangle2.height < 0) {
                rectangle2.height = 0;
            }
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y;
        } else {
            Dimension dimension = this.m_canvas.getSize();
            if (rectangle2.x < 0) {
                rectangle2.width += rectangle2.x;
                rectangle2.x = 0;
            }
            if (rectangle2.x + rectangle2.width > dimension.width) {
                rectangle2.width = dimension.width - rectangle2.x;
            }
            if (rectangle2.y < 0) {
                rectangle2.height += rectangle2.y;
                rectangle2.y = 0;
            }
            if (rectangle2.y + rectangle2.height > dimension.height) {
                rectangle2.height = dimension.height - rectangle2.y;
            }
        }
        return rectangle2;
    }

    public void uninstallListeners() {
        this.m_properties.removePDMLNodeListener(this.m_pdmlNodeListener);
        this.m_properties.removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class PanelMenuToolBorder
    extends EmptyBorder {
        MutableProperties m_MenuBar;
        MutableProperties m_ToolBar;
        int m_toolh = 30;
        int m_menuh = 20;

        PanelMenuToolBorder() {
            super(10, 10, 50, 50);
        }

        void setMenuBar(MutableProperties mutableProperties) {
            this.m_MenuBar = mutableProperties;
        }

        MutableProperties getMenuBar() {
            return this.m_MenuBar;
        }

        boolean hasMenuBar() {
            return this.m_MenuBar != null;
        }

        void setToolBar(MutableProperties mutableProperties) {
            this.m_ToolBar = mutableProperties;
        }

        MutableProperties getToolBar() {
            return this.m_ToolBar;
        }

        boolean hasToolBar() {
            return this.m_ToolBar != null;
        }

        boolean menuBarContains(Point point) {
            if (this.hasMenuBar()) {
                boolean bl = this.hasToolBar();
                boolean bl2 = true;
                if (bl) {
                    bl2 = this.m_ToolBar.getProperty("Orientation").equals("horizontal");
                }
                int n = 0;
                if (bl) {
                    n = bl2 ? 0 : this.m_toolh;
                }
                Rectangle rectangle = new Rectangle(10, 10, PanelEditor.this.m_canvas.getSize().width + n, this.m_menuh);
                return rectangle.contains(point);
            }
            return false;
        }

        boolean toolBarContains(Point point) {
            if (this.hasToolBar()) {
                boolean bl = this.hasMenuBar();
                boolean bl2 = this.m_ToolBar.getProperty("Orientation").equals("horizontal");
                int n = bl ? this.m_menuh : 0;
                Rectangle rectangle = null;
                rectangle = bl2 ? new Rectangle(10, 10 + n, PanelEditor.this.m_canvas.getSize().width, this.m_toolh) : new Rectangle(10, 10 + n, this.m_toolh, PanelEditor.this.m_canvas.getSize().height);
                return rectangle.contains(point);
            }
            return false;
        }

        public Insets getBorderInsets(Component component) {
            int n;
            int n2 = this.top;
            int n3 = this.left;
            if (this.hasMenuBar()) {
                n2 += this.m_menuh;
            }
            if (this.hasToolBar()) {
                n = this.m_ToolBar.getProperty("Orientation").equals("horizontal") ? 1 : 0;
                if (n != 0) {
                    n2 += this.m_toolh;
                } else {
                    n3 += this.m_toolh;
                }
            }
            n = this.bottom;
            int n4 = this.right;
            return new Insets(n2, n3, n, n4);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.getBorderInsets(component);
            insets.left = insets2.left;
            insets.top = insets2.top;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom;
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ImageIcon imageIcon;
            if (!this.hasMenuBar() && !this.hasToolBar()) {
                return;
            }
            Color color = graphics.getColor();
            Color color2 = PanelEditor.this.m_canvas.getBackground();
            Dimension dimension = PanelEditor.this.m_canvas.getSize();
            boolean bl = this.hasMenuBar();
            boolean bl2 = this.hasToolBar();
            boolean bl3 = true;
            if (bl2) {
                bl3 = this.m_ToolBar.getProperty("Orientation").equals("horizontal");
            }
            int n5 = 0;
            if (bl) {
                if (bl2) {
                    n5 = bl3 ? 0 : this.m_toolh;
                }
                graphics.setColor(color2);
                graphics.fillRect(10, 10, dimension.width + n5, this.m_menuh);
                if (PanelEditor.this.m_panelBuilder.getSelectedProperties().equals(this.m_MenuBar)) {
                    graphics.setColor(Color.blue);
                    graphics.drawRect(9, 9, dimension.width + n5 + 1, this.m_menuh - 1);
                    graphics.drawRect(8, 8, dimension.width + n5 + 3, this.m_menuh + 1);
                } else {
                    graphics.setColor(color2.darker());
                    graphics.drawLine(14, 10 + this.m_menuh - 2, 10 + dimension.width + n5 - 4, 10 + this.m_menuh - 2);
                    graphics.setColor(color2.brighter());
                    graphics.drawLine(14, 10 + this.m_menuh - 1, 10 + dimension.width + n5 - 4, 10 + this.m_menuh - 1);
                }
                n5 = this.m_menuh;
                imageIcon = GUIFactory.getImage("MenuBar.gif", true);
                graphics.drawImage(imageIcon.getImage(), 15, 11, null);
            }
            if (bl2) {
                if (bl3) {
                    graphics.setColor(color2);
                    graphics.fillRect(10, 10 + n5, dimension.width, this.m_toolh);
                    if (PanelEditor.this.m_panelBuilder.getSelectedProperties().equals(this.m_ToolBar)) {
                        graphics.setColor(Color.blue);
                        graphics.drawRect(9, 10 + n5 - 1, dimension.width + 1, this.m_toolh - 1);
                        graphics.drawRect(8, 10 + n5 - 2, dimension.width + 3, this.m_toolh + 1);
                    } else {
                        graphics.setColor(color2.darker());
                        graphics.drawLine(14, 10 + n5 + this.m_toolh - 2, 10 + dimension.width - 4, 10 + n5 + this.m_toolh - 2);
                        graphics.setColor(color2.brighter());
                        graphics.drawLine(14, 10 + n5 + this.m_toolh - 1, 10 + dimension.width - 4, 10 + n5 + this.m_toolh - 1);
                    }
                    imageIcon = GUIFactory.getImage("ToolBar.gif", true);
                    graphics.drawImage(imageIcon.getImage(), 15, 16 + n5, null);
                } else {
                    graphics.setColor(color2);
                    graphics.fillRect(10, 10 + n5, this.m_toolh, dimension.height);
                    if (PanelEditor.this.m_panelBuilder.getSelectedProperties().equals(this.m_ToolBar)) {
                        graphics.setColor(Color.blue);
                        graphics.drawRect(9, 10 + n5 - 1, this.m_toolh - 1, dimension.height + 1);
                        graphics.drawRect(8, 10 + n5 - 2, this.m_toolh + 1, dimension.height + 3);
                    } else {
                        graphics.setColor(color2.darker());
                        graphics.drawLine(10 + this.m_toolh - 2, 10 + n5 + 2, 10 + this.m_toolh - 2, 10 + n5 + dimension.height - 2);
                        graphics.setColor(color2.brighter());
                        graphics.drawLine(10 + this.m_toolh - 1, 10 + n5 + 2, 10 + this.m_toolh - 1, 10 + n5 + dimension.height - 2);
                    }
                    imageIcon = GUIFactory.getImage("ToolBar.gif", true);
                    graphics.drawImage(imageIcon.getImage(), 15, 16 + n5, null);
                }
            }
            graphics.setColor(color);
        }
    }

    class PanelMenuListener
    implements ActionListener {
        PanelMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    PanelEditor.this.m_panelBuilder.cut();
                } else if (string.equals("Copy")) {
                    PanelEditor.this.m_panelBuilder.copy();
                } else if (string.equals("Paste")) {
                    int n = 0;
                    int n2 = 0;
                    if (PanelEditor.this.m_contextMenuLocation != null) {
                        n = PanelEditor.this.m_contextMenuLocation.x;
                        n2 = PanelEditor.this.m_contextMenuLocation.y;
                    }
                    PanelEditor.this.m_panelBuilder.paste(n, n2);
                } else if (string.equals("Delete")) {
                    PanelEditor.this.m_panelBuilder.delete();
                }
            } else if (string.startsWith("Selected")) {
                string = string.substring(9);
                PanelEditor.this.m_panelBuilder.doSelectedEdit(null, true, string, null);
            } else if (string.startsWith("Deselected")) {
                string = string.substring(11);
                PanelEditor.this.m_panelBuilder.doSelectedEdit(null, false, string, null);
            } else if (string.equals("Show Properties")) {
                PanelEditor.this.m_panelBuilder.getBuilder().doShowProperties();
            } else if (string.equals("Show Editor")) {
                PanelEditor.this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(3));
                PanelEditor.this.m_panelBuilder.getBuilder().showEditor(PanelEditor.this.m_panelBuilder.getSelectedProperties());
                PanelEditor.this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Button Group")) {
                PanelEditor.this.m_panelBuilder.doButtonGroupEdit();
            } else if (string.equals("Image Default Size")) {
                ImageIcon imageIcon;
                MutableProperties mutableProperties = PanelEditor.this.m_panelBuilder.getSelectedProperties();
                String string2 = (String)mutableProperties.getProperty("Title");
                Rectangle rectangle = (Rectangle)mutableProperties.getProperty("Bounds");
                Dimension dimension = PanelEditor.this.getDefaultComponentSize(110);
                if (!string2.equals("") && (imageIcon = GUIFactory.getUserImage(string2)) != null) {
                    dimension.width = imageIcon.getIconWidth();
                    dimension.height = imageIcon.getIconHeight();
                }
                if (dimension.width != rectangle.width || dimension.height != rectangle.height) {
                    PanelEditor.this.m_panelBuilder.getPDMLDocument().beginEdit();
                    try {
                        mutableProperties.setProperty("Bounds", new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height));
                        PanelEditor.this.m_panelBuilder.getPDMLDocument().endEdit();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        PanelEditor.this.m_panelBuilder.getPDMLDocument().abortEdit();
                    }
                }
            }
        }
    }

    class PanelEditorCanvas
    extends JLayeredPane {
        PanelEditorCanvas() {
        }

        public void paint(Graphics graphics) {
            int n;
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
            Insets insets = PanelEditor.this.m_panelBuilder.getBuilder().getPanelMargins();
            int n2 = PanelEditor.this.m_bPaintMargins ? insets.top : 0;
            int n3 = PanelEditor.this.m_bPaintMargins ? insets.bottom : 0;
            int n4 = PanelEditor.this.m_bPaintMargins ? insets.left : 0;
            int n5 = n = PanelEditor.this.m_bPaintMargins ? insets.right : 0;
            if (PanelEditor.this.m_bPaintGrid) {
                Dimension dimension2 = PanelEditor.this.m_panelBuilder.getBuilder().getPanelGrid();
                int n6 = n4;
                while (n6 < dimension.width - n) {
                    int n7 = n2;
                    while (n7 < dimension.height - n3) {
                        graphics.drawLine(n6, n7, n6, n7);
                        n7 += dimension2.height;
                    }
                    n6 += dimension2.width;
                }
            }
            if (PanelEditor.this.m_bPaintMargins) {
                graphics.drawRect(n4 - 1, n2 - 1, dimension.width - (n4 + n - 2) - 1, dimension.height - (n2 + n3 - 2) - 1);
            }
            graphics.setColor(color);
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return (Dimension)PanelEditor.this.m_properties.getProperty("Size");
        }
    }

    class PanelEditorPDMLNodeListener
    implements PDMLNodeListener {
        PanelEditorPDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            Dimension dimension = (Dimension)PanelEditor.this.m_properties.getProperty("Size");
            PanelEditor.this.m_canvas.setSize(dimension);
            PanelEditor.this.repaint();
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class PanelEditorTreeModelListener
    implements TreeModelListener {
        PanelEditorTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            int n = mutableProperties.getType();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null && (n == 1 || n == 112)) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n2];
                    ComponentInfo componentInfo = (ComponentInfo)PanelEditor.this.m_components.get(mutableProperties2);
                    if (componentInfo != null) {
                        componentInfo.refresh();
                    } else if (mutableProperties2.getType() == 112) {
                        ButtonGroupProperties buttonGroupProperties = (ButtonGroupProperties)mutableProperties2;
                        Vector vector = buttonGroupProperties.getToggleButtonProperties(false);
                        int n3 = 0;
                        while (n3 < vector.size()) {
                            MutableProperties mutableProperties3 = (MutableProperties)vector.elementAt(n3);
                            componentInfo = (ComponentInfo)PanelEditor.this.m_components.get(mutableProperties3);
                            if (componentInfo != null) {
                                componentInfo.refresh();
                            }
                            ++n3;
                        }
                    } else if (mutableProperties2.getType() == 55) {
                        PanelEditor.this.m_panelBuilder.revalidateScroll();
                    }
                    ++n2;
                }
                PanelEditor.this.repaint();
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            int n = mutableProperties.getType();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null && (n == 1 || n == 112)) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n2];
                    PanelEditor.this.createComponentInfo(mutableProperties2);
                    ++n2;
                }
                PanelEditor.this.repaint();
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            int n = mutableProperties.getType();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null && (n == 1 || n == 112)) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n2];
                    PanelEditor.this.removeComponentInfo(mutableProperties2);
                    ++n2;
                }
                PanelEditor.this.repaint();
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class PanelSelectionListener
    implements SelectionListener {
        PanelSelectionListener() {
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            ComponentInfo componentInfo;
            MutableProperties mutableProperties = selectionEvent.getSelection();
            if (mutableProperties.getType() == 3 && (componentInfo = (ComponentInfo)PanelEditor.this.m_components.get(mutableProperties)) != null) {
                PanelEditor.this.m_canvas.moveToFront(componentInfo);
            }
            PanelEditor.this.repaint();
        }
    }

    class PanelDesktopMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        PanelDesktopMouseListener() {
        }

        Point convertPoint(Point point) {
            Point point2 = new Point();
            Point point3 = PanelEditor.this.m_canvas.getLocation();
            point2.x = point.x - point3.x;
            point2.y = point.y - point3.y;
            return point2;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseEntered(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseExited(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseMoved(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseDragged(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PanelEditor.this.m_border.menuBarContains(mouseEvent.getPoint())) {
                PanelEditor.this.m_panelBuilder.setSelectedProperties(PanelEditor.this.m_border.getMenuBar());
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = PanelEditor.this.m_panelBuilder.getContextMenu(PanelEditor.this.m_border.getMenuBar());
                    jPopupMenu.show(PanelEditor.this, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (PanelEditor.this.m_border.toolBarContains(mouseEvent.getPoint())) {
                PanelEditor.this.m_panelBuilder.setSelectedProperties(PanelEditor.this.m_border.getToolBar());
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = PanelEditor.this.m_panelBuilder.getContextMenu(PanelEditor.this.m_border.getToolBar());
                    jPopupMenu.show(PanelEditor.this, mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                PanelEditor.this.editorMousePressed(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PanelEditor.this.m_border.menuBarContains(mouseEvent.getPoint())) {
                if (PanelEditor.this.m_panelBuilder.getSelectedProperties().equals(PanelEditor.this.m_border.getMenuBar()) && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = PanelEditor.this.m_panelBuilder.getContextMenu(PanelEditor.this.m_border.getMenuBar());
                    jPopupMenu.show(PanelEditor.this, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    PanelEditor.this.editorMouseReleased(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
                }
            } else if (PanelEditor.this.m_border.toolBarContains(mouseEvent.getPoint())) {
                if (PanelEditor.this.m_panelBuilder.getSelectedProperties().equals(PanelEditor.this.m_border.getToolBar()) && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = PanelEditor.this.m_panelBuilder.getContextMenu(PanelEditor.this.m_border.getToolBar());
                    jPopupMenu.show(PanelEditor.this, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    PanelEditor.this.editorMouseReleased(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
                }
            } else {
                PanelEditor.this.editorMouseReleased(this.convertPoint(mouseEvent.getPoint()), mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (PanelEditor.this.m_border.menuBarContains(mouseEvent.getPoint())) {
                    PanelEditor.this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(3));
                    PanelEditor.this.m_panelBuilder.getBuilder().showEditor(PanelEditor.this.m_border.getMenuBar());
                    PanelEditor.this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(0));
                } else if (PanelEditor.this.m_border.toolBarContains(mouseEvent.getPoint())) {
                    PanelEditor.this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(3));
                    PanelEditor.this.m_panelBuilder.getBuilder().showEditor(PanelEditor.this.m_border.getToolBar());
                    PanelEditor.this.m_panelBuilder.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    class PanelMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        PanelMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseEntered(mouseEvent.getPoint(), mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseExited(mouseEvent.getPoint(), mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseMoved(mouseEvent.getPoint(), mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseDragged(mouseEvent.getPoint(), mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            PanelEditor.this.editorMousePressed(mouseEvent.getPoint(), mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            PanelEditor.this.editorMouseReleased(mouseEvent.getPoint(), mouseEvent);
        }
    }
}

