/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.ComponentInfo;
import com.ibm.as400.ui.tools.FixedDefaultTreeModel;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PanelBuilder;
import com.ibm.as400.ui.tools.PanelProperties;
import com.ibm.as400.ui.tools.SelectionEvent;
import com.ibm.as400.ui.tools.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class PanelTreeView
extends JPanel {
    PanelBuilder m_panelBuilder;
    PanelProperties m_properties;
    JTree m_tree;
    DefaultMutableTreeNode m_root;
    DefaultTreeModel m_treeModel;
    Hashtable m_viewNodes;
    PanelTreeViewTreeSelectionListener m_treeSelectionListener;
    PDMLNodeListener m_pdmlNodeListener;
    TreeModelListener m_treeModelListener;

    PanelTreeView(PanelBuilder panelBuilder, PanelProperties panelProperties) {
        this.m_panelBuilder = panelBuilder;
        this.m_panelBuilder.addSelectionListener(new PanelSelectionListener());
        this.m_properties = panelProperties;
        this.m_treeModelListener = new PanelTreeViewTreeModelListener();
        this.m_properties.addTreeModelListener(this.m_treeModelListener);
        this.m_pdmlNodeListener = new PanelTreeViewPDMLNodeListener();
        this.m_properties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.m_root = new DefaultMutableTreeNode(panelProperties);
        this.m_treeModel = new FixedDefaultTreeModel(this.m_root);
        this.m_tree = new JTree(this.m_treeModel);
        this.m_tree.setCellRenderer(new PanelTreeViewCellRenderer());
        this.m_treeSelectionListener = new PanelTreeViewTreeSelectionListener();
        this.m_tree.addTreeSelectionListener(this.m_treeSelectionListener);
        this.m_tree.getSelectionModel().setSelectionMode(4);
        this.m_tree.addMouseListener(new PanelTreeViewMouseListener());
        this.m_tree.addFocusListener(new PanelTreeViewFocusListener());
        this.m_viewNodes = new Hashtable();
        this.m_viewNodes.put(this.m_properties, this.m_root);
        int n = 0;
        Enumeration<TreeNode> enumeration = panelProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            this.insertProperties(mutableProperties, panelProperties, n, false);
            ++n;
        }
        this.m_tree.expandPath(new TreePath(this.m_root));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_tree), "Center");
    }

    MutableProperties getProperties() {
        return this.m_properties;
    }

    void insertProperties(MutableProperties mutableProperties, MutableProperties mutableProperties2, int n, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_viewNodes.get(mutableProperties2);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(mutableProperties);
        this.m_viewNodes.put(mutableProperties, defaultMutableTreeNode2);
        if (n > defaultMutableTreeNode.getChildCount()) {
            n = defaultMutableTreeNode.getChildCount();
        }
        this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        if (mutableProperties.getType() == 112) {
            int n2 = 0;
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties3 = (MutableProperties)enumeration.nextElement();
                this.insertProperties(mutableProperties3, mutableProperties, n2, bl);
                ++n2;
            }
        }
    }

    void removeProperties(MutableProperties mutableProperties, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_viewNodes.get(mutableProperties);
        if (defaultMutableTreeNode != null) {
            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.m_viewNodes.remove(mutableProperties);
        }
        if (mutableProperties.getType() == 112) {
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
                this.removeProperties(mutableProperties2, 0);
            }
        }
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class PanelTreeViewFocusListener
    extends FocusAdapter {
        PanelTreeViewFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            ComponentInfo componentInfo = PanelTreeView.this.m_panelBuilder.m_editor.getComponentInfo(PanelTreeView.this.m_panelBuilder.getSelectedProperties());
            if (componentInfo != null) {
                componentInfo.requestFocus();
            } else {
                PanelTreeView.this.m_panelBuilder.m_editor.requestFocus();
            }
        }
    }

    class PanelTreeViewMouseListener
    extends MouseAdapter {
        PanelTreeViewMouseListener() {
        }

        void showContextMenu(Point point) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableProperties mutableProperties;
            MutableProperties mutableProperties2 = PanelTreeView.this.m_panelBuilder.getSelectedProperties();
            TreePath treePath = PanelTreeView.this.m_tree.getPathForLocation(point.x, point.y);
            if (treePath != null && PanelTreeView.this.m_tree.getSelectionCount() > 0 && mutableProperties2.equals(mutableProperties = (MutableProperties)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject())) {
                PanelTreeView.this.m_panelBuilder.m_editor.clearContextMenuLocation();
                JPopupMenu jPopupMenu = null;
                ComponentInfo componentInfo = PanelTreeView.this.m_panelBuilder.m_editor.getComponentInfo(mutableProperties2);
                jPopupMenu = componentInfo != null ? componentInfo.getContextMenu() : PanelTreeView.this.m_panelBuilder.getContextMenu(mutableProperties2);
                if (jPopupMenu != null) {
                    jPopupMenu.show(PanelTreeView.this.m_tree, point.x, point.y);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent.getPoint());
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent.getPoint());
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            MutableProperties mutableProperties;
            DefaultMutableTreeNode defaultMutableTreeNode;
            MutableProperties mutableProperties2;
            TreePath treePath;
            if (mouseEvent.getClickCount() == 2 && (treePath = PanelTreeView.this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (mutableProperties2 = (MutableProperties)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()).equals(mutableProperties = PanelTreeView.this.m_panelBuilder.getSelectedProperties()) && ((n = mutableProperties.getType()) == 50 || n == 55 || n == 103 || n == 104 || n == 9 || n == 8)) {
                PanelTreeView.this.m_panelBuilder.getBuilder().showEditor(mutableProperties);
            }
        }
    }

    class PanelTreeViewTreeSelectionListener
    implements TreeSelectionListener {
        PanelTreeViewTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = treeSelectionEvent.getPaths();
            if (treePathArray == null) {
                return;
            }
            int n = 0;
            while (n < treePathArray.length) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                MutableProperties mutableProperties = (MutableProperties)defaultMutableTreeNode.getUserObject();
                if (treeSelectionEvent.isAddedPath(treePathArray[n])) {
                    int n2 = mutableProperties.getType();
                    if (n2 == 1 || n2 == 50 || n2 == 55 || n2 == 112) {
                        PanelTreeView.this.m_panelBuilder.setSelectedProperties(mutableProperties);
                        break;
                    }
                    PanelTreeView.this.m_panelBuilder.addSelectedProperties(mutableProperties);
                } else {
                    PanelTreeView.this.m_panelBuilder.removeSelectedProperties(mutableProperties);
                }
                ++n;
            }
        }
    }

    class PanelTreeViewCellRenderer
    extends DefaultTreeCellRenderer {
        PanelTreeViewCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            MutableProperties mutableProperties = (MutableProperties)defaultMutableTreeNode.getUserObject();
            String string = (String)mutableProperties.getProperty("Name");
            String string2 = null;
            switch (mutableProperties.getType()) {
                case 1: {
                    string2 = "Panel.gif";
                    break;
                }
                case 60: {
                    string2 = "DeckPane.gif";
                    break;
                }
                case 61: {
                    string2 = "SplitPane.gif";
                    break;
                }
                case 62: {
                    string2 = "TabbedPane.gif";
                    break;
                }
                case 2: {
                    string2 = "Label.gif";
                    break;
                }
                case 110: {
                    string2 = "Bitmap.gif";
                    break;
                }
                case 3: {
                    string2 = "Groupbox.gif";
                    break;
                }
                case 106: {
                    string2 = "SpinButton.gif";
                    break;
                }
                case 4: 
                case 5: {
                    string2 = "Textfield.gif";
                    break;
                }
                case 6: {
                    string2 = "Button.gif";
                    break;
                }
                case 101: {
                    string2 = "Radiobutton.gif";
                    break;
                }
                case 102: {
                    string2 = "Checkbox.gif";
                    break;
                }
                case 112: {
                    string2 = "ButtonGroup.gif";
                    break;
                }
                case 8: {
                    string2 = "Combobox.gif";
                    break;
                }
                case 9: {
                    string2 = "Listbox.gif";
                    break;
                }
                case 103: {
                    string2 = "Table.gif";
                    break;
                }
                case 104: {
                    string2 = "Tree.gif";
                    break;
                }
                case 108: {
                    string2 = "Progress.gif";
                    break;
                }
                case 109: {
                    string2 = "Slider.gif";
                    break;
                }
                case 111: {
                    string2 = "Custom.gif";
                    break;
                }
                case 50: {
                    string = GUIFactory.getString("IDS_MENUBAR");
                    string2 = "MenuBar.gif";
                    break;
                }
                case 55: {
                    string = GUIFactory.getString("IDS_TOOLBAR");
                    string2 = "ToolBar.gif";
                }
            }
            if (string2 != null) {
                jLabel.setIcon(GUIFactory.getImage(string2, true));
            }
            jLabel.setText(string);
            return jLabel;
        }
    }

    class PanelTreeViewPDMLNodeListener
    implements PDMLNodeListener {
        PanelTreeViewPDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            PanelTreeView.this.m_treeModel.nodeChanged(PanelTreeView.this.m_root);
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }

    class PanelTreeViewTreeModelListener
    implements TreeModelListener {
        PanelTreeViewTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PanelTreeView.this.m_viewNodes.get(mutableProperties);
                    if (defaultMutableTreeNode != null) {
                        PanelTreeView.this.m_treeModel.nodeChanged(defaultMutableTreeNode);
                    }
                    ++n;
                }
            } else {
                PanelTreeView.this.m_treeModel.nodeChanged(PanelTreeView.this.m_root);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            int n = mutableProperties.getType();
            Object[] objectArray = treeModelEvent.getChildren();
            int[] nArray = treeModelEvent.getChildIndices();
            if (objectArray != null && nArray != null && (n == 1 || n == 112)) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n2];
                    PanelTreeView.this.insertProperties(mutableProperties2, mutableProperties, nArray[n2], true);
                    ++n2;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            int n = mutableProperties.getType();
            Object[] objectArray = treeModelEvent.getChildren();
            int[] nArray = treeModelEvent.getChildIndices();
            if (objectArray != null && nArray != null && (n == 1 || n == 112)) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n2];
                    PanelTreeView.this.removeProperties(mutableProperties2, nArray[n2]);
                    ++n2;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class PanelSelectionListener
    implements SelectionListener {
        PanelSelectionListener() {
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            PanelTreeView.this.m_tree.removeTreeSelectionListener(PanelTreeView.this.m_treeSelectionListener);
            PanelTreeView.this.m_tree.clearSelection();
            Vector<TreePath> vector = new Vector<TreePath>(5, 5);
            Enumeration enumeration = PanelTreeView.this.m_panelBuilder.getSelection();
            while (enumeration.hasMoreElements()) {
                MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PanelTreeView.this.m_viewNodes.get(mutableProperties);
                if (defaultMutableTreeNode == null) continue;
                vector.addElement(new TreePath(defaultMutableTreeNode.getPath()));
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (n2 == 0) {
                    PanelTreeView.this.m_tree.setSelectionPath((TreePath)vector.elementAt(n2));
                } else {
                    PanelTreeView.this.m_tree.addSelectionPath((TreePath)vector.elementAt(n2));
                }
                ++n2;
            }
            PanelTreeView.this.m_tree.addTreeSelectionListener(PanelTreeView.this.m_treeSelectionListener);
        }
    }
}

