/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIConstants;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PanelProperties;
import com.ibm.as400.ui.tools.PropertyTable;
import com.ibm.as400.ui.tools.PropertyTableCellRenderer;
import com.ibm.as400.ui.tools.PropertyTableModel;
import com.ibm.as400.ui.tools.SelectionObject;
import com.ibm.as400.ui.tools.SelectionObjectCollection;
import com.ibm.as400.ui.tools.SpinnerProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class PropertyDialog
extends BuilderFrame {
    PropertyTable m_table;
    PropertyTableModel m_tableModel;
    PropertyTableModelListener m_modelListener;
    PropertyNodeListener m_nodeListener = new PropertyNodeListener();
    boolean m_editInProgress = false;
    static /* synthetic */ Class class$java$lang$Object;

    PropertyDialog(GUIBuilder gUIBuilder) {
        super(gUIBuilder, null, null);
        Object[] objectArray = new Object[]{GUIFactory.getString("IDS_PROPERTY_HEADER"), GUIFactory.getString("IDS_VALUE_HEADER")};
        this.m_tableModel = new PropertyTableModel();
        this.m_tableModel.setColumnIdentifiers(objectArray);
        this.m_table = new PropertyTable(this, this.m_tableModel);
        this.m_table.setOpaque(true);
        this.m_table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PropertyDialog.class$("java.lang.Object")) : class$java$lang$Object, new PropertyTableCellRenderer(this));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new PropertyCellEditor());
        defaultCellEditor.setClickCountToStart(1);
        this.m_table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = PropertyDialog.class$("java.lang.Object")) : class$java$lang$Object, defaultCellEditor);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getSelectionModel().setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                int n2 = PropertyDialog.this.getSelectedRow();
                if (n2 != (n = PropertyDialog.this.m_table.getEditingRow()) || n2 == -1) {
                    PropertyDialog.this.stopEditing();
                } else {
                    PropertyDialog.this.m_table.setRowSelectionInterval(n2, n2);
                }
            }
        });
        this.m_table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PropertyDialog.this.stopEditing();
            }
        });
        this.m_modelListener = new PropertyTableModelListener();
        this.m_tableModel.addTableModelListener(this.m_modelListener);
        ((Frame)this).setIconImage(GUIFactory.getImage("GUIBuilder.gif", true).getImage());
        this.setTitle(GUIFactory.getString("IDS_PROPERTIES_TITLEBAR"));
        this.getContentPane().setBackground(this.m_table.getBackground());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.m_table), "Center");
    }

    String getHelpName() {
        int n = this.getSelectedRow();
        if (n > -1) {
            String string = this.m_tableModel.getValueAt(n, 0).toString();
            String string2 = GUIFactory.getPropertyHelp(string);
            int n2 = this.getProperties().getType();
            if (string.equals("Title")) {
                switch (n2) {
                    case 110: {
                        string2 = "file";
                        break;
                    }
                    case 1: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 120: {
                        string2 = "title";
                    }
                }
            } else if (n2 == 1 && (string.equals("-> Width") || string.equals("-> Height"))) {
                string2 = "size";
            } else if (string2.equals("format") && n2 == 106) {
                string2 = "spinnerformat";
            } else if (string2.equals("spinnerformat") && n2 != 106) {
                string2 = "format";
            }
            return string2;
        }
        return null;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canPaste() {
        return false;
    }

    public boolean canDelete() {
        return false;
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void delete() {
    }

    public MutableProperties getSelectedProperties() {
        return this.getProperties();
    }

    public void stopEditing() {
        if (this.m_table.isEditing()) {
            if (this.m_table.getEditingRow() < this.m_table.getRowCount()) {
                this.m_table.getCellEditor().stopCellEditing();
            } else {
                this.m_table.getCellEditor().cancelCellEditing();
            }
        }
    }

    void editProperty(String string) {
        int n = -1;
        int n2 = this.m_tableModel.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = (String)this.m_tableModel.getValueAt(n3, 0);
            if (string2.equals(string)) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n > -1 && this.m_tableModel.isCellEditable(n, 1)) {
            ((Component)this).setVisible(true);
            this.requestFocus();
            this.m_table.setRowSelectionInterval(n, n);
            this.m_table.setColumnSelectionInterval(1, 1);
            this.m_table.editCellAt(n, 1);
            this.m_table.getEditorComponent().requestFocus();
        }
    }

    int getSelectedRow() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    void setProperties(MutableProperties mutableProperties) {
        MutableProperties mutableProperties2;
        if (this.m_properties != null) {
            this.m_properties.removePDMLNodeListener(this.m_nodeListener);
        }
        this.m_properties = mutableProperties;
        this.m_document = this.m_properties != null ? this.m_properties.getPDMLDocument() : null;
        this.m_table.setPanelProperties(null);
        if (this.m_properties != null && (mutableProperties2 = (MutableProperties)this.m_properties.getParent()) != null) {
            if (mutableProperties2.getType() == 112) {
                mutableProperties2 = (MutableProperties)mutableProperties2.getParent();
            }
            if (mutableProperties2.getType() == 1) {
                this.m_table.setPanelProperties((PanelProperties)mutableProperties2);
            }
        }
        if (this.m_properties != null) {
            this.m_properties.addPDMLNodeListener(this.m_nodeListener);
        }
        this.getBuilder().updateBuilder();
    }

    public void updateBuilder() {
        this.m_tableModel.setNumRows(0);
        if (this.getProperties() == null) {
            return;
        }
        int n = 0;
        Vector<Object> vector = new Vector<Object>(2);
        vector.addElement("Element");
        vector.addElement(GUIConstants.getType(this.getProperties().getType()));
        this.m_tableModel.setCellEditable(n, 1, false);
        this.m_tableModel.addRow(vector);
        ++n;
        Enumeration enumeration = this.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.getProperties().isPropertyVisible(string)) continue;
            vector = new Vector(2);
            vector.addElement(string);
            vector.addElement(this.getProperties().getProperty(string));
            this.m_tableModel.setCellEditable(n, 1, this.getProperties().isPropertyEditable(string));
            if (this.getBuilder().isTranslationMode() && this.m_tableModel.isCellEditable(n, 1) && !string.equals("-> X") && !string.equals("-> Y") && !string.equals("-> Width") && !string.equals("-> Height")) {
                this.m_tableModel.setCellEditable(n, 1, false);
            }
            this.m_tableModel.addRow(vector);
            ++n;
        }
        String[] stringArray = new String[]{"Enable", "Disable", "Refresh", "Show", "Hide", "Display"};
        int n2 = 0;
        while (n2 < 2) {
            SelectionObject selectionObject = this.getProperties().getSelectionObject(n2 == 0);
            if (selectionObject != null && selectionObject.containsSelectionObjectElements()) {
                vector = new Vector(2);
                if (n2 == 0) {
                    vector.addElement("Selected");
                } else {
                    vector.addElement("Deselected");
                }
                vector.addElement("");
                this.m_tableModel.setCellEditable(n, 1, false);
                this.m_tableModel.addRow(vector);
                ++n;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    SelectionObjectCollection selectionObjectCollection = selectionObject.getSelectionObjectCollection(stringArray[n3]);
                    if (selectionObjectCollection.getChildCount() > 0) {
                        vector = new Vector(2);
                        if (n2 == 0) {
                            vector.addElement("+ " + stringArray[n3]);
                        } else {
                            vector.addElement("- " + stringArray[n3]);
                        }
                        vector.addElement(selectionObjectCollection.getSelectionString());
                        this.m_tableModel.setCellEditable(n, 1, false);
                        this.m_tableModel.addRow(vector);
                        ++n;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        this.repaint();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PropertyNodeListener
    implements PDMLNodeListener {
        PropertyNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            if (!PropertyDialog.this.m_editInProgress && !PropertyDialog.this.getPDMLDocument().isTemporaryEdit()) {
                PropertyDialog.this.getBuilder().updateBuilder();
            }
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
            if (!PropertyDialog.this.m_editInProgress && !PropertyDialog.this.getPDMLDocument().isTemporaryEdit()) {
                PropertyDialog.this.setProperties(null);
            }
        }
    }

    class PropertyCellEditor
    extends JTextField {
        public PropertyCellEditor() {
            this.setBorder(new LineBorder(Color.black));
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ PropertyCellEditor this$1;
                {
                    this.this$1 = propertyCellEditor;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() != 9 && keyEvent.getKeyCode() == 27 && PropertyCellEditor.access$000((PropertyCellEditor)this.this$1).m_table.isEditing()) {
                        ((DefaultCellEditor)PropertyCellEditor.access$000((PropertyCellEditor)this.this$1).m_table.getCellEditor()).cancelCellEditing();
                    }
                }
            });
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isManagingFocus() {
            return true;
        }

        static /* synthetic */ PropertyDialog access$000(PropertyCellEditor propertyCellEditor) {
            return propertyCellEditor.PropertyDialog.this;
        }
    }

    class PropertyTableModelListener
    implements TableModelListener {
        PropertyTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            Object object;
            Object object2;
            String string;
            int n;
            int n2;
            block64: {
                if (tableModelEvent.getType() != 0 || PropertyDialog.this.getProperties() == null) {
                    return;
                }
                n2 = tableModelEvent.getColumn();
                n = tableModelEvent.getFirstRow();
                if (n2 != 1 || n < 0 || n >= PropertyDialog.this.m_tableModel.getRowCount()) {
                    return;
                }
                PropertyDialog.this.m_tableModel.removeTableModelListener(PropertyDialog.this.m_modelListener);
                string = (String)PropertyDialog.this.m_tableModel.getValueAt(n, 0);
                object2 = PropertyDialog.this.getProperties().getProperty(string);
                object = PropertyDialog.this.m_tableModel.getValueAt(n, 1);
                if (string.startsWith("->")) {
                    while (string.startsWith("->") && n >= 0) {
                        string = (String)PropertyDialog.this.m_tableModel.getValueAt(--n, 0);
                    }
                    object2 = PropertyDialog.this.getProperties().getProperty(string);
                    try {
                        int n3 = Integer.parseInt(PropertyDialog.this.m_tableModel.getValueAt(n + 1, 1).toString());
                        int n4 = Integer.parseInt(PropertyDialog.this.m_tableModel.getValueAt(n + 2, 1).toString());
                        if (object2 instanceof Dimension) {
                            object = new Dimension(n3, n4);
                            break block64;
                        }
                        if (object2 instanceof Rectangle) {
                            int n5 = Integer.parseInt(PropertyDialog.this.m_tableModel.getValueAt(n + 3, 1).toString());
                            int n6 = Integer.parseInt(PropertyDialog.this.m_tableModel.getValueAt(n + 4, 1).toString());
                            object = new Rectangle(n3, n4, n5, n6);
                            break block64;
                        }
                        object = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(PropertyDialog.this, GUIFactory.getString("IDS_INTEGER_NOT_VALID"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        object = null;
                    }
                } else if (string.equals("Name")) {
                    if (object.toString().equals("")) {
                        String string2 = GUIFactory.getString("IDS_PROPERTY_VALUE_REQUIRED");
                        Object[] objectArray = new Object[]{string};
                        string2 = MessageFormat.format(string2, objectArray);
                        JOptionPane.showMessageDialog(PropertyDialog.this, string2, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        object = null;
                    } else if (!object2.equals(object) && PropertyDialog.this.getPDMLDocument().isNameRegistered(PropertyDialog.this.getProperties().getFullyQualifiedName(object.toString()))) {
                        String string3 = GUIFactory.getString("IDS_NAME_EXISTS");
                        Object[] objectArray = new Object[]{object};
                        string3 = MessageFormat.format(string3, objectArray);
                        JOptionPane.showMessageDialog(PropertyDialog.this, string3, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        object = null;
                    }
                } else if (string.equals("* Class") && object.toString().equals("")) {
                    String string4 = GUIFactory.getString("IDS_PROPERTY_VALUE_REQUIRED");
                    Object[] objectArray = new Object[]{GUIFactory.getString("IDP_CLASS_NAME")};
                    string4 = MessageFormat.format(string4, objectArray);
                    JOptionPane.showMessageDialog(PropertyDialog.this, string4, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                    object = null;
                } else if (string.equals("Manager Class") && object.toString().equals("")) {
                    String string5 = GUIFactory.getString("IDS_PROPERTY_VALUE_REQUIRED");
                    Object[] objectArray = new Object[]{GUIFactory.getString("IDP_MANAGER_CLASS")};
                    string5 = MessageFormat.format(string5, objectArray);
                    JOptionPane.showMessageDialog(PropertyDialog.this, string5, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                    object = null;
                } else if (string.equals("Menu Action") && object.toString().equals("")) {
                    String string6 = GUIFactory.getString("IDS_PROPERTY_VALUE_REQUIRED");
                    Object[] objectArray = new Object[]{GUIFactory.getString("IDP_ACTION")};
                    string6 = MessageFormat.format(string6, objectArray);
                    JOptionPane.showMessageDialog(PropertyDialog.this, string6, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                    object = null;
                } else if (string.equals("* Key")) {
                    object = ((String)object).toUpperCase();
                } else if (string.equals("* Help Alias")) {
                    if (object instanceof String && object.toString().equals("@NONE")) {
                        object = "";
                    }
                } else if (PropertyDialog.this.getProperties().getType() == 110 && string.equals("Title")) {
                    ImageIcon imageIcon;
                    String string7 = (String)object;
                    if (!string7.equals("") && (imageIcon = GUIFactory.getUserImage(string7)) != null) {
                        Rectangle rectangle = (Rectangle)PropertyDialog.this.getProperties().getProperty("Bounds");
                        PropertyDialog.this.m_editInProgress = true;
                        PropertyDialog.this.getPDMLDocument().beginEdit(true);
                        try {
                            PropertyDialog.this.getProperties().setProperty("Bounds", new Rectangle(rectangle.x, rectangle.y, imageIcon.getIconWidth(), imageIcon.getIconHeight()));
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            PropertyDialog.this.getPDMLDocument().abortEdit();
                            PropertyDialog.this.m_editInProgress = false;
                        }
                    }
                } else if (string.startsWith("*") && !object.toString().equals("")) {
                    String string8 = object.toString();
                    if (string.equals("* Int Max Value") || string.equals("* Int Min Value") || string.equals("* Min Length") || string.equals("* Max Length") || string.equals("* Int Init Value") || string.equals("* Percent Min Fraction") || string.equals("* Percent Max Fraction")) {
                        try {
                            new Integer(string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(PropertyDialog.this, GUIFactory.getString("IDS_INTEGER_NOT_VALID"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            object = null;
                        }
                    } else if (string.equals("* Short Max Value") || string.equals("* Short Min Value")) {
                        try {
                            new Short(string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(PropertyDialog.this, GUIFactory.getString("IDS_INTEGER_NOT_VALID"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            object = null;
                        }
                    } else if (string.equals("* Long Max Value") || string.equals("* Long Min Value")) {
                        try {
                            new Long(string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(PropertyDialog.this, GUIFactory.getString("IDS_INTEGER_NOT_VALID"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            object = null;
                        }
                    } else if (string.equals("* Float Max Value") || string.equals("* Float Min Value")) {
                        try {
                            new Float(string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(PropertyDialog.this, GUIFactory.getString("IDS_FLOAT_NOT_VALID"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            object = null;
                        }
                    } else if (string.startsWith("* Date") && string.endsWith("Value")) {
                        Calendar calendar = Calendar.getInstance();
                        DateFormat dateFormat = SpinnerProperties.getDateFormat(calendar);
                        try {
                            Date date = dateFormat.parse(string8);
                            object = dateFormat.getCalendar();
                        }
                        catch (Exception exception) {
                            calendar.set(1999, 11, 31, 12, 34, 56);
                            Object[] objectArray = new Object[]{dateFormat.format(calendar.getTime())};
                            JOptionPane.showMessageDialog(PropertyDialog.this, MessageFormat.format(GUIFactory.getString("IDS_DATE_NOT_VALID"), objectArray), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            object = null;
                        }
                    } else if (string.startsWith("* Time") && string.endsWith("Value")) {
                        Calendar calendar = Calendar.getInstance();
                        DateFormat dateFormat = SpinnerProperties.getTimeFormat(calendar);
                        try {
                            Date date = dateFormat.parse(string8);
                            object = dateFormat.getCalendar();
                        }
                        catch (Exception exception) {
                            calendar.set(1999, 11, 31, 12, 34, 56);
                            Object[] objectArray = new Object[]{dateFormat.format(calendar.getTime())};
                            JOptionPane.showMessageDialog(PropertyDialog.this, MessageFormat.format(GUIFactory.getString("IDS_TIME_NOT_VALID"), objectArray), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            object = null;
                        }
                    }
                }
            }
            if (object != null) {
                if (object2 instanceof Boolean) {
                    object = new Boolean(object.toString());
                } else if (object2 instanceof Integer) {
                    try {
                        object = new Integer(object.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(PropertyDialog.this, GUIFactory.getString("IDS_INTEGER_NOT_VALID"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        object = null;
                    }
                }
            }
            if (object != null && !object2.equals(object)) {
                if (!PropertyDialog.this.m_editInProgress) {
                    PropertyDialog.this.m_editInProgress = true;
                    PropertyDialog.this.getPDMLDocument().beginEdit(true);
                }
                try {
                    PropertyDialog.this.getProperties().setProperty(string, object);
                    PropertyDialog.this.getPDMLDocument().endEdit();
                    PropertyDialog.this.m_editInProgress = false;
                    PropertyDialog.this.m_tableModel.setValueAt(object, n, n2);
                }
                catch (PropertyVetoException propertyVetoException) {
                    PropertyDialog.this.getPDMLDocument().abortEdit();
                    PropertyDialog.this.m_editInProgress = false;
                    PropertyDialog.this.m_tableModel.setValueAt(object2, n, n2);
                    JOptionPane.showMessageDialog(PropertyDialog.this, propertyVetoException.getMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                }
            }
            PropertyDialog.this.getBuilder().updateBuilder();
            PropertyDialog.this.m_tableModel.addTableModelListener(PropertyDialog.this.m_modelListener);
        }
    }
}

