/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.ComponentDescriptor;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.tools.ComponentProperties;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.MutableResource;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import com.ibm.as400.ui.tools.XMLWriter;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.MessageFormat;

class SliderProperties
extends ComponentProperties {
    SliderProperties() {
        super(109);
    }

    SliderProperties(XMLGUIBuilderDefinition xMLGUIBuilderDefinition) throws PDMLSpecificationException {
        super(xMLGUIBuilderDefinition, 109);
    }

    SliderProperties(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, ComponentDescriptor componentDescriptor) throws PDMLSpecificationException {
        super(xMLGUIBuilderDefinition, componentDescriptor, 109);
        this.processAttributes(componentDescriptor);
    }

    void processAttributes(ComponentDescriptor componentDescriptor) throws PDMLSpecificationException {
        if (componentDescriptor.m_orientation != null) {
            try {
                this.setProperty("Orientation", componentDescriptor.m_orientation);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (componentDescriptor.m_minValue > 0) {
            try {
                this.setProperty("Min Value", new Integer(componentDescriptor.m_minValue));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (componentDescriptor.m_maxValue > 0) {
            try {
                this.setProperty("Max Value", new Integer(componentDescriptor.m_maxValue));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (componentDescriptor.m_majorTicks > -1) {
            try {
                this.setProperty("Major Ticks", new Integer(componentDescriptor.m_majorTicks));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (componentDescriptor.m_minorTicks > -1) {
            try {
                this.setProperty("Minor Ticks", new Integer(componentDescriptor.m_minorTicks));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (componentDescriptor.m_action != null) {
            try {
                this.setProperty("Adjust", componentDescriptor.m_action);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    void initProperties() {
        super.initProperties();
        this.addProperty("Orientation");
        try {
            this.setProperty("Orientation", "horizontal");
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Min Value");
        this.addProperty("Max Value");
        try {
            this.setProperty("Min Value", new Integer(0));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setProperty("Max Value", new Integer(100));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Major Ticks");
        this.addProperty("Minor Ticks");
        try {
            this.setProperty("Major Ticks", new Integer(0));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setProperty("Minor Ticks", new Integer(0));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Adjust");
        this.setPropertyVisible("Title", false);
    }

    void propertyUpdate(String string, Object object, Object object2) {
        super.propertyUpdate(string, object, object2);
        if (string.equals("Orientation")) {
            boolean bl = object.equals("horizontal");
            boolean bl2 = object2.equals("horizontal");
            Rectangle rectangle = (Rectangle)this.getProperty("Bounds");
            if (bl2) {
                if (rectangle.width < rectangle.height) {
                    try {
                        this.setProperty("Bounds", new Rectangle(rectangle.x, rectangle.y, rectangle.height, rectangle.width));
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (rectangle.width > rectangle.height) {
                try {
                    this.setProperty("Bounds", new Rectangle(rectangle.x, rectangle.y, rectangle.height, rectangle.width));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        int n;
        super.vetoableChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Adjust")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (!this.isValidClassName(string2)) {
                Object[] objectArray = new Object[]{string2};
                String string3 = MessageFormat.format(GUIFactory.getString("IDS_CLASS_NOT_VALID"), objectArray);
                throw new PropertyVetoException(string3, propertyChangeEvent);
            }
        } else if (string.equals("Min Value")) {
            int n2;
            int n3;
            if (this.getProperty("Max Value") instanceof Integer && (n3 = ((Integer)propertyChangeEvent.getNewValue()).intValue()) > (n2 = ((Integer)this.getProperty("Max Value")).intValue())) {
                String string4 = GUIFactory.getString("IDS_MAX_LESS_THAN_MIN");
                throw new PropertyVetoException(string4, propertyChangeEvent);
            }
        } else if (string.equals("Max Value")) {
            if (this.getProperty("Min Value") instanceof Integer) {
                int n4 = (Integer)propertyChangeEvent.getNewValue();
                int n5 = (Integer)this.getProperty("Min Value");
                if (n5 > n4) {
                    String string5 = GUIFactory.getString("IDS_MAX_LESS_THAN_MIN");
                    throw new PropertyVetoException(string5, propertyChangeEvent);
                }
            }
        } else if (string.equals("Major Ticks")) {
            int n6 = (Integer)propertyChangeEvent.getNewValue();
            if (n6 < 0) {
                String string6 = GUIFactory.getString("IDS_VALUE_LESS_THAN_ZERO");
                throw new PropertyVetoException(string6, propertyChangeEvent);
            }
        } else if (string.equals("Minor Ticks") && (n = ((Integer)propertyChangeEvent.getNewValue()).intValue()) < 0) {
            String string7 = GUIFactory.getString("IDS_VALUE_LESS_THAN_ZERO");
            throw new PropertyVetoException(string7, propertyChangeEvent);
        }
    }

    String getOpenTag() {
        String string = "<SLIDER name=\"" + this.getProperty("Name") + "\" orientation=\"" + this.getProperty("Orientation");
        boolean bl = (Boolean)this.getProperty("Disabled");
        if (bl) {
            string = string + "\" disabled=\"yes";
        }
        string = string + "\">";
        return string;
    }

    String getCloseTag() {
        return "</SLIDER>";
    }

    void saveChildren(XMLWriter xMLWriter, MutableResource mutableResource) throws IOException {
        String string;
        xMLWriter.writeIndent();
        xMLWriter.writeChars("<MINVALUE>" + this.getProperty("Min Value") + "</MINVALUE>");
        xMLWriter.writeNewLine();
        xMLWriter.writeIndent();
        xMLWriter.writeChars("<MAXVALUE>" + this.getProperty("Max Value") + "</MAXVALUE>");
        xMLWriter.writeNewLine();
        int n = (Integer)this.getProperty("Major Ticks");
        int n2 = (Integer)this.getProperty("Minor Ticks");
        if (n > 0 || n2 > 0) {
            xMLWriter.writeIndent();
            xMLWriter.writeChars("<MAJORTICKS>" + n + "</MAJORTICKS>");
            xMLWriter.writeNewLine();
            xMLWriter.writeIndent();
            xMLWriter.writeChars("<MINORTICKS>" + n2 + "</MINORTICKS>");
            xMLWriter.writeNewLine();
        }
        if (!(string = (String)this.getProperty("Adjust")).equals("")) {
            xMLWriter.writeIndent();
            xMLWriter.writeChars("<ADJUST>" + string + "</ADJUST>");
            xMLWriter.writeNewLine();
        }
        super.saveChildren(xMLWriter, mutableResource);
    }

    MutableProperties cloneNodeInstance() {
        SliderProperties sliderProperties = new SliderProperties();
        return sliderProperties;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

