/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PropertyTableModel;
import com.ibm.as400.ui.tools.StringTableEntry;
import com.ibm.as400.ui.tools.StringTableProperties;
import com.ibm.as400.ui.tools.StringTableTable;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class StringTableBuilder
extends BuilderFrame {
    JTable m_table;
    DefaultTableModel m_tableModel;
    StringTableModelListener m_modelListener;
    Vector m_vFindCache;
    JPanel m_mainToolBar;
    JPanel m_editToolBar;
    JPanel m_helpToolBar;
    JPanel m_findToolBar;
    JPanel m_findButtonsBar;
    JComboBox m_dropFind;
    JPopupMenu m_contextMenu;
    ActionListener m_menuListener;
    int m_sortedKeys = 1;
    int m_sortedValues = 0;
    TreeModelListener m_treeModelListener = new StringTreeModelListener();
    static /* synthetic */ Class class$java$lang$Object;

    StringTableBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, StringTableProperties stringTableProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, stringTableProperties);
        stringTableProperties.addTreeModelListener(this.m_treeModelListener);
        this.removeKeyListener(this.m_keyListener);
        this.m_vFindCache = new Vector(10);
        this.m_dropFind = new JComboBox();
        this.m_dropFind.setEditable(true);
        this.m_dropFind.setAlignmentY(0.0f);
        this.m_dropFind.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    default: {
                        return;
                    }
                    case 10: {
                        StringTableBuilder.this.doFindNext();
                        return;
                    }
                    case 114: 
                }
                if ((keyEvent.getModifiers() & 1) != 0) {
                    StringTableBuilder.this.doFindPrevious();
                } else {
                    StringTableBuilder.this.doFindNext();
                }
            }
        });
        StringActionListener stringActionListener = new StringActionListener();
        this.m_menuListener = stringActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Add", null, null, "Add.gif", "IDTT_ADD_STRING", true, stringActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove", null, null, "Remove.gif", "IDTT_REMOVE_STRING", true, stringActionListener));
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 3, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, stringActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, stringActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, stringActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 1, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, stringActionListener));
        this.m_findToolBar = new JPanel();
        this.m_findToolBar.setLayout(new BorderLayout());
        this.m_findToolBar.add((Component)this.m_dropFind, "Center");
        this.m_findButtonsBar = new JPanel();
        this.m_findButtonsBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_findButtonsBar.add(GUIFactory.createButton("Find Next", null, null, "FindNext.gif", "IDTT_FIND_NEXT", true, stringActionListener));
        this.m_findButtonsBar.add(GUIFactory.createButton("Find Previous", null, null, "FindPrev.gif", "IDTT_FIND_PREVIOUS", true, stringActionListener));
        this.m_findToolBar.add((Component)this.m_findButtonsBar, "East");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_mainToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_helpToolBar);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.m_findToolBar, "South");
        Object[] objectArray = new Object[]{GUIFactory.getString("IDS_ID_HEADER"), GUIFactory.getString("IDS_VALUE_HEADER")};
        this.m_tableModel = new PropertyTableModel(stringTableProperties.getType());
        this.m_tableModel.setColumnIdentifiers(objectArray);
        this.m_table = new StringTableTable(gUIBuilder, this.m_tableModel, stringTableProperties);
        this.m_table.setOpaque(true);
        this.m_table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = StringTableBuilder.class$("java.lang.Object")) : class$java$lang$Object, new StringCellRenderer());
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getSelectionModel().setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(new StringSelectionListener());
        this.m_table.addMouseListener(new StringMouseListener());
        this.m_table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                StringTableBuilder.this.stopEditing();
            }
        });
        this.m_modelListener = new StringTableModelListener();
        this.m_tableModel.addTableModelListener(this.m_modelListener);
        this.m_table.getTableHeader().addMouseListener(new StringSortHandler());
        ((Frame)this).setIconImage(GUIFactory.getImage("Stringtable.gif", true).getImage());
        this.updateTitleBar(null);
        this.getContentPane().setBackground(this.m_table.getBackground());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)new JScrollPane(this.m_table), "Center");
        int n = 0;
        Enumeration<TreeNode> enumeration = stringTableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            this.insertProperties(mutableProperties, n, false);
            ++n;
        }
        Dimension dimension = jPanel2.getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 400;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_STRING_EDIT_CUT", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_STRING_EDIT_COPY", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_STRING_EDIT_PASTE", null, false, this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_STRING_EDIT_DELETE", null, false, this.m_menuListener));
    }

    JPopupMenu getContextMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.canDelete());
        return this.m_contextMenu;
    }

    String getHelpName() {
        return "StringTableBuilder";
    }

    public void updateBuilder() {
        int n = this.m_table.getRowCount();
        this.m_mainToolBar.getComponent(1).setEnabled(this.canDelete());
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        this.m_findButtonsBar.getComponent(0).setEnabled(n > 0);
        this.m_findButtonsBar.getComponent(1).setEnabled(n > 0);
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        this.setTitle(GUIFactory.getString("IDS_STRINGTABLE") + " (" + string + ")");
    }

    public void stopEditing() {
        if (this.m_table.isEditing()) {
            ((DefaultCellEditor)this.m_table.getCellEditor()).stopCellEditing();
        }
    }

    int getSelectedRow() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public boolean canCut() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canCopy() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public boolean canPaste() {
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        if (transferable != null && transferable instanceof MutableProperties) {
            MutableProperties mutableProperties = (MutableProperties)transferable;
            int n = mutableProperties.getType();
            return n == 81 || n == 80;
        }
        return false;
    }

    public boolean canDelete() {
        int n = this.getSelectedRow();
        int n2 = this.m_table.getRowCount();
        return n > -1 && n2 > 0;
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getTableSelection();
        this.doRemove();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.getPDMLDocument().endEdit();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getTableSelection();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
    }

    public void paste() {
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), (StringTableProperties)this.getProperties());
        if (mutableProperties.getType() == 80) {
            while (mutableProperties.getChildCount() > 0) {
                MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getChildAt(0);
                this.getProperties().add(mutableProperties2);
            }
        } else {
            this.getProperties().add(mutableProperties);
        }
        this.getPDMLDocument().endEdit();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        this.doRemove();
        this.getPDMLDocument().endEdit();
    }

    public MutableProperties getSelectedProperties() {
        return this.getProperties();
    }

    MutableProperties getTableSelection() {
        int n = this.getSelectedRow();
        if (n > -1) {
            return (MutableProperties)this.m_tableModel.getValueAt(n, 0);
        }
        return null;
    }

    StringTableEntry getEntryAtIndex(int n) {
        return (StringTableEntry)this.getProperties().getChildAt(n);
    }

    void doAdd() {
        StringTableEntry stringTableEntry = new StringTableEntry();
        try {
            stringTableEntry.setProperty("Name", ((StringTableProperties)this.getProperties()).generateName(81));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        stringTableEntry.setPDMLDocument(this.getPDMLDocument());
        this.getProperties().add(stringTableEntry);
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getTableSelection();
        if (mutableProperties != null) {
            int n = this.getSelectedRow();
            mutableProperties.removeFromParent();
            int n2 = this.m_table.getRowCount();
            if (n2 > 0) {
                if (n >= n2) {
                    n = n2 - 1;
                }
                this.m_table.setRowSelectionInterval(n, n);
            }
        }
    }

    void doFindNext() {
        this.stopEditing();
        int n = this.getSelectedRow();
        String string = this.getFindQuery();
        if (string == null) {
            return;
        }
        String string2 = string.toLowerCase();
        if (this.m_tableModel.getRowCount() > 0) {
            int n2 = n + 1;
            while (true) {
                StringTableEntry stringTableEntry;
                String string3;
                if (n2 >= this.m_tableModel.getRowCount()) {
                    if (n < 0) break;
                    n2 = 0;
                }
                if ((string3 = (String)(stringTableEntry = (StringTableEntry)this.m_tableModel.getValueAt(n2, 0)).getProperty("Name")).toLowerCase().indexOf(string2) >= 0) {
                    this.m_table.setRowSelectionInterval(n2, n2);
                    this.m_table.setColumnSelectionInterval(0, 0);
                    this.m_table.scrollRectToVisible(this.m_table.getCellRect(n2, 0, true));
                    return;
                }
                string3 = (String)stringTableEntry.getProperty("Value");
                if (string3.toLowerCase().indexOf(string2) >= 0) {
                    this.m_table.setRowSelectionInterval(n2, n2);
                    this.m_table.setColumnSelectionInterval(1, 1);
                    this.m_table.scrollRectToVisible(this.m_table.getCellRect(n2, 1, true));
                    return;
                }
                if (n2 == n) break;
                ++n2;
            }
            Object[] objectArray = new Object[]{string};
            String string4 = MessageFormat.format(GUIFactory.getString("IDS_STRING_NOT_FOUND"), objectArray);
            JOptionPane.showMessageDialog(this, string4, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 1);
        }
    }

    void doFindPrevious() {
        String string;
        this.stopEditing();
        int n = this.getSelectedRow();
        if (n < 0) {
            n = 0;
        }
        if ((string = this.getFindQuery()) == null) {
            return;
        }
        String string2 = string.toLowerCase();
        if (this.m_tableModel.getRowCount() > 0) {
            int n2 = n - 1;
            while (true) {
                StringTableEntry stringTableEntry;
                String string3;
                if (n2 < 0) {
                    n2 = this.m_tableModel.getRowCount() - 1;
                }
                if ((string3 = (String)(stringTableEntry = (StringTableEntry)this.m_tableModel.getValueAt(n2, 0)).getProperty("Name")).toLowerCase().indexOf(string2) >= 0) {
                    this.m_table.setRowSelectionInterval(n2, n2);
                    this.m_table.setColumnSelectionInterval(0, 0);
                    this.m_table.scrollRectToVisible(this.m_table.getCellRect(n2, 0, true));
                    return;
                }
                string3 = (String)stringTableEntry.getProperty("Value");
                if (string3.toLowerCase().indexOf(string2) >= 0) {
                    this.m_table.setRowSelectionInterval(n2, n2);
                    this.m_table.setColumnSelectionInterval(1, 1);
                    this.m_table.scrollRectToVisible(this.m_table.getCellRect(n2, 1, true));
                    return;
                }
                if (n2 == n) break;
                --n2;
            }
            Object[] objectArray = new Object[]{string};
            String string4 = MessageFormat.format(GUIFactory.getString("IDS_STRING_NOT_FOUND"), objectArray);
            JOptionPane.showMessageDialog(this, string4, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 1);
        }
    }

    String getFindQuery() {
        String string = ((JTextField)this.m_dropFind.getEditor().getEditorComponent()).getText();
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (!this.m_vFindCache.contains(string2)) {
            if (this.m_vFindCache.size() == 10) {
                this.m_dropFind.removeItem(this.m_vFindCache.elementAt(9));
                this.m_vFindCache.removeElementAt(9);
            }
            if (this.m_vFindCache.size() > 0) {
                this.m_vFindCache.insertElementAt(string2, 0);
                this.m_dropFind.insertItemAt(string2, 0);
            } else {
                this.m_vFindCache.addElement(string2);
                this.m_dropFind.addItem(string2);
            }
        }
        return string;
    }

    void insertProperties(MutableProperties mutableProperties, int n, boolean bl) {
        Object[] objectArray = new Object[]{mutableProperties, mutableProperties};
        this.m_tableModel.insertRow(n, objectArray);
        if (bl) {
            this.m_table.setRowSelectionInterval(n, n);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(n, 0, true));
        }
    }

    void removeProperties(MutableProperties mutableProperties, int n) {
        this.m_tableModel.removeRow(n);
    }

    public void uninstallListeners() {
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StringCellRenderer
    extends DefaultTableCellRenderer {
        StringCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            }
            if (object != null) {
                this.setValue(object);
                this.setIcon(null);
                MutableProperties mutableProperties = (MutableProperties)object;
                if (n2 == 0) {
                    this.setText((String)mutableProperties.getProperty("Name"));
                } else if (n2 == 1) {
                    this.setText((String)mutableProperties.getProperty("Value"));
                }
            }
            return this;
        }
    }

    class StringMouseListener
    extends MouseAdapter {
        StringMouseListener() {
        }

        void showContextMenu(MouseEvent mouseEvent) {
            int n = StringTableBuilder.this.m_table.rowAtPoint(mouseEvent.getPoint());
            int n2 = StringTableBuilder.this.m_table.columnAtPoint(mouseEvent.getPoint());
            if (n != -1 && n == StringTableBuilder.this.getSelectedRow() && n2 > -1) {
                JPopupMenu jPopupMenu = StringTableBuilder.this.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }
    }

    class StringActionListener
    implements ActionListener {
        StringActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringTableBuilder.this.stopEditing();
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                StringTableBuilder.this.getPDMLDocument().beginEdit();
                StringTableBuilder.this.doAdd();
                StringTableBuilder.this.getPDMLDocument().endEdit();
                StringTableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Remove")) {
                StringTableBuilder.this.getPDMLDocument().beginEdit();
                StringTableBuilder.this.doRemove();
                StringTableBuilder.this.getPDMLDocument().endEdit();
                StringTableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Find Next")) {
                StringTableBuilder.this.doFindNext();
                StringTableBuilder.this.getBuilder().updateBuilder();
            } else if (string.equals("Find Previous")) {
                StringTableBuilder.this.doFindPrevious();
                StringTableBuilder.this.getBuilder().updateBuilder();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    StringTableBuilder.this.cut();
                    StringTableBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Copy")) {
                    StringTableBuilder.this.copy();
                    StringTableBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Paste")) {
                    StringTableBuilder.this.paste();
                    StringTableBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Delete")) {
                    StringTableBuilder.this.delete();
                    StringTableBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.equals("Help")) {
                StringTableBuilder.this.displayHelp();
            }
        }
    }

    class StringSelectionListener
    implements ListSelectionListener {
        StringSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            StringTableBuilder.this.fireSelectionChangedEvent();
        }
    }

    class StringSortHandler
    extends MouseAdapter {
        StringSortHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            StringTableBuilder.this.stopEditing();
            if (StringTableBuilder.this.m_table.getTableHeader().getCursor().getType() != 0) {
                return;
            }
            int n = StringTableBuilder.this.m_table.getTableHeader().columnAtPoint(mouseEvent.getPoint());
            boolean bl = n == 0;
            boolean bl2 = true;
            if (bl && StringTableBuilder.this.m_sortedKeys > 0) {
                bl2 = false;
            } else if (!bl && StringTableBuilder.this.m_sortedValues > 0) {
                bl2 = false;
            }
            ((StringTableProperties)StringTableBuilder.this.getProperties()).sortEntries(bl, bl2);
            if (bl) {
                StringTableBuilder.this.m_sortedKeys = bl2 ? 1 : -1;
                StringTableBuilder.this.m_sortedValues = 0;
            } else {
                StringTableBuilder.this.m_sortedKeys = 0;
                StringTableBuilder.this.m_sortedValues = bl2 ? 1 : -1;
            }
        }
    }

    class StringTableModelListener
    implements TableModelListener {
        StringTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                StringTableBuilder.this.m_tableModel.removeTableModelListener(StringTableBuilder.this.m_modelListener);
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                String string = (String)StringTableBuilder.this.m_tableModel.getValueAt(n2, n);
                StringTableEntry stringTableEntry = StringTableBuilder.this.getEntryAtIndex(n2);
                String string2 = n == 0 ? "Name" : "Value";
                String string3 = (String)stringTableEntry.getProperty(string2);
                if (n == 0 && string.equals("")) {
                    String string4 = GUIFactory.getString("IDS_PROPERTY_VALUE_REQUIRED");
                    Object[] objectArray = new Object[]{string2};
                    string4 = MessageFormat.format(string4, objectArray);
                    JOptionPane.showMessageDialog(StringTableBuilder.this, string4, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                    StringTableBuilder.this.getBuilder().updateBuilder();
                } else if (!string.equals(string3)) {
                    StringTableBuilder.this.getPDMLDocument().beginEdit();
                    try {
                        stringTableEntry.setProperty(string2, string);
                        StringTableBuilder.this.getPDMLDocument().endEdit();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        StringTableBuilder.this.getPDMLDocument().abortEdit();
                        JOptionPane.showMessageDialog(StringTableBuilder.this, propertyVetoException.getMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                    }
                    StringTableBuilder.this.getBuilder().updateBuilder();
                }
                StringTableBuilder.this.m_tableModel.setValueAt(stringTableEntry, n2, n);
                StringTableBuilder.this.m_tableModel.addTableModelListener(StringTableBuilder.this.m_modelListener);
            }
        }
    }

    class StringTreeModelListener
    implements TreeModelListener {
        StringTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            StringTableBuilder.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(StringTableBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    StringTableBuilder.this.insertProperties(mutableProperties, nArray[n], true);
                    ++n;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath.getLastPathComponent().equals(StringTableBuilder.this.getProperties())) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                    StringTableBuilder.this.removeProperties(mutableProperties, nArray[n]);
                    ++n;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

