/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.PaneContainerBuilder;
import com.ibm.as400.ui.tools.PaneProperties;
import com.ibm.as400.ui.tools.WizardProperties;
import com.ibm.as400.ui.tools.WizardStepProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

class WizardBuilder
extends PaneContainerBuilder {
    WizardBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, WizardProperties wizardProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, wizardProperties);
        wizardProperties.addPDMLNodeListener(new WizardNodeListener());
    }

    void toggleStepsColumn() {
        if (this.getProperties().getProperty("Show Steps").equals(Boolean.TRUE)) {
            if (!this.m_stepsShowing) {
                this.m_table.addColumn(this.m_stepColumn);
                this.m_stepsShowing = true;
            }
        } else if (this.m_stepsShowing) {
            this.m_table.removeColumn(this.m_stepColumn);
            this.m_stepsShowing = false;
        }
        this.m_table.sizeColumnsToFit(-1);
    }

    void insertProperties(MutableProperties mutableProperties, int n, boolean bl) {
        if (mutableProperties.getType() == 66 && (n = this.getPaneIndex(mutableProperties)) > -1) {
            Object[] objectArray = new Object[]{mutableProperties, mutableProperties, mutableProperties};
            this.m_tableModel.insertRow(n, objectArray);
            if (bl) {
                this.m_table.setRowSelectionInterval(n, n);
                this.m_table.scrollRectToVisible(this.m_table.getCellRect(n, 0, true));
            }
        }
    }

    void removeProperties(MutableProperties mutableProperties, int n) {
        n = this.getViewIndex(mutableProperties);
        if (n > -1) {
            this.m_tableModel.removeRow(n);
        }
    }

    public void paste() {
        MutableProperties mutableProperties;
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties2 = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), null);
        mutableProperties2.setPDMLDocument(this.getPDMLDocument());
        if (mutableProperties2.getProperty("Resource").equals(this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
            mutableProperties = this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)mutableProperties2.getProperty("ID"));
            try {
                mutableProperties2.setProperty("File Target", this.getPDMLDocument().getPDMLRoot());
                if (mutableProperties != null) {
                    mutableProperties2.setProperty("Target", mutableProperties);
                } else {
                    mutableProperties2.setProperty("Target", "");
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if ((mutableProperties = this.getTableSelection()) == null) {
            this.getProperties().add(mutableProperties2);
        } else {
            this.getProperties().insert(mutableProperties2, this.getProperties().getIndex(mutableProperties) + 1);
        }
        ((WizardProperties)this.getProperties()).updateSteps();
        this.getPDMLDocument().endEdit();
    }

    void doAdd() {
        MutableProperties mutableProperties;
        String string = this.createNewStep();
        boolean bl = true;
        PaneProperties paneProperties = this.getBuilder().getFirstAvailablePane(this.getProperties(), bl);
        paneProperties.setPDMLDocument(this.getPDMLDocument());
        if (paneProperties.getProperty("Resource").equals(this.getPDMLDocument().getPDMLRoot().getResourceName(true, false))) {
            mutableProperties = this.getPDMLDocument().getPDMLRoot().getNodeNamed((String)paneProperties.getProperty("ID"));
            try {
                paneProperties.setProperty("File Target", this.getPDMLDocument().getPDMLRoot());
                if (mutableProperties != null) {
                    paneProperties.setProperty("Target", mutableProperties);
                } else {
                    paneProperties.setProperty("Target", "");
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        try {
            paneProperties.setProperty("Step", string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        mutableProperties = this.getTableSelection();
        if (mutableProperties == null) {
            this.getProperties().add(paneProperties);
        } else {
            this.getProperties().insert(paneProperties, this.getProperties().getIndex(mutableProperties) + 1);
        }
    }

    void doRemove() {
        super.doRemove();
        ((WizardProperties)this.getProperties()).updateSteps();
    }

    void doMoveUp() {
        super.doMoveUp();
        ((WizardProperties)this.getProperties()).updateSteps();
    }

    void doMoveDown() {
        super.doMoveDown();
        ((WizardProperties)this.getProperties()).updateSteps();
    }

    String createNewStep() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Enumeration<TreeNode> enumeration = this.getProperties().children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            if (mutableProperties.getType() == 66) {
                if (n == 0) {
                    n2 = n3;
                }
                ++n;
            }
            ++n3;
        }
        int n4 = this.getSelectedRow();
        if (n4 >= 0) {
            n = n4 + 1;
        }
        Object[] objectArray = new Object[]{new Integer(n + 1)};
        String string = MessageFormat.format(GUIFactory.getString("IDS_DEFAULT_LABEL_STEP"), objectArray);
        WizardStepProperties wizardStepProperties = new WizardStepProperties(this.getPDMLDocument());
        try {
            wizardStepProperties.setProperty("Step Value", string);
        }
        catch (PropertyVetoException propertyVetoException) {
            string = "";
        }
        this.getProperties().insert(wizardStepProperties, n2);
        return string;
    }

    PaneProperties getPaneAtIndex(int n) {
        int n2 = 0;
        Enumeration<TreeNode> enumeration = this.getProperties().children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            if (mutableProperties.getType() != 66) continue;
            if (n2 == n) {
                return (PaneProperties)mutableProperties;
            }
            ++n2;
        }
        return null;
    }

    int getPaneIndex(MutableProperties mutableProperties) {
        int n = 0;
        Enumeration<TreeNode> enumeration = this.getProperties().children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            if (mutableProperties2.equals(mutableProperties)) {
                return n;
            }
            if (mutableProperties2.getType() != 66) continue;
            ++n;
        }
        return -1;
    }

    int getViewIndex(MutableProperties mutableProperties) {
        if (mutableProperties.getType() == 66) {
            int n = this.m_tableModel.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.m_tableModel.getValueAt(n2, 0).equals(mutableProperties)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class WizardNodeListener
    implements PDMLNodeListener {
        WizardNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            WizardBuilder.this.toggleStepsColumn();
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }
}

