/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLErrorHandler;
import com.ibm.as400.ui.tools.RCInfo;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLPreprocessorDefinition {
    private Hashtable m_htUserTags = new Hashtable();
    private Hashtable m_htComments = new Hashtable();
    private Hashtable m_htMenuItemTypes = new Hashtable();
    private Vector m_vPanelDefTags = new Vector();
    private Vector m_vPanelDefComments = new Vector();
    private Vector m_vPanelNames = new Vector();
    private Vector m_vMenuNames = new Vector();
    private Vector m_vWizardNames = new Vector();
    private Vector m_vPropertySheetNames = new Vector();
    private Vector m_vDeckPaneNames = new Vector();
    private Vector m_vSplitPaneNames = new Vector();
    private Vector m_vTabbedPaneNames = new Vector();
    private Hashtable m_htButtonGroupDisabled = new Hashtable();

    public XMLPreprocessorDefinition(String string) throws IOException, ParseException, FileNotFoundException {
        Element element = this.parseXML(string);
        if (element == null) {
            return;
        }
        this.processDocument(element, null);
    }

    public Hashtable getUserTags() {
        return this.m_htUserTags;
    }

    public Hashtable getTagComments() {
        return this.m_htComments;
    }

    public Vector getPanelDefTags() {
        return this.m_vPanelDefTags;
    }

    public Vector getPanelDefComments() {
        return this.m_vPanelDefComments;
    }

    public Vector getPanelNames() {
        return this.m_vPanelNames;
    }

    public Vector getMenuNames() {
        return this.m_vMenuNames;
    }

    public Vector getWizardNames() {
        return this.m_vWizardNames;
    }

    public Vector getPropertySheetNames() {
        return this.m_vPropertySheetNames;
    }

    public Vector getDeckPaneNames() {
        return this.m_vDeckPaneNames;
    }

    public Vector getSplitPaneNames() {
        return this.m_vSplitPaneNames;
    }

    public Vector getTabbedPaneNames() {
        return this.m_vTabbedPaneNames;
    }

    public String getButtonGroupDisabled(String string) {
        return (String)this.m_htButtonGroupDisabled.get(string);
    }

    public String getMenuItemType(String string) {
        return (String)this.m_htMenuItemTypes.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element parseXML(String string) throws IOException, ParseException, FileNotFoundException {
        Object object;
        XMLErrorHandler xMLErrorHandler;
        Document document;
        block17: {
            BufferedInputStream bufferedInputStream;
            InputStream inputStream2;
            block18: {
                inputStream2 = null;
                bufferedInputStream = null;
                InputStream inputStream = null;
                document = null;
                xMLErrorHandler = new XMLErrorHandler(string, SystemResourceFinder.getHeaderLineCount());
                try {
                    try {
                        inputStream2 = SystemResourceFinder.getPDMLHeader();
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                        object = new DOMParser();
                        inputStream = new BufferedInputStream(new SequenceInputStream(inputStream2, bufferedInputStream));
                        object.parse(new InputSource(inputStream));
                        document = object.getDocument();
                    }
                    catch (SAXException sAXException) {
                        Exception exception = sAXException.getException();
                        if (exception == null) {
                            ParseException parseException = new ParseException(SystemResourceFinder.format((String)"failedToParse", (Object[])new Object[]{string}));
                            parseException.addMessage(sAXException.getMessage());
                            throw parseException;
                        }
                        if (exception != null) {
                            if (exception instanceof IOException) {
                                throw (IOException)exception;
                            }
                            if (exception instanceof ParseException) {
                                throw (ParseException)((Object)exception);
                            }
                            throw (RuntimeException)exception;
                        }
                        Object var11_10 = null;
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                        break block17;
                    }
                    Object var11_9 = null;
                    if (inputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        object = xMLErrorHandler.getException();
        if (object != null) {
            object.reportErrors();
            throw object;
        }
        return document.getDocumentElement();
    }

    private void processDocument(Element element, String string) {
        Object object;
        Object var3_3 = null;
        String string2 = null;
        if (element.getParentNode() != null && element.getParentNode().getNodeType() == 1) {
            string2 = ((Element)element.getParentNode()).getTagName();
        }
        if (string2 != null && string2.equalsIgnoreCase("PDML") && !element.getTagName().equalsIgnoreCase("PANEL") && !element.getTagName().equalsIgnoreCase("MENU")) {
            if (element.getTagName().equals("WIZARD")) {
                this.m_vWizardNames.addElement(element.getAttribute("name"));
            } else if (element.getTagName().equals("PROPERTYSHEET")) {
                this.m_vPropertySheetNames.addElement(element.getAttribute("name"));
            } else if (element.getTagName().equals("DECKPANE")) {
                this.m_vDeckPaneNames.addElement(element.getAttribute("name"));
            } else if (element.getTagName().equals("SPLITPANE")) {
                this.m_vSplitPaneNames.addElement(element.getAttribute("name"));
            } else if (element.getTagName().equals("TABBEDPANE")) {
                this.m_vTabbedPaneNames.addElement(element.getAttribute("name"));
            }
            this.m_vPanelDefTags.addElement(element);
            return;
        }
        String string3 = element.getAttribute("name");
        if (string3 != null && string3.equals("")) {
            string3 = null;
        }
        if (element.getTagName().equals("PANEL")) {
            this.m_vPanelNames.addElement(string3);
            string = string3;
        } else if (element.getTagName().equals("MENU")) {
            this.m_vMenuNames.addElement(string3);
            object = element.getAttribute("type");
            if (object != null && !((String)object).equals("") && !((String)object).equals("menu")) {
                this.m_htMenuItemTypes.put(string3, object);
            }
            string = string3;
        }
        if (string3 != null) {
            this.processComponent(element, string);
            if (!(element.getTagName().equalsIgnoreCase("PANEL") || element.getTagName().equalsIgnoreCase("BUTTONGROUP") || element.getTagName().equalsIgnoreCase("MENU") || element.getTagName().equalsIgnoreCase("MENUITEM"))) {
                return;
            }
        }
        object = element.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeType() == 8) {
                Comment comment = (Comment)node;
                if (string3 == null) {
                    Vector vector = this.m_vPanelDefComments;
                    vector.addElement(comment);
                }
            } else if (node.getNodeType() == 1) {
                this.processDocument((Element)node, string);
            }
            ++n;
        }
    }

    private String processComponent(Element element, String string) {
        String string2;
        String string3;
        Vector<Node> vector = new Vector<Node>();
        String string4 = string3 = element.getAttribute("name");
        if (!element.getTagName().equalsIgnoreCase("PANEL") && !element.getTagName().equalsIgnoreCase("MENU")) {
            string4 = string + "." + string3;
        }
        if (element.getTagName().equalsIgnoreCase("BUTTONGROUP")) {
            string2 = element.getAttribute("disabled");
            if (string2 != null && !string2.equals("")) {
                this.m_htButtonGroupDisabled.put(string4, string2);
            }
        } else if (element.getTagName().equalsIgnoreCase("MENUITEM") && (string2 = element.getAttribute("type")) != null && !string2.equals("")) {
            this.m_htMenuItemTypes.put(string4, string2);
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node;
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 8) {
                node = (Comment)node2;
                Vector<Node> vector2 = (Vector<Node>)this.m_htComments.get(string4);
                if (vector2 == null) {
                    vector2 = new Vector<Node>();
                }
                vector2.addElement(node);
                this.m_htComments.put(string4, vector2);
            } else if (node2.getNodeType() == 1) {
                node = (Element)node2;
                string2 = node.getTagName();
                if (!RCInfo.isSupported(string2)) {
                    vector.addElement(node);
                } else if (!string3.startsWith("IDCB_") && (node.getTagName().equalsIgnoreCase("DATACLASS") || node.getTagName().equalsIgnoreCase("ATTRIBUTE"))) {
                    vector.addElement(node);
                } else if (element.getTagName().equalsIgnoreCase("BUTTONGROUP") && !node.getTagName().equalsIgnoreCase("RADIOBUTTON") && !node.getTagName().equalsIgnoreCase("CHECKBOX")) {
                    vector.addElement(node);
                }
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.m_htUserTags.put(string4, vector);
        }
        return string3;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

