/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FTP;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;

public class AS400FTP
extends FTP
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_;
    private transient boolean connected_ = false;
    private transient boolean inConnect_ = false;
    private transient boolean inSaveFileProcessing_ = false;
    private String saveFilePublicAuthority_ = "*EXCLUDE";
    private String CDToRoot = "/";
    private static ResourceBundleLoader loader_;

    public AS400FTP() {
    }

    public AS400FTP(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream append(String string) throws IOException {
        OutputStream outputStream = null;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                outputStream = super.append(string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean append(String string, String string2) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string2);
            try {
                bl = super.append(string, string2);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean append(File file, String string) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                bl = super.append(file, string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    public boolean cd(String string) throws IOException {
        if (this.connect()) {
            return super.cd(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean connect() throws UnknownHostException, IOException, IllegalStateException {
        if (!this.connected_) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            try {
                this.system_.signon(false);
            }
            catch (AS400SecurityException aS400SecurityException) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Security exception in getVRM()", (Throwable)aS400SecurityException);
                }
                throw new IOException(aS400SecurityException.getMessage());
            }
            AS400ImplRemote aS400ImplRemote = (AS400ImplRemote)this.system_.getImpl();
            Socket socket = aS400ImplRemote.getConnection(super.getPort());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            super.externallyConnected(this.system_.getSystemName(), socket, bufferedReader, printWriter);
            this.connected_ = true;
            this.inConnect_ = true;
            try {
                if (!this.cd(this.CDToRoot) && Trace.isTraceOn()) {
                    Trace.log(1, "CD to root failed " + this.getLastMessage());
                }
            }
            finally {
                this.inConnect_ = false;
            }
            if (this.connected_) {
                super.fireEvent(0);
            }
        }
        return this.connected_;
    }

    public String[] dir() throws IOException {
        if (this.connect()) {
            return super.dir();
        }
        return new String[0];
    }

    public String[] dir(String string) throws IOException {
        if (this.connect()) {
            return super.dir(string);
        }
        return new String[0];
    }

    public InputStream get(String string) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(string);
        }
        return null;
    }

    public boolean get(String string, String string2) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(string, string2);
        }
        return false;
    }

    public boolean get(String string, File file) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(string, file);
        }
        return false;
    }

    public String getCurrentDirectory() throws IOException {
        if (this.connect()) {
            return super.getCurrentDirectory();
        }
        return null;
    }

    public String getSaveFilePublicAuthority() {
        return this.saveFilePublicAuthority_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public synchronized String issueCommand(String string) throws IOException {
        boolean bl = true;
        if (!this.inConnect_) {
            bl = this.connect();
        }
        if (bl) {
            return super.issueCommand(string);
        }
        return null;
    }

    public String[] ls() throws IOException {
        if (this.connect()) {
            return super.ls();
        }
        return new String[0];
    }

    public String[] ls(String string) throws IOException {
        if (this.connect()) {
            return super.ls(string);
        }
        return new String[0];
    }

    public boolean noop() throws IOException {
        boolean bl = true;
        if (!this.inConnect_) {
            bl = this.connect();
        }
        if (bl) {
            return super.noop();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream put(String string) throws IOException {
        OutputStream outputStream = null;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                outputStream = super.put(string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(String string, String string2) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string2);
            try {
                bl = super.put(string, string2);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(File file, String string) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                bl = super.put(file, string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    public synchronized String pwd() throws IOException {
        if (this.connect()) {
            return super.pwd();
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.connected_ = false;
        this.inConnect_ = false;
        this.inSaveFileProcessing_ = false;
    }

    private void saveFileProcessing(String string) throws IOException {
        block25: {
            if (!this.inSaveFileProcessing_) {
                this.inSaveFileProcessing_ = true;
                string = string.toUpperCase();
                if ((string = string.trim()).endsWith(".SAVF")) {
                    Object object;
                    if (!string.startsWith("/")) {
                        object = this.pwd();
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "pwd: " + (String)object);
                        }
                        if (object == null) {
                            return;
                        }
                        if (((String)object).startsWith("257")) {
                            int n;
                            int n2 = ((String)object).indexOf("\"");
                            if (n2 < 0) {
                                return;
                            }
                            if ((n = ((String)object).indexOf("\"", ++n2)) < n2) {
                                return;
                            }
                            object = ((String)object).substring(n2, n);
                            if (Trace.isTraceOn()) {
                                Trace.log(1, n2 + " " + n + " " + (String)object);
                            }
                        } else {
                            return;
                        }
                        string = ((String)object).endsWith("/") ? (String)object + string : (String)object + "/" + string;
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "target: " + string);
                    }
                    try {
                        object = new QSYSObjectPathName(string);
                        CommandCall commandCall = new CommandCall(this.system_);
                        String string2 = "CRTSAVF  FILE(" + ((QSYSObjectPathName)object).getLibraryName() + "/" + ((QSYSObjectPathName)object).getObjectName() + ")" + " AUT(" + this.saveFilePublicAuthority_ + ")";
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "command string " + string2);
                        }
                        try {
                            commandCall.setCommand(string2);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        if (!CommandCall.isThreadSafetyPropertySet()) {
                            commandCall.setThreadSafe(false);
                        }
                        try {
                            boolean bl = commandCall.run();
                            AS400Message[] aS400MessageArray = commandCall.getMessageList();
                            String string3 = aS400MessageArray[0].getText();
                            if (Trace.isTraceOn()) {
                                Trace.log(1, "message[0]: " + string3);
                            }
                            if (!bl && aS400MessageArray[0].getID().startsWith("CPF5813")) {
                                bl = true;
                            }
                            if (!bl) {
                                String string4 = " ";
                                string4 = ResourceBundleLoader.getText("CREATE_SAVE_FILE_FAILED");
                                throw new IOException(string4 + string3);
                            }
                        }
                        catch (Exception exception) {
                            if (Trace.isTraceOn()) {
                                Trace.log(1, "IO Exception running command call ", (Throwable)exception);
                            }
                            throw new IOException(exception.getMessage());
                        }
                        this.setDataTransferType(1);
                    }
                    catch (IllegalPathNameException illegalPathNameException) {
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "the put ends up in ifs");
                        }
                        break block25;
                    }
                }
                if (Trace.isTraceOn()) {
                    Trace.log(1, "the put is not for a save file ");
                }
            }
        }
    }

    public synchronized boolean setCurrentDirectory(String string) throws IOException {
        if (this.connect()) {
            return super.setCurrentDirectory(string);
        }
        return false;
    }

    public void setDataTransferType(int n) throws IOException {
        if (this.connect()) {
            super.setDataTransferType(n);
        }
    }

    public void setPassword(String string) {
        if (!this.inConnect_) {
            throw new IllegalStateException("password");
        }
        super.setPassword(string);
    }

    public void setSaveFilePublicAuthority(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("saveFilePublicAuthority");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("saveFilePublicAuthority");
        }
        String string2 = this.saveFilePublicAuthority_;
        this.vetos_.fireVetoableChange("saveFilePublicAuthority", string2, string);
        this.saveFilePublicAuthority_ = string;
        this.changes_.firePropertyChange("saveFilePublicAuthority", string2, string);
    }

    public void setServer(String string) throws PropertyVetoException {
        if (!this.inConnect_) {
            throw new IllegalStateException("server");
        }
        super.setServer(string);
    }

    public synchronized void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        this.vetos_.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        this.changes_.firePropertyChange("system", aS4002, aS400);
    }

    public void setUser(String string) throws PropertyVetoException {
        if (!this.inConnect_) {
            throw new IllegalStateException("user");
        }
        super.setUser(string);
    }
}

