/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImplBase;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.BytesWithOffset;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.DDMS38OpenFeedback;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.LocalIOFB;
import com.ibm.as400.access.LocalOpenFeedback;
import com.ibm.as400.access.MessageFBDataFormat;
import com.ibm.as400.access.MessageFBFormat;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Vector;

class AS400FileImplNative
extends AS400FileImplBase {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400FileImplNative";
    transient int handle_;
    static String synch_execute_;
    static String synch_open_close_;

    public AS400FileImplNative() {
        this.isNative_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        super.close();
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[12];
        boolean bl = this.system_.swapTo(byArray, byArray2);
        try {
            String string = synch_open_close_;
            synchronized (string) {
                this.closeNtv(this.handle_);
            }
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray, byArray2);
            }
        }
    }

    native void closeNtv(int var1) throws NativeException;

    public void commit() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[12];
        boolean bl = this.system_.swapTo(byArray, byArray2);
        try {
            this.commitNtv();
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray, byArray2);
            }
        }
    }

    native void commitNtv() throws NativeException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void createDDSSourceFile(RecordFormat recordFormat, String string, String string2, String string3, String string4, boolean bl, String string5, String string6) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n;
        String string7;
        AS400Message[] aS400MessageArray = this.execute("QSYS/CRTSRCPF FILE(QTEMP/JT400DSSRC) MBR(*FILE) TEXT('JT400 TEMPORARY DDS SOURCE FILE')");
        if (aS400MessageArray.length <= 0) throw new InternalErrorException("No messages from server.", 6);
        if (aS400MessageArray[0].getID().equals("CPF5813")) {
            aS400MessageArray = this.execute("QSYS/CLRPFM QTEMP/JT400DSSRC");
            if (aS400MessageArray.length <= 0) throw new InternalErrorException("QSYS/CLRPFM QTEMP/JT400DSSRC", 6);
            if (!aS400MessageArray[0].getID().equals("CPC3101")) {
                Trace.log(2, "QSYS/CLRPFM QTEMP/JT400DSSRC");
                throw new AS400Exception(aS400MessageArray);
            }
        } else if (!aS400MessageArray[0].getID().equals("CPC7301")) {
            Trace.log(2, "QSYS/CRTSRCPF FILE(QTEMP/JT400DSSRC) MBR(*FILE) TEXT('JT400 TEMPORARY DDS SOURCE FILE')");
            throw new AS400Exception(aS400MessageArray);
        }
        RecordFormat recordFormat2 = new RecordFormat("JT400DSSRC");
        recordFormat2.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 2), "SRCSEQ"));
        recordFormat2.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 0), "SRCDAT"));
        recordFormat2.addFieldDescription(new CharacterFieldDescription(new AS400Text(80, this.system_.getCcsid()), "SRCDTA"));
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            string7 = "                                            ALTSEQ(" + string + ")";
            vector.addElement(string7);
        }
        if (string2 != null) {
            string7 = "                                            CCSID(" + string2 + ")";
            vector.addElement(string7);
        }
        if (string3 != null) {
            string7 = "                                            " + string3;
            vector.addElement(string7);
        }
        if (string4 != null) {
            string7 = "                                            REF(" + string4 + ")";
            vector.addElement(string7);
        }
        if (bl) {
            string7 = "                                            UNIQUE";
            vector.addElement(string7);
        }
        string7 = "                R ";
        if (recordFormat.getName().length() > 10) {
            if (Trace.isTraceOn() && Trace.isTraceWarningOn()) {
                Trace.log(4, "Record format name '" + recordFormat.getName() + "' too long. Using '" + recordFormat.getName().substring(0, 10) + "' instead.");
            }
            string7 = string7 + recordFormat.getName().substring(0, 10);
        } else {
            string7 = string7 + recordFormat.getName();
        }
        vector.addElement(string7);
        if (string5 != null) {
            string7 = "                                            FORMAT(" + string5 + ")";
            vector.addElement(string7);
        }
        if (string6 != null) {
            if (string6.length() > 32) {
                string7 = "                                            TEXT('" + string6.substring(0, 33) + "-";
                vector.addElement(string7);
                string7 = "                                            " + string6.substring(34) + "')";
                vector.addElement(string7);
            } else {
                string7 = "                                            TEXT('" + string6 + "')";
                vector.addElement(string7);
            }
        }
        int n2 = recordFormat.getNumberOfFields();
        FieldDescription fieldDescription = null;
        String[] stringArray = null;
        for (n = 0; n < n2; ++n) {
            fieldDescription = recordFormat.getFieldDescription(n);
            stringArray = fieldDescription.getDDSDescription();
            String string8 = "                  " + stringArray[0];
            vector.addElement(string8);
            for (int i = 1; i < stringArray.length; ++i) {
                string8 = "                                            " + stringArray[i];
                int n3 = string8.length();
                int n4 = 0;
                if (n3 > 80) {
                    string7 = string8.substring(n4, 79) + "-";
                    vector.addElement(string7);
                    n3 -= 79;
                    n4 = 79;
                    string7 = "                                            " + string8.substring(n4);
                    vector.addElement(string7);
                    continue;
                }
                vector.addElement(string8);
            }
        }
        n2 = recordFormat.getNumberOfKeyFields();
        for (n = 0; n < n2; ++n) {
            fieldDescription = recordFormat.getKeyFieldDescription(n);
            string7 = "                K ";
            string7 = string7 + fieldDescription.getDDSName();
            vector.addElement(string7);
            String[] stringArray2 = fieldDescription.getKeyFieldFunctions();
            if (stringArray2 == null) continue;
            for (int n5 = 0; n5 < stringArray2.length; n5 = (int)((short)(n5 + 1))) {
                string7 = "                                            " + stringArray2[n5];
                vector.addElement(string7);
            }
        }
        Record[] recordArray = new Record[vector.size()];
        for (int i = 0; i < recordArray.length; ++i) {
            recordArray[i] = recordFormat2.getNewRecord();
            recordArray[i].setField("SRCSEQ", (Object)new BigDecimal((double)i));
            recordArray[i].setField("SRCDAT", (Object)new BigDecimal((double)i));
            recordArray[i].setField("SRCDTA", vector.elementAt(i));
        }
        AS400FileImplNative aS400FileImplNative = null;
        try {
            aS400FileImplNative = new AS400FileImplNative();
            aS400FileImplNative.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT400DSSRC.FILE", recordFormat2, false, false, false);
            aS400FileImplNative.openFile2(2, recordArray.length, 3, false);
            aS400FileImplNative.write(recordArray);
            aS400FileImplNative.close();
            return;
        }
        catch (Exception exception) {
            Trace.log(2, "Unable to write records to DDS source file:" + exception);
            try {
                if (aS400FileImplNative != null) {
                    aS400FileImplNative.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (!(exception instanceof AS400Exception)) throw new InternalErrorException(exception.getMessage(), 6);
            throw (AS400Exception)exception;
        }
    }

    public void deleteCurrentRecord() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        byte[] byArray = new byte[]{0, 2, 0, 8};
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl = this.system_.swapTo(byArray2, byArray3);
        try {
            this.deleteCurrentRecordNtv(this.handle_, byArray);
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
    }

    native void deleteCurrentRecordNtv(int var1, byte[] var2) throws NativeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400Message[] execute(String string) throws AS400SecurityException, InterruptedException, IOException {
        AS400Message[] aS400MessageArray;
        if (this.converter_ == null) {
            this.setConverter();
        }
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[12];
        boolean bl = this.system_.swapTo(byArray, byArray2);
        try {
            aS400MessageArray = synch_execute_;
            synchronized (synch_execute_) {
                bytesWithOffset = new BytesWithOffset(this.executeNtv(this.converter_.stringToByteArray(string)));
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray, byArray2);
            }
        }
        {
            aS400MessageArray = this.parseMsgFeedback(bytesWithOffset.data_);
            return aS400MessageArray;
        }
    }

    native byte[] executeNtv(byte[] var1);

    public void finalization() throws Throwable {
    }

    native void forceEndOfData(int var1, byte[] var2) throws NativeException;

    native byte[] getForPosition(int var1, byte[] var2, byte[] var3, int var4) throws NativeException;

    native byte[] getForRead(int var1, byte[] var2, byte[] var3, int var4) throws NativeException;

    native byte[] getdForPosition(int var1, byte[] var2, byte[] var3, int var4) throws NativeException;

    native byte[] getdForRead(int var1, byte[] var2, byte[] var3, int var4) throws NativeException;

    native byte[] getkForPosition(int var1, byte[] var2, byte[] var3, int var4) throws NativeException;

    native byte[] getkForRead(int var1, byte[] var2, byte[] var3, int var4) throws NativeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDMS38OpenFeedback openFile(int n, int n2, String string) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        AS400Message[] aS400MessageArray;
        byte[] byArray = this.createUFCB(n, n2, string, true);
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl = this.system_.swapTo(byArray2, byArray3);
        try {
            aS400MessageArray = synch_open_close_;
            synchronized (synch_open_close_) {
                bytesWithOffset = new BytesWithOffset(this.openFileNtv(byArray));
                // ** MonitorExit[var9_9] (shouldn't be in output)
            }
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
        {
            aS400MessageArray = this.parseMsgFeedback(bytesWithOffset);
            this.handle_ = BinaryConverter.byteArrayToInt(bytesWithOffset.data_, bytesWithOffset.offset_);
            bytesWithOffset.offset_ += 4;
            if (this.handle_ <= 0) {
                throw new InternalErrorException("Invalid handle returned from QYSTRART", 6);
            }
            if (aS400MessageArray.length > 0 && Trace.isTraceOn() && Trace.isTraceWarningOn()) {
                Trace.log(4, "AS400FileImplNative.openFile:");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    Trace.log(4, aS400MessageArray[i].toString());
                }
            }
            this.openFeedback_ = new LocalOpenFeedback(this.system_, bytesWithOffset.data_, bytesWithOffset.offset_);
            return this.openFeedback_;
        }
    }

    native byte[] openFileNtv(byte[] var1) throws NativeException;

    private Record[] parseRecordData(LocalIOFB localIOFB, BytesWithOffset bytesWithOffset) throws UnsupportedEncodingException {
        int n = localIOFB.getNumberOfRecordsReturned();
        Record[] recordArray = new Record[n];
        int n2 = this.openFeedback_.getNullFieldByteMapOffset();
        int n3 = this.recordFormat_.getNumberOfFields();
        boolean bl = this.openFeedback_.isNullCapable();
        int n4 = 0;
        while (n4 < n) {
            recordArray[n4] = this.recordFormat_.getNewRecord(bytesWithOffset.data_, bytesWithOffset.offset_);
            if (bl) {
                for (int i = 0; i < n3; ++i) {
                    if (bytesWithOffset.data_[n2 + i + bytesWithOffset.offset_] != -15) continue;
                    recordArray[n4].setField(i, null);
                }
            }
            try {
                recordArray[n4].setRecordNumber(BinaryConverter.byteArrayToInt(bytesWithOffset.data_, bytesWithOffset.offset_ + localIOFB.getRecordLength() + 2));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++n4;
            bytesWithOffset.offset_ += this.openFeedback_.getRecordIncrement();
        }
        return recordArray;
    }

    private AS400Message[] parseMsgFeedback(byte[] byArray) throws IOException {
        AS400Message[] aS400MessageArray = new AS400Message[]{};
        Record record = new MessageFBFormat().getNewRecord(byArray);
        Short s = (Short)record.getField("messagesOccurred");
        if (s.intValue() == 1) {
            int n = ((Short)record.getField("numberOfMessages")).intValue();
            if (n == 0) {
                return aS400MessageArray;
            }
            aS400MessageArray = new AS400Message[n];
            MessageFBDataFormat messageFBDataFormat = new MessageFBDataFormat(this.system_.getCcsid());
            Object[] objectArray = (Object[])record.getField("feedbackData");
            for (int i = 0; i < n; ++i) {
                Record record2 = messageFBDataFormat.getNewRecord((byte[])objectArray[i]);
                int n2 = (Integer)record2.getField("severityCode");
                String string = (String)record2.getField("messageType");
                char[] cArray = string.toCharArray();
                int n3 = (cArray[0] & 0xF) * 10 + (cArray[1] & 0xF);
                String string2 = (String)record2.getField("messageID");
                int n4 = (Integer)record2.getField("messageTextLength");
                int n5 = (Integer)record2.getField("replacementTextLength");
                byte[] byArray2 = (byte[])objectArray[i];
                String string3 = new CharConverter(this.system_.getCcsid()).byteArrayToString(byArray2, 112 + n5, n4);
                aS400MessageArray[i] = new AS400Message(string2, string3);
                aS400MessageArray[i].setSeverity(n2);
                aS400MessageArray[i].setType(n3);
            }
        }
        return aS400MessageArray;
    }

    private AS400Message[] parseMsgFeedback(BytesWithOffset bytesWithOffset) throws IOException {
        AS400Message[] aS400MessageArray = new AS400Message[]{};
        Record record = new MessageFBFormat().getNewRecord(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += record.getRecordLength();
        Short s = (Short)record.getField("messagesOccurred");
        if (s.intValue() == 1) {
            int n = ((Short)record.getField("numberOfMessages")).intValue();
            if (n == 0) {
                return aS400MessageArray;
            }
            aS400MessageArray = new AS400Message[n];
            MessageFBDataFormat messageFBDataFormat = new MessageFBDataFormat(this.system_.getCcsid());
            Object[] objectArray = (Object[])record.getField("feedbackData");
            for (int i = 0; i < n; ++i) {
                Record record2 = messageFBDataFormat.getNewRecord((byte[])objectArray[i]);
                int n2 = (Integer)record2.getField("severityCode");
                String string = (String)record2.getField("messageType");
                char[] cArray = string.toCharArray();
                int n3 = (cArray[0] & 0xF) * 10 + (cArray[1] & 0xF);
                String string2 = (String)record2.getField("messageID");
                int n4 = (Integer)record2.getField("messageTextLength");
                int n5 = (Integer)record2.getField("replacementTextLength");
                byte[] byArray = (byte[])objectArray[i];
                String string3 = new CharConverter(this.system_.getCcsid()).byteArrayToString(byArray, 112 + n5, n4);
                aS400MessageArray[i] = new AS400Message(string2, string3);
                aS400MessageArray[i].setSeverity(n2);
                aS400MessageArray[i].setType(n3);
            }
        }
        return aS400MessageArray;
    }

    public void positionCursorAfterLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsLastRecord()) {
            this.cache_.setPositionAfterLast();
            return;
        }
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        byte[] byArray = new byte[]{2, 2, 1, 1};
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl = this.system_.swapTo(byArray2, byArray3);
        try {
            this.forceEndOfData(this.handle_, byArray);
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
    }

    public Record[] positionCursorAt(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray = new byte[]{(byte)n, by, 0, 1};
        byte[] byArray2 = new byte[6];
        byArray2[0] = 16;
        BinaryConverter.shortToByteArray((short)2, byArray2, 1);
        BinaryConverter.shortToByteArray((short)this.blockingFactor_, byArray2, 3);
        byArray2[5] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[12];
        boolean bl = this.system_.swapTo(byArray3, byArray4);
        try {
            bytesWithOffset = new BytesWithOffset(this.getForPosition(this.handle_, byArray, byArray2, this.blockingFactor_ * this.openFeedback_.getRecordIncrement()));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray3, byArray4);
            }
        }
        LocalIOFB localIOFB = new LocalIOFB(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += 14;
        Record[] recordArray = this.parseRecordData(localIOFB, bytesWithOffset);
        return recordArray;
    }

    public void positionCursorBeforeFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsFirstRecord()) {
            this.cache_.setPositionBeforeFirst();
            return;
        }
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        byte[] byArray = new byte[]{1, 2, 1, 1};
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl = this.system_.swapTo(byArray2, byArray3);
        try {
            this.forceEndOfData(this.handle_, byArray);
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
    }

    public Record positionCursorToIndex(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && !this.cache_.setPosition(n)) {
            this.cache_.setIsEmpty();
        }
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray = new byte[]{8, by, 0, 2};
        byte[] byArray2 = new byte[26];
        byArray2[0] = 1;
        BinaryConverter.shortToByteArray((short)35, byArray2, 1);
        System.arraycopy(this.recordFormatCTLLName_, 0, byArray2, 3, this.recordFormatCTLLName_.length);
        byArray2[13] = 15;
        BinaryConverter.shortToByteArray((short)2, byArray2, 14);
        BinaryConverter.shortToByteArray((short)0, byArray2, 16);
        byArray2[18] = 2;
        BinaryConverter.shortToByteArray((short)4, byArray2, 19);
        BinaryConverter.intToByteArray(n, byArray2, 21);
        byArray2[25] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[12];
        boolean bl = this.system_.swapTo(byArray3, byArray4);
        try {
            bytesWithOffset = new BytesWithOffset(this.getdForPosition(this.handle_, byArray, byArray2, this.openFeedback_.getRecordIncrement() * this.blockingFactor_));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray3, byArray4);
            }
        }
        LocalIOFB localIOFB = new LocalIOFB(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += 14;
        Record[] recordArray = this.parseRecordData(localIOFB, bytesWithOffset);
        return recordArray.length == 0 ? null : recordArray[0];
    }

    public Record positionCursorToKey(Object[] objectArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2;
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray = new byte[]{(byte)n, by, 0, 3};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[2];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            try {
                byte[] byArray3;
                FieldDescription fieldDescription = this.recordFormat_.getKeyFieldDescription(n2);
                if (fieldDescription instanceof VariableLengthFieldDescription) {
                    boolean bl = ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength();
                    if (fieldDescription instanceof HexFieldDescription) {
                        if (bl) {
                            BinaryConverter.shortToByteArray((short)((byte[])objectArray[n2]).length, byArray2, 0);
                            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                        }
                        byteArrayOutputStream.write((byte[])objectArray[n2], 0, ((byte[])objectArray[n2]).length);
                        if (!bl) continue;
                        int n3 = fieldDescription.getDataType().getByteLength();
                        for (int i = ((byte[])objectArray[n2]).length; i < n3; ++i) {
                            byteArrayOutputStream.write(0);
                        }
                        continue;
                    }
                    if (bl) {
                        BinaryConverter.shortToByteArray((short)((String)objectArray[n2]).length(), byArray2, 0);
                        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                    }
                    byArray3 = fieldDescription.getDataType().toBytes(objectArray[n2]);
                    byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                    continue;
                }
                byArray3 = fieldDescription.getDataType().toBytes(objectArray[n2]);
                byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new ExtendedIllegalArgumentException("key", 2);
            }
        }
        n2 = byteArrayOutputStream.size();
        byte[] byArray4 = new byte[29 + n2];
        byArray4[0] = 1;
        BinaryConverter.shortToByteArray((short)35, byArray4, 1);
        System.arraycopy(this.recordFormatCTLLName_, 0, byArray4, 3, this.recordFormatCTLLName_.length);
        byArray4[13] = 15;
        BinaryConverter.shortToByteArray((short)2, byArray4, 14);
        BinaryConverter.shortToByteArray((short)0, byArray4, 16);
        byArray4[18] = 8;
        BinaryConverter.shortToByteArray((short)4, byArray4, 19);
        BinaryConverter.intToByteArray(objectArray.length, byArray4, 21);
        byArray4[25] = 7;
        BinaryConverter.shortToByteArray((short)n2, byArray4, 26);
        System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray4, 28, n2);
        byArray4[28 + n2] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray5 = new byte[12];
        byte[] byArray6 = new byte[12];
        boolean bl = this.system_.swapTo(byArray5, byArray6);
        try {
            bytesWithOffset = new BytesWithOffset(this.getkForPosition(this.handle_, byArray, byArray4, this.openFeedback_.getRecordIncrement() * this.blockingFactor_));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray5, byArray6);
            }
        }
        return null;
    }

    public Record positionCursorToKey(byte[] byArray, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray2 = new byte[]{(byte)n, by, 0, 3};
        int n3 = byArray.length;
        byte[] byArray3 = new byte[29 + n3];
        byArray3[0] = 1;
        BinaryConverter.shortToByteArray((short)35, byArray3, 1);
        System.arraycopy(this.recordFormatCTLLName_, 0, byArray3, 3, this.recordFormatCTLLName_.length);
        byArray3[13] = 15;
        BinaryConverter.shortToByteArray((short)2, byArray3, 14);
        BinaryConverter.shortToByteArray((short)0, byArray3, 16);
        byArray3[18] = 8;
        BinaryConverter.shortToByteArray((short)4, byArray3, 19);
        BinaryConverter.intToByteArray(n2, byArray3, 21);
        byArray3[25] = 7;
        BinaryConverter.shortToByteArray((short)n3, byArray3, 26);
        System.arraycopy(byArray, 0, byArray3, 28, n3);
        byArray3[28 + n3] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray4 = new byte[12];
        byte[] byArray5 = new byte[12];
        boolean bl = this.system_.swapTo(byArray4, byArray5);
        try {
            bytesWithOffset = new BytesWithOffset(this.getkForPosition(this.handle_, byArray2, byArray3, this.openFeedback_.getRecordIncrement() * this.blockingFactor_));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray4, byArray5);
            }
        }
        return null;
    }

    native void put(int var1, byte[] var2, byte[] var3, byte[] var4) throws NativeException;

    public Record read(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            return super.read(n);
        }
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray = new byte[]{8, by, 0, 2};
        byte[] byArray2 = new byte[26];
        byArray2[0] = 1;
        BinaryConverter.shortToByteArray((short)35, byArray2, 1);
        System.arraycopy(this.recordFormatCTLLName_, 0, byArray2, 3, this.recordFormatCTLLName_.length);
        byArray2[13] = 15;
        BinaryConverter.shortToByteArray((short)2, byArray2, 14);
        BinaryConverter.shortToByteArray((short)0, byArray2, 16);
        byArray2[18] = 2;
        BinaryConverter.shortToByteArray((short)4, byArray2, 19);
        BinaryConverter.intToByteArray(n, byArray2, 21);
        byArray2[25] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[12];
        boolean bl = this.system_.swapTo(byArray3, byArray4);
        try {
            bytesWithOffset = new BytesWithOffset(this.getdForRead(this.handle_, byArray, byArray2, this.openFeedback_.getRecordIncrement() * this.blockingFactor_));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray3, byArray4);
            }
        }
        LocalIOFB localIOFB = new LocalIOFB(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += 14;
        Record[] recordArray = this.parseRecordData(localIOFB, bytesWithOffset);
        return recordArray.length == 0 ? null : recordArray[0];
    }

    public Record read(Object[] objectArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2;
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray = new byte[]{(byte)n, by, 0, 3};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[2];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            try {
                byte[] byArray3;
                FieldDescription fieldDescription = this.recordFormat_.getKeyFieldDescription(n2);
                if (fieldDescription instanceof VariableLengthFieldDescription) {
                    boolean bl = ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength();
                    if (fieldDescription instanceof HexFieldDescription) {
                        if (bl) {
                            BinaryConverter.shortToByteArray((short)((byte[])objectArray[n2]).length, byArray2, 0);
                            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                        }
                        byteArrayOutputStream.write((byte[])objectArray[n2], 0, ((byte[])objectArray[n2]).length);
                        if (!bl) continue;
                        int n3 = fieldDescription.getDataType().getByteLength();
                        for (int i = ((byte[])objectArray[n2]).length; i < n3; ++i) {
                            byteArrayOutputStream.write(0);
                        }
                        continue;
                    }
                    if (bl) {
                        BinaryConverter.shortToByteArray((short)((String)objectArray[n2]).length(), byArray2, 0);
                        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                    }
                    byArray3 = fieldDescription.getDataType().toBytes(objectArray[n2]);
                    byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                    continue;
                }
                byArray3 = fieldDescription.getDataType().toBytes(objectArray[n2]);
                byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new ExtendedIllegalArgumentException("key", 2);
            }
        }
        n2 = byteArrayOutputStream.size();
        byte[] byArray4 = new byte[29 + n2];
        byArray4[0] = 1;
        BinaryConverter.shortToByteArray((short)35, byArray4, 1);
        System.arraycopy(this.recordFormatCTLLName_, 0, byArray4, 3, this.recordFormatCTLLName_.length);
        byArray4[13] = 15;
        BinaryConverter.shortToByteArray((short)2, byArray4, 14);
        BinaryConverter.shortToByteArray((short)0, byArray4, 16);
        byArray4[18] = 8;
        BinaryConverter.shortToByteArray((short)4, byArray4, 19);
        BinaryConverter.intToByteArray(objectArray.length, byArray4, 21);
        byArray4[25] = 7;
        BinaryConverter.shortToByteArray((short)n2, byArray4, 26);
        System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray4, 28, n2);
        byArray4[28 + n2] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray5 = new byte[12];
        byte[] byArray6 = new byte[12];
        boolean bl = this.system_.swapTo(byArray5, byArray6);
        try {
            bytesWithOffset = new BytesWithOffset(this.getkForRead(this.handle_, byArray, byArray4, this.openFeedback_.getRecordIncrement() * this.blockingFactor_));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray5, byArray6);
            }
        }
        LocalIOFB localIOFB = new LocalIOFB(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += 14;
        Record[] recordArray = this.parseRecordData(localIOFB, bytesWithOffset);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return recordArray.length == 0 ? null : recordArray[0];
    }

    public Record read(byte[] byArray, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray2 = new byte[]{(byte)n, by, 0, 3};
        int n3 = byArray.length;
        byte[] byArray3 = new byte[29 + n3];
        byArray3[0] = 1;
        BinaryConverter.shortToByteArray((short)35, byArray3, 1);
        System.arraycopy(this.recordFormatCTLLName_, 0, byArray3, 3, this.recordFormatCTLLName_.length);
        byArray3[13] = 15;
        BinaryConverter.shortToByteArray((short)2, byArray3, 14);
        BinaryConverter.shortToByteArray((short)0, byArray3, 16);
        byArray3[18] = 8;
        BinaryConverter.shortToByteArray((short)4, byArray3, 19);
        BinaryConverter.intToByteArray(n2, byArray3, 21);
        byArray3[25] = 7;
        BinaryConverter.shortToByteArray((short)n3, byArray3, 26);
        System.arraycopy(byArray, 0, byArray3, 28, n3);
        byArray3[28 + n3] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray4 = new byte[12];
        byte[] byArray5 = new byte[12];
        boolean bl = this.system_.swapTo(byArray4, byArray5);
        try {
            bytesWithOffset = new BytesWithOffset(this.getkForRead(this.handle_, byArray2, byArray3, this.openFeedback_.getRecordIncrement() * this.blockingFactor_));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray4, byArray5);
            }
        }
        LocalIOFB localIOFB = new LocalIOFB(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += 14;
        Record[] recordArray = this.parseRecordData(localIOFB, bytesWithOffset);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return recordArray.length == 0 ? null : recordArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record[] readAll(String string, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.openFile2(0, n, 3, string);
        Record[] recordArray = null;
        try {
            recordArray = new Record[this.openFeedback_.getNumberOfRecords()];
            for (int i = 0; i < recordArray.length; ++i) {
                recordArray[i] = this.readNext();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.close();
            }
            catch (AS400Exception aS400Exception) {
                this.resetState();
                throw aS400Exception;
            }
            catch (AS400SecurityException aS400SecurityException) {
                this.resetState();
                throw aS400SecurityException;
            }
            catch (InterruptedException interruptedException) {
                this.resetState();
                throw interruptedException;
            }
            catch (IOException iOException) {
                this.resetState();
                throw iOException;
            }
            throw throwable;
        }
        try {
            this.close();
        }
        catch (AS400Exception aS400Exception) {
            this.resetState();
            throw aS400Exception;
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.resetState();
            throw aS400SecurityException;
        }
        catch (InterruptedException interruptedException) {
            this.resetState();
            throw interruptedException;
        }
        catch (IOException iOException) {
            this.resetState();
            throw iOException;
        }
        return recordArray;
    }

    public Record readRecord(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        byte by = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? (byte)0 : 3;
        byte[] byArray = new byte[]{(byte)n, by, 0, 1};
        byte[] byArray2 = new byte[6];
        byArray2[0] = 16;
        BinaryConverter.shortToByteArray((short)2, byArray2, 1);
        BinaryConverter.shortToByteArray((short)this.blockingFactor_, byArray2, 3);
        byArray2[5] = -1;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[12];
        boolean bl = this.system_.swapTo(byArray3, byArray4);
        try {
            bytesWithOffset = new BytesWithOffset(this.getForRead(this.handle_, byArray, byArray2, this.openFeedback_.getRecordIncrement() * this.blockingFactor_));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray3, byArray4);
            }
        }
        LocalIOFB localIOFB = new LocalIOFB(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += 14;
        Record[] recordArray = this.parseRecordData(localIOFB, bytesWithOffset);
        return recordArray.length == 0 ? null : recordArray[0];
    }

    public Record[] readRecords(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        byte by = n == 0 ? (byte)3 : 4;
        byte[] byArray = new byte[]{by, 0, 0, 1};
        byte[] byArray2 = new byte[6];
        byArray2[0] = 16;
        BinaryConverter.shortToByteArray((short)2, byArray2, 1);
        BinaryConverter.shortToByteArray((short)this.blockingFactor_, byArray2, 3);
        byArray2[5] = -1;
        int n2 = this.openFeedback_.getRecordIncrement() * this.blockingFactor_;
        BytesWithOffset bytesWithOffset = null;
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[12];
        boolean bl = this.system_.swapTo(byArray3, byArray4);
        try {
            bytesWithOffset = new BytesWithOffset(this.getForRead(this.handle_, byArray, byArray2, n2));
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray3, byArray4);
            }
        }
        LocalIOFB localIOFB = new LocalIOFB(bytesWithOffset.data_, bytesWithOffset.offset_);
        bytesWithOffset.offset_ += 14;
        Record[] recordArray = this.parseRecordData(localIOFB, bytesWithOffset);
        return recordArray;
    }

    private static native void resetStaticStorage();

    public void rollback() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[12];
        boolean bl = this.system_.swapTo(byArray, byArray2);
        try {
            this.rollbackNtv();
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray, byArray2);
            }
        }
    }

    native void rollbackNtv() throws NativeException;

    native void updat(int var1, byte[] var2, byte[] var3, byte[] var4) throws NativeException;

    public void update(Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n;
        int n2;
        int n3;
        if (record.getRecordLength() != this.openFeedback_.getRecordLength()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Incorrect record length for file :");
                Trace.log(2, "record.getRecordLength() :" + String.valueOf(record.getRecordLength()));
            }
            throw new ExtendedIllegalArgumentException("record", 2);
        }
        byte[] byArray = new byte[]{33, 3, 0, 7};
        int n4 = this.openFeedback_.getRecordIncrement();
        byte[] byArray2 = new byte[n4];
        System.arraycopy(record.getContents(), 0, byArray2, 0, record.getRecordLength());
        int n5 = n3 = record.getNumberOfFields();
        if (this.rfCache_ != null) {
            n2 = this.rfCache_.length;
            for (n = 0; n < n2; ++n) {
                n5 = Math.max(n5, this.rfCache_[n].getNumberOfFields());
            }
        }
        n2 = n4 - n5;
        n = 0;
        while (n < n3) {
            byArray2[n2] = record.isNullField(n) ? -15 : -16;
            ++n;
            ++n2;
        }
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[12];
        boolean bl = this.system_.swapTo(byArray3, byArray4);
        try {
            this.updat(this.handle_, byArray, null, byArray2);
        }
        catch (NativeException nativeException) {
            throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray3, byArray4);
            }
        }
    }

    public void write(Record[] recordArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n;
        int n2;
        if (recordArray[0].getRecordLength() != this.openFeedback_.getRecordLength()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Incorrect record length for file :");
                Trace.log(2, "record.getRecordLength() :" + String.valueOf(recordArray[0].getRecordLength()));
            }
            throw new ExtendedIllegalArgumentException("records", 2);
        }
        int n3 = this.openFeedback_.getRecordIncrement();
        byte[] byArray = new byte[(recordArray.length < this.blockingFactor_ ? recordArray.length : this.blockingFactor_) * n3];
        int n4 = -1;
        if (this.rfCache_ != null) {
            n2 = this.rfCache_.length;
            for (n = 0; n < n2; ++n) {
                n4 = Math.max(n4, this.rfCache_[n].getNumberOfFields());
            }
        }
        n2 = 0;
        for (n = 1; n <= recordArray.length; ++n) {
            byte[] byArray2 = recordArray[n - 1].getContents();
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            int n5 = recordArray[n - 1].getNumberOfFields();
            if (n4 == -1) {
                n4 = n5;
            }
            int n6 = n2 + (n3 - n4);
            for (int i = 0; i < n5; ++i) {
                byArray[n6] = recordArray[n - 1].isNullField(i) ? -15 : -16;
                ++n6;
            }
            if (n == recordArray.length && n > this.blockingFactor_ && n % this.blockingFactor_ != 0) {
                byte[] byArray3 = new byte[n2 + n3];
                System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
                byte[] byArray4 = new byte[12];
                byte[] byArray5 = new byte[12];
                boolean bl = this.system_.swapTo(byArray4, byArray5);
                try {
                    this.put(this.handle_, null, null, byArray3);
                    continue;
                }
                catch (NativeException nativeException) {
                    throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
                }
                finally {
                    if (bl) {
                        this.system_.swapBack(byArray4, byArray5);
                    }
                }
            }
            if (n == recordArray.length || n % this.blockingFactor_ == 0) {
                byte[] byArray6 = new byte[12];
                byte[] byArray7 = new byte[12];
                boolean bl = this.system_.swapTo(byArray6, byArray7);
                try {
                    this.put(this.handle_, null, null, byArray);
                }
                catch (NativeException nativeException) {
                    throw new AS400Exception(this.parseMsgFeedback(nativeException.data));
                }
                finally {
                    if (bl) {
                        this.system_.swapBack(byArray6, byArray7);
                    }
                }
                n2 = 0;
                continue;
            }
            n2 += n3;
        }
    }

    static {
        block3: {
            if (Trace.traceOn_) {
                Trace.logLoadPath(CLASSNAME);
            }
            synch_execute_ = "";
            synch_open_close_ = "";
            System.load("/QSYS.LIB/QYJSPART.SRVPGM");
            try {
                AS400FileImplNative.resetStaticStorage();
            }
            catch (Throwable throwable) {
                if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block3;
                Trace.log(4, "Exception occurred while resetting static storage for DDM: ", throwable);
            }
        }
    }
}

