/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobOutputStream;
import com.ibm.as400.access.JDError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class AS400JDBCBlob
implements Blob {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private byte[] data_;
    private int maxLength_;

    AS400JDBCBlob(byte[] byArray, int n) {
        this.data_ = byArray;
        this.maxLength_ = n;
    }

    public synchronized void free() throws SQLException {
        this.data_ = null;
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        return new ByteArrayInputStream(this.data_);
    }

    public synchronized byte[] getBytes(long l, int n) throws SQLException {
        int n2;
        int n3;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n3 = (int)l - 1) < 0 || n < 0 || n3 + n > this.data_.length) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n2 = this.data_.length - n3) < 0) {
            return new byte[0];
        }
        if (n2 > n) {
            n2 = n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data_, n3, byArray, 0, n2);
        return byArray;
    }

    public synchronized long length() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        return this.data_.length;
    }

    public synchronized long position(byte[] byArray, long l) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        int n = (int)l - 1;
        if (byArray == null || n < 0 || n >= this.data_.length) {
            JDError.throwSQLException(this, "HY024");
        }
        int n2 = this.data_.length - byArray.length;
        for (int i = n; i <= n2; ++i) {
            int n3;
            for (n3 = 0; n3 < byArray.length && this.data_[i + n3] == byArray[n3]; ++n3) {
            }
            if (n3 != byArray.length) continue;
            return i + 1;
        }
        return -1L;
    }

    public synchronized long position(Blob blob, long l) throws SQLException {
        int n;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        int n2 = (int)l - 1;
        if (blob == null || n2 < 0 || n2 >= this.data_.length) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n = (int)blob.length()) > this.data_.length || n < 0) {
            return -1L;
        }
        int n3 = this.data_.length - n;
        byte[] byArray = blob.getBytes(1L, n);
        for (int i = n2; i <= n3; ++i) {
            int n4;
            for (n4 = 0; n4 < n && this.data_[i + n4] == byArray[n4]; ++n4) {
            }
            if (n4 != n) continue;
            return i + 1;
        }
        return -1L;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if (l <= 0L || l > (long)this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        return new AS400JDBCBlobOutputStream(this, l);
    }

    synchronized int setByte(long l, byte by) throws SQLException {
        int n;
        int n2;
        int n3;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n3 = (int)l - 1) < 0 || n3 >= this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n2 = n3 + 1) < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n2 > this.data_.length) {
            byte[] byArray = this.data_;
            this.data_ = new byte[n2];
            System.arraycopy(byArray, 0, this.data_, 0, byArray.length);
        }
        if ((n = n2 - n3) > 0) {
            this.data_[n3] = by;
            return 1;
        }
        return 0;
    }

    public synchronized int setBytes(long l, byte[] byArray) throws SQLException {
        int n;
        int n2;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n2 = (int)l - 1) < 0 || n2 >= this.maxLength_ || byArray == null) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n = n2 + byArray.length) < 0) {
            n = Integer.MAX_VALUE;
        }
        if (n > this.data_.length) {
            byte[] byArray2 = this.data_;
            this.data_ = new byte[n];
            System.arraycopy(byArray2, 0, this.data_, 0, byArray2.length);
        }
        int n3 = n - n2;
        System.arraycopy(byArray, 0, this.data_, n2, n3);
        return n3;
    }

    public synchronized int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        int n4;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n4 = (int)l - 1) < 0 || n4 >= this.maxLength_ || byArray == null || n < 0 || n2 < 0 || n + n2 > byArray.length || n4 + n2 > this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n3 = n4 + n2) < 0) {
            n3 = Integer.MAX_VALUE;
        }
        if (n3 > this.data_.length) {
            byte[] byArray2 = this.data_;
            this.data_ = new byte[n3];
            System.arraycopy(byArray2, 0, this.data_, 0, byArray2.length);
        }
        int n5 = n3 - n4;
        System.arraycopy(byArray, n, this.data_, n4, n5);
        return n5;
    }

    public synchronized void truncate(long l) throws SQLException {
        int n;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n = (int)l) < 0 || n > this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        byte[] byArray = this.data_;
        this.data_ = new byte[n];
        int n2 = n < byArray.length ? n : byArray.length;
        System.arraycopy(byArray, 0, this.data_, 0, n2);
    }
}

