/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCParameterMetaData;
import com.ibm.as400.access.AS400JDBCResultSetMetaData;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBExtendedData;
import com.ibm.as400.access.DBExtendedDataFormat;
import com.ibm.as400.access.DBOriginalData;
import com.ibm.as400.access.DBOriginalDataFormat;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLDescriptorDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLInteger;
import com.ibm.as400.access.SQLLocator;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class AS400JDBCPreparedStatement
extends AS400JDBCStatement
implements PreparedStatement {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean dataTruncation_;
    private int descriptorHandle_;
    boolean executed_;
    private boolean outputParametersExpected_;
    int parameterCount_;
    boolean batchExecute_ = false;
    private int[] parameterLengths_;
    private int[] parameterOffsets_;
    private boolean[] parameterNulls_;
    private boolean[] parameterDefaults_;
    private boolean[] parameterUnassigned_;
    Vector batchParameterRows_;
    private int parameterTotalSize_;
    boolean[] parameterSet_;
    private boolean prepared_;
    private JDServerRow resultRow_;
    SQLInteger returnValueParameter_;
    JDSQLStatement sqlStatement_;
    boolean useReturnValueParameter_;
    private int maxToLog_ = 10000;
    private int containsLocator_ = -1;
    private static final int LOCATOR_UNKNOWN = -1;
    private static final int LOCATOR_NOT_FOUND = 0;
    private static final int LOCATOR_FOUND = 1;
    private static final short INDICATOR_NULL = -1;
    private static final short INDICATOR_DEFAULT = -5;
    private static final short INDICATOR_UNASSIGNED = -7;
    static final int LOB_BLOCK_SIZE = 262144;

    AS400JDBCPreparedStatement(AS400JDBCConnection aS400JDBCConnection, int n, JDTransactionManager jDTransactionManager, JDPackageManager jDPackageManager, String string, int n2, boolean bl, JDSQLStatement jDSQLStatement, boolean bl2, String string2, int n3, int n4, int n5, int n6) throws SQLException {
        super(aS400JDBCConnection, n, jDTransactionManager, jDPackageManager, string, n2, bl, string2, n3, n4, n5, n6);
        this.outputParametersExpected_ = bl2;
        this.parameterCount_ = jDSQLStatement.countParameters();
        this.parameterLengths_ = new int[this.parameterCount_];
        this.parameterNulls_ = new boolean[this.parameterCount_];
        this.parameterDefaults_ = new boolean[this.parameterCount_];
        this.parameterUnassigned_ = new boolean[this.parameterCount_];
        this.parameterOffsets_ = new int[this.parameterCount_];
        this.parameterSet_ = new boolean[this.parameterCount_];
        this.sqlStatement_ = jDSQLStatement;
        this.useReturnValueParameter_ = jDSQLStatement.hasReturnValueParameter();
        if (this.useReturnValueParameter_) {
            this.returnValueParameter_ = new SQLInteger(this.connection_.getVRM());
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Preparing [" + this.sqlStatement_ + "]");
            if (this.useReturnValueParameter_) {
                JDTrace.logInformation(this, "Suppressing return value parameter (?=CALL)");
            }
        }
        this.allowImmediate_ = false;
        this.prepared_ = true;
        try {
            this.resultRow_ = this.commonPrepare(this.sqlStatement_);
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
        this.executed_ = false;
        this.dataTruncation_ = aS400JDBCConnection.getProperties().getBoolean(33);
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            Object[] objectArray = new Object[this.parameterCount_];
            for (int i = 0; i < this.parameterCount_; ++i) {
                int n;
                if (this.parameterRow_.isOutput(i + 1)) {
                    JDError.throwSQLException(this, "HY105");
                }
                if (!this.parameterSet_[i]) {
                    JDError.throwSQLException(this, "07001");
                }
                SQLData sQLData = this.parameterRow_.getSQLData(i + 1);
                if (!this.parameterNulls_[i]) {
                    objectArray[i] = this.parameterDefaults_[i] ? new Byte("1") : (this.parameterUnassigned_[i] ? new Byte("2") : sQLData.getObject());
                }
                if (this.containsLocator_ != -1 || (n = sQLData.getSQLType()) != 8 && n != 4 && n != 12) continue;
                this.containsLocator_ = 1;
            }
            if (this.containsLocator_ == -1) {
                this.containsLocator_ = 0;
            }
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "addBatch()");
            }
            this.batch_.addElement(objectArray);
        }
    }

    public void addBatch(String string) throws SQLException {
        JDError.throwSQLException(this, "HY010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeDescriptor() throws SQLException {
        DBSQLDescriptorDS dBSQLDescriptorDS = null;
        try {
            this.descriptorHandle_ = this.id_;
            dBSQLDescriptorDS = DBDSPool.getDBSQLDescriptorDS(7680, this.id_, 0, this.descriptorHandle_);
            DBDataFormat dBDataFormat = this.connection_.useExtendedFormats() ? new DBExtendedDataFormat(this.parameterCount_) : new DBOriginalDataFormat(this.parameterCount_);
            dBSQLDescriptorDS.setParameterMarkerDataFormat(dBDataFormat);
            dBDataFormat.setConsistencyToken(1);
            dBDataFormat.setRecordSize(this.parameterTotalSize_);
            for (int i = 0; i < this.parameterCount_; ++i) {
                SQLData sQLData = this.parameterRow_.getSQLData(i + 1);
                dBDataFormat.setFieldDescriptionLength(i);
                dBDataFormat.setFieldLength(i, this.parameterLengths_[i]);
                dBDataFormat.setFieldCCSID(i, this.parameterRow_.getCCSID(i + 1));
                dBDataFormat.setFieldNameLength(i, 0);
                dBDataFormat.setFieldNameCCSID(i, 0);
                dBDataFormat.setFieldName(i, "", this.connection_.converter_);
                dBDataFormat.setFieldSQLType(i, (short)(sQLData.getNativeType() | 1));
                dBDataFormat.setFieldScale(i, (short)sQLData.getScale());
                dBDataFormat.setFieldPrecision(i, (short)sQLData.getPrecision());
            }
            this.connection_.send(dBSQLDescriptorDS, this.descriptorHandle_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Descriptor " + this.descriptorHandle_ + " created or changed");
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
        }
        finally {
            if (dBSQLDescriptorDS != null) {
                dBSQLDescriptorDS.inUse_ = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            for (int i = 0; i < this.parameterCount_; ++i) {
                this.parameterNulls_[i] = false;
                this.parameterDefaults_[i] = false;
                this.parameterUnassigned_[i] = false;
                this.parameterSet_[i] = false;
            }
            if (this.useReturnValueParameter_) {
                this.returnValueParameter_.set(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.descriptorHandle_ != 0) {
                DBSQLDescriptorDS dBSQLDescriptorDS = null;
                try {
                    dBSQLDescriptorDS = DBDSPool.getDBSQLDescriptorDS(7681, this.id_, 0, this.descriptorHandle_);
                    this.connection_.send(dBSQLDescriptorDS, this.descriptorHandle_);
                }
                finally {
                    if (dBSQLDescriptorDS != null) {
                        dBSQLDescriptorDS.inUse_ = false;
                    }
                }
                this.descriptorHandle_ = 0;
            }
            super.close();
        }
    }

    void commonExecuteAfter(JDSQLStatement jDSQLStatement, DBReplyRequestedDS dBReplyRequestedDS) throws SQLException {
        super.commonExecuteAfter(jDSQLStatement, dBReplyRequestedDS);
        if (this.prepared_) {
            DBData dBData = null;
            if (this.outputParametersExpected_) {
                dBData = dBReplyRequestedDS.getResultData();
            }
            if (this.outputParametersExpected_ && dBData != null) {
                this.parameterRow_.setServerData(dBData);
                this.parameterRow_.setRowIndex(0);
            }
            try {
                if (this.useReturnValueParameter_) {
                    this.returnValueParameter_.set(dBReplyRequestedDS.getSQLCA().getErrd(1));
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
            }
        }
    }

    void commonExecuteBefore(JDSQLStatement jDSQLStatement, DBSQLRequestDS dBSQLRequestDS) throws SQLException {
        super.commonExecuteBefore(jDSQLStatement, dBSQLRequestDS);
        if (this.prepared_) {
            int n;
            this.closeResultSet(241);
            boolean bl = false;
            for (n = 0; n < this.parameterCount_; ++n) {
                if (!this.parameterSet_[n] && this.parameterRow_.isInput(n + 1)) {
                    JDError.throwSQLException(this, "07001");
                }
                if (!this.parameterRow_.isOutput(n + 1)) continue;
                bl = true;
            }
            if (!bl) {
                this.outputParametersExpected_ = false;
            }
            if (this.parameterCount_ > 0 && this.descriptorHandle_ == 0) {
                this.parameterTotalSize_ = 0;
                for (n = 0; n < this.parameterCount_; ++n) {
                    this.parameterLengths_[n] = this.parameterRow_.getLength(n + 1);
                    this.parameterOffsets_[n] = this.parameterTotalSize_;
                    this.parameterTotalSize_ += this.parameterLengths_[n];
                }
                this.changeDescriptor();
            }
            try {
                dBSQLRequestDS.setStatementType(jDSQLStatement.getNativeType());
                dBSQLRequestDS.setParameterMarkerDescriptorHandle(this.descriptorHandle_);
                if (this.parameterCount_ > 0) {
                    n = 0;
                    do {
                        n = 0;
                        int n2 = this.batchExecute_ ? this.batchParameterRows_.size() : 1;
                        DBData dBData = this.connection_.useExtendedFormats() ? new DBExtendedData(n2, this.parameterCount_, 2, this.parameterTotalSize_) : new DBOriginalData(n2, this.parameterCount_, 2, this.parameterTotalSize_);
                        for (int i = 0; i < n2; ++i) {
                            Object[] objectArray = null;
                            if (this.batchExecute_) {
                                objectArray = (Object[])this.batchParameterRows_.get(i);
                            }
                            if (i == 0) {
                                dBSQLRequestDS.setParameterMarkerData(dBData);
                                dBData.setConsistencyToken(1);
                            }
                            int n3 = dBData.getRowDataOffset(i);
                            for (int j = 0; j < this.parameterCount_; ++j) {
                                if (this.batchExecute_ && (objectArray[j] == null || objectArray[j] instanceof Byte) || !this.batchExecute_ && (this.parameterNulls_[j] || this.parameterDefaults_[j] || this.parameterUnassigned_[j])) {
                                    int n4 = -1;
                                    if (this.batchExecute_) {
                                        if (objectArray[j] == null) {
                                            n4 = -1;
                                        } else if ((Byte)objectArray[j] == 1) {
                                            n4 = -5;
                                        } else if ((Byte)objectArray[j] == 2) {
                                            n4 = -7;
                                        }
                                    } else if (this.parameterNulls_[j]) {
                                        n4 = -1;
                                    } else if (this.parameterDefaults_[j]) {
                                        n4 = -5;
                                    } else if (this.parameterUnassigned_[j]) {
                                        n4 = -7;
                                    }
                                    dBData.setIndicator(i, j, n4);
                                    byte[] byArray = dBData.getRawBytes();
                                    int n5 = n3 + this.parameterOffsets_[j];
                                    int n6 = this.parameterLengths_[j] + n5;
                                    int n7 = n5;
                                    while (n7 < n6) {
                                        byArray[n7++] = 0;
                                    }
                                    continue;
                                }
                                dBData.setIndicator(i, j, 0);
                                ConvTable convTable = this.connection_.getConverter(this.parameterRow_.getCCSID(j + 1));
                                int n8 = -1;
                                if (this.batchExecute_) {
                                    this.setValue(j + 1, objectArray[j], null, -1);
                                }
                                SQLData sQLData = this.parameterRow_.getSQLType(j + 1);
                                try {
                                    sQLData.convertToRawBytes(dBData.getRawBytes(), n3 + this.parameterOffsets_[j], convTable);
                                    if (convTable.getCcsid() == 5035) {
                                        this.testDataTruncation(j + 1, sQLData);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    if (sQLException.getSQLState().trim().equals("HY000")) {
                                        if (sQLException.getMessage().indexOf("Change Descriptor") != -1) {
                                            n8 = sQLData.getPrecision();
                                        }
                                        throw sQLException;
                                    }
                                    throw sQLException;
                                }
                                if (n8 < 0) continue;
                                n = 1;
                                this.parameterLengths_[j] = n8;
                                this.parameterTotalSize_ = this.parameterOffsets_[j] + n8;
                                if (j + 1 >= this.parameterCount_) continue;
                                for (int k = j + 1; k < this.parameterCount_; ++k) {
                                    this.parameterOffsets_[k] = this.parameterTotalSize_;
                                    this.parameterTotalSize_ += this.parameterLengths_[k];
                                }
                            }
                            if (n == 0) continue;
                            this.changeDescriptor();
                        }
                    } while (n != 0);
                    dBSQLRequestDS.setParameterMarkerBlockIndicator(0);
                }
                if (this.outputParametersExpected_) {
                    dBSQLRequestDS.addOperationResultBitmap(0x4000000);
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
            }
        }
    }

    void commonPrepareAfter(JDSQLStatement jDSQLStatement, DBReplyRequestedDS dBReplyRequestedDS) throws SQLException {
        super.commonPrepareAfter(jDSQLStatement, dBReplyRequestedDS);
        if (this.prepared_) {
            this.parameterRow_ = new JDServerRow(this.connection_, this.id_, dBReplyRequestedDS.getParameterMarkerFormat(), this.settings_);
        }
    }

    void commonPrepareBefore(JDSQLStatement jDSQLStatement, DBSQLRequestDS dBSQLRequestDS) throws SQLException {
        super.commonPrepareBefore(jDSQLStatement, dBSQLRequestDS);
        if (this.prepared_) {
            dBSQLRequestDS.addOperationResultBitmap(0x800000);
        }
    }

    void commonPrepareBypass(JDSQLStatement jDSQLStatement, int n) throws SQLException {
        super.commonPrepareBypass(jDSQLStatement, n);
        if (this.prepared_) {
            this.parameterRow_ = new JDServerRow(this.connection_, this.id_, this.packageManager_.getCachedParameterMarkerFormat(n), this.settings_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            return this.resultSet_ != null;
        }
    }

    public boolean execute(String string) throws SQLException {
        JDError.throwSQLException(this, "HY010");
        return false;
    }

    public boolean execute(String string, int n) throws SQLException {
        JDError.throwSQLException(this, "HY010");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.batch_ == null || this.batch_.size() == 0) {
                return new int[0];
            }
            this.batchParameterRows_ = new Vector();
            int n = this.batch_.size();
            int[] nArray = new int[n];
            int n2 = 0;
            boolean bl = true;
            boolean bl2 = false;
            try {
                try {
                    if (!this.sqlStatement_.isInsert_) {
                        bl = false;
                        bl2 = true;
                    }
                    if (!this.sqlStatement_.canBatch()) {
                        bl = false;
                    }
                    if (this.containsLocator_ == 1) {
                        bl = false;
                    }
                    this.batchExecute_ = true;
                    this.rowsInserted_ = 0;
                    if (!this.prepared_) {
                        this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                        this.prepared_ = true;
                        if (this.resultSet_ != null) {
                            this.closeResultSet(241);
                            JDError.throwSQLException(this, "24000");
                        }
                    }
                    if (bl) {
                        Enumeration enumeration = this.batch_.elements();
                        int n3 = 0;
                        while (enumeration.hasMoreElements()) {
                            this.batchParameterRows_.add(enumeration.nextElement());
                            if (++n3 != 32000 || !enumeration.hasMoreElements()) continue;
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "Begin batching via server-side with " + this.batchParameterRows_.size() + " rows.");
                            }
                            this.commonExecute(this.sqlStatement_, this.resultRow_);
                            this.batchParameterRows_.clear();
                            if (this.resultSet_ != null) {
                                this.closeResultSet(241);
                                JDError.throwSQLException(this, "24000");
                            }
                            n3 = 0;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Begin batching via server-side with " + this.batchParameterRows_.size() + " rows.");
                        }
                        this.commonExecute(this.sqlStatement_, this.resultRow_);
                        this.batchParameterRows_.clear();
                        if (this.resultSet_ != null) {
                            this.closeResultSet(241);
                            JDError.throwSQLException(this, "24000");
                        }
                        n2 = n;
                        for (int i = 0; i < n; ++i) {
                            nArray[i] = -2;
                        }
                    } else {
                        Enumeration enumeration = this.batch_.elements();
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Begin batching via client-side multiple executes.");
                        }
                        while (enumeration.hasMoreElements()) {
                            this.batchParameterRows_.addElement(enumeration.nextElement());
                            this.commonExecute(this.sqlStatement_, this.resultRow_);
                            this.batchParameterRows_.removeAllElements();
                            if (this.resultSet_ != null) {
                                this.closeResultSet(241);
                                JDError.throwSQLException(this, "24000");
                            }
                            nArray[n2++] = this.rowsInserted_;
                        }
                    }
                    this.executed_ = true;
                }
                catch (SQLException sQLException) {
                    int[] nArray2 = null;
                    if (bl) {
                        nArray2 = new int[this.rowsInserted_];
                        for (int i = 0; i < nArray2.length; ++i) {
                            nArray2[i] = -2;
                        }
                        throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                    } else {
                        nArray2 = new int[n2];
                        System.arraycopy(nArray, 0, nArray2, 0, n2);
                    }
                    throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                }
                Object var11_14 = null;
                this.batch_.removeAllElements();
                this.batchExecute_ = false;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                this.batch_.removeAllElements();
                this.batchExecute_ = false;
                if (!JDTrace.isTraceOn()) throw throwable;
                JDTrace.logInformation(this, "Done batching.");
                throw throwable;
            }
            if (!JDTrace.isTraceOn()) return nArray;
            JDTrace.logInformation(this, "Done batching.");
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            if (this.resultSet_ == null && (this.behaviorOverride_ & 1) == 0) {
                JDError.throwSQLException(this, "24000");
            }
            return this.resultSet_;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        JDError.throwSQLException(this, "HY010");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
                if (this.resultRow_ != null) {
                    JDError.throwSQLException(this, "24000");
                }
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            if (this.resultSet_ != null) {
                this.closeResultSet(241);
                JDError.throwSQLException(this, "24000");
            }
            return this.updateCount_;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        JDError.throwSQLException(this, "HY010");
        return 0;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        JDError.throwSQLException(this, "HY010");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.resultRow_ == null) {
                return null;
            }
            ConvTable convTable = null;
            DBExtendedColumnDescriptors dBExtendedColumnDescriptors = this.getExtendedColumnDescriptors();
            if (dBExtendedColumnDescriptors != null) {
                convTable = this.connection_.converter_;
            }
            return new AS400JDBCResultSetMetaData(this.connection_.getCatalog(), this.resultSetConcurrency_, this.cursor_.getName(), this.resultRow_, dBExtendedColumnDescriptors, convTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getParameterClassName(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getJavaClassName();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getJavaClassName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParameterCount() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                return this.parameterCount_ + 1;
            }
            return this.parameterCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            return new AS400JDBCParameterMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParameterMode(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return 4;
                }
                --n;
            }
            boolean bl = this.parameterRow_.isInput(n);
            boolean bl2 = this.parameterRow_.isOutput(n);
            if (bl && bl2) {
                return 2;
            }
            if (bl) {
                return 1;
            }
            if (bl2) {
                return 4;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParameterType(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getType();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getParameterTypeName(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getTypeName();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getTypeName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPrecision(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getPrecision();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getPrecision();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getScale(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getScale();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getScale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int isNullable(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return 0;
                }
                --n;
            }
            return this.parameterRow_.isNullable(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSigned(int n) throws SQLException {
        if (n > this.getParameterCount() || n < 1) {
            JDError.throwSQLException(this, "07009");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.isSigned();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).isSigned();
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        JDError.throwSQLException(this, "HY105");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException(this, "HY090");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (n < 1 || n > this.parameterCount_) {
                JDError.throwSQLException(this, "07009");
            }
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException(this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException(this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (inputStream != null) {
                try {
                    if (sQLData.getSQLType() == 8 || sQLData.getSQLType() == 4 || sQLData.getSQLType() == 12) {
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                        }
                        sQLData.set(new ConvTableReader(inputStream, 819, 0, 262144), null, n2);
                    } else {
                        sQLData.set(JDUtilities.readerToString(new ConvTableReader(inputStream, 819, 0, 262144), n2), null, -1);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = inputStream == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBigDecimal()");
            if (bigDecimal == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + bigDecimal.toString());
            }
        }
        this.setValue(n, bigDecimal, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException(this, "HY090");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (n < 1 || n > this.parameterCount_) {
                JDError.throwSQLException(this, "07009");
            }
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException(this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException(this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (inputStream != null) {
                if (sQLData instanceof SQLLocator) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    sQLData.set(inputStream, null, n2);
                } else {
                    sQLData.set(JDUtilities.streamToBytes(inputStream, n2), null, n2);
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = inputStream == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (blob == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + blob.length());
            }
        }
        this.setValue(n, blob, null, -1);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBoolean()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + bl);
        }
        this.setValue(n, new Short((short)(bl ? 1 : 0)), null, -1);
    }

    public void setByte(int n, byte by) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setByte()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + by);
        }
        this.setValue(n, new Short(by), null, -1);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBytes()");
            if (byArray == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (byArray.length > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + byArray.length);
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + byArray.length + " value: " + new String(byArray));
            }
        }
        this.setValue(n, byArray, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException(this, "HY090");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (n < 1 || n > this.parameterCount_) {
                JDError.throwSQLException(this, "07009");
            }
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException(this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException(this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (reader != null) {
                if (sQLData.getSQLType() == 8 || sQLData.getSQLType() == 4 || sQLData.getSQLType() == 12) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                    }
                    sQLData.set(JDUtilities.readerToString(reader, n2), null, -1);
                } else {
                    sQLData.set(JDUtilities.readerToString(reader, n2), null, -1);
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = reader == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (clob == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (clob.length() > (long)this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + clob.getSubString(1L, (int)clob.length()));
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + clob.length());
            }
        }
        this.setValue(n, clob, null, -1);
    }

    public void setDate(int n, Date date) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (date == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + date.toString());
            }
        }
        this.setValue(n, date, null, -1);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (date == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + date.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException(this, "HY024");
        }
        this.setValue(n, date, calendar, -1);
    }

    public void setDB2Default(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDB2Default()");
            JDTrace.logInformation(this, "parameter index: " + n);
        }
        this.setValueExtendedIndicator(n, 1);
    }

    public void setDB2Unassigned(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDB2Unassigned()");
            JDTrace.logInformation(this, "parameter index: " + n);
        }
        this.setValueExtendedIndicator(n, 2);
    }

    public void setDouble(int n, double d) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDouble()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + d);
        }
        this.setValue(n, new Double(d), null, -1);
    }

    public void setFloat(int n, float f) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFloat()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + f);
        }
        this.setValue(n, new Float(f), null, -1);
    }

    public void setInt(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setInt()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + n2);
        }
        this.setValue(n, new Integer(n2), null, -1);
    }

    public void setLong(int n, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setLong()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + l);
        }
        this.setValue(n, new Long(l), null, -1);
    }

    public void setNull(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
        }
        this.setValue(n, null, null, -1);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
        }
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " type: " + object.getClass().getName());
            }
        }
        this.setValue(n, object, null, -1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " type: " + object.getClass().getName());
            }
        }
        this.setValue(n, object, null, -1);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " type: " + object.getClass().getName());
            }
        }
        if (n3 < 0) {
            JDError.throwSQLException(this, "HY094");
        }
        this.setValue(n, object, null, n3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        JDError.throwSQLException(this, "HY105");
    }

    public void setShort(int n, short s) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setShort()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + s);
        }
        this.setValue(n, new Short(s), null, -1);
    }

    public void setString(int n, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setString()");
            if (string == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (string.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + string.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + string);
            }
        }
        this.setValue(n, string, null, -1);
    }

    public void setTime(int n, Time time) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (time == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + time.toString());
            }
        }
        this.setValue(n, time, null, -1);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (time == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + time.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException(this, "HY024");
        }
        this.setValue(n, time, calendar, -1);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (timestamp == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + timestamp.toString());
            }
        }
        this.setValue(n, timestamp, null, -1);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (timestamp == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + timestamp.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException(this, "HY024");
        }
        this.setValue(n, timestamp, calendar, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setUnicodeStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException(this, "HY090");
        }
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (n < 1 || n > this.parameterCount_) {
                JDError.throwSQLException(this, "07009");
            }
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException(this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException(this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (inputStream != null) {
                try {
                    if (sQLData.getSQLType() == 8 || sQLData.getSQLType() == 4 || sQLData.getSQLType() == 12) {
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                        }
                        sQLData.set(new ConvTableReader(inputStream, 13488, 0, 262144), null, n2 / 2);
                    } else {
                        sQLData.set(JDUtilities.readerToString(new ConvTableReader(inputStream, 13488, 0, 262144), n2 / 2), null, -1);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = inputStream == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setURL()");
            if (uRL == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + uRL.toString());
            }
        }
        this.setValue(n, uRL, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValue(int n, Object object, Calendar calendar, int n2) throws SQLException {
        Object object2 = this.internalLock_;
        synchronized (object2) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException(this, "HY105");
                } else {
                    --n;
                }
            }
            if (n < 1 || n > this.parameterCount_) {
                JDError.throwSQLException(this, "07009");
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException(this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (object != null) {
                int n3 = sQLData.getSQLType();
                if (n3 == 8 || n3 == 4 || n3 == 12) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                    }
                }
                sQLData.set(object, calendar, n2);
                if (this.dataTruncation_ || !sQLData.isText()) {
                    this.testDataTruncation(n, sQLData);
                }
            }
            this.parameterNulls_[n - 1] = object == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValueExtendedIndicator(int n, int n2) throws SQLException {
        Object object = this.internalLock_;
        synchronized (object) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException(this, "HY105");
                } else {
                    --n;
                }
            }
            if (n < 1 || n > this.parameterCount_) {
                JDError.throwSQLException(this, "07009");
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException(this, "HY105");
            }
            this.parameterNulls_[n - 1] = false;
            this.parameterDefaults_[n - 1] = n2 == 1;
            this.parameterUnassigned_[n - 1] = n2 == 2;
            this.parameterSet_[n - 1] = true;
        }
    }

    private void testDataTruncation(int n, SQLData sQLData) throws SQLException {
        int n2;
        if (sQLData != null && (this.dataTruncation_ || !sQLData.isText()) && (n2 = sQLData.getTruncated()) > 0) {
            int n3 = sQLData.getActualSize();
            DataTruncation dataTruncation = new DataTruncation(n, true, false, n3 + n2, n3);
            if (this.connection_.getVRM() >= JDUtilities.vrm610 && !sQLData.isText()) {
                throw dataTruncation;
            }
            if (this.sqlStatement_ != null && this.sqlStatement_.isSelect()) {
                this.postWarning(dataTruncation);
            } else {
                throw dataTruncation;
            }
        }
    }

    private void testSQLType(int n, int n2) throws SQLException {
        int n3 = this.parameterRow_.getSQLType(n2).getType();
        if (n != n3 && (n != 1 && n != 12 || n3 != 1 && n3 != 12)) {
            JDError.throwSQLException(this, "HY105");
        }
    }

    JDServerRow getResultRow() {
        return this.resultRow_;
    }
}

