/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class PSConfig {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String OPTION_BALANCE_THRESHOLD = "balanceThreshold";
    private static final String OPTION_CONFIGURATION = "configuration";
    private static final String OPTION_JDBC_DRIVERS = "jdbcDrivers";
    private static final String OPTION_MAX_CONNECTIONS = "maxConnections";
    private static final String OPTION_PEERS = "peers";
    private static final String OPTION_VERBOSE = "verbose";
    static final Vector expectedOptions_ = new Vector();
    static final Hashtable shortcuts_ = new Hashtable();
    private PSLoad load_;
    private PSLoadBalancer loadBalancer_;
    private String name_;
    private Properties properties_;

    public PSConfig(PSLoad pSLoad, PSLoadBalancer pSLoadBalancer) {
        this.load_ = pSLoad;
        this.loadBalancer_ = pSLoadBalancer;
        this.name_ = null;
        this.properties_ = new Properties();
    }

    public void apply(CommandLineArguments commandLineArguments) throws IOException {
        Trace.loadTraceProperties();
        String string = commandLineArguments.getOptionValue(OPTION_VERBOSE);
        if (string != null) {
            this.setVerbose(string);
            ((Hashtable)this.properties_).put(OPTION_VERBOSE, string);
        }
        if ((string = commandLineArguments.getOptionValue(OPTION_CONFIGURATION)) != null) {
            this.setName(string);
            this.load();
        }
        if ((string = commandLineArguments.getOptionValue(OPTION_VERBOSE)) != null) {
            this.setVerbose(string);
            ((Hashtable)this.properties_).put(OPTION_VERBOSE, string);
        }
        if ((string = commandLineArguments.getOptionValue(OPTION_BALANCE_THRESHOLD)) != null) {
            this.load_.setBalanceThreshold(Integer.parseInt(string));
            ((Hashtable)this.properties_).put(OPTION_BALANCE_THRESHOLD, string);
        }
        if ((string = commandLineArguments.getOptionValue(OPTION_JDBC_DRIVERS)) != null) {
            this.registerJDBCDrivers(string);
            ((Hashtable)this.properties_).put(OPTION_JDBC_DRIVERS, string);
        }
        if ((string = commandLineArguments.getOptionValue(OPTION_MAX_CONNECTIONS)) != null) {
            this.load_.setMaxConnections(Integer.parseInt(string));
            ((Hashtable)this.properties_).put(OPTION_MAX_CONNECTIONS, string);
        }
        if ((string = commandLineArguments.getOptionValue(OPTION_PEERS)) != null) {
            this.loadBalancer_.setPeers(string);
            ((Hashtable)this.properties_).put(OPTION_PEERS, string);
        }
    }

    public void apply(Properties properties) {
        Trace.loadTraceProperties();
        boolean bl = Verbose.isVerbose();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Changing option " + string + " to " + string2 + ".");
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_BALANCE_THRESHOLD)) {
                this.load_.setBalanceThreshold(Integer.parseInt(string2));
                ((Hashtable)this.properties_).put(OPTION_BALANCE_THRESHOLD, string2);
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_JDBC_DRIVERS)) {
                this.registerJDBCDrivers(string2);
                ((Hashtable)this.properties_).put(OPTION_JDBC_DRIVERS, string2);
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_MAX_CONNECTIONS)) {
                this.load_.setMaxConnections(Integer.parseInt(string2));
                ((Hashtable)this.properties_).put(OPTION_MAX_CONNECTIONS, string2);
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_PEERS)) {
                this.loadBalancer_.setPeers(string2);
                ((Hashtable)this.properties_).put(OPTION_PEERS, string2);
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_VERBOSE)) {
                this.setVerbose(string2);
                ((Hashtable)this.properties_).put(OPTION_VERBOSE, string2);
                continue;
            }
            if (string.trim().length() <= 0) continue;
            throw new IllegalArgumentException(ResourceBundleLoader.getText("PROXY_OPTION_NOT_VALID", string));
        }
        boolean bl2 = Verbose.isVerbose();
        if (bl || bl2) {
            Verbose.forcePrintln(ResourceBundleLoader.getText("PROXY_CONFIGURATION_UPDATED"));
        }
    }

    public String getName() {
        return this.name_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public void load() throws IOException {
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.name_));
        properties.load(bufferedInputStream);
        this.apply(properties);
    }

    private void registerJDBCDrivers(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";, ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Class<?> clazz = Class.forName(string2);
                Driver driver = (Driver)clazz.newInstance();
                boolean bl = false;
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                while (enumeration.hasMoreElements() && !bl) {
                    Driver driver2 = enumeration.nextElement();
                    if (!driver2.getClass().equals(clazz)) continue;
                    bl = true;
                }
                if (!bl) {
                    DriverManager.registerDriver((Driver)Class.forName(string2).newInstance());
                }
                Verbose.println(ResourceBundleLoader.getText("PROXY_JDBC_DRIVER_REGISTERED", string2));
            }
            catch (Exception exception) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "JDBC driver not found.", (Throwable)exception);
                }
                Verbose.println(ResourceBundleLoader.getText("PROXY_JDBC_DRIVER_NOT_REGISTERED", string2));
            }
        }
    }

    public void setName(String string) {
        this.name_ = string;
    }

    private void setVerbose(String string) {
        if (string.length() == 0 || string.equalsIgnoreCase("true")) {
            Verbose.setVerbose(true);
        } else if (string.equalsIgnoreCase("false")) {
            Verbose.setVerbose(false);
        } else {
            throw new IllegalArgumentException(ResourceBundleLoader.getText("PROXY_OPTION_VALUE_NOT_VALID", new String[]{OPTION_VERBOSE, string}));
        }
    }

    static void usage(PrintStream printStream) {
        String string = ResourceBundleLoader.getText("PROXY_SERVER_USAGE");
        String string2 = ResourceBundleLoader.getText("PROXY_SERVER_OPTIONSLC");
        String string3 = ResourceBundleLoader.getText("PROXY_SERVER_OPTIONSUC");
        String string4 = ResourceBundleLoader.getText("PROXY_SERVER_SHORTCUTS");
        printStream.println(string + ":");
        printStream.println();
        printStream.println("  com.ibm.as400.access.ProxyServer [ " + string2 + " ]");
        printStream.println();
        printStream.println(string3 + ":");
        printStream.println();
        printStream.println("  -balanceThreshold balanceThreshold");
        printStream.println("  -configuration configuration");
        printStream.println("  -jdbcDrivers jdbcDriver1[;jdbcDriver2;...]");
        printStream.println("  -maxConnections maxConnections");
        printStream.println("  -peers hostname1[:port1][;hostname2[:port2];...");
        printStream.println("  -port port");
        printStream.println("  -securePort securePort");
        printStream.println("  -keyringName ProxyServerKeyringName");
        printStream.println("  -keyringPassword ProxyServerKeyringPassword");
        printStream.println("  -verbose [true|false]");
        printStream.println("  -help");
        printStream.println();
        printStream.println(string4 + ":");
        printStream.println();
        printStream.println("  -bt balanceThreshold");
        printStream.println("  -c configuration");
        printStream.println("  -jd jdbcDriver1[;jdbcDriver2;...]");
        printStream.println("  -mc maxConnections");
        printStream.println("  -pe hostname1[:port1][;hostname2[:port2];...");
        printStream.println("  -po port");
        printStream.println("  -sp securePort");
        printStream.println("  -kn ProxyServerKeyringName");
        printStream.println("  -kp ProxyServerKeyringPassword");
        printStream.println("  -v [true|false]");
        printStream.println("  -h");
        printStream.println("  -?");
    }

    static {
        expectedOptions_.addElement("-balanceThreshold");
        expectedOptions_.addElement("-configuration");
        expectedOptions_.addElement("-jdbcDrivers");
        expectedOptions_.addElement("-maxConnections");
        expectedOptions_.addElement("-peers");
        expectedOptions_.addElement("-port");
        expectedOptions_.addElement("-securePort");
        expectedOptions_.addElement("-keyringName");
        expectedOptions_.addElement("-keyringPassword");
        expectedOptions_.addElement("-verbose");
        expectedOptions_.addElement("-help");
        shortcuts_.put("-bt", "-balanceThreshold");
        shortcuts_.put("-c", "-configuration");
        shortcuts_.put("-jd", "-jdbcDrivers");
        shortcuts_.put("-mc", "-maxConnections");
        shortcuts_.put("-pe", "-peers");
        shortcuts_.put("-po", "-port");
        shortcuts_.put("-sp", "-securePort");
        shortcuts_.put("-kn", "-keyringName");
        shortcuts_.put("-kp", "-keyringPassword");
        shortcuts_.put("-v", "-verbose");
        shortcuts_.put("-h", "-help");
        shortcuts_.put("-?", "-help");
    }
}

