/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLVargraphic
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private SQLConversionSettings settings_;
    private int length_;
    private int maxLength_;
    private int truncated_;
    private String value_;
    private int ccsid_;

    SQLVargraphic(int n, SQLConversionSettings sQLConversionSettings, int n2) {
        this.settings_ = sQLConversionSettings;
        this.length_ = 0;
        this.maxLength_ = n;
        this.truncated_ = 0;
        this.value_ = "";
        this.ccsid_ = n2;
    }

    public Object clone() {
        return new SQLVargraphic(this.maxLength_, this.settings_, this.ccsid_);
    }

    public void trim() {
        this.value_ = this.value_.trim();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.value_ = convTable.byteArrayToString(byArray, n + 2, this.length_ * 2, bidiConversionProperties);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        try {
            int n2 = this.settings_.getBidiStringType();
            if (n2 == -1) {
                n2 = convTable.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            byte[] byArray2 = convTable.stringToByteArray(this.value_, bidiConversionProperties);
            BinaryConverter.unsignedShortToByteArray(byArray2.length / 2, byArray, n);
            if (byArray2.length > this.maxLength_) {
                this.maxLength_ = byArray2.length;
                JDError.throwSQLException(this, "HY000");
            }
            System.arraycopy(byArray2, 0, byArray, n + 2, byArray2.length);
            if (this.maxLength_ > 256 && this.maxLength_ - byArray2.length > 16) {
                int n3 = n + 2 + this.maxLength_;
                for (int i = n + 2 + byArray2.length; i < n3; ++i) {
                    byArray[i] = 0;
                }
            }
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        int n2;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Number) {
            string = object.toString();
        } else if (object instanceof Boolean) {
            string = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            string = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            string = SQLTimestamp.timestampToString((Timestamp)object, calendar);
        } else if (object instanceof java.util.Date) {
            string = SQLDate.dateToString((java.util.Date)object, this.settings_, calendar);
        } else if (object instanceof URL) {
            string = object.toString();
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
            Clob clob = (Clob)object;
            string = clob.getSubString(1L, (int)clob.length());
        }
        if (string == null) {
            JDError.throwSQLException(this, "07006");
        }
        this.value_ = string;
        int n3 = this.value_.length();
        if (n3 > (n2 = this.maxLength_ / 2)) {
            this.value_ = this.value_.substring(0, n2);
            this.truncated_ = n3 - n2;
        } else {
            this.truncated_ = 0;
        }
        this.length_ = this.value_.length();
    }

    public int getSQLType() {
        return 32;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "java.lang.String";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "VARGRAPHIC";
    }

    public int getMaximumPrecision() {
        return 16369;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 464;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 12;
    }

    public String getTypeName() {
        if (this.ccsid_ == 13488 || this.ccsid_ == 1200) {
            return "NVARCHAR";
        }
        return "VARGRAPHIC";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.getString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        try {
            BigDecimal bigDecimal = new BigDecimal(SQLDataFactory.convertScientificNotation(this.getString()));
            if (n >= 0) {
                if (n >= bigDecimal.scale()) {
                    this.truncated_ = 0;
                    return bigDecimal.setScale(n);
                }
                this.truncated_ = bigDecimal.scale() - n;
                return bigDecimal.setScale(n, 4);
            }
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        return new HexReaderInputStream(new StringReader(this.getString()));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        try {
            byte[] byArray = BinaryConverter.stringToBytes(this.getString());
            return new AS400JDBCBlob(byArray, byArray.length);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        String string = this.getString().trim();
        return string.length() > 0 && !string.equalsIgnoreCase("false") && !string.equals("0");
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        try {
            return new Double(this.getString().trim()).byteValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1;
        }
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        return new StringReader(this.getString());
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        String string = this.getString();
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        return SQLDate.stringToDate(this.getString(), this.settings_, calendar);
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        try {
            return new Double(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1.0;
        }
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        try {
            return new Double(this.getString().trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1.0f;
        }
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        try {
            return new Double(this.getString().trim()).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1;
        }
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        try {
            return new Double(this.getString().trim()).longValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1L;
        }
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return this.getString();
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        try {
            return new Double(this.getString().trim()).shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1;
        }
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length() > n && n > 0) {
            return this.value_.substring(0, n);
        }
        return this.value_;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        return SQLTime.stringToTime(this.getString(), this.settings_, calendar);
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        return SQLTimestamp.stringToTimestamp(this.getString(), calendar);
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ReaderInputStream((Reader)new StringReader(this.getString()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }
}

