/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class BidiOrdering
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 367063750196907253L;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private Vector list_ = new Vector();
    private transient Vector elementListeners;

    public BidiOrdering() {
    }

    public BidiOrdering(String string) {
        this();
        this.setDirection(string);
    }

    public BidiOrdering(String string, String string2) {
        this(string2);
        this.setLanguage(string);
    }

    public void addItem(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("data");
        }
        this.list_.addElement(hTMLTagElement);
        this.fireElementEvent(0);
    }

    public void addItem(String string) {
        if (string == null) {
            throw new NullPointerException("data");
        }
        this.list_.addElement(new HTMLText(string));
        this.fireElementEvent(0);
    }

    public void addItemElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    void clear() {
        this.list_.removeAllElements();
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public Vector getItems() {
        return this.list_;
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.dir_ == null) {
            Trace.log(2, "Attempting to get tag before setting direction.");
            throw new ExtendedIllegalStateException("dir", 4);
        }
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("\n<bdo");
        if (this.lang_ != null) {
            stringBuffer.append(" lang=\"" + this.lang_ + "\"");
        }
        stringBuffer.append(" dir=\"" + this.dir_ + "\"");
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.list_.elementAt(i);
            stringBuffer.append(hTMLTagElement.getTag());
        }
        stringBuffer.append("\n</bdo>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        if (this.dir_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting direction.");
            throw new ExtendedIllegalStateException("dir", 4);
        }
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("\n<fo:block-container");
        stringBuffer.append(" writing-mode='");
        if (this.dir_.equals("rtl")) {
            stringBuffer.append("rl'");
        } else {
            stringBuffer.append("lr'");
        }
        stringBuffer.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.list_.elementAt(i);
            stringBuffer.append(hTMLTagElement.getFOTag());
        }
        stringBuffer.append("</fo:block-container>\n");
        return stringBuffer.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public void removeItem(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("data");
        }
        if (this.list_.removeElement(hTMLTagElement)) {
            this.fireElementEvent(2);
        }
    }

    public void removeItemElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setDirection(String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

