/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.DirFilter;
import com.ibm.as400.util.html.HTMLTreeElement;
import com.ibm.as400.util.servlet.ServletHyperlink;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FileTreeElement
extends HTMLTreeElement
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = 210948696422108527L;
    private File file_;
    private boolean populated_ = false;
    private String parameter_;
    private String shareName_;
    private String sharePath_;
    private int patternMatching_ = -1;

    public FileTreeElement() {
    }

    public FileTreeElement(File file) {
        this.setFile(file);
        this.setText(file.getName());
    }

    public FileTreeElement(File file, String string) {
        this.setFile(file);
        this.setText(file.getName());
        this.parameter_ = string;
    }

    public FileTreeElement(File file, String string, String string2) {
        this.setFile(file);
        this.setShareName(string);
        this.setSharePath(string2);
    }

    public FileTreeElement(File file, String string, String string2, String string3) {
        this.setFile(file);
        this.setShareName(string);
        this.setSharePath(string2);
        this.parameter_ = string3;
    }

    private void addProperties() {
        if (this.getTextUrl() != null) {
            ServletHyperlink servletHyperlink = (ServletHyperlink)this.getTextUrl().clone();
            if (this.shareName_ != null) {
                String string = this.file_.getAbsolutePath().replace('\\', '/');
                if (this.sharePath_.charAt(0) != '/') {
                    string = string.substring(1);
                }
                if (Trace.isTraceOn()) {
                    Trace.log(3, "FileTree absolute path: " + string);
                    Trace.log(3, "FileTree share path:    " + this.sharePath_);
                }
                StringBuffer stringBuffer = new StringBuffer(this.shareName_);
                String string2 = string.substring(this.sharePath_.length());
                if (string2.length() > 0 && string2.charAt(0) != '/') {
                    stringBuffer.append('/');
                }
                stringBuffer.append(string2);
                if (this.parameter_ != null) {
                    Properties properties = servletHyperlink.getProperties();
                    if (properties == null) {
                        properties = new Properties();
                    }
                    ((Hashtable)properties).put(this.parameter_, stringBuffer.toString());
                    try {
                        servletHyperlink.setProperties(properties);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    servletHyperlink.setPathInfo(stringBuffer.toString());
                }
            } else {
                String string = this.file_.getAbsolutePath().replace('\\', '/');
                if (this.parameter_ != null) {
                    Properties properties = servletHyperlink.getProperties();
                    if (properties == null) {
                        properties = new Properties();
                    }
                    ((Hashtable)properties).put(this.parameter_, string);
                    try {
                        servletHyperlink.setProperties(properties);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    servletHyperlink.setPathInfo(string);
                }
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "FileTree path Info:    " + servletHyperlink.getPathInfo());
            }
            try {
                servletHyperlink.setText(this.file_.getName());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setTextUrl(servletHyperlink);
        }
    }

    public File getFile() {
        return this.file_;
    }

    public String getShareName() {
        if (this.shareName_ == null) {
            return null;
        }
        return this.shareName_;
    }

    public String getSharePath() {
        if (this.sharePath_ == null) {
            return null;
        }
        return this.sharePath_;
    }

    public boolean isLeaf() {
        if (this.getTextUrl() != null) {
            this.addProperties();
        }
        if (!this.populated_) {
            return this.file_.isFile();
        }
        return super.isLeaf();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void selected(int n) {
        if (n == this.hashCode() && this.file_.isDirectory() && !this.populated_) {
            Object[] objectArray;
            Serializable serializable;
            Object[] objectArray2;
            if (this.file_ instanceof IFSJavaFile) {
                block28: {
                    if (this.patternMatching_ != -1) {
                        try {
                            ((IFSJavaFile)this.file_).setPatternMatching(this.patternMatching_);
                        }
                        catch (IOException iOException) {
                            if (!Trace.isTraceOn()) break block28;
                            Trace.log(2, iOException);
                        }
                    }
                }
                objectArray2 = ((IFSJavaFile)this.file_).listFiles();
                serializable = new Vector<Object>();
                for (int i = 0; i < objectArray2.length; ++i) {
                    if (!((File)objectArray2[i]).isDirectory()) continue;
                    ((Vector)serializable).addElement(objectArray2[i]);
                }
                objectArray = new File[((Vector)serializable).size()];
                ((Vector)serializable).copyInto(objectArray);
            } else {
                objectArray2 = this.file_.list(new DirFilter());
                objectArray = new File[objectArray2.length];
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray[i] = new File(this.file_, (String)objectArray2[i]);
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                serializable = this.shareName_ != null ? new FileTreeElement((File)objectArray[i], this.shareName_, this.sharePath_, this.parameter_) : new FileTreeElement((File)objectArray[i], this.parameter_);
                if (this.patternMatching_ != -1) {
                    ((FileTreeElement)serializable).setPatternMatching(this.patternMatching_);
                }
                if (this.getTextUrl() != null) {
                    Serializable serializable2;
                    String string;
                    ServletHyperlink servletHyperlink = (ServletHyperlink)this.getTextUrl().clone();
                    if (this.shareName_ != null) {
                        string = this.file_.getAbsolutePath().replace('\\', '/');
                        if (this.sharePath_.charAt(0) != '/') {
                            string = string.substring(1);
                        }
                        if (Trace.isTraceOn()) {
                            Trace.log(3, "FileTree absolute path: " + string);
                        }
                        serializable2 = new StringBuffer(this.shareName_);
                        String string2 = string.substring(this.sharePath_.length());
                        if (string2.charAt(0) != '/') {
                            ((StringBuffer)serializable2).append('/');
                        }
                        ((StringBuffer)serializable2).append(string2);
                        if (this.parameter_ != null) {
                            Properties properties = servletHyperlink.getProperties();
                            if (properties == null) {
                                properties = new Properties();
                            }
                            ((Hashtable)properties).put(this.parameter_, ((StringBuffer)serializable2).toString());
                            try {
                                servletHyperlink.setProperties(properties);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            servletHyperlink.setPathInfo(((StringBuffer)serializable2).toString());
                        }
                    } else {
                        string = ((File)objectArray[i]).getAbsolutePath().replace('\\', '/');
                        if (this.parameter_ != null) {
                            serializable2 = servletHyperlink.getProperties();
                            if (serializable2 == null) {
                                serializable2 = new Properties();
                            }
                            ((Hashtable)serializable2).put(this.parameter_, string);
                            try {
                                servletHyperlink.setProperties((Properties)serializable2);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            servletHyperlink.setPathInfo(string);
                        }
                    }
                    try {
                        servletHyperlink.setText(((File)objectArray[i]).getName());
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ((HTMLTreeElement)serializable).setTextUrl(servletHyperlink);
                }
                ((HTMLTreeElement)serializable).setIconUrl((ServletHyperlink)this.getIconUrl().clone());
                this.addElement((HTMLTreeElement)serializable);
            }
            this.populated_ = true;
        }
        super.selected(n);
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        File file2 = this.file_;
        this.file_ = file;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("file", file2, this.file_);
        }
    }

    public void setShareName(String string) {
        if (string == null) {
            throw new NullPointerException("shareName");
        }
        String string2 = this.shareName_;
        this.shareName_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("shareName", string2, this.shareName_);
        }
    }

    public void setSharePath(String string) {
        if (string == null) {
            throw new NullPointerException("sharePath");
        }
        String string2 = this.sharePath_;
        this.sharePath_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("sharePath", string2, this.sharePath_);
        }
    }

    public void setPatternMatching(int n) {
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("patternMatching", 2);
        }
        this.patternMatching_ = n;
    }
}

