/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLParameter
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6620025554753779980L;
    private String name_;
    private String value_;

    public HTMLParameter() {
    }

    public HTMLParameter(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLParameter was here -->";
    }

    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting HTML parameter name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.value_ == null) {
            Trace.log(2, "Attempting to get tag before setting HTML parameter value.");
            throw new ExtendedIllegalStateException("value", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<param");
        stringBuffer.append(" name=\"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\"");
        stringBuffer.append(" value=\"");
        stringBuffer.append(this.getValue());
        stringBuffer.append("\"");
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        String string2 = this.name_;
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setValue(String string) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("value", 1);
        }
        String string2 = this.value_;
        this.value_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

