/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTagElement;

public class HTMLTableHeader
extends HTMLTableCell {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6954665365850223957L;
    private boolean useFO_ = false;
    private int borderWidth_ = 1;
    private int cellPadding_ = 1;

    public HTMLTableHeader() {
    }

    public HTMLTableHeader(HTMLTagElement hTMLTagElement) {
        super(hTMLTagElement);
    }

    public String getTag() {
        return this.getTag(this.getElement());
    }

    public String getFOTag() {
        return this.getFOTag(this.getElement());
    }

    public String getFOTag(HTMLTagElement hTMLTagElement) {
        String string;
        int n;
        int n2;
        int n3;
        boolean bl = this.useFO_;
        this.setUseFO(true);
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        StringBuffer stringBuffer = new StringBuffer("<fo:table-cell border-style='solid' border-width='");
        stringBuffer.append(this.borderWidth_);
        stringBuffer.append("px'");
        stringBuffer.append(" padding='");
        stringBuffer.append(this.cellPadding_);
        stringBuffer.append("px'");
        int n4 = this.getHeight();
        if (n4 > 1) {
            stringBuffer.append(" height='");
            stringBuffer.append(n4);
            if (this.isHeightInPercent()) {
                stringBuffer.append("%");
            }
            stringBuffer.append("'");
        }
        if ((n3 = this.getWidth()) > 1) {
            stringBuffer.append(" width='");
            stringBuffer.append(n3);
            if (this.isWidthInPercent()) {
                stringBuffer.append("%");
            }
            stringBuffer.append("'");
        }
        if ((n2 = this.getColumnSpan()) > 1) {
            stringBuffer.append(" number-columns-spanned='");
            stringBuffer.append(n2);
            stringBuffer.append("'");
        }
        if ((n = this.getRowSpan()) > 1) {
            stringBuffer.append(" number-rows-spanned='");
            stringBuffer.append(n);
            stringBuffer.append("'");
        }
        stringBuffer.append(">\n");
        stringBuffer.append("<fo:block font-weight='bold'");
        String string2 = this.getDirection();
        if (string2 != null && string2.length() > 0) {
            if (string2.equals("rtl")) {
                stringBuffer.append(" writing-mode='rl'");
            } else {
                stringBuffer.append(" writing-mode='lr'");
            }
        }
        if ((string = this.getHorizontalAlignment()) != null) {
            stringBuffer.append(" text-align='");
            if (string.equals("center")) {
                stringBuffer.append("center");
            } else if (string.equals("left")) {
                stringBuffer.append("start");
            } else if (string.equals("right")) {
                stringBuffer.append("end");
            }
            stringBuffer.append("'");
        }
        stringBuffer.append(">");
        stringBuffer.append(hTMLTagElement.getFOTag());
        stringBuffer.append("</fo:block>\n");
        stringBuffer.append("</fo:table-cell>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public String getTag(HTMLTagElement hTMLTagElement) {
        if (this.useFO_) {
            return this.getFOTag(hTMLTagElement);
        }
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        StringBuffer stringBuffer = new StringBuffer("<th");
        stringBuffer.append(this.getAttributeTag());
        stringBuffer.append(hTMLTagElement.getTag());
        stringBuffer.append("</th>\n");
        return stringBuffer.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public void setBorderWidth(int n) {
        Integer n2 = new Integer(this.borderWidth_);
        Integer n3 = new Integer(n);
        this.borderWidth_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", n2, n3);
        }
    }

    public void setCellPadding(int n) {
        Integer n2 = new Integer(this.cellPadding_);
        Integer n3 = new Integer(n);
        this.cellPadding_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", n2, n3);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

