/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.FormInput;
import com.ibm.as400.util.html.HTMLConstants;
import java.beans.PropertyVetoException;

public class ImageFormInput
extends FormInput
implements HTMLConstants {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 3208810620206338498L;
    private int height_ = 0;
    private int width_ = 0;
    private String align_ = "top";
    private String source_;

    public ImageFormInput() {
    }

    public ImageFormInput(String string) {
        super(string);
    }

    public ImageFormInput(String string, String string2) {
        super(string);
        try {
            this.setSource(string2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getAlignment() {
        return this.align_;
    }

    private String getAttributeTag() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.source_ != null && this.source_.length() > 0) {
            stringBuffer.append(" src=\"" + this.source_ + "\"");
        }
        stringBuffer.append(" align=\"");
        stringBuffer.append(this.align_);
        stringBuffer.append("\"");
        if (this.height_ > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using height attribute tag.");
            }
            stringBuffer.append(" height=\"" + this.height_ + "\"");
        }
        if (this.width_ > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using width attribute tag.");
            }
            stringBuffer.append(" width=\"" + this.width_ + "\"");
        }
        return stringBuffer.toString();
    }

    public int getHeight() {
        return this.height_;
    }

    public String getSource() {
        return this.source_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An ImageFormInput was here -->";
    }

    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.getSource() == null) {
            Trace.log(2, "Attempting to get tag before setting source.");
            throw new ExtendedIllegalStateException("source", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<input type=\"image\"");
        stringBuffer.append(this.getNameAttributeTag());
        stringBuffer.append(this.getValueAttributeTag(true));
        stringBuffer.append(this.getAttributeTag());
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(" />");
        return stringBuffer.toString();
    }

    public int getWidth() {
        return this.width_;
    }

    public void setAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("align");
        }
        if (!(string.equals("baseline") || string.equals("bottom") || string.equals("absbottom") || string.equals("left") || string.equals("right") || string.equals("middle") || string.equals("absmiddle") || string.equals("top") || string.equals("texttop"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        String string2 = this.align_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("align", string2, string);
        }
        this.align_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", string2, string);
        }
    }

    public void setHeight(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int n2 = this.height_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("height", new Integer(n2), new Integer(n));
        }
        this.height_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", new Integer(n2), new Integer(n));
        }
    }

    public void setSource(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("source", 2);
        }
        String string2 = this.source_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("source", string2, string);
        }
        this.source_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("source", string2, string);
        }
    }

    public void setWidth(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int n2 = this.width_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("width", new Integer(n2), new Integer(n));
        }
        this.width_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", new Integer(n2), new Integer(n));
        }
    }
}

