/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLListItem;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;

public class OrderedListItem
extends HTMLListItem {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -5825465966031878506L;
    private String type_;
    private int value_ = -1;

    public OrderedListItem() {
    }

    public OrderedListItem(HTMLTagElement hTMLTagElement) {
        this.setItemData(hTMLTagElement);
    }

    public String getType() {
        return this.type_;
    }

    public int getValue() {
        return this.value_;
    }

    String getTypeAttribute() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.type_ != null) {
            if (this.type_.equals("numbers")) {
                stringBuffer.append(" type=\"1\"");
            } else if (this.type_.equals("capitals")) {
                stringBuffer.append(" type=\"A\"");
            } else if (this.type_.equals("lower_case")) {
                stringBuffer.append(" type=\"a\"");
            } else if (this.type_.equals("large_roman")) {
                stringBuffer.append(" type=\"I\"");
            } else if (this.type_.equals("small_roman")) {
                stringBuffer.append(" type=\"i\"");
            }
        }
        if (this.value_ > 0) {
            stringBuffer.append(" value=\"");
            stringBuffer.append(Integer.toString(this.value_));
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    String getTypeAttributeFO(String string, int n) {
        if (this.value_ > 0) {
            n = this.value_;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (string != null) {
            if (string.equals("numbers")) {
                stringBuffer.append(String.valueOf(n));
                stringBuffer.append(".");
            } else if (string.equals("capitals")) {
                char c = (char)(64 + n);
                stringBuffer.append(c);
                stringBuffer.append(".");
            } else if (string.equals("lower_case")) {
                char c = (char)(96 + n);
                stringBuffer.append(c);
                stringBuffer.append(".");
            } else if (string.equals("large_roman")) {
                stringBuffer.append(this.toRoman(n));
                stringBuffer.append(".");
            } else if (string.equals("small_roman")) {
                stringBuffer.append(this.toRoman(n).toLowerCase());
                stringBuffer.append(".");
            }
        }
        return stringBuffer.toString();
    }

    String toRoman(int n) {
        StringBuffer stringBuffer = new StringBuffer(20);
        while (n >= 1000) {
            stringBuffer.append("M");
            n -= 1000;
        }
        if (n >= 900) {
            stringBuffer.append("CM");
            n -= 900;
        }
        if (n >= 500) {
            stringBuffer.append("D");
            n -= 500;
        }
        if (n >= 400) {
            stringBuffer.append("CD");
            n -= 400;
        }
        while (n >= 100) {
            stringBuffer.append("C");
            n -= 100;
        }
        if (n >= 90) {
            stringBuffer.append("XC");
            n -= 90;
        }
        if (n >= 50) {
            stringBuffer.append("L");
            n -= 50;
        }
        if (n >= 40) {
            stringBuffer.append("XL");
            n -= 40;
        }
        while (n >= 10) {
            stringBuffer.append("X");
            n -= 10;
        }
        if (n >= 9) {
            stringBuffer.append("IX");
            n -= 9;
        }
        if (n >= 5) {
            stringBuffer.append("V");
            n -= 5;
        }
        if (n >= 4) {
            stringBuffer.append("IV");
            n -= 4;
        }
        while (n >= 1) {
            stringBuffer.append("I");
            --n;
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setType(String string) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        if (!(string.equals("numbers") || string.equals("capitals") || string.equals("lower_case") || string.equals("large_roman") || string.equals("small_roman"))) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting order labeling type for <ol>.");
        }
        String string2 = this.type_;
        this.type_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", string2, string);
        }
    }

    public void setValue(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("value", 4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting current <li> number for <ol>.");
        }
        int n2 = this.value_;
        this.value_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", new Integer(n2), new Integer(n));
        }
    }
}

