/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLList;
import java.io.IOException;
import java.io.ObjectInputStream;

public class UnorderedList
extends HTMLList {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -8234261579413831795L;
    private String type_;

    public UnorderedList() {
    }

    public UnorderedList(String string) {
        this.setType(string);
    }

    private String getTypeAttributeTag() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.type_ != null) {
            if (this.type_.equals("disc")) {
                stringBuffer.append(" type=\"disc\"");
            } else if (this.type_.equals("square")) {
                stringBuffer.append(" type=\"square\"");
            } else if (this.type_.equals("circle")) {
                stringBuffer.append(" type=\"circle\"");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String getType() {
        return this.type_;
    }

    public String getTag() {
        if (this.isUseFO()) {
            return this.getFOTag();
        }
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<ul");
        stringBuffer.append(this.getTypeAttributeTag());
        if (this.isCompact()) {
            stringBuffer.append(" compact=\"compact\"");
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        stringBuffer.append(this.getItemAttributeTag());
        stringBuffer.append("</ul>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.isUseFO();
        this.setUseFO(true);
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        if (this.type_ == null) {
            this.type_ = "disc";
        }
        StringBuffer stringBuffer = new StringBuffer("<fo:block-container");
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">\n");
        stringBuffer.append("<fo:list-block");
        stringBuffer.append(">\n");
        stringBuffer.append(this.getItemAttributeFOTag(this.type_));
        stringBuffer.append("</fo:list-block>\n");
        stringBuffer.append("</fo:block-container>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setType(String string) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        if (!(string.equals("disc") || string.equals("circle") || string.equals("square"))) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        String string2 = this.type_;
        this.type_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", string2, string);
        }
    }
}

