/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.Log;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.ResourceBundleLoader_s;
import com.ibm.as400.util.servlet.ServletEventLog;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class AuthenticationServlet
extends HttpServlet {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 3761917964251765027L;
    private String realm_ = "localhost";
    private String realmDisplayName_;
    private Hashtable sessionTable_ = new Hashtable();
    private Log log_;
    private static ResourceBundleLoader_s loader_;

    public AuthenticationServlet() {
    }

    public AuthenticationServlet(String string, String string2, String string3) {
        this.setUser(string);
        this.setPassword(string2);
        this.setRealm(string3);
    }

    public boolean bypassAuthentication(HttpServletRequest httpServletRequest) {
        return false;
    }

    public Log getLog() {
        return this.log_;
    }

    public String getUser() {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        Properties properties = (Properties)this.sessionTable_.get(string);
        return properties.getProperty("uid");
    }

    public String getRealm() {
        return this.realm_;
    }

    Hashtable getSessionData() {
        return this.sessionTable_;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.log_ = new ServletEventLog(servletConfig);
        super.init(servletConfig);
        this.setRealm("localhost");
    }

    public void log(String string) {
        if (this.log_ != null) {
            this.log_.log(string);
        }
    }

    public void log(Exception exception, String string) {
        if (this.log_ != null) {
            this.log_.log(string, exception);
        }
    }

    private void sendAuthenticationResponse(HttpServletResponse httpServletResponse, String string) throws IOException {
        this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_CHALLENGE"), new String[]{this.realmDisplayName_}));
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("Www-authenticate", "Basic realm=\"" + this.realmDisplayName_ + "\"");
        httpServletResponse.setContentType("text/html");
    }

    public void setLog(Log log) {
        if (log == null) {
            throw new NullPointerException("log");
        }
        this.log_ = log;
    }

    public void setPassword(String string) {
        if (string == null) {
            throw new NullPointerException("password");
        }
        Thread thread = Thread.currentThread();
        String string2 = thread.getName();
        Properties properties = (Properties)this.sessionTable_.get(string2);
        if (properties == null) {
            properties = new Properties();
        }
        ((Hashtable)properties).put("pw", string);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_SERVICE"), new String[]{httpServletRequest.getRemoteHost(), httpServletRequest.getRemoteAddr()}));
        if (!this.bypassAuthentication(httpServletRequest)) {
            String string = httpServletRequest.getHeader("Authorization");
            if (string != null) {
                String string2;
                String string3;
                int n = string.indexOf(" ");
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byte[] byArray = bASE64Decoder.decodeBuffer(string = string.substring(n + 1));
                String string4 = new String(byArray);
                if ((n = string4.indexOf(":")) == -1) {
                    string3 = string4;
                    string2 = "";
                    Trace.log(3, "Missing ':' (colon) in authorization header.");
                } else {
                    string3 = string4.substring(0, n);
                    string2 = string4.substring(n + 1);
                }
                try {
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATING"), new String[]{this.realm_, string3}));
                    if (!this.validateAuthority(this.realm_, string3, string2)) {
                        return;
                    }
                    Thread thread = Thread.currentThread();
                    String string5 = thread.getName();
                    Properties properties = new Properties();
                    ((Hashtable)properties).put("realm", this.realm_);
                    ((Hashtable)properties).put("uid", string3);
                    ((Hashtable)properties).put("pwd", string2);
                    this.sessionTable_.put(string5, properties);
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATED"), new String[]{this.realm_, string3}));
                    if (!this.postValidation(httpServletRequest, httpServletResponse)) {
                        return;
                    }
                    super.service(httpServletRequest, httpServletResponse);
                    this.sessionTable_.remove(string5);
                }
                catch (SecurityException securityException) {
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATEFAILED"), new String[]{string3, securityException.getMessage()}));
                    if (Trace.isTraceOn()) {
                        Trace.log(2, securityException);
                    }
                    this.sendAuthenticationResponse(httpServletResponse, this.realmDisplayName_);
                }
                catch (Exception exception) {
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_REQFAILED"), new String[]{string3, exception.getMessage()}));
                    if (Trace.isTraceOn()) {
                        Trace.log(2, exception);
                    }
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    if (exception instanceof ServletException) {
                        throw (ServletException)((Object)exception);
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new ServletException(exception.getMessage());
                }
                this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_REQCOMPLETED"), new String[]{httpServletRequest.getRemoteHost(), httpServletRequest.getRemoteAddr()}));
                return;
            }
            this.sendAuthenticationResponse(httpServletResponse, this.realmDisplayName_);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    public void setRealm(String string) {
        if (string == null) {
            throw new NullPointerException("realm");
        }
        if (string.equalsIgnoreCase("localhost")) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.realm_ = this.realmDisplayName_ = inetAddress.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_REALMFAILED"));
                if (Trace.isTraceOn()) {
                    Trace.log(2, unknownHostException);
                }
                this.realm_ = string;
                this.realmDisplayName_ = string;
            }
        } else {
            this.realm_ = string;
            this.realmDisplayName_ = string;
        }
    }

    public void setUser(String string) {
        if (string == null) {
            throw new NullPointerException("user");
        }
        Thread thread = Thread.currentThread();
        String string2 = thread.getName();
        Properties properties = (Properties)this.sessionTable_.get(string2);
        if (properties == null) {
            properties = new Properties();
        }
        ((Hashtable)properties).put("uid", string);
    }

    public boolean validateAuthority(String string, String string2, String string3) throws SecurityException, IOException {
        return true;
    }

    public boolean postValidation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        return true;
    }
}

