/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.RowMetaDataType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ListMetaData
implements RowMetaData,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = -230291530342866669L;
    private int columnCount_ = 0;
    private String[] columnName_;
    private String[] columnLabel_;
    private int[] columnType_;
    private int[] columnSize_;
    private String[] columnAlignment_;
    private String[] columnDirection_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;

    public ListMetaData() {
    }

    public ListMetaData(int n) {
        this();
        try {
            this.setColumns(n);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public int getColumnCount() {
        return this.columnCount_;
    }

    public int getColumnDisplaySize(int n) {
        this.validateColumnIndex(n);
        return this.columnSize_[n];
    }

    public String getColumnLabel(int n) {
        this.validateColumnIndex(n);
        return this.columnLabel_[n];
    }

    public String getColumnName(int n) {
        this.validateColumnIndex(n);
        return this.columnName_[n];
    }

    public int getColumnType(int n) {
        this.validateColumnIndex(n);
        return this.columnType_[n];
    }

    public String getColumnAlignment(int n) {
        this.validateColumnIndex(n);
        return this.columnAlignment_[n];
    }

    public String getColumnDirection(int n) {
        this.validateColumnIndex(n);
        return this.columnDirection_[n];
    }

    public String getColumnTypeName(int n) {
        this.validateColumnIndex(n);
        if (this.columnType_[n] != 0) {
            return RowMetaDataType.getDataTypeName(this.columnType_[n]);
        }
        return null;
    }

    public int getPrecision(int n) {
        this.validateColumnIndex(n);
        return 0;
    }

    public int getScale(int n) {
        this.validateColumnIndex(n);
        return 0;
    }

    public boolean isNumericData(int n) {
        return RowMetaDataType.isNumericData(this.getColumnType(n));
    }

    public boolean isTextData(int n) {
        return RowMetaDataType.isTextData(this.getColumnType(n));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setColumnAlignment(int n, String string) {
        this.validateColumnIndex(n);
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (!(string.equals("left") || string.equals("right") || string.equals("center") || string.equals("justify"))) {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
        this.columnAlignment_[n] = string;
    }

    public void setColumnDirection(int n, String string) {
        this.validateColumnIndex(n);
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDirection_[n] = string;
    }

    public void setColumnDisplaySize(int n, int n2) {
        this.validateColumnIndex(n);
        if (n2 < 1) {
            throw new ExtendedIllegalArgumentException("displaySize", 4);
        }
        this.columnSize_[n] = n2;
    }

    public void setColumnLabel(int n, String string) {
        this.validateColumnIndex(n);
        if (string == null) {
            throw new NullPointerException("label");
        }
        this.columnLabel_[n] = string;
    }

    public void setColumnName(int n, String string) {
        this.validateColumnIndex(n);
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.columnName_[n] = string;
        if (this.columnLabel_[n] == null) {
            this.columnLabel_[n] = string;
        }
    }

    public void setColumns(int n) throws PropertyVetoException {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("columns", 4);
        }
        int n2 = this.columnCount_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("columns", new Integer(n2), new Integer(n));
        }
        this.columnCount_ = n;
        this.columnName_ = new String[this.columnCount_];
        this.columnLabel_ = new String[this.columnCount_];
        this.columnType_ = new int[this.columnCount_];
        this.columnSize_ = new int[this.columnCount_];
        this.columnAlignment_ = new String[this.columnCount_];
        this.columnDirection_ = new String[this.columnCount_];
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("columns", new Integer(n2), new Integer(n));
        }
    }

    public void setColumnType(int n, int n2) {
        this.validateColumnIndex(n);
        if (!RowMetaDataType.isDataTypeValid(n2)) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        this.columnType_[n] = n2;
    }

    private void validateColumnIndex(int n) {
        if (n < 0 || n >= this.columnCount_) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
    }
}

