/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowDataListener;
import com.ibm.as400.util.servlet.RowDataSupport;
import com.ibm.as400.util.servlet.RowMetaData;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class ListRowData
extends RowData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 1232409461443729991L;
    private RowMetaData metadata_;
    private transient RowDataSupport rowdataSupport_;

    public ListRowData() {
    }

    public ListRowData(RowMetaData rowMetaData) throws RowDataException {
        this();
        try {
            this.setMetaData(rowMetaData);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addRow(Object[] objectArray) throws RowDataException {
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to add a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        this.addRow(objectArray, new Vector[this.metadata_.getColumnCount()]);
    }

    public void addRow(Object[] objectArray, Vector[] vectorArray) throws RowDataException {
        this.validateRow(objectArray);
        this.validateProperties(vectorArray);
        this.rows_.addElement(objectArray);
        this.rowProperties_.addElement(vectorArray);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRow(Object[] objectArray, int n) throws RowDataException {
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to add a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        this.addRow(objectArray, new Vector[this.metadata_.getColumnCount()], n);
    }

    public void addRow(Object[] objectArray, Vector[] vectorArray, int n) throws RowDataException {
        this.validateRow(objectArray);
        this.validateProperties(vectorArray);
        if (n < 0 || n > this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.insertElementAt(objectArray, n);
        this.rowProperties_.insertElementAt(vectorArray, n);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRowDataListener(RowDataListener rowDataListener) {
        if (this.rowdataSupport_ == null) {
            this.rowdataSupport_ = new RowDataSupport(this);
        }
        this.rowdataSupport_.addRowDataListener(rowDataListener);
    }

    public RowMetaData getMetaData() {
        return this.metadata_;
    }

    public Object[] getRow() {
        this.validateRowList("Attempting to get the row object");
        this.validateListPosition("Attempting to get the row object");
        return (Object[])this.rows_.elementAt(this.position_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, RowDataException {
        objectInputStream.defaultReadObject();
    }

    public void removeRow(int n) {
        this.validateRowList("Attempting to remove a row");
        if (n < 0 || n >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.removeElementAt(n);
        this.rowProperties_.removeElementAt(n);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireRemoved();
        }
    }

    public void removeRowDataListener(RowDataListener rowDataListener) {
        if (rowDataListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.removeRowDataListener(rowDataListener);
        }
    }

    public void setMetaData(RowMetaData rowMetaData) throws RowDataException, PropertyVetoException {
        if (rowMetaData == null) {
            throw new NullPointerException("metaData");
        }
        if (rowMetaData.getColumnCount() == 0) {
            Trace.log(2, "The metadata parameter 'columns' is invalid.");
            throw new ExtendedIllegalStateException("metadata columns", 4);
        }
        RowMetaData rowMetaData2 = this.metadata_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("metadata", rowMetaData2, rowMetaData);
        }
        this.metadata_ = rowMetaData;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("metadata", rowMetaData2, rowMetaData);
        }
    }

    public void setRow(Object[] objectArray, int n) throws RowDataException {
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to add a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        this.setRow(objectArray, new Vector[this.metadata_.getColumnCount()], n);
    }

    public void setRow(Object[] objectArray, Vector[] vectorArray, int n) throws RowDataException {
        this.validateRowList("Attempting to change a row");
        this.validateRow(objectArray);
        if (n < 0 || n >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.validateProperties(vectorArray);
        this.rows_.setElementAt(objectArray, n);
        this.rowProperties_.setElementAt(vectorArray, n);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireChanged();
        }
    }

    private void validateProperties(Vector[] vectorArray) throws RowDataException {
        if (vectorArray == null) {
            throw new NullPointerException("properties");
        }
        if (vectorArray.length != this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("properties", 1);
        }
    }

    private void validateRow(Object[] objectArray) throws RowDataException {
        if (objectArray == null) {
            throw new NullPointerException("row");
        }
        if (this.metadata_ == null) {
            Trace.log(2, "Attempting to process a row before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
        if (objectArray.length != this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("row", 1);
        }
    }
}

