/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.AS400Array;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.RowMetaDataType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class RecordFormatMetaData
implements RowMetaData,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 5676240820170682074L;
    private RecordFormat recordFormat_;
    private transient String[] columnLabel_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private String[] columnAlignment_;
    private String[] columnDirection_;

    public RecordFormatMetaData() {
    }

    public RecordFormatMetaData(RecordFormat recordFormat) {
        try {
            this.setRecordFormat(recordFormat);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getColumnAlignment(int n) {
        this.validateRecordFormat("Attempting to get the column alignment");
        this.validateColumnIndex(n);
        return this.columnAlignment_[n];
    }

    public String getColumnDirection(int n) {
        this.validateRecordFormat("Attempting to get the column direction");
        this.validateColumnIndex(n);
        return this.columnDirection_[n];
    }

    public int getColumnCount() {
        if (this.recordFormat_ == null) {
            Trace.log(2, "Attempting to get the column count before setting the record format.");
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.recordFormat_.getNumberOfFields();
    }

    public int getColumnDisplaySize(int n) {
        this.validateRecordFormat("Attempting to get the column display size");
        this.validateColumnIndex(n);
        FieldDescription fieldDescription = this.recordFormat_.getFieldDescription(n);
        return fieldDescription.getLength();
    }

    public String getColumnLabel(int n) {
        this.validateRecordFormat("Attempting to get the column label");
        this.validateColumnIndex(n);
        String string = this.columnLabel_[n];
        if (string == null) {
            string = this.getColumnName(n);
        }
        this.columnLabel_[n] = string;
        return string;
    }

    public String getColumnName(int n) {
        this.validateRecordFormat("Attempting to get the column name");
        this.validateColumnIndex(n);
        FieldDescription fieldDescription = this.recordFormat_.getFieldDescription(n);
        return fieldDescription.getFieldName();
    }

    public int getColumnType(int n) {
        this.validateRecordFormat("Attempting to get the column type");
        this.validateColumnIndex(n);
        FieldDescription fieldDescription = this.recordFormat_.getFieldDescription(n);
        AS400DataType aS400DataType = fieldDescription.getDataType();
        if (aS400DataType instanceof AS400Bin2) {
            return 7;
        }
        if (aS400DataType instanceof AS400Bin4) {
            return 5;
        }
        if (aS400DataType instanceof AS400ByteArray) {
            return 1;
        }
        if (aS400DataType instanceof AS400Float4) {
            return 4;
        }
        if (aS400DataType instanceof AS400Float8) {
            return 3;
        }
        if (aS400DataType instanceof AS400PackedDecimal) {
            return 2;
        }
        if (aS400DataType instanceof AS400Structure) {
            return 1;
        }
        if (aS400DataType instanceof AS400Array) {
            return 1;
        }
        if (aS400DataType instanceof AS400Text) {
            return 8;
        }
        if (aS400DataType instanceof AS400UnsignedBin2) {
            return 5;
        }
        if (aS400DataType instanceof AS400UnsignedBin4) {
            return 6;
        }
        if (aS400DataType instanceof AS400ZonedDecimal) {
            return 2;
        }
        return 1;
    }

    public String getColumnTypeName(int n) {
        this.validateRecordFormat("Attempting to get the column type name");
        this.validateColumnIndex(n);
        FieldDescription fieldDescription = this.recordFormat_.getFieldDescription(n);
        AS400DataType aS400DataType = fieldDescription.getDataType();
        if (aS400DataType instanceof AS400Bin2) {
            return RowMetaDataType.getDataTypeName(7);
        }
        if (aS400DataType instanceof AS400Bin4) {
            return RowMetaDataType.getDataTypeName(5);
        }
        if (aS400DataType instanceof AS400ByteArray) {
            return RowMetaDataType.getDataTypeName(1);
        }
        if (aS400DataType instanceof AS400Float4) {
            return RowMetaDataType.getDataTypeName(4);
        }
        if (aS400DataType instanceof AS400Float8) {
            return RowMetaDataType.getDataTypeName(3);
        }
        if (aS400DataType instanceof AS400PackedDecimal) {
            return RowMetaDataType.getDataTypeName(2);
        }
        if (aS400DataType instanceof AS400Structure) {
            return RowMetaDataType.getDataTypeName(1);
        }
        if (aS400DataType instanceof AS400Array) {
            return RowMetaDataType.getDataTypeName(1);
        }
        if (aS400DataType instanceof AS400Text) {
            return RowMetaDataType.getDataTypeName(8);
        }
        if (aS400DataType instanceof AS400UnsignedBin2) {
            return RowMetaDataType.getDataTypeName(5);
        }
        if (aS400DataType instanceof AS400UnsignedBin4) {
            return RowMetaDataType.getDataTypeName(6);
        }
        if (aS400DataType instanceof AS400ZonedDecimal) {
            return RowMetaDataType.getDataTypeName(2);
        }
        return RowMetaDataType.getDataTypeName(1);
    }

    public int getPrecision(int n) {
        this.validateRecordFormat("Attempting to get the precision");
        this.validateColumnIndex(n);
        FieldDescription fieldDescription = this.recordFormat_.getFieldDescription(n);
        AS400DataType aS400DataType = fieldDescription.getDataType();
        if (aS400DataType instanceof AS400ZonedDecimal) {
            return ((AS400ZonedDecimal)aS400DataType).getNumberOfDigits();
        }
        if (aS400DataType instanceof AS400PackedDecimal) {
            return ((AS400PackedDecimal)aS400DataType).getNumberOfDigits();
        }
        return 0;
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    public int getScale(int n) {
        this.validateRecordFormat("Attempting to get the scale");
        this.validateColumnIndex(n);
        FieldDescription fieldDescription = this.recordFormat_.getFieldDescription(n);
        AS400DataType aS400DataType = fieldDescription.getDataType();
        if (aS400DataType instanceof AS400ZonedDecimal) {
            return ((AS400ZonedDecimal)aS400DataType).getNumberOfDecimalPositions();
        }
        if (aS400DataType instanceof AS400PackedDecimal) {
            return ((AS400PackedDecimal)aS400DataType).getNumberOfDecimalPositions();
        }
        return 0;
    }

    public boolean isNumericData(int n) {
        return RowMetaDataType.isNumericData(this.getColumnType(n));
    }

    public boolean isTextData(int n) {
        return RowMetaDataType.isTextData(this.getColumnType(n));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, RowDataException {
        objectInputStream.defaultReadObject();
        if (this.recordFormat_ != null) {
            try {
                this.setRecordFormat(this.recordFormat_);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setColumnAlignment(int n, String string) {
        this.validateRecordFormat("Attempting to set the column alignment");
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        this.validateColumnIndex(n);
        if (!(string.equals("left") || string.equals("right") || string.equals("center") || string.equals("justify"))) {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
        this.columnAlignment_[n] = string;
    }

    public void setColumnDirection(int n, String string) {
        this.validateRecordFormat("Attempting to set the column directionl");
        if (string == null) {
            throw new NullPointerException("dir");
        }
        this.validateColumnIndex(n);
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDirection_[n] = string;
    }

    public void setColumnLabel(int n, String string) {
        this.validateRecordFormat("Attempting to set the column label");
        if (string == null) {
            throw new NullPointerException("label");
        }
        this.validateColumnIndex(n);
        this.columnLabel_[n] = string;
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        RecordFormat recordFormat2 = this.recordFormat_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordFormat", recordFormat2, recordFormat);
        }
        this.recordFormat_ = recordFormat;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordFormat", recordFormat2, recordFormat);
        }
        int n = this.getColumnCount();
        this.columnLabel_ = new String[n];
        this.columnAlignment_ = new String[n];
        this.columnDirection_ = new String[n];
    }

    private void validateColumnIndex(int n) {
        if (n < 0 || n >= this.recordFormat_.getNumberOfFields()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
    }

    private void validateRecordFormat(String string) {
        if (this.recordFormat_ == null) {
            Trace.log(2, string + " before setting the record format.");
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
    }
}

