/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.command;

import com.vividsolutions.jtstest.command.Option;
import com.vividsolutions.jtstest.command.ParseException;
import java.util.Iterator;
import java.util.Vector;

public class OptionSpec {
    public static final int NARGS_ZERO_OR_MORE = -1;
    public static final int NARGS_ONE_OR_MORE = -2;
    public static final int NARGS_ZERO_OR_ONE = -3;
    public static final String OPTION_FREE_ARGS = "**FREE_ARGS**";
    String name;
    int nAllowedArgs = 0;
    String syntaxPattern;
    String argDoc = "";
    String doc = "";
    Vector options = new Vector();

    public OptionSpec(String string) {
        this.name = string;
        this.nAllowedArgs = 0;
    }

    public OptionSpec(String string, int n) {
        this(string);
        if (this.nAllowedArgs >= -3) {
            this.nAllowedArgs = n;
        }
    }

    public OptionSpec(String string, String string2) {
        this(string);
        this.syntaxPattern = string2;
    }

    public void setDoc(String string, String string2) {
        this.argDoc = string;
        this.doc = string2;
    }

    public String getArgDesc() {
        return this.argDoc;
    }

    public String getDocDesc() {
        return this.doc;
    }

    public int getNumOptions() {
        return this.options.size();
    }

    public Option getOption(int n) {
        if (this.options.size() > 0) {
            return (Option)this.options.elementAt(n);
        }
        return null;
    }

    public Iterator getOptions() {
        return this.options.iterator();
    }

    public boolean hasOption() {
        return this.options.size() > 0;
    }

    void addOption(Option option) {
        this.options.addElement(option);
    }

    String getName() {
        return this.name;
    }

    int getAllowedArgs() {
        return this.nAllowedArgs;
    }

    Option parse(String[] stringArray) throws ParseException {
        this.checkNumArgs(stringArray);
        return new Option(this, stringArray);
    }

    void checkNumArgs(String[] stringArray) throws ParseException {
        if (this.nAllowedArgs != -1) {
            if (this.nAllowedArgs == -2) {
                if (stringArray.length <= 0) {
                    throw new ParseException("option " + this.name + ": expected one or more args, found " + stringArray.length);
                }
            } else if (this.nAllowedArgs == -3) {
                if (stringArray.length > 1) {
                    throw new ParseException("option " + this.name + ": expected zero or one arg, found " + stringArray.length);
                }
            } else if (stringArray.length != this.nAllowedArgs) {
                throw new ParseException("option " + this.name + ": expected " + this.nAllowedArgs + " args, found " + stringArray.length);
            }
        }
    }
}

