/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jtstest.command.CommandLine;
import com.vividsolutions.jtstest.command.OptionSpec;
import com.vividsolutions.jtstest.command.ParseException;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.function.GeometryFunctionRegistry;
import com.vividsolutions.jtstest.geomop.GeometryMethodOperation;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testrunner.GeometryOperationLoader;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.UIManager;

public class JTSTestBuilder {
    private static final String OPT_GEOMOP = "geomop";
    private static final String OPT_GEOMFUNC = "geomfunc";
    private static GeometryOperation geometryOp = new GeometryMethodOperation();
    private static GeometryFunctionRegistry funcRegistry = new GeometryFunctionRegistry();
    private static CommandLine commandLine = JTSTestBuilder.createCmdLine();
    public static JTSTestBuilder app;
    private TestBuilderModel tbModel = new TestBuilderModel();
    boolean packFrame = false;
    static /* synthetic */ Class class$com$vividsolutions$jtstest$testrunner$TopologyTestApp;
    static /* synthetic */ Class class$com$vividsolutions$jtstest$testbuilder$JTSTestBuilder;

    public static Geometry getGeometryA() {
        return JTSTestBuilder.getInstance().getModel().getGeometryEditModel().getGeometry(0);
    }

    public static Geometry getGeometryB() {
        return JTSTestBuilder.getInstance().getModel().getGeometryEditModel().getGeometry(1);
    }

    private static CommandLine createCmdLine() {
        commandLine = new CommandLine('-');
        commandLine.addOptionSpec(new OptionSpec(OPT_GEOMOP, 1));
        commandLine.addOptionSpec(new OptionSpec(OPT_GEOMFUNC, 1));
        return commandLine;
    }

    public static GeometryOperation getGeometryOperation() {
        return geometryOp;
    }

    public static GeometryFunctionRegistry getFunctionRegistry() {
        return funcRegistry;
    }

    public static JTSTestBuilder getInstance() {
        return app;
    }

    public static PrecisionModel getPrecisionModel() {
        return app.getModel().getPrecisionModel();
    }

    public static GeometryFactory getGeometryFactory() {
        return app.getModel().getGeometryFactory();
    }

    private void initFrame() {
        JTSTestBuilderFrame jTSTestBuilderFrame = new JTSTestBuilderFrame();
        jTSTestBuilderFrame.setModel(this.getModel());
        if (this.packFrame) {
            jTSTestBuilderFrame.pack();
        } else {
            jTSTestBuilderFrame.validate();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jTSTestBuilderFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        jTSTestBuilderFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jTSTestBuilderFrame.setVisible(true);
    }

    public TestBuilderModel getModel() {
        return this.tbModel;
    }

    public static void main(String[] stringArray) {
        try {
            JTSTestBuilder.readArgs(stringArray);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        app = new JTSTestBuilder();
        app.initFrame();
    }

    private static void readArgs(String[] stringArray) throws ParseException {
        String string;
        commandLine.parse(stringArray);
        if (commandLine.hasOption(OPT_GEOMOP)) {
            string = commandLine.getOption(OPT_GEOMOP).getArg(0);
            geometryOp = GeometryOperationLoader.createGeometryOperation((class$com$vividsolutions$jtstest$testrunner$TopologyTestApp == null ? (class$com$vividsolutions$jtstest$testrunner$TopologyTestApp = JTSTestBuilder.class$("com.vividsolutions.jtstest.testrunner.TopologyTestApp")) : class$com$vividsolutions$jtstest$testrunner$TopologyTestApp).getClassLoader(), string);
            if (geometryOp == null) {
                System.exit(0);
            }
            System.out.println("Using Geometry Operation: " + string);
        }
        if (commandLine.hasOption(OPT_GEOMFUNC)) {
            string = commandLine.getOption(OPT_GEOMFUNC).getArg(0);
            GeometryFunction geometryFunction = JTSTestBuilder.createGeometryFunction((class$com$vividsolutions$jtstest$testbuilder$JTSTestBuilder == null ? (class$com$vividsolutions$jtstest$testbuilder$JTSTestBuilder = JTSTestBuilder.class$("com.vividsolutions.jtstest.testbuilder.JTSTestBuilder")) : class$com$vividsolutions$jtstest$testbuilder$JTSTestBuilder).getClassLoader(), string);
            if (geometryOp == null) {
                System.exit(0);
            }
            System.out.println("Adding Geometry Function: " + string);
            funcRegistry.add(geometryFunction);
        }
    }

    public static GeometryFunction createGeometryFunction(ClassLoader classLoader, String string) {
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ERROR: Class not found - " + string);
            return null;
        }
        try {
            GeometryFunction geometryFunction = (GeometryFunction)clazz.newInstance();
            return geometryFunction;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

