/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.util.ExceptionFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ResultWKTPanel
extends JPanel {
    TestBuilderModel tbModel = null;
    Object currResult = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel lblYellowResult = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea txtResult = new JTextArea();
    JPanel labelPanel = new JPanel();
    JLabel resultLabel = new JLabel();
    BorderLayout labelPanelLayout = new BorderLayout();
    JPanel rPanel = new JPanel();
    JButton copyButton = new JButton();
    JButton copyToTestButton = new JButton();
    JPanel rButtonPanel = new JPanel();
    GridLayout rButtonPanelLayout = new GridLayout();
    BorderLayout rPanelLayout = new BorderLayout();
    BorderLayout tabPanelLayout = new BorderLayout();
    private final ImageIcon copyIcon = new ImageIcon(this.getClass().getResource("Copy.gif"));
    private final ImageIcon copyToTestIcon = new ImageIcon(this.getClass().getResource("CopyToTest.png"));

    public ResultWKTPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.tabPanelLayout);
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.lblYellowResult.setFont(new Font("Dialog", 1, 12));
        this.lblYellowResult.setForeground(Color.YELLOW);
        this.lblYellowResult.setText("Result");
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.copyButton.setToolTipText("Copy Result");
        this.copyButton.setIcon(this.copyIcon);
        this.copyButton.setMargin(new Insets(0, 0, 0, 0));
        this.copyToTestButton.setToolTipText("Copy Result to new Test");
        this.copyToTestButton.setIcon(this.copyToTestIcon);
        this.copyToTestButton.setMargin(new Insets(0, 0, 0, 0));
        this.rButtonPanelLayout = new GridLayout(2, 1);
        this.rButtonPanelLayout.setVgap(1);
        this.rButtonPanelLayout.setHgap(1);
        this.rButtonPanel.setLayout(this.rButtonPanelLayout);
        this.rButtonPanel.add(this.copyButton);
        this.rButtonPanel.add(this.copyToTestButton);
        this.rPanel.setLayout(this.rPanelLayout);
        this.rPanel.add((Component)this.rButtonPanel, "North");
        this.txtResult.setWrapStyleWord(true);
        this.txtResult.setLineWrap(true);
        this.txtResult.setBackground(SystemColor.control);
        this.labelPanel.setLayout(this.labelPanelLayout);
        this.labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 2, 2));
        this.labelPanel.add(this.resultLabel);
        this.resultLabel.setText("Result");
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.labelPanel, "North");
        this.add((Component)this.rPanel, "East");
        this.jScrollPane1.getViewport().add((Component)this.txtResult, null);
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultWKTPanel.this.rCopyButton_actionPerformed(actionEvent);
            }
        });
        this.copyToTestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultWKTPanel.this.copyToTestButton_actionPerformed(actionEvent);
            }
        });
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
    }

    public void setResult(String string, String string2, Object object) {
        this.currResult = object;
        this.resultLabel.setText("Result of: " + string + "    ( " + string2 + " )");
        if (object == null) {
            this.setString("");
        } else if (object instanceof Geometry) {
            this.setGeometry((Geometry)object);
        } else if (object instanceof Throwable) {
            this.setError((Throwable)object);
        } else {
            this.setString(object.toString());
        }
    }

    public Object getResult() {
        return this.currResult;
    }

    public void setGeometry(Geometry geometry) {
        this.txtResult.setText(this.tbModel.getResultDisplayString(geometry));
        this.txtResult.setBackground(SystemColor.control);
    }

    public void setString(String string) {
        this.txtResult.setText(string);
        this.txtResult.setBackground(SystemColor.control);
    }

    public void setError(Throwable throwable) {
        String string = ExceptionFormatter.getFullString(throwable);
        this.txtResult.setText(string);
        this.txtResult.setBackground(Color.pink);
    }

    void rCopyButton_actionPerformed(ActionEvent actionEvent) {
        this.txtResult.selectAll();
        this.txtResult.copy();
    }

    void copyToTestButton_actionPerformed(ActionEvent actionEvent) {
        JTSTestBuilderFrame.getInstance().copyResultToTest();
    }
}

