/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.testbuilder.GeometryEditControlPanel;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.RelatePanel;
import com.vividsolutions.jtstest.testbuilder.ScalarFunctionPanel;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanel;
import com.vividsolutions.jtstest.testbuilder.ValidPanel;
import com.vividsolutions.jtstest.testbuilder.ValidPanelEvent;
import com.vividsolutions.jtstest.testbuilder.ValidPanelListener;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEvent;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestCasePanel
extends JPanel {
    TestCaseEdit testCase;
    BorderLayout borderLayout1 = new BorderLayout();
    GeometryEditPanel editPanel = new GeometryEditPanel();
    ButtonGroup geometryType = new ButtonGroup();
    ButtonGroup editMode = new ButtonGroup();
    ButtonGroup partType = new ButtonGroup();
    Border border4;
    JPanel editGroupPanel = new JPanel();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel btnPanel = new JPanel();
    JPanel relateTabPanel = new JPanel();
    JButton btnRunTests = new JButton();
    RelatePanel relatePanel = new RelatePanel();
    BorderLayout borderLayout2 = new BorderLayout();
    GeometryEditControlPanel editCtlPanel = new GeometryEditControlPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JTextField txtDesc = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    SpatialFunctionPanel spatialFunctionPanel = new SpatialFunctionPanel();
    private int currentTestCaseIndex = 0;
    private int maxTestCaseIndex = 0;
    private boolean initialized = false;
    JPanel casePrecisionModelPanel = new JPanel();
    JPanel namePanel = new JPanel();
    JLabel testCaseIndexLabel = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel precisionModelLabel = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel1 = new JLabel();
    JButton btnSetPrecisionModel = new JButton();
    ValidPanel validPanel = new ValidPanel();
    JPanel jPanel2 = new JPanel();
    JLabel txtMousePos = new JLabel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JTextField txtSelectedPoint = new JTextField();
    ScalarFunctionPanel scalarFunctionPanel = new ScalarFunctionPanel();
    private TestBuilderModel tbModel;

    public TestCasePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initialized = true;
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
        this.editPanel.setModel(testBuilderModel);
        this.editCtlPanel.setModel(testBuilderModel);
    }

    public void setCurrentTestCaseIndex(int n) {
        this.currentTestCaseIndex = n;
        this.updateTestCaseIndexLabel();
    }

    public void setMaxTestCaseIndex(int n) {
        this.maxTestCaseIndex = n;
        this.updateTestCaseIndexLabel();
    }

    public GeometryEditControlPanel getGeometryEditControlPanel() {
        return this.editCtlPanel;
    }

    public GeometryEditPanel getGeometryEditPanel() {
        return this.editPanel;
    }

    public SpatialFunctionPanel getSpatialFunctionPanel() {
        return this.spatialFunctionPanel;
    }

    public ScalarFunctionPanel getScalarFunctionPanel() {
        return this.scalarFunctionPanel;
    }

    void setTestCase(TestCaseEdit testCaseEdit) {
        this.testCase = testCaseEdit;
        this.tbModel.getGeometryEditModel().setTestCase(testCaseEdit);
        this.relatePanel.setTestCase(testCaseEdit);
        this.validPanel.setTestCase(testCaseEdit);
        this.txtDesc.setText(testCaseEdit.getName());
    }

    void editPanel_mouseMoved(MouseEvent mouseEvent) {
        Point2D point2D = this.editPanel.getViewport().toModel(mouseEvent.getPoint());
        this.txtMousePos.setText((double)Math.round(point2D.getX() * 1000.0) / 1000.0 + ", " + (double)Math.round(point2D.getY() * 1000.0) / 1000.0);
    }

    void btnRunTests_actionPerformed(ActionEvent actionEvent) {
        this.relatePanel.runTests();
    }

    void editPanel_geometryChanged(GeometryEvent geometryEvent) {
        this.relatePanel.clearResults();
    }

    void validPanel_setHighlightPerformed(ValidPanelEvent validPanelEvent) {
        this.editPanel.setHighlightPoint(this.validPanel.getHighlightPoint());
        this.editPanel.forceRepaint();
    }

    void txtDesc_focusLost(FocusEvent focusEvent) {
        this.testCase.setName(this.txtDesc.getText());
    }

    void jTabbedPane1_stateChanged(ChangeEvent changeEvent) {
        boolean bl = this.jTabbedPane1.getSelectedComponent() == this.spatialFunctionPanel;
        boolean bl2 = this.jTabbedPane1.getSelectedComponent() == this.editCtlPanel;
        this.editPanel.setShowingResult(bl);
        this.editPanel.setShowingGeometryA(!bl || this.spatialFunctionPanel.shouldShowGeometryA());
        this.editPanel.setShowingGeometryB(!bl || this.spatialFunctionPanel.shouldShowGeometryB());
        this.editPanel.setHighlightPoint(null);
        if (this.jTabbedPane1.getSelectedComponent() == this.validPanel) {
            this.editPanel.setHighlightPoint(this.validPanel.getHighlightPoint());
        }
        if (this.initialized) {
            if (bl2) {
                JTSTestBuilderFrame.getInstance().showGeomsTab();
            }
            if (bl) {
                JTSTestBuilderFrame.getInstance().showResultTab();
            }
        }
    }

    public void setPrecisionModelDescription(String string) {
        this.precisionModelLabel.setText(string);
    }

    private void jbInit() throws Exception {
        this.border4 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(93, 93, 93), new Color(134, 134, 134));
        this.setLayout(this.borderLayout1);
        this.editGroupPanel.setLayout(this.borderLayout3);
        this.editPanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                TestCasePanel.this.editPanel_mouseMoved(mouseEvent);
            }
        });
        this.relateTabPanel.setLayout(this.borderLayout2);
        this.btnRunTests.setToolTipText("");
        this.btnRunTests.setText("Run");
        this.btnRunTests.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestCasePanel.this.btnRunTests_actionPerformed(actionEvent);
            }
        });
        this.validPanel.addValidPanelListener(new ValidPanelListener(){

            public void setHighlightPerformed(ValidPanelEvent validPanelEvent) {
                TestCasePanel.this.validPanel_setHighlightPerformed(validPanelEvent);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.txtDesc.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TestCasePanel.this.txtDesc_focusLost(focusEvent);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestCasePanel.this.jTabbedPane1_stateChanged(changeEvent);
            }
        });
        this.testCaseIndexLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.testCaseIndexLabel.setToolTipText("");
        this.testCaseIndexLabel.setText("0 of 0");
        this.casePrecisionModelPanel.setLayout(this.gridBagLayout2);
        this.namePanel.setLayout(this.gridBagLayout3);
        this.precisionModelLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.precisionModelLabel.setToolTipText("");
        this.precisionModelLabel.setText("");
        this.jLabel2.setForeground(Color.darkGray);
        this.jLabel2.setToolTipText("");
        this.jLabel2.setText("Precision Model");
        this.jLabel3.setForeground(Color.darkGray);
        this.jLabel3.setText("Case");
        this.jLabel1.setForeground(Color.darkGray);
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText("Name");
        this.txtDesc.setBackground(Color.white);
        this.btnSetPrecisionModel.setMaximumSize(new Dimension(30, 27));
        this.btnSetPrecisionModel.setMinimumSize(new Dimension(30, 27));
        this.btnSetPrecisionModel.setPreferredSize(new Dimension(30, 21));
        this.btnSetPrecisionModel.setToolTipText("Set the Precision Model used by all Test Cases");
        this.btnSetPrecisionModel.setMargin(new Insets(2, 2, 2, 2));
        this.btnSetPrecisionModel.setMnemonic('0');
        this.btnSetPrecisionModel.setText("Set");
        this.txtMousePos.setBackground(SystemColor.text);
        this.txtMousePos.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txtMousePos.setPreferredSize(new Dimension(21, 21));
        this.txtMousePos.setHorizontalAlignment(4);
        this.jPanel2.setLayout(this.gridBagLayout4);
        this.txtSelectedPoint.setBackground(SystemColor.text);
        this.txtSelectedPoint.setEditable(false);
        this.txtSelectedPoint.setText("Sel Pt:");
        this.add((Component)this.editGroupPanel, "Center");
        this.editGroupPanel.add((Component)this.editPanel, "Center");
        this.editGroupPanel.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.txtMousePos, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.txtSelectedPoint, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jTabbedPane1, "West");
        this.jTabbedPane1.add((Component)this.editCtlPanel, "Edit");
        this.jTabbedPane1.add((Component)this.relateTabPanel, "Predicates");
        this.jTabbedPane1.add((Component)this.validPanel, "Valid");
        this.jTabbedPane1.add((Component)this.spatialFunctionPanel, "Geometry Functions");
        this.jTabbedPane1.add((Component)this.scalarFunctionPanel, "Scalar Functions");
        this.relateTabPanel.add((Component)this.relatePanel, "Center");
        this.relateTabPanel.add((Component)this.btnPanel, "North");
        this.btnPanel.add((Component)this.btnRunTests, null);
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.casePrecisionModelPanel, new GridBagConstraints(100, 100, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.casePrecisionModelPanel.add((Component)this.testCaseIndexLabel, new GridBagConstraints(2, 0, 1, 1, 0.2, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.casePrecisionModelPanel.add((Component)this.precisionModelLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.casePrecisionModelPanel.add((Component)this.jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.casePrecisionModelPanel.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 4), 0, 0));
        this.casePrecisionModelPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.casePrecisionModelPanel.add((Component)this.txtDesc, new GridBagConstraints(2, 1, 5, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.casePrecisionModelPanel.add((Component)this.btnSetPrecisionModel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.namePanel, new GridBagConstraints(100, 200, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateTestCaseIndexLabel() {
        this.testCaseIndexLabel.setText(this.currentTestCaseIndex + " of " + this.maxTestCaseIndex);
    }
}

